//
// (c) Mark McIlroy June 2022. Author of the design of the Bitstream Tree.
//
//

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "../calc.h"
#include "bst_tree_c_version.h"

#define MAX_KEY_LEN 10000



char *_calc_c_bst_init( long int var_arg1, char *source_file_id_txt )
{
	return ((char *) c_bst_init2( var_arg1 )); 
}


char *_calc_bst_get_key( var *result, var *var_arg1, char *source_file_id_txt )
{
	if (var_arg1 == NULL)
	{
		printf( "NULL node ptr in bst_get_key()\n" );
		exit( 1 );
	}

	var_set_b_2( result, ((bst_tree_node *) (var_arg1))->key_bits, ((bst_tree_node *) (var_arg1))->num_key_bytes, source_file_id_txt );
	
	return ((char *) result);
}


char *_calc_bst_get_data_ptr( char *var_arg1, char *source_file_id_txt )
{
	if (var_arg1 == NULL)
	{
		printf( "NULL node ptr in bst_get_data_ptr()\n" );
		exit( 1 );
	}
	
	return ((char *) ((bst_tree_node *) var_arg1)->data_ptr);
}

long int _calc_bst_insert_b( char *var_arg1, var *var_arg2, char *var_arg3, char *source_file_id_txt )
{
	int len;
	char key[MAX_KEY_LEN];
	char *ptr;
	bst_tree *bst;
	
	if (var_arg1 == NULL)
	{
		printf( "NULL tree in bst_insert_b()\n" );
		exit( 1 );
	}

	if (var_arg2->data.bvalue == NULL)
	{
		printf( "NULL key in bst_insert_b\n" );
		exit( 1 );
	}
	
	len = (int) *((int_64 *) var_arg2->data.bvalue);
	
	ptr = var_arg2->data.bvalue + sizeof( int_64 );
	
	return (c_bst_insert( (bst_tree *) var_arg1, ptr, len, var_arg3 ));
}


long int _calc_bst_insert_s( char *var_arg1, var *var_arg2, char *var_arg3, char *source_file_id_txt )
{
	int len;
	char key[MAX_KEY_LEN];
	char *ptr;
	bst_tree *bst;
	
	if (var_arg1 == NULL)
	{
		printf( "NULL tree in bst_insert_key_s()\n" );
		exit( 1 );
	}

	if (var_arg2->data.bvalue == NULL)
	{
		printf( "NULL key in bst_insert_key_s\n" );
		exit( 1 );
	}
	
	len = (int) *((int_64 *) var_arg2->data.svalue);
	
	ptr = var_arg2->data.svalue + sizeof( int_64 );
	
	return (c_bst_insert( (bst_tree *) var_arg1, ptr, len, var_arg3 ));
}


char *_calc_bst_search_b( char *var_arg1, var *var_arg2, char *var_arg3, char *source_file_id_txt )
{
	int found;
	int len;
	char key[MAX_KEY_LEN];
	char *ptr;

	if (var_arg1 == NULL)
	{
		printf( "NULL tree in bst_search_b()\n" );
		exit( 1 );
	}
	
	if (var_arg2->data.bvalue == NULL)
	{
		printf( "NULL key in bst_search_b()\n" );
		exit( 1 );
	}
	
	len = *((int_64 *) var_arg2->data.bvalue);
		
	ptr = var_arg2->data.bvalue + sizeof( int_64 );
		

	ptr = (char *) c_bst_search( (bst_tree *) var_arg1, ptr, len, &found );
	
	*var_arg3 = found;
	
	return ((char *) ptr);
}

char *_calc_bst_search_s( char *var_arg1, var *var_arg2, char *var_arg3, char *source_file_id_txt )
{
	int found;
	int len;
	char key[MAX_KEY_LEN];
	char *ptr;

	if (var_arg1 == NULL)
	{
		printf( "NULL tree in bst_search_key_s()\n" );
		exit( 1 );
	}
	
	if (var_arg2->data.bvalue == NULL)
	{
		printf( "NULL key in bst_search_key_s()\n" );
		exit( 1 );
	}
	
	len = *((int_64 *) var_arg2->data.svalue);
		
	ptr = var_arg2->data.svalue + sizeof( int_64 );

	ptr = (char *) c_bst_search( (bst_tree *) var_arg1, ptr, len, &found );
	
	*var_arg3 = found;
	
	return ((char *) ptr);
}


char _calc_bst_key_is_in_tree_b( unsigned char *var_arg1, var *var_arg2, char *source_file_id_txt )
{
	int len;

	if (var_arg1 == NULL)
	{
		printf( "NULL tree in bst_key_is_in_tree_b()\n" );
		exit( 1 );
	}
	
	if (var_arg2->data.bvalue == NULL)
	{
		printf( "NULL key in bst_key_is_in_tree_b()\n" );
		exit( 1 );
	}
	
	len = *((int_64 *) (var_arg2->data.bvalue));
	
	return (c_bst_key_is_in_tree( (bst_tree *) var_arg1, var_arg2->data.bvalue + sizeof( int_64 ), len ));
}


char _calc_bst_key_is_in_tree_s( char *var_arg1, var *var_arg2, char *source_file_id_txt )
{
	int len;

	if (var_arg1 == NULL)
	{
		printf( "NULL tree in bst_key_is_in_tree_key_s()\n" );
		exit( 1 );
	}
	
	if (var_arg2->data.bvalue == NULL)
	{
		printf( "NULL key in bst_key_is_in_tree_key_s()\n" );
		exit( 1 );
	}
	
	len = *((int_64 *) (var_arg2->data.svalue));
	
	return (c_bst_key_is_in_tree( (bst_tree *) var_arg1, var_arg2->data.svalue + sizeof( int_64 ), len ));
}


char _calc_bst_delete_item_b( unsigned char *var_arg1, var *var_arg2, char *source_file_id_txt )
{
	int len;

	if (var_arg1 == NULL)
	{
		printf( "NULL tree in bst_delete_item_b()\n" );
		exit( 1 );
	}

	if (var_arg2->data.bvalue == NULL)
	{
		printf( "NULL key in bst_delete_item_b()\n" );
		exit( 1 );
	}
	
	len = *((int_64 *) var_arg2->data.bvalue);
	
	return (c_bst_delete_item( (bst_tree *) var_arg1, var_arg2->data.bvalue + sizeof( int_64 ), len ));
}


char *_calc_bst_free( char *var_arg1, char *source_file_id_txt )
{
	if (var_arg1 == NULL)
	{
		printf( "NULL tree in bst_free()\n" );
		exit( 1 );
	}

	c_bst_free( (bst_tree *) var_arg1 );
}


char *_calc_bst_tree_first_item2( char *var_arg1, char var_arg2, char *source_file_id_txt )
{
	if (var_arg1 == NULL)
	{
		printf( "NULL tree in bst_tree_first_item2()\n" );
		exit( 1 );
	}

	return ((char *) c_bst_tree_first_item( (bst_tree *) var_arg1, var_arg2, source_file_id_txt ));
}

char *_calc_bst_tree_next_item2( char *var_arg1, char var_arg2, char *source_file_id_txt )
{
	if (var_arg1 == NULL)
	{
		printf( "NULL tree in bst_tree_next_item2()\n" );
		exit( 1 );
	}

	return ((char *) c_bst_tree_next_item( (bst_tree_node *) var_arg1, var_arg2 ));
}

long int _calc_bst_unique_items_in_tree( char *var_arg1, char *source_file_id_txt )
{
	if (var_arg1 == NULL)
	{
		printf( "NULL tree value in bst_unique_items_in_tree()\n" );
		exit( 1 );
	}

	return (((bst_tree *) (var_arg1))->unique_items_in_tree );
}

long int _calc_bst_total_items_in_tree( char *var_arg1, char *source_file_id_txt )
{
	if (var_arg1 == NULL)
	{
		printf( "NULL tree value in bst_total_items_in_tree()\n" );
		exit( 1 );
	}

	return (((bst_tree *) (var_arg1))->total_items_in_tree );
}

