//<? Turn on PHP editor syntax highlighting

#include <stdio.h>
#include <execinfo.h>
#include <unistd.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>
#include <stdarg.h>
#include "calc.h"

#define DEBUG

#define MEDIUM_STRING_BUFFER_SIZE 	100000


char *sp;
int_64 ic_ptr;
int_64 offset;
int_64 push_flags;
int var_type;
char *vptr;
char *vptr_to;
char *vptr_from;
char *vptr_start;
char *vptr_from_init;

extern int _calcsys_ascii_only;
extern int _calcsys_bytes_per_char;


int_64 peak_bytes_malloced;
int_64 curr_bytes_malloced;

int _calcsys_call_level;
char *_calcsys_err_source_file_id_txt[MAX_NESTED_FUNCTION_CALLS]; 
char *_calcsys_err_function_name[MAX_NESTED_FUNCTION_CALLS]; 

unsigned char dec_to_hex_1_nibble2( unsigned char i );

int show_large_strings_warnings;


void x4_warning_only( char *source_file_id_txt, int error_number, char *text, char *extra_text );



void rarray_cp_item( rarray *rarray_ptr, rarray *rarray_prev, int_64 *curr_item, int sizeof2, char *source_file_id_txt );


char *rarray_calc_pos( rarray *rarray_ptr, int_64 *curr_item );


long int _calcsys_xor( long int x1, long int x2 )
{
	if ((x1 != 0 && x2 == 0) || (x1 == 0 && x2 != 0)) 
		return (1);
	else
		return (0);
}


void _calcsys_check_link_type( char *function_name, char *required_type_map, char *actual_type_map )
{
	char str[1000];

	if (actual_type_map != NULL)
	{
		if (strcmp( required_type_map, actual_type_map ) != 0)
		{
			sprintf( str, "Link type in function parameter to function '%s' does not match the required type.", function_name );
			
			runtime_error( "", 1143, str, "" );
		}
	}	 
}


long int _calcsys_array_bounds_check( int index_number, long int max_size, long int curr_size, char *source_file_id_txt )
{
	char str[100];
	
	if (curr_size < 0)
	{
		sprintf( str, "Negative array index, index number: %d, value %d", index_number, curr_size );
		
		runtime_error( source_file_id_txt, 1094, str, "" );
	}
		
	if (curr_size >= max_size)
	{
		sprintf( str, "Array bounds overflow, index number: %d, value %d, maximum size %d", index_number, curr_size, max_size );
		
		runtime_error( source_file_id_txt, 1095, str, "" );
	}

	return (curr_size);
}


long int _calcsys_decimal_div( long int x1, long int x2, char *source_file_id_txt )
{
	if (x2 == 0)
		runtime_error( source_file_id_txt, 105, "divide by zero", "" );
	else
	{
		return ((long int) (((long double) x1 / (long double) x2) * VAR_DECIMAL_SCALE + (long double) VAR_DECIMAL_ROUNDING_OFFSET));
	}
}

float _calcsys_div_check_0_float( float x1, float x2, char *source_file_id_txt )
{
	if (x2 == 0)
		runtime_error( source_file_id_txt, 105, "divide by zero", "" );
	else
	{
		return (x1 / x2);
	}
}

double _calcsys_div_check_0_double( double x1, double x2, char *source_file_id_txt )
{
	if (x2 == 0)
		runtime_error( source_file_id_txt, 105, "divide by zero", "" );
	else
	{
		return (x1 / x2);
	}
}

long double _calcsys_div_check_0_long_double( long double x1, long double x2, char *source_file_id_txt )
{
	if (x2 == 0)
		runtime_error( source_file_id_txt, 105, "divide by zero", "" );
	else
	{
		return (x1 / x2);
	}
}

char _calcsys_div_check_0_byte( char x1, char x2, char *source_file_id_txt )
{
	if (x2 == 0)
		runtime_error( source_file_id_txt, 105, "divide by zero", "" );
	else
	{
		return (x1 / x2);
	}
}

short int _calcsys_div_check_0_short_int( short int x1, short int x2, char *source_file_id_txt )
{
	if (x2 == 0)
		runtime_error( source_file_id_txt, 105, "divide by zero", "" );
	else
	{
		return (x1 / x2);
	}
}

int _calcsys_div_check_0_medium_int( int x1, int x2, char *source_file_id_txt )
{
	if (x2 == 0)
		runtime_error( source_file_id_txt, 105, "divide by zero", "" );
	else
	{
		return (x1 / x2);
	}
}

long int _calcsys_div_check_0_int( long int x1, long int x2, char *source_file_id_txt )
{
	if (x2 == 0)
		runtime_error( source_file_id_txt, 105, "divide by zero", "" );
	else
	{
		return (x1 / x2);
	}
}


double _calcsys_double_pow( double x1, double x2, char *source_file_id_txt )
{
	return (pow( x1, x2 ));
}

long double _calcsys_long_double_pow( long double x1, long double x2, char *source_file_id_txt )
{
	return (powl( x1, x2 ));
}

long int _calcsys_decimal_pow( long int x1, long int x2, char *source_file_id_txt )
{
	return ( (long int) (pow( ((double) x1) / VAR_DECIMAL_SCALE, ((double) x2) / VAR_DECIMAL_SCALE ) * VAR_DECIMAL_SCALE) );
}

long int _calcsys_int_pow( long int x1, long int x2, char *source_file_id_txt )
{
	return ((long int) pow( (double) x1, (double) x2 ));
}


long int _calcsys_decimal_mult( long int x1, long int x2 )
{
	return ((long int) (((long double) x1 * (long double) x2) / VAR_DECIMAL_SCALE + (long double) VAR_DECIMAL_ROUNDING_OFFSET));
}



void _calc_sydump_call_stack( int ic_ptr, char *source_file_id_txt )
{
	runtime_error( source_file_id_txt, 105, "Runtime error", "" );
}



void _calcsys_str_append( char *str1, char *str2, char *source_file_id_txt )
{
	char *ptr;
	char str[MEDIUM_STRING_BUFFER_SIZE];
	int_64 len1, len2, len3;

	var_check_s( (var *) str1, source_file_id_txt );
	var_check_s( (var *) str2, source_file_id_txt );

	len1 = *((int_64 *)((var *) str1)->data.svalue);
	len2 = *((int_64 *)((var *) str2)->data.svalue);

	len3 = len1 + len2 + sizeof( int_64 );
	
	if (len3 <= VAR_SHORT_STRING_MAX_SIZE && ((var *) str1)->storage_type == VAR_SHORT_STRING)
	{
		memcpy( ((var *) str1)->data.svalue + sizeof( int_64 ) + len1, ((var *) str2)->data.svalue + sizeof( int_64 ), len2 ); 
	
		*((int_64 *) (((var *) str1)->data.svalue)) = len1 + len2;
	}
	else
	{ 
		if (len3 < MEDIUM_STRING_BUFFER_SIZE)
			ptr = str;
		else
			ptr = _malloc( len3 );
	
		memcpy( ptr + sizeof( int_64 ), ((var *) str1)->data.svalue + sizeof( int_64 ), len1 ); 
		memcpy( ptr + sizeof( int_64 ) + len1, ((var *) str2)->data.svalue + sizeof( int_64 ), len2 ); 
	
		*((int_64 *) ptr) = len1 + len2;
	
		_calcsys_var_set_s_u32( (var *) str1, ptr, false, source_file_id_txt );
		
		if (len3 >= MEDIUM_STRING_BUFFER_SIZE)
			_free( ptr );
	}
}



long int *_calcsys_set_register_i( long int *iptr, long int x )
{
	*iptr = x;
	
	return (iptr);
}


char *_calcsys_set_register_b( char *iptr, char x )
{
	*iptr = x;
	
	return (iptr);
}

long int *_calcsys_set_register_d( long int *dptr, long int x )
{
	*dptr = x;
	
	return (dptr);
}

double *_calcsys_set_register_n( double *nptr, double x )
{
	*nptr = x;
	
	return (nptr);
}

char *_calcsys_set_register_s( char *sstr, char *str, char *source_file_id_txt )
{
	copy_var( (var *) sstr, (var *) str, source_file_id_txt );
	
	return (sstr);
}

char *_calcsys_set_register_s_no_debug( char *sstr, char *str )
{
	copy_var_no_debug( (var *) sstr, (var *) str );
	
	return (sstr);
}

char **_calcsys_set_register_p( char **sstr, char *str )
{
	*sstr = str;
	
	return (sstr);
}

char *_calcsys_check_link( char *ptr, char *required_type_map, char *source_file_id_txt )
{
	dyn_block *ptr2;

	if (ptr == NULL)
		runtime_error( source_file_id_txt, 1092, "Attempt to access a data item using a link with a value of NULL_LINK.", "" );
	
	ptr2 = (dyn_block *) ptr;
		
	if (ptr2->status == 2)
		runtime_error( source_file_id_txt, 1137, "Attempt to access a freed data item.", "" );

	if (ptr2->status != 1)
		runtime_error( source_file_id_txt, 1138, "Corrupted memory.", "" );
	
	if (ptr2->data_ptr == NULL)
		runtime_error( source_file_id_txt, 1139, "NULL link (2).", "" );

	if (strcmp( required_type_map, ptr2->type_map ) != 0)
		runtime_error( source_file_id_txt, 1144, "Link type does not match the required type.", "" );

	return (ptr2->data_ptr);
}


char *_calcsys_check_link_no_checks( char *ptr )
{
	return (((dyn_block *) ptr)->data_ptr);
}

long double _calcsys_conv_decimal_to_long_double( long int x )
{
	return (roundl(((long double) x * (long double) 100) / (double) VAR_DECIMAL_SCALE ) / 100 );
}

double _calcsys_conv_decimal_to_double( long int x )
{
	return (round(((double) x * (double) 100) / (double) VAR_DECIMAL_SCALE ) / 100 );
}

long int _calcsys_conv_decimal_to_int( long int x )
{
	return ((long int) round( ((double) x * (double) 100) / (double) VAR_DECIMAL_SCALE ) / 100 );
}

long int _calcsys_conv_int_to_decimal( long int x )
{
	return ((long int ) (x * VAR_DECIMAL_SCALE ));
}

long int _calcsys_conv_double_to_decimal( double x )
{
	if (x > 0)
		return ((long int) (x * VAR_DECIMAL_SCALE + 0.005 ));
	else
		return ((long int) (x * VAR_DECIMAL_SCALE - 0.005 ));
}

long int _calcsys_conv_long_double_to_decimal( long double x )
{
	if (x > 0)
		return ((long int) (x * VAR_DECIMAL_SCALE + 0.005 ));
	else
		return ((long int) (x * VAR_DECIMAL_SCALE - 0.005 ));
}



#define MAX_STRCONCAT_ITEMS	10000
#define MAX_STRCONCAT_LEN	100000


char *str_concat( char *vptr3, char *source_file_id_txt, int num_items, ... )
{
	char *vptr;
	char str[MEDIUM_STRING_BUFFER_SIZE];
	char *items[MAX_STRCONCAT_ITEMS];
	char *ptr1, *ptr2;
	int_64 len, len1, len2;
	int_64 i;
	va_list vargs;
	
	if (num_items >= MAX_STRCONCAT_ITEMS)
		runtime_error( source_file_id_txt, 1113, "Too many items in string concatenation.", "" );
	
	va_start( vargs, num_items );
	
	len = 0;
	
	for (i=0; i < num_items; i++)
	{
		vptr = va_arg( vargs, char * );
		
		var_check_s( (var *) vptr, source_file_id_txt );
		
		len += *((int_64 *)((var *) vptr)->data.svalue);

		items[i] = vptr;
	} 

	len2 = len + sizeof( int_64 );

	 
	if (len2 < MEDIUM_STRING_BUFFER_SIZE)
		ptr2 = str;
	else
		ptr2 = _malloc( len2 );

		
	ptr1 = ptr2 + sizeof( int_64 );

	for (i=0; i < num_items; i++)
	{
		vptr = items[i];
		
		len1 = *((int_64 *)((var *) vptr)->data.svalue);
		
		memcpy( ptr1, ((var *) vptr)->data.svalue + sizeof( int_64 ), len1 );
		
		ptr1 += len1;
	}

	*((int_64 *) ptr2) = len;
	
	_calcsys_var_set_s_u32( (var *) vptr3, ptr2, false, source_file_id_txt );
	
	if (len2 >= MEDIUM_STRING_BUFFER_SIZE)
		_free( ptr2 );
	
	return (vptr3);
}


char *str_concat_no_debug( char *vptr3, int num_items, ... )
{
	char *vptr;
	char *source_file_id_txt;
	char str[MEDIUM_STRING_BUFFER_SIZE];
	char *items[MAX_STRCONCAT_ITEMS];
	char *ptr1, *ptr2;
	int_64 len, len1;
	int_64 i;
	va_list vargs;
	
	va_start( vargs, num_items );
	
	source_file_id_txt = "str_concat_no_debug()";
	
	len = 0;
	
	for (i=0; i < num_items; i++)
	{
		vptr = va_arg( vargs, char * );
		
		len += *((int_64 *)((var *) vptr)->data.svalue);

		items[i] = vptr;
	} 


	if (len < MEDIUM_STRING_BUFFER_SIZE)
		ptr2 = str;
	else
		ptr2 = _malloc( len );

		
	ptr1 = ptr2 + sizeof( int_64 );

	for (i=0; i < num_items; i++)
	{
		vptr = items[i];
		
		len1 = *((int_64 *)((var *) vptr)->data.svalue);
		
		memcpy( ptr1, ((var *) vptr)->data.svalue + sizeof( int_64 ), len1 );
		
		ptr1 += len1;
	}

	*((int_64 *) ptr2) = len;
	
	_calcsys_var_set_s_u32( (var *) vptr3, ptr2, false, source_file_id_txt );
	
	if (len >= MEDIUM_STRING_BUFFER_SIZE)
		_free( ptr2 );
	
	return (vptr3);
}



char *rarray_deref( char **result, char *sp, char *source_file_id_txt, int number_dimensions, ... )
{
	long int index_value[MAX_RARRAY_DIMENSIONS];
	char str[100];
	int_64 total_size, offset;
	int_64 subarray_size;
	rarray *rarray_ptr;
	va_list vargs;
	int i;

	va_start( vargs, number_dimensions );

	for (i=0; i < number_dimensions; i++)
		index_value[i] = va_arg( vargs, long int );

	offset = index_value[0];


	if (number_dimensions == 1)
	{
		if (((var *) sp)->var_type != VAR_RESIZABLE_ARRAY)
			runtime_error( source_file_id_txt, 1114, "Variable type is not a resizable array. Call 'setsize'.", "" );
			
		rarray_ptr = ((var *) sp)->data.pvalue;

		if (rarray_ptr == NULL)
			runtime_error( source_file_id_txt, 1115, "NULL resizable array value.", "" );

		if (rarray_ptr->number_of_dimensions != 1)
			runtime_error( source_file_id_txt, 1116, "Mismatch in the number of array dimensions.", "" );
									
		if (offset < 0)
			runtime_error( source_file_id_txt, 1117, "Array negative index.", "" );
				
		if (offset >= rarray_ptr->index_size[0])
			runtime_error( source_file_id_txt, 1118, "Array bounds overflow.", "" );

		*result = &(rarray_ptr->datap[offset * rarray_ptr->sizeof_array_element]);
	}
	else
	{
		if (((var *) sp)->var_type != VAR_RESIZABLE_ARRAY)
			runtime_error( source_file_id_txt, 1119, "Variable type is not a resizable array. Call 'setsize'.", "" );

		rarray_ptr = ((var *) sp)->data.pvalue;

		if (rarray_ptr == NULL)
			runtime_error( source_file_id_txt, 1120, "NULL resizable array value.", "" );

		if (rarray_ptr->number_of_dimensions != number_dimensions)
			runtime_error( source_file_id_txt, 1121, "Mismatch in the number of array dimensions.", "" );
									
		if (index_value[0] < 0)
			runtime_error( source_file_id_txt, 1122, "Array negative index.", "" );
				
		if (index_value[0] > rarray_ptr->index_size[0]-1)
			runtime_error( source_file_id_txt, 1123, "Array bounds overflow.", "" );
		
		subarray_size = 1;
					 
		for (i=1; i < number_dimensions; i++)
		{
			if (index_value[i] < 0)
				runtime_error( source_file_id_txt, 1124, "Array negative index.", "" );
			
			if (index_value[i] >= rarray_ptr->index_size[i])
			{
				sprintf( str, "Array bounds overflow, value: %ld, maximum: %ld.", index_value[i], rarray_ptr->index_size[i] ); 						
				
				runtime_error( source_file_id_txt, 1125, str, "" );
			}
					
			subarray_size *= rarray_ptr->index_size[i-1];

			offset += index_value[i] * subarray_size;
		}

		*result = &(rarray_ptr->datap[offset * rarray_ptr->sizeof_array_element]);
	}
	
	return (*result);
}



char *rarray_deref_no_debug( char **result, char *sp, int number_dimensions, ... )
{
	long int index_value[MAX_RARRAY_DIMENSIONS];
	char str[100];
	int_64 total_size, offset;
	int_64 subarray_size;
	rarray *rarray_ptr;
	va_list vargs;
	int i;

	va_start( vargs, number_dimensions );

	if (number_dimensions == 1)
	{
		offset = va_arg( vargs, long int );
	
		rarray_ptr = ((var *) sp)->data.pvalue;

		*result = &(rarray_ptr->datap[offset * rarray_ptr->sizeof_array_element]);
	}
	else
	{
		for (i=0; i < number_dimensions; i++)
			index_value[i] = va_arg( vargs, long int );

		offset = index_value[0];
	
		rarray_ptr = ((var *) sp)->data.pvalue;
		
		subarray_size = 1;
					 
		for (i=1; i < number_dimensions; i++)
		{
			subarray_size *= rarray_ptr->index_size[i-1];

			offset += index_value[i] * subarray_size;
		}

		*result = &(rarray_ptr->datap[offset * rarray_ptr->sizeof_array_element]);
	}
	
	return (*result);
}


char *_calcsys_conv_link_to_string( char *str, char *x )
{
	char str2[100];
	char str3[100];

	strcpy( str2, "{link to " );

	sprintf( str3, "%p", x );

	strcat( str2, str3 );

	strcat( str2, "}" );
				
	_calcsys_var_set_s( (var *) str, str2, 0 );
							
	return (str);
}

char *_calcsys_conv_short_int_to_string( char *str, short int x )
{
	char str2[100];

	sprintf( str2, "%d", (int) x );
				
	_calcsys_var_set_s( (var *) str, str2, 0 );

	return (str);
}


char *_calcsys_conv_medium_int_to_string( char *str, int x )
{
	char str2[100];

	sprintf( str2, "%d", x );
				
	_calcsys_var_set_s( (var *) str, str2, 0 );

	return (str);
}


char *_calcsys_conv_byte_to_string( char *str, char x )
{
	char str2[100];

	sprintf( str2, "%c", x );
				
	_calcsys_var_set_s( (var *) str, str2, 0 );

	return (str);
}


char *_calcsys_conv_int_to_string( char *str, long int x )
{
	char str2[100];

	sprintf( str2, "%ld", x );
				
	_calcsys_var_set_s( (var *) str, str2, 0 );

	return (str);
}


char *_calcsys_conv_decimal_to_string( char *str, long int x )
{
	char str2[100];

	sprintf( str2, "%.2lf", ((double) x) / (double) VAR_DECIMAL_SCALE) + 0.005;

	_calcsys_var_set_s( (var *) str, str2, 0 );

	return (str);
}

char *_calcsys_conv_float_to_string( char *str, float x )
{
	char str2[100];

	sprintf( str2, "%7.7f", x );
			
	trim_trailing_zeros( str2 );
				
	_calcsys_var_set_s( (var *) str, str2, 0 );

	return (str);
}

char *_calcsys_conv_double_to_string( char *str, double x )
{
	char str2[100];

	sprintf( str2, "%13.13lf", x );
			
	trim_trailing_zeros( str2 );
				
	_calcsys_var_set_s( (var *) str, str2, 0 );

	return (str);
}


char *_calcsys_conv_long_double_to_string( char *str, long double x )
{
	char str2[100];

	sprintf( str2, "%18.18Lf", x );
			
	trim_trailing_zeros( str2 );
				
	_calcsys_var_set_s( (var *) str, str2, 0 );

	return (str);
}

char *_calcsys_conv_bool_to_string( char *str, long int x )
{
	if (x != 0)
		_calcsys_var_set_s( (var *) str, "true", 0 );
	else
		_calcsys_var_set_s( (var *) str, "false", 0 );

	return (str);
}


char *_calcsys_conv_binary_to_string( char *str, char *vptr )
{
	long int len1;
	char *bptr;
	
	len1 = *((int_64 *) (((var *) vptr)->data.bvalue));

	bptr = _malloc( len1 * 2 + 1 );

	dec_to_hex( bptr, ((var *) vptr)->data.svalue + sizeof( int_64 ), len1, true, false );

	_calcsys_var_set_s( (var *) str, bptr, 0 );
	
	_free( bptr );
	
	return (str);
}


	char *op_setsize_1( int sizeof2, int_64 element_size, rarray **rarray_ptr2, char *source_file_id_txt )
	{
		int number_dimensions;
		rarray *rarray_ptr;
		int i;
		int_64 total_size;
		char *ptr2;
		char *vptr;
				
//		sp -= sizeof( var );

		number_dimensions = ((var *) sp)->data.ivalue;

		if (number_dimensions >= MAX_RARRAY_DIMENSIONS)
			runtime_error( source_file_id_txt, 1091, "Too many dimensions in array resize.", "" );

		rarray_ptr = _malloc( sizeof( rarray ) );
		
		rarray_ptr->number_of_dimensions = number_dimensions;
		
		rarray_ptr->sizeof_array_element = element_size;
		
		sp -= sizeof( var );
		
		total_size = 1;
		
		for (i=0; i < number_dimensions; i++)
		{
			if (((var *) sp)->data.ivalue < 0)
				runtime_error( source_file_id_txt, 1092, "Negative array size in 'setsize'.", "" );
		
			total_size *= ((var *) sp)->data.ivalue;
		 
		 	rarray_ptr->index_size[i] = ((var *) sp)->data.ivalue;
		 
			sp -= sizeof( var );
		}

		rarray_ptr->total_size = total_size * element_size;
					
		ptr2 = _malloc( rarray_ptr->total_size ); 
		
		memset( ptr2, 0, rarray_ptr->total_size ); 

		rarray_ptr->datap = ptr2;
		
		vptr = ((var *) sp)->data.pvalue;
		
		*rarray_ptr2 = rarray_ptr;
		
		return (vptr);
	}
					
					
	void op_setsize_2( char *vptr, rarray *rarray_ptr, int sizeof2, int_64 element_size, char *source_file_id_txt )
	{
		rarray *rarray_prev;
		int_64 num_items[ MAX_RARRAY_DIMENSIONS ];
		int_64 curr_item[ MAX_RARRAY_DIMENSIONS ];
		int curr_item_indx;
		int i;
		
		if (((var *) vptr)->var_type == VAR_STRING && ((var *) vptr)->data.svalue != NULL && 
			((var *) vptr)->storage_type == VAR_DYNAMIC_STORAGE)
		
			_free( ((var *) vptr)->data.svalue );

		if (((var *) vptr)->var_type == VAR_BINARY && ((var *) vptr)->data.bvalue != NULL)
			_free( ((var *) vptr)->data.bvalue );

		if (((var *) vptr)->var_type == VAR_RESIZABLE_ARRAY)
		{
			rarray_prev = ((var *) vptr)->data.pvalue;

			if (rarray_ptr->number_of_dimensions == 1 && rarray_prev->number_of_dimensions == 1)
			{
				if (rarray_ptr->total_size >= rarray_prev->total_size)
					memcpy( rarray_ptr->datap, rarray_prev->datap, rarray_prev->total_size );
				else
					memcpy( rarray_ptr->datap, rarray_prev->datap, rarray_ptr->total_size );
			}
			else			
			if (rarray_ptr->number_of_dimensions == rarray_prev->number_of_dimensions)
			{
				for (i=0; i < rarray_ptr->number_of_dimensions; i++)
				{
				 	if (rarray_ptr->index_size[i] > rarray_prev->index_size[i])
				 	{
						num_items[i] = rarray_prev->index_size[i] - 1;
						curr_item[i] = rarray_prev->index_size[i] - 1;
					}
					else
					{
						num_items[i] = rarray_ptr->index_size[i] - 1;
						curr_item[i] = rarray_ptr->index_size[i] - 1;
					}
				}
				
		 		curr_item_indx = rarray_ptr->number_of_dimensions - 1;
			 	
			 	while (curr_item[0] >= 0)
			 	{
			 		rarray_cp_item( rarray_ptr, rarray_prev, curr_item, sizeof( var ), source_file_id_txt ); 
			 		
			 		curr_item[curr_item_indx]--;
			 		
			 		while (curr_item_indx > 0 && curr_item[curr_item_indx] < 0)
			 		{
			 			curr_item_indx--;
			 			
			 			curr_item[curr_item_indx]--;
			 		}
			 		
		 			curr_item_indx++;
		 			
		 			while (curr_item_indx < rarray_ptr->number_of_dimensions)
		 			{
			 			curr_item[curr_item_indx] = num_items[curr_item_indx];
			 			curr_item_indx++;
			 		}
			 		
			 		curr_item_indx = rarray_ptr->number_of_dimensions - 1;
			 	}
			} 
		}

		((var *) vptr)->var_type = VAR_RESIZABLE_ARRAY;
		((var *) vptr)->data.pvalue = rarray_ptr;
	}


	void rarray_cp_item( rarray *rarray_ptr, rarray *rarray_prev, int_64 *curr_item, int sizeof2, char *source_file_id_txt )
	{
		char *vptr_src;
		char *vptr_end;
		char *vptr_dest;
		
		vptr_src = rarray_calc_pos( rarray_prev, curr_item );
		
		vptr_dest = rarray_calc_pos( rarray_ptr, curr_item );
	
		vptr_end = vptr_src + rarray_ptr->sizeof_array_element;
		
		while (vptr_src < vptr_end)
		{ 
			copy_var( (var *) vptr_dest, (var *) vptr_src, source_file_id_txt );
			
			vptr_src += sizeof( var );
			vptr_dest += sizeof( var );
		}
	}


	char *rarray_calc_pos( rarray *rarray_ptr, int_64 *curr_item )
	{
		int i;
		int_64 subarray_size;
		int number_dimensions;
		int_64 offset;
		
		number_dimensions = rarray_ptr->number_of_dimensions;
		
		offset = curr_item[0];
		
		subarray_size = 1;
					 
		for (i=1; i < number_dimensions; i++)
		{
			subarray_size *= rarray_ptr->index_size[i-1];

			offset += curr_item[i] * subarray_size;
		}

		return (&rarray_ptr->datap[offset * rarray_ptr->sizeof_array_element]);
	}

							
		void copy_var( var *vptr_dest, var *vptr_src, char *source_file_id_txt )
		{
			char str[10000];
		
	#ifdef DEBUG	
			if (vptr_src == NULL)
				runtime_error( source_file_id_txt, 196, "NULL vptr_src in copy_var", "" );
		
			if (vptr_dest == NULL)
				runtime_error( source_file_id_txt, 196, "NULL vptr_dest in copy_var", "" );
	#endif
		
			if (vptr_dest != vptr_src)
			{
				if (vptr_src->var_type == VAR_STRING)
				{
					if (show_large_strings_warnings)
					{
						if (vptr_src->data.svalue != NULL)
						{
							if (*((int_64 *) vptr_src->data.svalue) > 5000)
							{
								sprintf( str, "Large string copy will slow program performance (%d characters)", (*((int_64 *) vptr_src->data.svalue)) / 4 );
							
								x4_warning_only( source_file_id_txt, 1093, str, "" );
							}
						}
					}
					
					if (vptr_src->storage_type == VAR_CONSTANT_STRING)
						_calcsys_var_set_s_u32( vptr_dest, vptr_src->data.svalue, true, source_file_id_txt );
					else
						_calcsys_var_set_s_u32( vptr_dest, vptr_src->data.svalue, false, source_file_id_txt );
				}
				else
				if (vptr_src->var_type == VAR_BINARY)
					var_set_b( vptr_dest, vptr_src, source_file_id_txt );
				else
				if (vptr_src->var_type == VAR_RESIZABLE_ARRAY)
				{
					runtime_error( source_file_id_txt, 1126, "Internal error, attempted copy of resizable array in copy_var().", "" );
				
//					var_copy_rarray_p( vptr_dest, vptr_src, sizeof( var ), source_file_id_txt );
				}
				else 	// pointer
				{			
					free_curr_mem_1( vptr_dest, source_file_id_txt );
	
					vptr_dest->var_type = vptr_src->var_type;
					
					vptr_dest->data = vptr_src->data;
				}
			}
		}
	
	
	char *_calc_conv_to_latin_text( char *result, char *vptr, char *source_file_id_txt )
	{
	    char str[MEDIUM_STRING_BUFFER_SIZE];
	    char dest[MEDIUM_STRING_BUFFER_SIZE]; 
	    long int len;
	    int has_non_ascii_char;
		int high_nibble;
		int low_nibble;
	    char *ptr;
	    char *ptr2;

		if (_calcsys_ascii_only)
		{
			if (((var *) vptr)->storage_type == VAR_CONSTANT_STRING)
				_calcsys_var_set_s_u32( (var *) result, ((var *) vptr)->data.svalue, true, source_file_id_txt );
			else
				_calcsys_var_set_s_u32( (var *) result, ((var *) vptr)->data.svalue, false, source_file_id_txt );
		}
		else
		{
			len = *((int_64 *) ((var *) vptr)->data.svalue);
	
			has_non_ascii_char = false;
			
			ptr2 = ((var *) vptr)->data.svalue + sizeof( int_64 ) + len;
			
			for (ptr = ((var *) vptr)->data.svalue + sizeof( int_64 ); ptr < ptr2; ptr++)
			{
				if (((*ptr) & 0x80) != 0)
					has_non_ascii_char = true;
			}
			
			if (! has_non_ascii_char)
				_calcsys_var_set_s_u32( (var *) result, ((var *) vptr)->data.svalue, false, "" );
			else
			{	
				str_u32_to_u8( str, ((var *) vptr)->data.svalue, MEDIUM_STRING_BUFFER_SIZE );
			
				ptr = str;
					
				ptr2 = dest;
				
				if (*ptr >= '0' && *ptr <= '9')
					*ptr2++ = 'v';
				
				while (*ptr != '\0')
				{
					if ((*ptr >= 'a' && *ptr <= 'z') ||
					   (*ptr >= 'A' && *ptr <= 'Z') ||
					   (*ptr >= '0' && *ptr <= '9') ||
					   *ptr == '_')
					   	*ptr2++ = *ptr++;
					else
					{
						high_nibble = (*ptr >> 4) & 15;
						
						low_nibble = *ptr & 15;
						 
						*ptr2++ = dec_to_hex_1_nibble2( high_nibble ); 
						
						*ptr2++ = dec_to_hex_1_nibble2( low_nibble );
		
						ptr++;			
					}
				}
				
				*ptr2 = '\0';
				 
				_calcsys_var_set_s( (var *) result, dest, 0 );
			}
		}
						
		return (result);
	}
	
	

	unsigned char dec_to_hex_1_nibble2( unsigned char i )
	{
		unsigned char dest;
		
		dest = 0;
		
		if (i == 0)				dest = '0';		else		
		if (i == 1)				dest = '1';		else		
		if (i == 2)				dest = '2';		else		
		if (i == 3)				dest = '3';		else		
		if (i == 4)				dest = '4';		else		
		if (i == 5)				dest = '5';		else		
		if (i == 6)				dest = '6';		else		
		if (i == 7)				dest = '7';		else		
		if (i == 8)				dest = '8';		else		
		if (i == 9)				dest = '9';		else		
		if (i == 10)			dest = 'A';		else
		if (i == 11)			dest = 'B';		else
		if (i == 12)			dest = 'C';		else
		if (i == 13)			dest = 'D';		else
		if (i == 14)			dest = 'E';		else
		if (i == 15)			dest = 'F';
	
		return (dest);
	}
	
	
	
		void copy_var_no_debug( var *vptr_dest, var *vptr_src )
		{
			if (vptr_dest != vptr_src)
			{
				if (vptr_src->var_type == VAR_STRING)
				{
					if (vptr_src->storage_type == VAR_CONSTANT_STRING)
						_calcsys_var_set_s_u32( vptr_dest, vptr_src->data.svalue, true, "" );
					else
						_calcsys_var_set_s_u32( vptr_dest, vptr_src->data.svalue, false, "" );
				}				
				else
				if (vptr_src->var_type == VAR_BINARY)
					var_set_b( vptr_dest, vptr_src, 0 );
				else 											// pointer
				{			
					free_curr_mem_1( vptr_dest, "" );
	
					vptr_dest->var_type = vptr_src->var_type;
					
					vptr_dest->data = vptr_src->data;
				}
			}
		}
	

	
	int isset( var *vptr )
	{
		int stat;

		if (vptr->var_type == VAR_EMPTY)
			stat = 0;
		else
			stat = 1;

		return (stat);
	}
	
	
	int get_var_type( char *vptr )
	{
		return (((var *) vptr)->var_type);
	}
	
	
	void set_var_type( char *vptr, int var_type )
	{
		((var *) vptr)->var_type = var_type;
	}



/*
	void var_set_s2( var *vptr, char *s, int is_constant_string, char *source_file_id_txt )
	{
		_calcsys_var_set_s( vptr, s, source_file_id_txt );
	}
*/

#define TMP_BUFFER	10000

	void _calcsys_var_set_s( var *vptr, char *s, char *source_file_id_txt )
	{
		int_64 len;
		char *s_u32;
		char str[MEDIUM_STRING_BUFFER_SIZE];
		

#ifdef DEBUG	
		if (vptr == NULL)
			runtime_error( source_file_id_txt, 196, "NULL vptr in var_set_s", "" );

		if (s == NULL)
			runtime_error( source_file_id_txt, 197, "NULL str in var_set_s", "" );
#endif
		
		len = 4 * strlen( s ) + sizeof( int_64 );
		 
		if (len < MEDIUM_STRING_BUFFER_SIZE)
			s_u32 = str;
		else
			s_u32 = _malloc( len );
		
		
		str_u8_to_u32( s_u32, s );
		
		
		_calcsys_var_set_s_u32( vptr, s_u32, false, source_file_id_txt );


		if (len >= MEDIUM_STRING_BUFFER_SIZE)
			_free( s_u32 );
	}



	void _calcsys_var_set_s_as_constant( var *vptr, char *source_file_id_txt )
	{
#ifdef DEBUG	
		if (vptr == NULL)
			runtime_error( source_file_id_txt, 1127, "NULL vptr in var_set_s_as_constant()", "" );
			
		if (vptr->var_type != VAR_STRING)
			runtime_error( source_file_id_txt, 1128, "vptr not a string in var_set_s_as_constant()", "" );
#endif
				
		vptr->storage_type = VAR_CONSTANT_STRING;
	}
	
	

	void _calcsys_var_set_s_u32( var *vptr, unsigned char *s, int src_is_constant_string, char const *source_file_id_txt )
	{
		int_64 len2;
		
#ifdef DEBUG	
		if (vptr == NULL)
			runtime_error( source_file_id_txt, 196, "NULL vptr in var_set_s", "" );

		if (s == NULL)
			runtime_error( source_file_id_txt, 197, "NULL str in var_set_s", "" );
#endif

		len2 = *((int_64 *) s) + sizeof( int_64 );

		if (vptr->var_type != VAR_STRING)
		{
			if (vptr->var_type == VAR_BINARY && vptr->data.bvalue != NULL)
			{
				free_curr_mem_1( vptr, source_file_id_txt );
			}
			else
			if (vptr->var_type == VAR_RESIZABLE_ARRAY)
			{
				runtime_error( source_file_id_txt, 0, "Attempt to free resizable array within 'var_set_s_u32()'", "" );
			}
		
			if (src_is_constant_string)
			{
				vptr->data.svalue = s;
						
//				vptr->alloc_len = 0;
				
				vptr->storage_type = VAR_CONSTANT_STRING;
			}
			else
			{
				if (len2 < VAR_SHORT_STRING_MAX_SIZE)
				{
					vptr->data.svalue = vptr->short_string;

//					vptr->alloc_len = 0;
					
					memcpy( vptr->short_string, s, len2 );
					
					vptr->storage_type = VAR_SHORT_STRING;
				}
				else
				{
					vptr->alloc_len = len2;
				
					vptr->data.svalue = _malloc( len2 );
					
					memcpy( vptr->data.svalue, s, len2 );
					
					vptr->storage_type = VAR_DYNAMIC_STORAGE;
				}
			}
			
			vptr->var_type = VAR_STRING;
		}
		else
		{
			if (src_is_constant_string)
			{
				if (vptr->storage_type == VAR_DYNAMIC_STORAGE)
				{
					_free( vptr->data.svalue );

//					vptr->alloc_len = 0;
				}
				
				vptr->data.svalue = s;
						
				vptr->storage_type = VAR_CONSTANT_STRING;
			}
			else
			{
				if (len2 < VAR_SHORT_STRING_MAX_SIZE)
				{
					if (vptr->storage_type == VAR_DYNAMIC_STORAGE)
					{
						_free( vptr->data.svalue );
	
//						vptr->alloc_len = 0;
					}
				
					vptr->data.svalue = vptr->short_string;
					
					memcpy( vptr->short_string, s, len2 );
					
					vptr->storage_type = VAR_SHORT_STRING;
				}
				else
				{
					if (vptr->storage_type == VAR_DYNAMIC_STORAGE)
					{
						if (len2 > vptr->alloc_len)
						{
							_free( vptr->data.svalue );
							
							vptr->data.svalue = _malloc( len2 );
							
							vptr->alloc_len = len2;
						}
						
						memcpy( vptr->data.svalue, s, len2 );
					}
					else
					{
						vptr->data.svalue = _malloc( len2 );
							
						vptr->alloc_len = len2;
						
						memcpy( vptr->data.svalue, s, len2 );
						
						vptr->storage_type = VAR_DYNAMIC_STORAGE;
					}
				}
			}
		}
	}
	
	
	void var_set_b( var *vptr, var *vptr_src, char *source_file_id_txt )
	{
		int_64 len1;
	
#ifdef DEBUG	
		if (vptr == NULL)
			runtime_error( source_file_id_txt, 196, "NULL vptr in var_set_b", "" );

		if (vptr_src == NULL)
			runtime_error( source_file_id_txt, 197, "NULL vptr_src in var_set_b", "" );
#endif

		free_curr_mem_1( vptr, source_file_id_txt );

		if (vptr_src->data.bvalue == 0)
			vptr->data.bvalue = NULL;
		else
		{
			len1 = *((int_64 *) ((var *) vptr_src)->data.bvalue);
				
			vptr->data.bvalue = _malloc( len1 + sizeof( int_64 ) );

			memcpy( vptr->data.bvalue + sizeof( int_64 ), vptr_src->data.bvalue + sizeof( int_64 ), len1 );
			
			*((int_64 *) ((var *) vptr)->data.bvalue) = len1;
		}

		vptr->var_type = VAR_BINARY;
	}

	void var_set_b_2( var *vptr, char *bits, int num_bytes, char *source_file_id_txt )
	{
		int_64 len1;
	
#ifdef DEBUG	
		if (vptr == NULL)
			runtime_error( source_file_id_txt, 196, "NULL vptr in var_set_b", "" );

		if (bits == NULL)
			runtime_error( source_file_id_txt, 197, "NULL bits in var_set_b", "" );
#endif

		free_curr_mem_1( vptr, source_file_id_txt );

		if (bits == 0)
			vptr->data.bvalue = NULL;
		else
		{
			vptr->data.bvalue = _malloc( num_bytes + sizeof( int_64 ) );

			memcpy( vptr->data.bvalue + sizeof( int_64 ), bits, num_bytes );
			
			*((int_64 *) ((var *) vptr)->data.bvalue) = num_bytes;
		}

		vptr->var_type = VAR_BINARY;
	}


	void var_clear_b( var *vptr, char *source_file_id_txt )
	{
		int_64 len1;
	
#ifdef DEBUG	
		if (vptr == NULL)
			runtime_error( source_file_id_txt, 196, "NULL vptr in var_set_b", "" );
#endif

		free_curr_mem_1( vptr, source_file_id_txt );

		vptr->data.bvalue = NULL;

		vptr->var_type = VAR_BINARY;
	}


	void var_set_p( var *vptr, void *ptr, char *source_file_id_txt )
	{
#ifdef DEBUG	
		if (vptr == NULL)
			runtime_error( source_file_id_txt, 196, "NULL vptr in var_set_p", "" );
#endif

		if (((var *) vptr)->var_type != VAR_POINTER)
		{
			free_curr_mem_1( vptr, source_file_id_txt );

			vptr->var_type = VAR_POINTER;
		}
		
		vptr->data.pvalue = ptr;
	}

	void free_curr_mem_1( var *vptr, char const *source_file_id_txt )
	{
		rarray *rarray_ptr;
		
		if (vptr->var_type == VAR_STRING && vptr->data.svalue != NULL &&
			vptr->storage_type == VAR_DYNAMIC_STORAGE)
		{
			_free( vptr->data.svalue );
			
			vptr->alloc_len = 0;
			vptr->var_type = VAR_EMPTY;
		}
		else
		if (vptr->var_type == VAR_BINARY && vptr->data.bvalue != NULL)
		{
			_free( vptr->data.bvalue );

			vptr->alloc_len = 0;
			vptr->var_type = VAR_EMPTY;
		}
		else
		if (vptr->var_type == VAR_RESIZABLE_ARRAY && vptr->data.pvalue != NULL)
		{
			runtime_error( source_file_id_txt, 0, "Attempt to free resizable array with 'free_curr_mem_1()'", "" );
		}
	}

	
	void runtime_error( char const *source_file_id_txt, int error_number, char const *text, char const *extra_text )
	{
		void *bt[1000];
		char **ptr;
		int i;
		size_t size;

		printf( "\nCall stack\n\n<br><br>" );
				
		for (i=0; i < _calcsys_call_level; i++)
		{
			if (_calcsys_err_source_file_id_txt[i] != NULL)
			{
				if (*(_calcsys_err_source_file_id_txt[i]) == '\0')
					printf( "Function: %s()\n<br>", _calcsys_err_function_name[i] );
				else
					printf( "%s: Function: %s()\n<br>", _calcsys_err_source_file_id_txt[i], _calcsys_err_function_name[i] );
			}
		}

		printf( "\n<br><br>" );
				
		printf( "Runtime error: %d: %s: %s %s<br>", error_number, source_file_id_txt, text, extra_text );
		
		exit(1);
	}

	void x4_warning_only( char *source_file_id_txt, int error_number, char *text, char *extra_text )
	{
		void *bt[1000];
		char **ptr;
		int i;
		size_t size;
/*
		printf( "\nCall stack\n\n" );
				
		for (i=0; i < call_level; i++)
		{
			if (err_filename[i] != NULL)
				printf( "File: %s: Line number: %d\n", err_filename[i], err_linenumber[i] );
		}

		printf( "\n" );
*/				

		printf( "Runtime warning: %d: %s: %s %s<br>\n", error_number, source_file_id_txt, text, extra_text );


/*
		size = backtrace( bt, 1000 );

		ptr = backtrace_symbols( bt, size );

		for (i=0; i < size; i++)
			printf( "%s<br>", ptr[i] );
*/		
	}



	void trim_trailing_zeros( char *s )
	{
		int_64 pos;

		if (index( s, '.') != NULL)
		{
			pos = strlen( s ) - 1;

			while (s[pos] == '0')
				pos--;

			if (s[pos] == '.')
				s[pos] = '\0';
			else
				s[pos+1] = '\0';
		}
	}

			// Convert a UTF-8 string to fixed width UTF-32


	void str_u8_to_u32( unsigned char *dest, char *src )
	{
		unsigned char *start;
		unsigned char *ptr;
		int count;
		int_64 len;

		if (src == NULL)
		{
			printf( "NULL src in str_u8_to_u32" );
			exit(1);
		}

		if (dest == NULL)
		{
			printf( "NULL dest in str_u8_to_u32" );
			exit(1);
		}

		start = dest;

		dest += sizeof( int_64 );

		if (_calcsys_ascii_only)
		{
			len = strlen( src );
			
			memcpy( dest, src, len );
			
			*((int_64 *) start) = len; 
		}
		else
		{		 
			ptr = src;
	
			while (*ptr != '\0')
			{
				if (((*ptr) & 0x80) == 0)		// ASCII character
				{
					*dest++ = *ptr++;
					*dest++ = '\0';
					*dest++ = '\0';
					*dest++ = '\0';
				}
				else
				{
					*dest++ = *ptr++;
	
					count = 1;
	
					while (((*ptr) & 0x80) != 0 && ((*ptr) & 0x40) == 0)
					{
						*dest++ = *ptr++;
						count++;
					} 
	
					while (count < 4)
					{
						*dest++ = '\0';
						count++;
					}
				}
			}
	
			*((int_64 *) start) = dest - start - sizeof( int_64 );		// length
		}
	}


			// Convert a fixed width UTF-32 string to a UTF-8

			// Returns the destination string length without the terminating '\0' 

	void str_u32_to_u8( char *dest, unsigned char *src, int dest_size )
	{
		unsigned char *ptr;
		unsigned char *lst;
		int_64 src_length;
		char *ptr2;
		
		if (src == NULL)
		{
			printf( "NULL src in str_u32_to_u8" );
			exit(1);
		}

		if (dest == NULL)
		{
			printf( "NULL dest in str_u32_to_u8" );
			exit(1);
		}
		
		src_length = *((int_64 *) src);
	
		if (src_length > dest_size-1)
			runtime_error( "", 0, "Source size too large in str_u32_to_u8().", "" );
		
		if (_calcsys_ascii_only)
		{
			memcpy( dest, src + sizeof( int_64 ), src_length );
			dest[src_length] = '\0';
		}
		else
		{	
			ptr = src + sizeof( int_64 );
	
			lst = ptr + src_length;
			
			ptr2 = dest;
					
			while (ptr < lst)
			{
				if (*ptr != '\0')
				{
					*dest++ = *ptr++;
				}
				else
					ptr++;
			}
			
			*dest = '\0';
		}
	}


		// Returns length of a UTF-32 string in bytes, excluding the 8 byte leading length value 
		
	int_64 str_u32_length( unsigned char *str )
	{
		return (*((int_64 *) str));
	}


		// Returns 0 if two u32 strings are the same
		
	int str_u32_cmp( unsigned char *str1, unsigned char *str2, char *source_file_id_txt )
	{
		int_64 len, len1, len2;
		int stat;

		if (str1 == NULL)
			runtime_error( source_file_id_txt, 105, "NULL string 1 in str_u32_cmp().\n", "" );

		if (str2 == NULL)
			runtime_error( source_file_id_txt, 105, "NULL string 2 in str_u32_cmp().\n", "" );

		len1 = *((int_64 *) str1);
		len2 = *((int_64 *) str2);
		
		len = len1;
		
		if (len > len2)
			len = len2;

		stat = memcmp( str1 + sizeof( int_64 ), str2 + sizeof( int_64 ), len );
		
		if (stat == 0)
		{
			if (len1 > len2)
				stat = 1;
			else
			if (len1 < len2)
				stat = -1;
		}

		return (stat);		
	}

		// Returns 1 if two u32 strings are the same
		
	int str_u32_eq( unsigned char *str1, unsigned char *str2, char *source_file_id_txt )
	{
		int stat;
		
		stat = 0;

		if (str1 == NULL)
			runtime_error( source_file_id_txt, 105, "NULL string 1 in str_u32_eq().\n", "" );

		if (str2 == NULL)
			runtime_error( source_file_id_txt, 105, "NULL string 2 in str_u32_eq().\n", "" );
			
		if (*((int_64 *) str1) == *((int_64 *) str2))
		{
			if (memcmp( str1 + sizeof( int_64 ), str2 + sizeof( int_64 ), *((int_64 *) str1) ) == 0)
				stat = 1;
		}
		
		return (stat);		
	}
		
		
	void *_malloc( int_64 size )
	{
		char *ptr;

//		curr_bytes_malloced += size;

//		if (curr_bytes_malloced > peak_bytes_malloced)
//			peak_bytes_malloced = curr_bytes_malloced;
			 
		ptr = malloc( size + sizeof( short ) );

		if (ptr == NULL)
			runtime_error( "", 0, "Out of heap space", "" );

		*((short *) ptr) = 5678;
		
		return (ptr + sizeof( short ));
	}


	void *_malloc_initialised( int_64 size )
	{
		void *ptr;
			 
		ptr = _malloc( size );

		memset( ptr, 0, size );
		
		return (ptr);
	}

	
	void _free( void *ptr )
	{
		char *ptr2;
		
		ptr2 = (char *) ptr;
		
		ptr2 -= sizeof( short );
		
		if (*((short *) ptr2) == 6789)
		{
			printf( "Attempted free of already freed block" );
			exit( 1 );
		}

		if (*((short *) ptr2) != 5678)
		{
			printf( "Attempted free of non malloced block" );
			exit( 1 );
		}
	
		*((short *) ptr2) = 6789;
		
		free( ptr2 );
	}
	



	void var_check_s( var *vptr, char *source_file_id_txt )
	{
		char str[100];
	
#ifdef DEBUG	
		if (vptr == NULL)
			runtime_error( source_file_id_txt, 185, "NULL vptr in var_check_s", "" );
#endif

		if (vptr->var_type != VAR_STRING)
		{
			sprintf( str, "Invalid var_type in var_check_s, not a string. Possible uninitialised variable. Type: %d", vptr->var_type );
			
			runtime_error( source_file_id_txt, 185, str, "" );
		}

		if (vptr->data.svalue == NULL)
			runtime_error( source_file_id_txt, 185, "Invalid svalue in var_check_s, NULL string", "" );
	}
	
	