//<?

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <math.h>
#include <time.h>
#include <unistd.h>
#include <sys/stat.h>
#include <dirent.h>
#include "calc.h"
//#include "bst_tree_c_version.c"



//****************************************
// Next available runtime error code: 1153
//****************************************

#define NUM_FORMAT_FIXED 		1
#define NUM_FORMAT_FLOATING		2
#define NUM_FORMAT_NEEDED		4
#define NUM_FORMAT_CURRENCY		8
#define NUM_FMT_SCI_NOTATION	16
#define NUM_FORMAT_NO_COMMAS	32

#define NUM_IFORMAT_CURRENCY	1
#define NUM_IFORMAT_NO_COMMAS	2

#define FILE_MODE_READ 			0
#define FILE_MODE_WRITE 		1
#define FILE_MODE_APPEND 		2


#define MAX_OPEN_FILES 			1000
#define MAX_FGETS_INPUT 		100000

#define MAX_POST_ITEMS			2000
#define MAX_POST_KEY_SIZE		100
#define MAX_POST_ITEM_SIZE		50000

#define MAX_SESSION_ITEMS		3000
#define MAX_SESSION_KEY_SIZE	100
#define MAX_SESSION_ITEM_SIZE	50000

#define MAX_GET_ITEMS			100
#define MAX_GET_KEY_SIZE		100
#define MAX_GET_ITEM_SIZE		1000


#define MEDIUM_STRING_BUFFER_SIZE 	100000
#define SMALL_STRING_BUFFER_SIZE 	100


FILE *open_files[MAX_OPEN_FILES];
int fd_in_use[MAX_OPEN_FILES];

extern int _calcsys_ascii_only;
extern int _calcsys_bytes_per_char;

char post_item_key[MAX_POST_ITEMS][MAX_POST_KEY_SIZE + 1];
char *post_item_value[MAX_POST_ITEMS];
char get_item_key[MAX_GET_ITEMS][MAX_GET_KEY_SIZE + 1];
char get_item_value[MAX_GET_ITEMS][MAX_GET_ITEM_SIZE + 1];
char *session_item_key[MAX_SESSION_ITEMS];
char *session_item_value[MAX_SESSION_ITEMS];
int num_get_items;
int num_post_items;
int num_session_items;
int low_res_screen;
char ip_address[200];
int _calcsys_sort_function_number;


char *sp;
char *redirect_filename;
char *get_and_post_filename;

int is_web_page;
int memory_report;
int_64 peak_bytes_malloced;
int_64 peak_stack_usage;
int_64 stack_size;

int _calcsys_num_function_table_items;
char *_calcsys_function_table_name[MAX_FUNCTION_TABLE_ITEMS];
long int (*_calcsys_function_table_ptr[MAX_FUNCTION_TABLE_ITEMS])();


#define MAX_STR_SORT_SIGNIFICANT_CHARS	100


typedef struct
{
    int_64 input_array_key;
    char svalue[MAX_STR_SORT_SIGNIFICANT_CHARS];
} sort_item_s;


typedef struct
{
    int_64 input_array_key;
    double nvalue;
} sort_item_n;


typedef struct
{
    int_64 input_array_key;
    void *pvalue;
} sort_item_p;


sort_item_s *sort_items_s;
sort_item_n *sort_items_n;
sort_item_p *sort_items_p;

int sort_compare_n_asc( const void *item1, const void *item2 );
int sort_compare_n_desc( const void *item1, const void *item2 );
int sort_compare_s_asc( const void *item1, const void *item2 );
int sort_compare_s_desc( const void *item1, const void *item2 );

char *sleft( char *dest, char const *src, int_64 len );
char *sright( char *dest, char const *src, int_64 len );
char *smid( char *dest, char const *src, int_64 start, int_64 len );
void str_replace( char *dest, char *src, char *search, char *replace );
int_64 str_search( char *src, char *search );
int_64 str_rsearch( char *src, char *search );
void date_from_parts( char *text, int day, int month, int year, char *source_file_id_txt );
void time_from_parts( char *text, int hour, int minute, int second, char *source_file_id_txt );
int last_day_of_the_month( int year, int month );


void dec_to_hex( char *dest, unsigned char *src, int_64 num_bytes, int asc, int pad_with_leading_zeros );
void hex_to_binary( unsigned char *dest, char *src, char *source_file_id_txt );
int_64 hex_to_int( char *src, char *source_file_id_txt );
unsigned char dec_to_hex_1_nibble( unsigned char i );
unsigned char hex_to_dec_1_char( char ch );
void convert_date_to_yyyymmdd( char *dt, char *this_date, char *date_format, char *source_file_id_txt );
int check_date_valid( char const *date_text, char const *format, char const *source_file_id_txt );
int check_time_valid( char const *time_text );
int check_datetime_valid( char const *datetime_text, char const *source_file_id_txt );
int is_digit( char ch );
int is_leap_year( int year );
double max( double num1, double num2 );
long convert_date_to_julian( char *this_date, char *source_file_id_txt );
void convert_julian_to_date( char *str, long J );
int jweekday( long julian_date );
double jtrunc( double num );
void setup_get_and_post_arrays( char *get_and_post_filename );
void commarise( char *str2, char *str1 );

		void calc_stdlib_init( char *get_and_post_filename )
		{
		    int i;
			
			srand( time( NULL ) );
					    
		    for (i=0; i < MAX_OPEN_FILES; i++)
		    {
		    	fd_in_use[i] = -1;
		    	open_files[i] = NULL;
		    }
		    
			if (is_web_page && get_and_post_filename != NULL)
		    	setup_get_and_post_arrays( get_and_post_filename );
		}


		void calc_stdlib_exit( char *get_and_post_filename )
		{
			FILE *fp;
			int i;
			char str[MAX_SESSION_ITEM_SIZE];
			char filename[MEDIUM_STRING_BUFFER_SIZE];
			
			if (is_web_page && num_session_items > 0 && get_and_post_filename != NULL)
			{
				strncpy( filename, get_and_post_filename, 200 );
				
				filename[200] = '\0';
				
				strcat( filename, ".output" );
				
			    fp = fopen( filename, "w" );
			    
				if (fp == NULL)
				{
					printf( "Can't open output file: %s\n", filename );
					exit(1);
				}
				
				for (i=0; i < num_session_items; i++)
				{
					fputs( "SESSION\n", fp );
					fputs( session_item_key[i], fp );
					fputs( "\n", fp );
					
					str_replace( str, session_item_value[i], "\n", "\\n" );
					
					fputs( str, fp );
					
					fputs( "\n", fp );
				}
							
				fclose( fp );
			}
		}
		
		
		char *_calc_fopen( var *result, var *arg1, long int arg2, char *open_successful, char *source_file_id_txt )
		{
			int fd;
			int i;
			char str1[MEDIUM_STRING_BUFFER_SIZE];
			
			var_check_s( arg1, source_file_id_txt );
			
		    for (i=0; fd_in_use[i] != -1 && i < MAX_OPEN_FILES; i++) ;
		    
		    if (i >= MAX_OPEN_FILES)
				runtime_error( source_file_id_txt, 1089, "Too many open files", "" );
		
			fd = i;
			
			fd_in_use[fd] = 1;

			str_u32_to_u8( str1, arg1->data.svalue, MEDIUM_STRING_BUFFER_SIZE );
			
			if (arg2 == FILE_MODE_READ)
				open_files[fd] = fopen( str1, "r" );
			else
			if (arg2 == FILE_MODE_WRITE)
				open_files[fd] = fopen( str1, "w" );
			else
			if (arg2 == FILE_MODE_APPEND)
				open_files[fd] = fopen( str1, "a" );
			else
				runtime_error( source_file_id_txt, 1001, "Invalid file open type parameter.", "" );

			if (open_files[fd] == NULL)
			{
				*open_successful = false;
				fd = -1;
			}
			else
				*open_successful = true;
			
//				/* runtime_error */ runtime_error( source_file_id_txt, 1001, "fopen() returned NULL", arg1->data.svalue );
				
			*((long int *) result) = fd;
			
			return ((char *) result);
		}

		char *_calc_fgets( var *result, var *arg, char *source_file_id_txt )
		{
			char str[MAX_FGETS_INPUT];
			int arg1;

			arg1 = *((long int *) arg);

			str[0] = '\0';
			
			if (arg1 < 0 || arg1 >= MAX_OPEN_FILES) 
				runtime_error( source_file_id_txt, 1002, "Invalid fd in fgets()", "" );

			if (open_files[arg1] == NULL)
				runtime_error( source_file_id_txt, 1003, "NULL fd", "" );
		
			fgets( str, MAX_FGETS_INPUT, open_files[arg1]  );

			_calcsys_var_set_s( result, str, source_file_id_txt );
			
			return ((char *) result);
		}
		
		void _calc_fputs( var *arg1, var *arg, char *source_file_id_txt )
		{
			char str[MEDIUM_STRING_BUFFER_SIZE];
			char *ptr;
			long int arg2;
			long int src_length;

			arg2 = *((long int *) arg);
			
			if (arg2 < 0 || arg2 >= MAX_OPEN_FILES) 
				runtime_error( source_file_id_txt, 1004, "Invalid fd in fputs()", "" );

			if (open_files[arg2] == NULL)
				runtime_error( source_file_id_txt, 1005, "NULL fd", "" );
		
			var_check_s( arg1, source_file_id_txt );

			src_length = *((int_64 *) arg1->data.svalue);
		
			if (src_length >= MEDIUM_STRING_BUFFER_SIZE)
			{
				ptr = malloc( src_length + 1 );
				  
				str_u32_to_u8( ptr, arg1->data.svalue, src_length + 1 );
			}
			else
			{
				ptr = str;

				str_u32_to_u8( str, arg1->data.svalue, MEDIUM_STRING_BUFFER_SIZE );
			}
		
			fputs( ptr, open_files[arg2] );
			
			if (src_length >= MEDIUM_STRING_BUFFER_SIZE)
				free( ptr );
		}

		char _calc_feof( var *arg, char *source_file_id_txt )
		{
			int stat;
			int arg1;

			arg1 = *((long int *) arg);

			if (arg1 < 0 || arg1 >= MAX_OPEN_FILES) 
				runtime_error( source_file_id_txt, 1006, "Invalid fd in feof()", "" );

			if (open_files[arg1] == NULL)
				runtime_error( source_file_id_txt, 1007, "NULL fd", "" );
			
			stat = feof( open_files[arg1] );
		
			if (stat != 0)
				return ( true );
			else
				return ( false );
		}
		
		char _calc_fexists( var *arg1, char *source_file_id_txt )
		{
			FILE *fp;
			int stat;
			char str[MEDIUM_STRING_BUFFER_SIZE];
			
			var_check_s( arg1, source_file_id_txt );
			
			str_u32_to_u8( str, arg1->data.svalue, MEDIUM_STRING_BUFFER_SIZE );
			
			fp = fopen( str, "r" );
			
			if (fp == NULL)
				stat = false;
			else
			{
				stat = true;
			
				fclose( fp );
			}

			return ( stat );
		}


		char _calc_fis_a_directory( var *arg1, char *source_file_id_txt )
		{
			int st;
			struct stat file_info;
			char filename[MEDIUM_STRING_BUFFER_SIZE];
			
			var_check_s( arg1, source_file_id_txt );
			
			str_u32_to_u8( filename, arg1->data.svalue, MEDIUM_STRING_BUFFER_SIZE );
			
			st = lstat( filename, &file_info );
			
			if (st == -1)
				return ( 0 );
			else			
			if (S_ISDIR( file_info.st_mode ))
				return ( 1 );
			else
				return ( 0 );
		}


		char *_calc_flast_modified_datetime( var *result, var *arg1, char *source_file_id_txt )
		{
			int st;
			struct stat file_info;
			char str[MEDIUM_STRING_BUFFER_SIZE];
			char filename[MEDIUM_STRING_BUFFER_SIZE];
			
			var_check_s( arg1, source_file_id_txt );
			
			str_u32_to_u8( filename, arg1->data.svalue, MEDIUM_STRING_BUFFER_SIZE );
			
			st = lstat( filename, &file_info );
			
			if (st == -1)
				_calcsys_var_set_s( result, "0000-00-00 99:99:99", source_file_id_txt );
			else
			{
				strftime( str, MEDIUM_STRING_BUFFER_SIZE, "%Y-%m-%d %H:%M:%S", localtime(&(file_info.st_mtime)) );
				
				_calcsys_var_set_s( result, str, source_file_id_txt );
			}
			
			return ((char *) result);
		}


		long int _calc_ffiles_in_folder( var *arg1, var *arg2, char *source_file_id_txt )
		{
			DIR *fd;
			struct dirent *in_file;
			int_64 num_items; 
			int_64 len1;
			int_64 array_len_out;
			char out_str[MEDIUM_STRING_BUFFER_SIZE];
			char pathname[MEDIUM_STRING_BUFFER_SIZE];
			rarray *ra_ptr_dest;

			var_check_s( arg1, source_file_id_txt );

			if (arg2->var_type != VAR_RESIZABLE_ARRAY)
				runtime_error( source_file_id_txt, 1021, "Variable type is not a resizable array in ffiles_in_folder(). Call setsize.", "" );
			 
			ra_ptr_dest = (rarray *) arg2->data.pvalue;
			
			array_len_out = ra_ptr_dest->index_size[0];


			str_u32_to_u8( pathname, arg1->data.svalue, MEDIUM_STRING_BUFFER_SIZE );
			
			num_items = 0;
			
			len1 = *((int_64 *) arg1->data.svalue);

			if (len1 == 0)
				_calcsys_var_set_s( (var *) ra_ptr_dest->datap, "", source_file_id_txt );
			else
			{
				fd = opendir( pathname );
				
				if (fd != NULL)
				{
					in_file = readdir( fd );
				
					while (in_file)
					{
						if (strcmp( in_file->d_name, "." ) != 0 && strcmp( in_file->d_name, ".." ) != 0)
						{
							if (num_items >= array_len_out)
								runtime_error( source_file_id_txt, 1022, "The number of items exceeds the number of items in the output array", "" );
							
							str_u8_to_u32( out_str, in_file->d_name );

							_calcsys_var_set_s_u32( (var *) (ra_ptr_dest->datap + num_items * sizeof( var )), out_str, false, source_file_id_txt );
							
							num_items++;
						}
						
						in_file = readdir( fd );
					}
					
					closedir( fd );
				}
			}
						
			return ( num_items );
		}
		
		long int _calc_fsize( var *arg1, char *source_file_id_txt )
		{
			int_64 fsize;
			FILE *fp;
			char str[MEDIUM_STRING_BUFFER_SIZE];

			var_check_s( arg1, source_file_id_txt );

			str_u32_to_u8( str, arg1->data.svalue, MEDIUM_STRING_BUFFER_SIZE );

			fp = fopen( str, "r" );
			
			if (fp == NULL)
			{
				printf( "Can't open file for fsize(): %s\n", str );
				exit(1);
			}
			
			fseek( fp, (long) 0, SEEK_END );
			
			fsize = ftell( fp );

			rewind( fp );
			
			fclose( fp );
			
			return ( fsize );
		}


		void _calc_fseek( var *arg, long int arg2, char *source_file_id_txt )
		{
			int fd;

			fd = *((long int *) arg);
			
			if (fd < 0 || fd >= MAX_OPEN_FILES) 
				runtime_error( source_file_id_txt, 1011, "Invalid fd in fseek()", "" );

			if (open_files[fd] == NULL)
				runtime_error( source_file_id_txt, 1012, "NULL fd", "" );

			fseek( open_files[fd], (long) arg2, SEEK_SET );
		}


		long int _calc_fcurrent_position( var *arg1, char *source_file_id_txt )
		{
			int fd;

			fd = *((long int *) arg1);

			if (fd < 0 || fd >= MAX_OPEN_FILES) 
				runtime_error( source_file_id_txt, 1011, "Invalid fd in fcurrent_position()", "" );

			if (open_files[fd] == NULL)
				runtime_error( source_file_id_txt, 1012, "NULL fd", "" );
			
			return ( ftell( open_files[fd] ) );
		}

		
		char *_calc_ffile_get_contents_text( var *result, var *arg1, char *source_file_id_txt )
		{
			int_64 fsize;
			FILE *fp;
			char *ptr;
			char str[MEDIUM_STRING_BUFFER_SIZE];
			
			var_check_s( arg1, source_file_id_txt );

			str_u32_to_u8( str, arg1->data.svalue, MEDIUM_STRING_BUFFER_SIZE );

			fp = fopen( str, "r" );
			
			if (fp == NULL)
			{
				printf( "File '%s' not found\n", str );
				exit(1);
			}
			
			fseek( fp, (long) 0, SEEK_END );
			
			fsize = ftell( fp );

			ptr = _malloc( fsize + 1 );

			fseek( fp, (long) 0, SEEK_SET );
			
			fread( ptr, fsize, 1, fp );
			
			fclose( fp );
			
			ptr[fsize] = '\0';
			
			_calcsys_var_set_s( result, ptr, source_file_id_txt );
			
			_free( ptr );
			
			return ((char *) result);
		}


		void _calc_ffile_get_contents_binary( var *arg1, var *arg2, char *source_file_id_txt )
		{
			int_64 fsize;
			FILE *fp;
			char *ptr;
			char str[MEDIUM_STRING_BUFFER_SIZE];
			
			var_check_s( arg1, source_file_id_txt );

			if (arg2->var_type != VAR_BINARY)
				runtime_error( source_file_id_txt, 1100, "Variable is not a binary variable", "" );

			str_u32_to_u8( str, arg1->data.svalue, MEDIUM_STRING_BUFFER_SIZE );

			fp = fopen( str, "r" );
			
			if (fp == NULL)
			{
				printf( "File '%s' not found\n", str );
				exit(1);
			}
			
			fseek( fp, (long) 0, SEEK_END );
			
			fsize = ftell( fp );

			ptr = _malloc( fsize + sizeof( int_64 ) );

			fseek( fp, (long) 0, SEEK_SET );
			
			fread( ptr + sizeof( int_64 ), fsize, 1, fp );
			
			fclose( fp );
			
			if (arg2->data.bvalue != NULL)
				_free( arg2->data.bvalue );

			*((int_64 *) ptr) = fsize;
			
			arg2->data.bvalue = ptr;
		}

		
		void _calc_fdelete( var *arg1, char *source_file_id_txt )
		{
			char str[MEDIUM_STRING_BUFFER_SIZE];
			
			var_check_s( arg1, source_file_id_txt );

			str_u32_to_u8( str, arg1->data.svalue, MEDIUM_STRING_BUFFER_SIZE );
		
			remove( str );
		}
		
		void _calc_fclose( var *arg, char *source_file_id_txt )
		{
			int arg1;

			arg1 = *((long int *) arg);
		
			if (arg1 < 0 || arg1 >= MAX_OPEN_FILES) 
				runtime_error( source_file_id_txt, 1008, "Invalid fd in fclose()", "" );

			if (open_files[arg1] == NULL)
				runtime_error( source_file_id_txt, 1009, "NULL fd", "" );
			 	
			fclose( open_files[arg1] );

			fd_in_use[arg1] = -1;

	    	open_files[arg1] = NULL;
		}

		
		long int _calc_fread( var *arg1, long int arg2, var *arg, char *source_file_id_txt )
		{
			int_64 len;
			int_64 len2;
			int_64 num;
			char *ptr;
			int arg3;

			arg3 = *((long int *) arg);
			
			if (arg3 < 0 || arg3 >= MAX_OPEN_FILES) 
				runtime_error( source_file_id_txt, 1011, "Invalid fd in fread()", "" );

			if (open_files[arg3] == NULL)
				runtime_error( source_file_id_txt, 1012, "NULL fd", "" );

			len = arg2;

			if (arg1->var_type == VAR_BINARY)
			{			
				len2 = *((int_64 *) (arg1->data.bvalue));
			
				if (len > len2)
				{
					ptr = (unsigned char *) _malloc( len + sizeof( int_64 ) );
				
					_free( arg1->data.bvalue );
	
					arg1->data.bvalue = (unsigned char *) ptr;
				}
			}
			else
			{
				free_curr_mem_1( arg1, source_file_id_txt );
						
				arg1->data.bvalue = (unsigned char *) _malloc( len + sizeof( int_64 ) );
				
				arg1->var_type = VAR_BINARY;
			}
			
			num = fread( arg1->data.bvalue + sizeof( int_64 ), len, 1, open_files[arg3] );
			
			return ( num );
		}
		
		
		void _calc_fwrite( var *arg1, long int arg2, var *arg, char *source_file_id_txt )
		{
			int_64 len;
			int arg3;

			arg3 = *((long int *) arg);
			
			if (arg1->var_type != VAR_BINARY)
				runtime_error( source_file_id_txt, 1101, "Variable is not a binary variable", "" );
			
			if (arg3 < 0 || arg3 >= MAX_OPEN_FILES) 
				runtime_error( source_file_id_txt, 1013, "Invalid fd in fwrite()", "" );

			if (open_files[arg3] == NULL)
				runtime_error( source_file_id_txt, 1014, "NULL fd", "" );
			
			if (((var *) arg1)->data.bvalue == NULL)
				runtime_error( source_file_id_txt, 1102, "NULL bvalue in fwrite", "" );
			
			len = *((int_64 *) (((var *) arg1)->data.bvalue));
			
			if (arg2 > len)
				runtime_error( source_file_id_txt, 1015, "Bytes to write exceeds data length", "" );

			fwrite( arg1->data.bvalue + sizeof( int_64 ), arg2, 1, open_files[arg3] );
		}
		
		
		void _calc_mkdir( var *arg1, long int arg2, char *source_file_id_txt )
		{
			char str[MEDIUM_STRING_BUFFER_SIZE];
			
			var_check_s( arg1, source_file_id_txt );
		
			str_u32_to_u8( str, arg1->data.svalue, MEDIUM_STRING_BUFFER_SIZE );
		
			mkdir( str, arg2 );
		}

		void _calc_print( var *arg1, char *source_file_id_txt )
		{
			char str[MEDIUM_STRING_BUFFER_SIZE];
			
			var_check_s( arg1, source_file_id_txt );

			str_u32_to_u8( str, arg1->data.svalue, MEDIUM_STRING_BUFFER_SIZE );
		
			if (is_web_page)
				printf( "%s<br>", str );
			else
				printf( "%s\n", str );
		}

		
		void _calc_output( var *arg1, char *source_file_id_txt )
		{
			char str[MEDIUM_STRING_BUFFER_SIZE];
			
			var_check_s( arg1, source_file_id_txt );

			str_u32_to_u8( str, arg1->data.svalue, MEDIUM_STRING_BUFFER_SIZE );
		
//			fputs( str, stdout );
			
			printf( "%s", str );
		}


		char *_calc_input_string( var *result, char *source_file_id_txt )
		{
			char str[MEDIUM_STRING_BUFFER_SIZE];

			str[0] = '\0';

			fgets( str, MEDIUM_STRING_BUFFER_SIZE-1, stdin );

			_calcsys_var_set_s( result, str, source_file_id_txt );
			
			return ((char *) result);
		}

	
	//--------------------------------------------------------------------------
	// Strings
	//--------------------------------------------------------------------------

				
		long int _calc_slength( var *arg1, char *source_file_id_txt )
		{
			var_check_s( arg1, source_file_id_txt );
		
			if (arg1->data.svalue == NULL)
				return ( 0 );
			else
			if (_calcsys_ascii_only)
				return ( *((int_64 *) (arg1->data.svalue)) );
			else
				return ( *((int_64 *) (arg1->data.svalue)) / 4 );
		}
		
				
		char *_calc_sleft( var *result, var *arg1, long int arg2, char *source_file_id_txt )
		{
			char *str;
			char str4[MEDIUM_STRING_BUFFER_SIZE + sizeof( int_64 )];
			int_64 len;
			int_64 src_len;
			
			var_check_s( arg1, source_file_id_txt );
			
			src_len = *((int_64 *) arg1->data.svalue);
			
			if (_calcsys_ascii_only)
				len = arg2;
			else
				len = arg2 * 4;

			if (len < 0)
				runtime_error( source_file_id_txt, 1016, "Negative length in sleft().", "" );
			
			if (len >= src_len)
			{			
				if (arg1->storage_type == VAR_CONSTANT_STRING)
					_calcsys_var_set_s_u32( result, arg1->data.svalue, true, source_file_id_txt );
				else
					_calcsys_var_set_s_u32( result, arg1->data.svalue, false, source_file_id_txt );
			}			
			else
			{
				if (len >= MEDIUM_STRING_BUFFER_SIZE)
					str = _malloc( len + sizeof( int_64 ) );
				else
					str = str4;
				
				memcpy( str + sizeof( int_64 ), arg1->data.svalue + sizeof( int_64 ), len );
				
				*((int_64 *) str) = len;
	
				_calcsys_var_set_s_u32( result, str, false, source_file_id_txt );
				
				if (len >= MEDIUM_STRING_BUFFER_SIZE)
					_free( str );
			}
			
			return ((char *) result);			
		}

				
		char *_calc_sright( var *result, var *arg1, long int arg2, char *source_file_id_txt )
		{
			char *str;
			char str4[MEDIUM_STRING_BUFFER_SIZE + sizeof( int_64 )];
			int_64 len;
			int_64 src_len;
			
			var_check_s( arg1, source_file_id_txt );
			
			src_len = *((int_64 *) arg1->data.svalue);
			
			if (_calcsys_ascii_only)
				len = arg2;
			else
				len = arg2 * 4;
			
			if (len < 0)
				runtime_error( source_file_id_txt, 1017, "Negative length in sright().", "" );
			
			if (len >= src_len)
			{
				if (arg1->storage_type == VAR_CONSTANT_STRING)
					_calcsys_var_set_s_u32( result, arg1->data.svalue, true, source_file_id_txt );
				else
					_calcsys_var_set_s_u32( result, arg1->data.svalue, false, source_file_id_txt );
			}			
			else
			{
				if (len >= MEDIUM_STRING_BUFFER_SIZE)
					str = _malloc( len + sizeof( int_64 ) );
				else
					str = str4;
				
				memcpy( str + sizeof( int_64 ), arg1->data.svalue + sizeof( int_64 ) + src_len - len, len );
				
				*((int_64 *) str) = len;
	
				_calcsys_var_set_s_u32( result, str, false, source_file_id_txt );
				
				if (len >= MEDIUM_STRING_BUFFER_SIZE)
					_free( str );
			}
			
			return ((char *) result);			
		}

		char *_calc_sright_from_pos( var *result, var *arg1, long int arg2, char *source_file_id_txt )
		{
			char *str;
			char str4[MEDIUM_STRING_BUFFER_SIZE + sizeof( int_64 )];
			int_64 pos, len;
			int_64 src_len;
			
			var_check_s( arg1, source_file_id_txt );
			
			src_len = *((int_64 *) arg1->data.svalue);
			
			if (_calcsys_ascii_only)
				pos = arg2;
			else
				pos = arg2 * 4;
			
			if (pos < 0)
				runtime_error( source_file_id_txt, 1017, "Negative start pos in sright_from_pos().", "" );
			
			if (pos >= src_len)
				_calcsys_var_set_s( result, "", source_file_id_txt );
			else
			{
				len = src_len - pos;
				
				if (len >= MEDIUM_STRING_BUFFER_SIZE)
					str = _malloc( len + sizeof( int_64 ) );
				else
					str = str4;
				
				memcpy( str + sizeof( int_64 ), arg1->data.svalue + sizeof( int_64 ) + pos, len );
				
				*((int_64 *) str) = len;
	
				_calcsys_var_set_s_u32( result, str, false, source_file_id_txt );
				
				if (len >= MEDIUM_STRING_BUFFER_SIZE)
					_free( str );
			}
			
			return ((char *) result);			
		}

		char *_calc_smid( var *result, var *arg1, long int arg2, long int arg3, char *source_file_id_txt )
		{
			char *str;
			char str4[MEDIUM_STRING_BUFFER_SIZE + sizeof( int_64 )];
			int_64 len;
			int_64 src_len;
			int_64 start;
			
			var_check_s( arg1, source_file_id_txt );
			
			src_len = *((int_64 *) arg1->data.svalue);

			if (_calcsys_ascii_only)
				start = arg2;
			else
				start = arg2 * 4;

			if (start < 0)
				runtime_error( source_file_id_txt, 1018, "Negative start in smid().", "" );

			if (_calcsys_ascii_only)
				len = arg3;
			else
				len = arg3 * 4;

			if (len < 0)
				runtime_error( source_file_id_txt, 1019, "Negative length in smid().", "" );

			if (start >= src_len)
				runtime_error( source_file_id_txt, 1103, "Start position exceeds string length in smid().", "" );

			if (start + len > src_len)
				len = src_len - start;
				
			if (len >= MEDIUM_STRING_BUFFER_SIZE)
				str = _malloc( len + sizeof( int_64 ) );
			else
				str = str4;
			
			memcpy( str + sizeof( int_64 ), arg1->data.svalue + sizeof( int_64 ) + start, len );
			
			*((int_64 *) str) = len;

			_calcsys_var_set_s_u32( result, str, false, source_file_id_txt );
			
			if (len >= MEDIUM_STRING_BUFFER_SIZE)
				_free( str );
				
			return ((char *) result);			
		}

		char *_calc_schar( var *result, var *arg1, long int arg2, char *source_file_id_txt )
		{
			char str[SMALL_STRING_BUFFER_SIZE], *ptr, *ptr2;
			int_64 src_len;
			int_64 pos;

			var_check_s( arg1, source_file_id_txt );

			src_len = *((int_64 *) (arg1->data.svalue));
			
			if (_calcsys_ascii_only)
				pos = arg2;
			else
				pos = arg2 * 4;
				
			if (pos < 0)
				runtime_error( source_file_id_txt, 1020, "Negative position in schar().", "" );
				
			if (pos >= src_len)
				_calcsys_var_set_s( result, "", source_file_id_txt );
			else
			{
				if (_calcsys_ascii_only)
					*((int_64 *) str) = 1;
				else
					*((int_64 *) str) = 4;
				
				ptr = str + sizeof( int_64 );
				ptr2 = arg1->data.svalue + sizeof( int_64 ) + pos;
				
				*ptr++ = *ptr2++;
				
				if (! _calcsys_ascii_only)
				{
					*ptr++ = *ptr2++;
					*ptr++ = *ptr2++;
					*ptr++ = *ptr2++;
				}
								
				_calcsys_var_set_s_u32( result, str, false, source_file_id_txt );
			}
			
			return ((char *) result);			
		}

		char *_calc_stoupper( var *result, var *arg1, char *source_file_id_txt )
		{
			char *str, *ptr, *ptr2;
			char str4[MEDIUM_STRING_BUFFER_SIZE + sizeof( int_64 )];
			int_64 i, src_len;

			var_check_s( arg1, source_file_id_txt );

			src_len = *((int_64 *) arg1->data.svalue);
		
			if (src_len >= MEDIUM_STRING_BUFFER_SIZE)
				str = _malloc( src_len + sizeof( int_64 ) );
			else
				str = str4;

			*((int_64 *) str) = src_len;
			
			ptr = str + sizeof( int_64 );
			
			ptr2 = arg1->data.svalue + sizeof( int_64 ); 
			
			
			if (_calcsys_ascii_only)
			{
				for (i=0; i < src_len; i++)
					*ptr++ = toupper( *ptr2++ ); 
			}
			else
			{
				for (i=0; i < src_len; i+=4)
				{
					*ptr++ = toupper( *ptr2++ ); 
					*ptr++ = *ptr2++; 
					*ptr++ = *ptr2++; 
					*ptr++ = *ptr2++; 
				}
			}
						
			_calcsys_var_set_s_u32( result, str, false, source_file_id_txt );
				
			if (src_len >= MEDIUM_STRING_BUFFER_SIZE)
				_free( str );
				
			return ((char *) result);			
		}

		char *_calc_stolower( var *result, var *arg1, char *source_file_id_txt )
		{
			char *str, *ptr, *ptr2;
			char str4[MEDIUM_STRING_BUFFER_SIZE + sizeof( int_64 )];
			int_64 i, src_len;

			var_check_s( arg1, source_file_id_txt );

			src_len = *((int_64 *) arg1->data.svalue);
		
			if (src_len >= MEDIUM_STRING_BUFFER_SIZE)
				str = _malloc( src_len + sizeof( int_64 ) );
			else
				str = str4;

			*((int_64 *) str) = src_len;

			ptr = str + sizeof( int_64 );
			
			ptr2 = arg1->data.svalue + sizeof( int_64 ); 
				
			if (_calcsys_ascii_only)
			{
				for (i=0; i < src_len; i++)
					*ptr++ = tolower( *ptr2++ ); 
			}
			else
			{				
				for (i=0; i < src_len; i+=4)
				{
					*ptr++ = tolower( *ptr2++ ); 
					*ptr++ = *ptr2++; 
					*ptr++ = *ptr2++; 
					*ptr++ = *ptr2++; 
				}
			}
			
			_calcsys_var_set_s_u32( result, str, false, source_file_id_txt );
				
			if (src_len >= MEDIUM_STRING_BUFFER_SIZE)
				_free( str );
				
			return ((char *) result);			
		}
			

		char _calc_scaseieq( var *arg1, var *arg2, char *source_file_id_txt )
		{
			int stat;
			int_64 i;
			int_64 len1, len2;
			char *ptr1, *ptr2;
			
			var_check_s( arg1, source_file_id_txt );
			var_check_s( arg2, source_file_id_txt );

			stat = true;
		
			len1 = *((int_64 *) arg1->data.svalue);
			len2 = *((int_64 *) arg2->data.svalue);
		
			if (len1 != len2)
				stat = false;
			else
			{
				ptr1 = arg1->data.svalue + sizeof( int_64 );
				ptr2 = arg2->data.svalue + sizeof( int_64 );
			 
				if (_calcsys_ascii_only)
				{
					for (i=0; stat && (i < len1); i++)
					{
						if (toupper( *ptr1++ ) != toupper( *ptr2++ ))
							stat = false;
					}			
				}
				else				
			 	{
					for (i=0; stat && (i < len1); i+=4)
					{
						if (toupper( *ptr1++ ) != toupper( *ptr2++ ))
							stat = false;
	
						if (*ptr1++ != *ptr2++)
							stat = false;
							
						if (*ptr1++ != *ptr2++)
							stat = false;
							
						if (*ptr1++ != *ptr2++)
							stat = false;
					}
				}			
			}			

			return ( stat );
		}
			

		long int _calc_ssearch( var *arg1, var *arg2, char *source_file_id_txt )
		{
			int_64 pos, lst;
			int_64 i, len1, len2;
			char *ptr1, *ptr2;

			pos = -1;
						
			len1 = *((int_64 *) arg1->data.svalue);
			len2 = *((int_64 *) arg2->data.svalue);
			
			ptr1 = arg1->data.svalue + sizeof( int_64 );
			ptr2 = arg2->data.svalue + sizeof( int_64 );
			
			lst = len1 - len2;
			
			if (len2 <= len1)
			{
				if (_calcsys_ascii_only)
				{
					for (i=0; pos == -1 && (i <= lst); i++)
					{
						if (memcmp( ptr1, ptr2, len2 ) == 0)
							pos = i;
						else
							ptr1++;
					}
				}
				else
				{			
					for (i=0; pos == -1 && (i <= lst); i+=4)
					{
						if (memcmp( ptr1, ptr2, len2 ) == 0)
							pos = i / 4;
						else
							ptr1 += 4;
					}
				}
			}
				
			return ( pos );
		}
			

		long int _calc_srsearch( var *arg1, var *arg2, char *source_file_id_txt )
		{
			int_64 pos, lst;
			int_64 i, len1, len2;
			char *ptr1, *ptr2;

			pos = -1;
						
			len1 = *((int_64 *) arg1->data.svalue);
			len2 = *((int_64 *) arg2->data.svalue);
			
			ptr1 = arg1->data.svalue + sizeof( int_64 ) + len1 - len2;
			ptr2 = arg2->data.svalue + sizeof( int_64 );
			
			lst = len1 - len2;
			
			if (len2 <= len1)
			{
				if (_calcsys_ascii_only)
				{
					for (i=lst; pos == -1 && (i >= 0); i--)
					{
						if (memcmp( ptr1, ptr2, len2 ) == 0)
							pos = i;
						else
							ptr1--;
					}
				}
				else
				{
					for (i=lst; pos == -1 && (i >= 0); i-=4)
					{
						if (memcmp( ptr1, ptr2, len2 ) == 0)
							pos = i / 4;
						else
							ptr1 -= 4;
					}
				}
			}
				
			return ( pos );
		}

		char *_calc_strim( var *result, var *arg1, char *source_file_id_txt )
		{
			char *str;
			char str4[MEDIUM_STRING_BUFFER_SIZE];
			char *start, *end;
			int_64 len, len2;
			
			var_check_s( arg1, source_file_id_txt );
			
			len = *((int_64 *) arg1->data.svalue);
			
			start = arg1->data.svalue + sizeof( int_64 );

			end = start + len - _calcsys_bytes_per_char;
			 
			while (start < end && (*start == ' ' || *start == '\t' || *start == '\n'|| *start == '\r'))
				start += _calcsys_bytes_per_char;
			
			while (end >= start && (*end == ' ' || *end == '\t' || *end == '\n'|| *end == '\r')) 
				end -= _calcsys_bytes_per_char;
			
			if (end < start)
			{
				_calcsys_var_set_s( result, "", source_file_id_txt );
			}
			else
			{
				len2 = end - start + _calcsys_bytes_per_char;
					
				str = _malloc( sizeof( int_64 ) + len2 );

				memcpy( str + sizeof( int_64 ), start, len2 );

				*((int_64 *) str) = len2;

				_calcsys_var_set_s_u32( result, str, false, source_file_id_txt );
				
				_free( str );
			}

			return ((char *) result);			
		}


		char *_calc_sreplace( var *result, var *arg1, var *arg2, var *arg3, char *source_file_id_txt )
		{
			char *str, *str2, *ptr1, *ptr4;
			int_64 len1, len2, len3, len4;
			int_64 result_len;
			
			var_check_s( arg1, source_file_id_txt );
			var_check_s( arg2, source_file_id_txt );
			var_check_s( arg3, source_file_id_txt );

			len1 = *((int_64 *) arg1->data.svalue);
			len2 = *((int_64 *) arg2->data.svalue);
			len3 = *((int_64 *) arg3->data.svalue);
			
			result_len = _calcsys_bytes_per_char * len1 + 1;
			
			if (result_len < 1000)
				result_len = 1000;
			
			str = _malloc( result_len );

			ptr1 = arg1->data.svalue + sizeof( int_64 );
			ptr4 = str + sizeof( int_64 );

			while (ptr1 < arg1->data.svalue + sizeof( int_64 ) + len1)			
			{
				if (memcmp( ptr1, arg2->data.svalue + sizeof( int_64 ), len2 ) == 0)
				{
					if ((ptr4 - str) + len3 >= result_len)
					{
						str2 = _malloc( result_len * 2 );
						memcpy( str2, str, result_len );
						ptr4 = str2 + (ptr4 - str);
						_free( str );
						str = str2;
						result_len *= 2;
					}
					
					memcpy( ptr4, arg3->data.svalue + sizeof( int_64 ), len3 );
					ptr1 += len2;
					ptr4 += len3;
				}
				else
				{
					if ((ptr4 - str) + _calcsys_bytes_per_char >= result_len)
					{
						str2 = _malloc( result_len * 2 );
						memcpy( str2, str, result_len );
						ptr4 = str2 + (ptr4 - str);
						_free( str );
						str = str2;
						result_len *= 2;
					}
					
					memcpy( ptr4, ptr1, _calcsys_bytes_per_char );
					ptr1 += _calcsys_bytes_per_char;
					ptr4 += _calcsys_bytes_per_char;
				}
			}
			
			len4 = ptr4 - str - sizeof( int_64 );
			
			*((int_64 *) str) = len4;
	
			_calcsys_var_set_s_u32( result, str, false, source_file_id_txt );
			
			_free( str );
			
			return ((char *) result);			
		}
			
			// sexplode( string s, string delimiter, array string [int variable] receiving_array );

		long int _calc_sexplode( var *arg1, var *arg2, var *arg3, char *source_file_id_txt )
		{
			int_64 num_items; 
			int_64 len1, len2;
			char *delimiter;
			char *startp;
			char *endp;
			int_64 array_len_out;
			char *ptr;
			char out_str[MEDIUM_STRING_BUFFER_SIZE];
			rarray *ra_ptr_dest;

			var_check_s( arg1, source_file_id_txt );
			var_check_s( arg2, source_file_id_txt );

			if (arg3->var_type != VAR_RESIZABLE_ARRAY)
				runtime_error( source_file_id_txt, 1021, "Variable type is not a resizable array in sexplode(). Call setsize.", "" );
			 
			ra_ptr_dest = (rarray *) arg3->data.pvalue;
			
			array_len_out = ra_ptr_dest->index_size[0];
			
			delimiter = arg2->data.svalue + sizeof( int_64 );
			
			ptr = arg1->data.svalue + sizeof( int_64 );

			num_items = 0;
			
			len1 = *((int_64 *) arg1->data.svalue);
			len2 = *((int_64 *) arg2->data.svalue);

			if (len1 == 0 || len2 > len1)
				_calcsys_var_set_s( (var *) ra_ptr_dest->datap, "", source_file_id_txt );
			else
			{
				startp = ptr;
				endp = ptr + len1;
				
				for (; ptr < endp; ptr += _calcsys_bytes_per_char)
				{
					if (memcmp( ptr, delimiter, len2 ) == 0)
					{
						if (num_items >= array_len_out)
							runtime_error( source_file_id_txt, 1022, "The number of items exceeds the number of items in the output array", "" );

						memcpy( out_str + sizeof( int_64 ), startp, ptr - startp );

						*((int_64 *) out_str) = ptr - startp; 
						
						_calcsys_var_set_s_u32( (var *) (ra_ptr_dest->datap + num_items * sizeof( var )), out_str, false, source_file_id_txt );
	
						startp = ptr + len2;
	
						ptr += len2 - _calcsys_bytes_per_char;
						
						num_items++;
					}
				}
	
				if (startp < endp || memcmp( endp - len2, delimiter, len2 ) == 0)
				{
					if (num_items >= array_len_out)
						runtime_error( source_file_id_txt, 1023, "The number of items exceeds the number of items in the output array", "" );

					memcpy( out_str + sizeof( int_64 ), startp, ptr - startp );

					*((int_64 *) out_str) = ptr - startp; 
							
					_calcsys_var_set_s_u32( (var *) (ra_ptr_dest->datap + num_items * sizeof( var )), out_str, false, source_file_id_txt );
		
					num_items++;
				}
			}
						
			return ( num_items );
		}		

			// sexplode_whitespace( string s, array string [int variable] receiving_array );

		long int _calc_sexplode_whitespace( var *arg1, var *arg2, var *arg3, char *source_file_id_txt )
		{
			int_64 num_items, j; 
			int_64 len1;
			char *sp2;
			int_64 array_len_out;
			char *ptr;
			char *ptr2;
			char out_str[MEDIUM_STRING_BUFFER_SIZE];
			var *vptr;
			rarray *ra_ptr_dest;

			var_check_s( arg1, source_file_id_txt );

			if (arg2->var_type != VAR_RESIZABLE_ARRAY)
				runtime_error( source_file_id_txt, 1021, "Variable type is not a resizable array in sexplode_whitespace(). Call setsize.", "" );
			 
			ra_ptr_dest = (rarray *) arg2->data.pvalue;
			
			array_len_out = ra_ptr_dest->index_size[0];
			
			ptr = arg1->data.svalue + sizeof( int_64 );

			ptr2 = out_str + sizeof( int_64 );
			num_items = 0;

			
			len1 = *((int_64 *) arg1->data.svalue);

			if (len1 == 0)
				_calcsys_var_set_s( (var *) ra_ptr_dest->datap, "", source_file_id_txt );
			else
			{
				while ((*ptr == ' ' || *ptr == '\t' || *ptr == '\r' || *ptr == '\n') &&
						(ptr - arg1->data.svalue) < len1 + sizeof( int_64 )) 
					ptr += _calcsys_bytes_per_char;
	
				for (; (ptr - arg1->data.svalue) < len1 + sizeof( int_64 );)
				{
					if (*ptr == ' ' || *ptr == '\t' || *ptr == '\r' || *ptr == '\n')
					{
						if (num_items >= array_len_out)
							runtime_error( source_file_id_txt, 1022, "The number of items exceeds the number of items in the output array", "" );
						
						*((int_64 *) out_str) = ptr2 - out_str - sizeof( int_64 ); 
						
						_calcsys_var_set_s_u32( (var *) (ra_ptr_dest->datap + num_items * sizeof( var )), out_str, false, source_file_id_txt );
	
						ptr2 = out_str + sizeof( int_64 );
						num_items++;
						
						while ((*ptr == ' ' || *ptr == '\t' || *ptr == '\r' || *ptr == '\n') &&
								(ptr - arg1->data.svalue) < len1 + sizeof( int_64 )) 
							ptr += _calcsys_bytes_per_char;
					}
					else
					{
						memcpy( ptr2, ptr, _calcsys_bytes_per_char );
						ptr2 += _calcsys_bytes_per_char;
						ptr += _calcsys_bytes_per_char;
					}
				}
	
				if (ptr2 > out_str)
				{
					if (num_items >= array_len_out)
						runtime_error( source_file_id_txt, 1023, "The number of items exceeds the number of items in the output array", "" );
	
					*((int_64 *) out_str) = ptr2 - out_str - sizeof( int_64 ); 
							
					_calcsys_var_set_s_u32( (var *) (ra_ptr_dest->datap + num_items * sizeof( var )), out_str, false, source_file_id_txt );
		
					num_items++;
				}
				
				ptr -= _calcsys_bytes_per_char;
							
				if (num_items > 0 && (*ptr == ' ' || *ptr == '\t' || *ptr == '\r' || *ptr == '\n'))
					num_items--;
			}
						
			return ( num_items );
		}		
		
			// sexplode( string s, string delimiter, array string [int variable] receiving_array );

		long int _calc_sexplode_csv( var *arg1, var *arg2, var *arg3, char *source_file_id_txt )
		{
			int_64 num_items, j; 
			int_64 len1, len2;
			int in_quote_string;
			int next_item;
			int lst_is_quoted_string;
			char *sp2;
			char *delimiter;
			int_64 array_len_out;
			char *ptr;
			char *ptr2;
			char out_str[MEDIUM_STRING_BUFFER_SIZE];
			var *vptr;
			rarray *ra_ptr_dest;

			var_check_s( arg1, source_file_id_txt );
			var_check_s( arg2, source_file_id_txt );

			if (arg3->var_type != VAR_RESIZABLE_ARRAY)
				runtime_error( source_file_id_txt, 1021, "Variable type is not a resizable array in sexplode_csv(). Call setsize.", "" );
			 
			ra_ptr_dest = (rarray *) arg3->data.pvalue;
			
			array_len_out = ra_ptr_dest->index_size[0];
			
			delimiter = arg2->data.svalue + sizeof( int_64 );
			
			ptr = arg1->data.svalue + sizeof( int_64 );

			ptr2 = out_str + sizeof( int_64 );
			num_items = 0;
			
			lst_is_quoted_string = false;
			
			len1 = *((int_64 *) arg1->data.svalue);
			len2 = *((int_64 *) arg2->data.svalue);

			in_quote_string = false;

			if (len1 == 0)
				_calcsys_var_set_s( (var *) ra_ptr_dest->datap, "", source_file_id_txt );
			else
			{
				if (*ptr == '"')
				{
					in_quote_string = true;
					ptr += _calcsys_bytes_per_char;
				}

				next_item = false;
			
				for (; (ptr - arg1->data.svalue) < len1 + sizeof( int_64 ); ptr += _calcsys_bytes_per_char)
				{
					if (in_quote_string && *ptr == '"')
						next_item = true;
				
					if ((! in_quote_string) && memcmp( ptr, delimiter, len2 ) == 0)
						next_item = true;
					
					if (next_item)
					{
						if (num_items >= array_len_out)
							runtime_error( source_file_id_txt, 1022, "The number of items exceeds the number of items in the output array", "" );
						
						*((int_64 *) out_str) = ptr2 - out_str - sizeof( int_64 ); 
						
						_calcsys_var_set_s_u32( (var *) (ra_ptr_dest->datap + num_items * sizeof( var )), out_str, false, source_file_id_txt );
	
						ptr2 = out_str + sizeof( int_64 );
						num_items++;
						
						next_item = false;
						
						ptr += len2 - _calcsys_bytes_per_char;

						if (in_quote_string)
							ptr += _calcsys_bytes_per_char;

						if ((ptr - arg1->data.svalue) >= len1 + sizeof( int_64 ))
							lst_is_quoted_string = true;
						else
						{
							in_quote_string = false;
							
							if ((ptr - arg1->data.svalue) < len1 + sizeof( int_64 ))
							{
								if (*(ptr+_calcsys_bytes_per_char) == '"')
								{
									in_quote_string = true;
									
									ptr += _calcsys_bytes_per_char;
								}
							}
						}						
					}
					else
					{
						memcpy( ptr2, ptr, _calcsys_bytes_per_char );
						ptr2 += _calcsys_bytes_per_char;
					}
				}
	
				if ((! lst_is_quoted_string) && ptr2 > out_str)
				{
					if (num_items >= array_len_out)
						runtime_error( source_file_id_txt, 1023, "The number of items exceeds the number of items in the output array", "" );
	
					if (in_quote_string)
						ptr2 -= _calcsys_bytes_per_char;
					
					*((int_64 *) out_str) = ptr2 - out_str - sizeof( int_64 ); 
							
					_calcsys_var_set_s_u32( (var *) (ra_ptr_dest->datap + num_items * sizeof( var )), out_str, false, source_file_id_txt );
		
					num_items++;
				}
			}
						
			return ( num_items );
		}		
		

		long int _calc_schar_to_int( var *arg1, char *source_file_id_txt )
		{
			int_32 ch;

			var_check_s( arg1, source_file_id_txt );
			
			if (arg1->data.svalue == NULL)
				runtime_error( source_file_id_txt, 1024, "NULL string in scalc_char_to_int()", "" );
			
			ch = *((int_32 *) (arg1->data.svalue + sizeof( int_64 )));
		
			return ( ch );
 
		}

 
		char *_calc_sint_to_char( var *result, long int arg1, char *source_file_id_txt ) 
		{
			char str[SMALL_STRING_BUFFER_SIZE];
			char *ptr;
			
			ptr = str;
			
			*((int_64 *) ptr) = 4;

			*((int_64 *) (ptr + sizeof( int_64 ))) = arg1;
			
			_calcsys_var_set_s_u32( result, str, false, source_file_id_txt );
			
			return ((char *) result);			
		}


	//--------------------------------------------------------------------------
	// Mathematics
	//--------------------------------------------------------------------------
		
				
		double _calc_mrand( char *source_file_id_txt )
		{
			return ( ((double) rand()) / ((double) RAND_MAX) );
		}
			

		void _calc_mseed_rand( long int seed, char *source_file_id_txt )
		{
			srand( seed );
		}
				
				
		long int _calc_mtrunc( double arg1, char *source_file_id_txt )
		{
			return ( (long int) arg1 );
		}
			
				
		double _calc_msqrt( double arg1, char *source_file_id_txt )
		{
			if (arg1 == 0)
				runtime_error( source_file_id_txt, 1025, "Square root of zero", "" );

			if (arg1 < 0)
				runtime_error( source_file_id_txt, 1026, "Square root of a negative number", "" );
		
			return ( sqrt(arg1) );
		}
			
				
		double _calc_mfabs( double arg1, char *source_file_id_txt )
		{
			if (arg1 >= 0)
				return ( arg1 );
			else
				return ( -arg1 );
		}
			
				
		long int _calc_miabs( long int arg1, char *source_file_id_txt )
		{
			if (arg1 >= 0)
				return ( arg1 );
			else
				return ( -arg1 );
		}
			
				
		double _calc_mfmax( double arg1, double arg2, char *source_file_id_txt )
		{
			if (arg1 >= arg2)
				return ( arg1 );
			else
				return ( arg2 );
		}
					
				
		double _calc_mfmin( double arg1, double arg2, char *source_file_id_txt )
		{
			if (arg1 <= arg2)
				return ( arg1 );
			else
				return ( arg2 );
		}
			
				
		long int _calc_mimax( long int arg1, long int arg2, char *source_file_id_txt )
		{
			if (arg1 >= arg2)
				return ( arg1 );
			else
				return ( arg2 );
		}
			
				
		long int _calc_mimin( long int arg1, long int arg2, char *source_file_id_txt )
		{
			if (arg1 <= arg2)
				return ( arg1 );
			else
				return ( arg2 );
		}
			
				
		double _calc_mlog( double arg1, char *source_file_id_txt )
		{
			return ( log( arg1 ) );
		}
	
				
		double _calc_mlog10( double arg1, char *source_file_id_txt )
		{
			return ( log10( arg1 ) );
		}
					
				
		double _calc_mexp( double arg1, char *source_file_id_txt )
		{
			return ( pow( 2.71828182845904, arg1 ) );
		}
			
				
		double _calc_mround( double arg1, long int arg2, char *source_file_id_txt )
		{
			double x;
		
			x = arg1 * pow( 10, arg2 );
			
			x += 0.5;
			
			x = (int) x;
			
			x = x / pow( 10, arg2 );

			return ( x );
		}

		char *_calc_mformat( var *result, double arg1, long int arg2, long int arg3, char *source_file_id_txt )
		{
			char s[MEDIUM_STRING_BUFFER_SIZE];
			char s2[MEDIUM_STRING_BUFFER_SIZE];
			char s3[MEDIUM_STRING_BUFFER_SIZE];
			char fmt[SMALL_STRING_BUFFER_SIZE];
			int i, dec;
			char *pos;
			
			sprintf( s2, "%%.%df", arg3 );
				
			sprintf( s, s2, arg1 );

			trim_trailing_zeros( s );

			s2[0] = '\0';
			
			
			if ((arg2 & NUM_FORMAT_FLOATING) != 0)
			{
				sprintf( s2, "%lf", arg1 );
				
				if ((arg2 & NUM_FORMAT_NO_COMMAS) == 0)
					commarise( s3, s2 );
				else
					strcpy( s3, s2 );
					
				trim_trailing_zeros( s3 );					
			}
			else
			if ((arg2 & NUM_FMT_SCI_NOTATION) != 0)
			{
				sprintf( s2, "%%.%de", arg3 );
				
				sprintf( s3, s2, arg1 );
			}
			else
			if ((arg2 & NUM_FORMAT_NEEDED) != 0)
			{
				pos = strchr( s, (int) '.' );

				strcpy( s2, s );
				
				if (pos != NULL)
				{
					dec = strlen( s ) - (pos - s) - 1;

					if (dec < arg2)
					{
						for (i=0; i < (arg3 - dec); i++)
							strcat( s2, "0" );
					}
				}
				
				if ((arg2 & NUM_FORMAT_NO_COMMAS) == 0)
					commarise( s3, s2 );
				else
					strcpy( s3, s2 );
			}	
			else
			if ((arg2 & NUM_FORMAT_FIXED) != 0 || (arg2 & NUM_FORMAT_CURRENCY) != 0)
			{
				pos = strchr( s, (int) '.' );

				strcpy( s2, s );
				
				if (pos == NULL)
				{
					if (arg3 > 0)
					{
						strcat( s2, "." );
						
						for (i=0; i < arg3; i++)
							strcat( s2, "0" );
					}
				}
				else
				{
					dec = strlen( s ) - (pos - s) - 1;

					if (dec > arg3)
					{
						sleft( s2, s2, strlen( s2 ) - (dec - arg3) );
						
						sright( s3, s2, 1 );
						
						if (strcmp( s3, "." ) == 0)
							sleft( s2, s2, strlen( s2 ) - 1 );
					}
					else
					if (dec < arg3)
					{
						for (i=0; i < arg3 - dec; i++)
							strcat( s2, "0" );
					}
				}
				
				if ((arg2 & NUM_FORMAT_NO_COMMAS) == 0)
					commarise( s3, s2 );
				else
					strcpy( s3, s2 );
			}	

			if ((arg2 & NUM_FORMAT_CURRENCY) != 0)
			{
				pos = strchr( s3, (int) '.' );
				
				if (pos != NULL)
				{
					dec = strlen( s3 ) - (pos - s3) - 1;

					if (dec == 1)
						strcat( s3, "0" );
				}
				
				sleft( s2, s3, 1 );
				
				if (strcmp( s2, "-" ) == 0)
				{
					strcpy( s2, "-$" );
					strcat( s2, s3+1 );
					strcpy( s3, s2 );
				}
				else
				{
					strcpy( s2, "$" );
					strcat( s2, s3 );
					strcpy( s3, s2 );
				}
			}
							
			_calcsys_var_set_s( result, s3, source_file_id_txt );
			
			return ((char *) result);			
		}

		char *_calc_miformat( var *result, long int arg1, long int arg2, char *source_file_id_txt )
		{
			char s2[MEDIUM_STRING_BUFFER_SIZE];
			char s3[MEDIUM_STRING_BUFFER_SIZE];
				
			sprintf( s3, "%ld", arg1 );

			if ((arg2 & NUM_IFORMAT_NO_COMMAS) == 0)
			{
				commarise( s2, s3 );
				strcpy( s3, s2 );
			}

			if ((arg2 & NUM_IFORMAT_CURRENCY) != 0)
			{
				if (arg1 < 0)
				{
					strcpy( s2, "-$" );
					strcat( s2, s3+1 );
					strcpy( s3, s2 );
				}
				else
				{
					strcpy( s2, "$" );
					strcat( s2, s3 );
					strcpy( s3, s2 );
				}
			}
							
			_calcsys_var_set_s( result, s3, source_file_id_txt );
			
			return ((char *) result);			
		}

		
		double _calc_msin( double arg1, char *source_file_id_txt )
		{
			return ( sin( arg1 ) );
		}

				
		double _calc_mcos( double arg1, char *source_file_id_txt )
		{
			return ( cos( arg1 ) );
		}

				
		double _calc_mtan( double arg1, char *source_file_id_txt )
		{
			return ( tan( arg1 ) );
		}

				
		double _calc_marcsin( double arg1, char *source_file_id_txt )
		{
			return ( asin( arg1 ) );
		}

				
		double _calc_marccos( double arg1, char *source_file_id_txt )
		{
			return ( acos( arg1 ) );
		}

				
		double _calc_marctan( double arg1, char *source_file_id_txt )
		{
			return ( atan( arg1 ) );
		}
		
		
	//--------------------------------------------------------------------------
	//--------------------------------------------------------------------------

		float _calc_mrandf( char *source_file_id_txt )
		{
			return ( ((float) rand()) / ((float) RAND_MAX) );
		}

		long int _calc_mtruncf( float arg1, char *source_file_id_txt )
		{
			return ( (long int) arg1 );
		}
				
		float _calc_msqrtf( float arg1, char *source_file_id_txt )
		{
			if (arg1 == 0)
				runtime_error( source_file_id_txt, 1025, "Square root of zero", "" );

			if (arg1 < 0)
				runtime_error( source_file_id_txt, 1026, "Square root of a negative number", "" );
		
			return ( sqrtf(arg1) );
		}
			
				
		float _calc_mfabsf( float arg1, char *source_file_id_txt )
		{
			if (arg1 >= 0)
				return ( arg1 );
			else
				return ( -arg1 );
		}
			
				
		float _calc_mfmaxf( float arg1, float arg2, char *source_file_id_txt )
		{
			if (arg1 >= arg2)
				return ( arg1 );
			else
				return ( arg2 );
		}
					
				
		float _calc_mfminf( float arg1, float arg2, char *source_file_id_txt )
		{
			if (arg1 <= arg2)
				return ( arg1 );
			else
				return ( arg2 );
		}
				
		float _calc_mlogf( float arg1, char *source_file_id_txt )
		{
			return ( logf( arg1 ) );
		}
	
				
		float _calc_mlog10f( float arg1, char *source_file_id_txt )
		{
			return ( log10f( arg1 ) );
		}
					
				
		float _calc_mexpf( float arg1, char *source_file_id_txt )
		{
			return ( powf( 2.71828182845904523536L, arg1 ) );
		}
			
				
		float _calc_mroundf( float arg1, long int arg2, char *source_file_id_txt )
		{
			float x;
		
			x = arg1 * pow( 10, arg2 );
			
			x += 0.5;
			
			x = (long int) x;
			
			x = x / pow( 10, arg2 );

			return ( x );
		}

		char *_calc_mformatf( var *result, float arg1, long int arg2, long int arg3, char *source_file_id_txt )
		{
			char s[MEDIUM_STRING_BUFFER_SIZE];
			char s2[MEDIUM_STRING_BUFFER_SIZE];
			char s3[MEDIUM_STRING_BUFFER_SIZE];
			char fmt[SMALL_STRING_BUFFER_SIZE];
			int i, dec;
			char *pos;
			
			sprintf( s2, "%%.%ldf", arg3 );
				
			sprintf( s, s2, arg1 );

			trim_trailing_zeros( s );

			s2[0] = '\0';
			
			
			if ((arg2 & NUM_FORMAT_FLOATING) != 0)
			{
				sprintf( s2, "%f", arg1 );
				
				if ((arg2 & NUM_FORMAT_NO_COMMAS) == 0)
					commarise( s3, s2 );
				else
					strcpy( s3, s2 );
					
				trim_trailing_zeros( s3 );					
			}
			else
			if ((arg2 & NUM_FMT_SCI_NOTATION) != 0)
			{
				sprintf( s2, "%%.%de", arg3 );
				
				sprintf( s3, s2, arg1 );
			}
			else
			if ((arg2 & NUM_FORMAT_NEEDED) != 0)
			{
				pos = strchr( s, (int) '.' );

				strcpy( s2, s );
				
				if (pos != NULL)
				{
					dec = strlen( s ) - (pos - s) - 1;

					if (dec < arg2)
					{
						for (i=0; i < (arg3 - dec); i++)
							strcat( s2, "0" );
					}
				}
				
				if ((arg2 & NUM_FORMAT_NO_COMMAS) == 0)
					commarise( s3, s2 );
				else
					strcpy( s3, s2 );
			}	
			else
			if ((arg2 & NUM_FORMAT_FIXED) != 0 || (arg2 & NUM_FORMAT_CURRENCY) != 0)
			{
				pos = strchr( s, (int) '.' );

				strcpy( s2, s );
				
				if (pos == NULL)
				{
					if (arg3 > 0)
					{
						strcat( s2, "." );
						
						for (i=0; i < arg3; i++)
							strcat( s2, "0" );
					}
				}
				else
				{
					dec = strlen( s ) - (pos - s) - 1;

					if (dec > arg3)
					{
						sleft( s2, s2, strlen( s2 ) - (dec - arg3) );
						
						sright( s3, s2, 1 );
						
						if (strcmp( s3, "." ) == 0)
							sleft( s2, s2, strlen( s2 ) - 1 );
					}
					else
					if (dec < arg3)
					{
						for (i=0; i < arg3 - dec; i++)
							strcat( s2, "0" );
					}
				}
				
				if ((arg2 & NUM_FORMAT_NO_COMMAS) == 0)
					commarise( s3, s2 );
				else
					strcpy( s3, s2 );
			}	

			if ((arg2 & NUM_FORMAT_CURRENCY) != 0)
			{
				pos = strchr( s3, (int) '.' );
				
				if (pos != NULL)
				{
					dec = strlen( s3 ) - (pos - s3) - 1;

					if (dec == 1)
						strcat( s3, "0" );
				}
				
				sleft( s2, s3, 1 );
				
				if (strcmp( s2, "-" ) == 0)
				{
					strcpy( s2, "-$" );
					strcat( s2, s3+1 );
					strcpy( s3, s2 );
				}
				else
				{
					strcpy( s2, "$" );
					strcat( s2, s3 );
					strcpy( s3, s2 );
				}
			}
							
			_calcsys_var_set_s( result, s3, source_file_id_txt );
			
			return ((char *) result);			
		}


		float _calc_msinf( float arg1, char *source_file_id_txt )
		{
			return ( sinf( arg1 ) );
		}

				
		float _calc_mcosf( float arg1, char *source_file_id_txt )
		{
			return ( cosf( arg1 ) );
		}

				
		float _calc_mtanf( float arg1, char *source_file_id_txt )
		{
			return ( tanf( arg1 ) );
		}

				
		float _calc_marcsinf( float arg1, char *source_file_id_txt )
		{
			return ( asinf( arg1 ) );
		}

				
		float _calc_marccosf( float arg1, char *source_file_id_txt )
		{
			return ( acosf( arg1 ) );
		}

				
		float _calc_marctanf( float arg1, char *source_file_id_txt )
		{
			return ( atanl( arg1 ) );
		}
		
		
	//--------------------------------------------------------------------------
	//--------------------------------------------------------------------------

		long double _calc_mrandl( char *source_file_id_txt )
		{
			return ( ((long double) rand()) / ((long double) RAND_MAX) );
		}

		long int _calc_mtruncl( long double arg1, char *source_file_id_txt )
		{
			return ( (long int) arg1 );
		}
				
		long double _calc_msqrtl( long double arg1, char *source_file_id_txt )
		{
			if (arg1 == 0)
				runtime_error( source_file_id_txt, 1025, "Square root of zero", "" );

			if (arg1 < 0)
				runtime_error( source_file_id_txt, 1026, "Square root of a negative number", "" );
		
			return ( sqrtl(arg1) );
		}
			
				
		long double _calc_mfabsl( long double arg1, char *source_file_id_txt )
		{
			if (arg1 >= 0)
				return ( arg1 );
			else
				return ( -arg1 );
		}
			
				
		long double _calc_mfmaxl( long double arg1, long double arg2, char *source_file_id_txt )
		{
			if (arg1 >= arg2)
				return ( arg1 );
			else
				return ( arg2 );
		}
					
				
		long double _calc_mfminl( long double arg1, long double arg2, char *source_file_id_txt )
		{
			if (arg1 <= arg2)
				return ( arg1 );
			else
				return ( arg2 );
		}
				
		long double _calc_mlogl( long double arg1, char *source_file_id_txt )
		{
			return ( logl( arg1 ) );
		}
	
				
		long double _calc_mlog10l( long double arg1, char *source_file_id_txt )
		{
			return ( log10l( arg1 ) );
		}
					
				
		long double _calc_mexpl( long double arg1, char *source_file_id_txt )
		{
			return ( powl( 2.71828182845904523536L, arg1 ) );
		}
			
				
		long double _calc_mroundl( long double arg1, long int arg2, char *source_file_id_txt )
		{
			long double x;
		
			x = arg1 * pow( 10, arg2 );
			
			x += 0.5;
			
			x = (long int) x;
			
			x = x / pow( 10, arg2 );

			return ( x );
		}

		char *_calc_mformatl( var *result, long double arg1, long int arg2, long int arg3, char *source_file_id_txt )
		{
			char s[MEDIUM_STRING_BUFFER_SIZE];
			char s2[MEDIUM_STRING_BUFFER_SIZE];
			char s3[MEDIUM_STRING_BUFFER_SIZE];
			char fmt[SMALL_STRING_BUFFER_SIZE];
			int i, dec;
			char *pos;
			
			sprintf( s2, "%%.%dLf", arg3 );
				
			sprintf( s, s2, arg1 );

			trim_trailing_zeros( s );

			s2[0] = '\0';
			
			
			if ((arg2 & NUM_FORMAT_FLOATING) != 0)
			{
				sprintf( s2, "%Lf", arg1 );
				
				if ((arg2 & NUM_FORMAT_NO_COMMAS) == 0)
					commarise( s3, s2 );
				else
					strcpy( s3, s2 );
					
				trim_trailing_zeros( s3 );					
			}
			else
			if ((arg2 & NUM_FMT_SCI_NOTATION) != 0)
			{
				sprintf( s2, "%%.%de", arg3 );
				
				sprintf( s3, s2, arg1 );
			}
			else
			if ((arg2 & NUM_FORMAT_NEEDED) != 0)
			{
				pos = strchr( s, (int) '.' );

				strcpy( s2, s );
				
				if (pos != NULL)
				{
					dec = strlen( s ) - (pos - s) - 1;

					if (dec < arg2)
					{
						for (i=0; i < (arg3 - dec); i++)
							strcat( s2, "0" );
					}
				}
				
				if ((arg2 & NUM_FORMAT_NO_COMMAS) == 0)
					commarise( s3, s2 );
				else
					strcpy( s3, s2 );
			}	
			else
			if ((arg2 & NUM_FORMAT_FIXED) != 0 || (arg2 & NUM_FORMAT_CURRENCY) != 0)
			{
				pos = strchr( s, (int) '.' );

				strcpy( s2, s );
				
				if (pos == NULL)
				{
					if (arg3 > 0)
					{
						strcat( s2, "." );
						
						for (i=0; i < arg3; i++)
							strcat( s2, "0" );
					}
				}
				else
				{
					dec = strlen( s ) - (pos - s) - 1;

					if (dec > arg3)
					{
						sleft( s2, s2, strlen( s2 ) - (dec - arg3) );
						
						sright( s3, s2, 1 );
						
						if (strcmp( s3, "." ) == 0)
							sleft( s2, s2, strlen( s2 ) - 1 );
					}
					else
					if (dec < arg3)
					{
						for (i=0; i < arg3 - dec; i++)
							strcat( s2, "0" );
					}
				}
				
				if ((arg2 & NUM_FORMAT_NO_COMMAS) == 0)
					commarise( s3, s2 );
				else
					strcpy( s3, s2 );
			}	

			if ((arg2 & NUM_FORMAT_CURRENCY) != 0)
			{
				pos = strchr( s3, (int) '.' );
				
				if (pos != NULL)
				{
					dec = strlen( s3 ) - (pos - s3) - 1;

					if (dec == 1)
						strcat( s3, "0" );
				}
				
				sleft( s2, s3, 1 );
				
				if (strcmp( s2, "-" ) == 0)
				{
					strcpy( s2, "-$" );
					strcat( s2, s3+1 );
					strcpy( s3, s2 );
				}
				else
				{
					strcpy( s2, "$" );
					strcat( s2, s3 );
					strcpy( s3, s2 );
				}
			}
							
			_calcsys_var_set_s( result, s3, source_file_id_txt );
			
			return ((char *) result);			
		}


		long double _calc_msinl( long double arg1, char *source_file_id_txt )
		{
			return ( sinl( arg1 ) );
		}

				
		long double _calc_mcosl( long double arg1, char *source_file_id_txt )
		{
			return ( cosl( arg1 ) );
		}

				
		long double _calc_mtanl( long double arg1, char *source_file_id_txt )
		{
			return ( tanl( arg1 ) );
		}

				
		long double _calc_marcsinl( long double arg1, char *source_file_id_txt )
		{
			return ( asinl( arg1 ) );
		}

				
		long double _calc_marccosl( long double arg1, char *source_file_id_txt )
		{
			return ( acosl( arg1 ) );
		}

				
		long double _calc_marctanl( long double arg1, char *source_file_id_txt )
		{
			return ( atanl( arg1 ) );
		}
		

		void commarise( char *str2, char *str1 )
		{
			char *ptr, *ptr2;
			int main_length;
			
			ptr = str1;
			ptr2 = str2;
			
			if (str1[0] == '-')
				*ptr2++ = *ptr++;
			
			if (index( ptr, '.' ) != NULL)
				main_length = index( ptr, '.' ) - ptr;
			else
				main_length = strlen( ptr );
			
			*ptr2++ = *ptr++;
			main_length--;
			
			while (main_length > 0)
			{
				if (main_length % 3 == 0)
					*ptr2++ = ',';
				
				*ptr2++ = *ptr++;
				main_length--;
			}

			*ptr2 = '\0';
			
			strcpy( ptr2, ptr );
		}
		



	//--------------------------------------------------------------------------
	// Forms
	//--------------------------------------------------------------------------
		
/*
		void _calc_form_start( var *result, var *arg1, var *arg2, char *source_file_id_txt )
		{
			write_yellow_input_boxes();
			
			echo "<form id='".$arg1."' name='".$arg1."' action='".url_encode( $arg2 )."' method='POST'><table style='border: 1px solid #bbbbbb; background: linear-gradient(#fcfcfc, #e1e1e1)'>";

			var_set_n( result, 31, source_file_id_txt );
		}
		
		void _calc_form_text( var *result, var *arg1, var *arg2, char *source_file_id_txt )
		{
			form_text( "", $arg1, $arg2, $arg3, $arg4, $arg5, $arg6 );

			var_set_n( result, 31, source_file_id_txt );
		}
		
		void _calc_form_dropdown( var *result, var *arg1, var *arg2, char *source_file_id_txt )
		{
			form_dropdown( "", $arg1, $arg2, $arg3, $arg4, $arg5, $arg6 );

			var_set_n( result, 31, source_file_id_txt );
		}
		
		void _calc_form_radio( var *result, var *arg1, var *arg2, char *source_file_id_txt )
		{
			form_radio( "", $arg1, $arg2, $arg3, $arg4, $arg5, $arg6, $arg7 );

			var_set_n( result, 31, source_file_id_txt );
		}
		
		void _calc_form_checkbox( var *result, var *arg1, var *arg2, char *source_file_id_txt )
		{
			form_checkbox( "", $arg1, $arg2, $arg3, $arg4, $arg5 );

			var_set_n( result, 31, source_file_id_txt );
		}
		
		void _calc_form_textarea( var *result, var *arg1, var *arg2, char *source_file_id_txt )
		{
			form_textarea( "", $arg1, $arg2, $arg3, $arg4, $arg5, $arg6 );

			var_set_n( result, 31, source_file_id_txt );
		}
		
		void _calc_form_password( var *result, var *arg1, var *arg2, char *source_file_id_txt )
		{
			form_password( "", $arg1, $arg2, $arg3, $arg4, $arg5 );

			var_set_n( result, 31, source_file_id_txt );
		}
		
		void _calc_form_submit_new( var *result, var *arg1, var *arg2, char *source_file_id_txt )
		{
			show_green_button_submit( "", $arg2, (double) $arg3, $arg1 );

			var_set_n( result, 31, source_file_id_txt );
		}
		
		void _calc_form_end( var *result, var *arg1, var *arg2, char *source_file_id_txt )
		{
			form_end();

			var_set_n( result, 31, source_file_id_txt );
		}	
		
		void _calc_show_link( var *result, var *arg1, var *arg2, char *source_file_id_txt )
		{
			$result = "<a class='glink' href='" & $arg2 & "'>" & $arg1 & "</a>";

			var_set_n( result, 31, source_file_id_txt );
		}
*/	
	
	
	//--------------------------------------------------------------------------
	// Dates & times
	//--------------------------------------------------------------------------
	
				
		char *_calc_dtoday( var *result, char *source_file_id_txt )
		{
			char str4[MEDIUM_STRING_BUFFER_SIZE];
			time_t t;
			struct tm *t2;
			
			time( &t );
			
			t2 = localtime( &t );
			
			strftime( str4, SMALL_STRING_BUFFER_SIZE, "%Y-%m-%d", t2 );
			
			_calcsys_var_set_s( result, str4, source_file_id_txt );
			
			return ((char *) result);			
		}
			
				
		char *_calc_tnow( var *result, char *source_file_id_txt )
		{
			char str4[MEDIUM_STRING_BUFFER_SIZE];
			time_t t;
			struct tm *t2;
			
			time( &t );
			
			t2 = localtime( &t );
			
			strftime( str4, SMALL_STRING_BUFFER_SIZE, "%H:%M:%S", t2 );
			
			_calcsys_var_set_s( result, str4, source_file_id_txt );
			
			return ((char *) result);			
		}
			
				
		char *_calc_dtnow( var *result, char *source_file_id_txt )
		{
			char str4[MEDIUM_STRING_BUFFER_SIZE];
			time_t t;
			struct tm *t2;
			
			time( &t );
			
			t2 = localtime( &t );
			
			strftime( str4, SMALL_STRING_BUFFER_SIZE, "%Y-%m-%d %H:%M:%S", t2 );
			
			_calcsys_var_set_s( result, str4, source_file_id_txt );
			
			return ((char *) result);			
		}


char *strptime(const char* s, const char *format, struct tm *tm);


		char *_calc_dformat( var *result, var *arg1, var *arg2, char *source_file_id_txt )
		{
			char str5[MEDIUM_STRING_BUFFER_SIZE];
			char str4[MEDIUM_STRING_BUFFER_SIZE];
			char str3[MEDIUM_STRING_BUFFER_SIZE];
			char str2[MEDIUM_STRING_BUFFER_SIZE];
			char str[MEDIUM_STRING_BUFFER_SIZE];
			struct tm t2;
			int day;
			int hour;
			char hour_text[10];
			char day_text[10];
			
			var_check_s( arg1, source_file_id_txt );
			var_check_s( arg2, source_file_id_txt );
			
			str_u32_to_u8( str5, arg1->data.svalue, MEDIUM_STRING_BUFFER_SIZE );

			if (! check_date_valid( str5, "yyyy-mm-dd", source_file_id_txt ))
				runtime_error( source_file_id_txt, 1027, "Invalid date text", str5 );
					
			str_u32_to_u8( str2, arg2->data.svalue, MEDIUM_STRING_BUFFER_SIZE );

			if (strcmp( str2, "%Y-%m-%d" ) == 0)
				_calcsys_var_set_s_u32( result, arg1->data.svalue, false, source_file_id_txt );
			else
			{
				day = atoi( sright( str, str5, 2 ) );

				hour = atoi( smid( str, str5, 11, 2 ) );
	
				if (hour > 12)
					hour -= 12;
					
				if (hour == 0)
					hour = 12;
					
				sprintf( hour_text, "%d", hour );

				sprintf( day_text, "%d", day );
	
				strcpy( str3, str2 );
				
				if (day == 1)				str_replace( str3, str2, "%i", "st" );	else
				if (day == 2)				str_replace( str3, str2, "%i", "nd" );	else
				if (day == 3)				str_replace( str3, str2, "%i", "rd" );	else
				if (day == 4)				str_replace( str3, str2, "%i", "th" );	else
				if (day == 5)				str_replace( str3, str2, "%i", "th" );	else
				if (day == 6)				str_replace( str3, str2, "%i", "th" );	else
				if (day == 7)				str_replace( str3, str2, "%i", "th" );	else
				if (day == 8)				str_replace( str3, str2, "%i", "th" );	else
				if (day == 9)				str_replace( str3, str2, "%i", "th" );	else
				if (day == 10)				str_replace( str3, str2, "%i", "th" );	else
				if (day == 11)				str_replace( str3, str2, "%i", "th" );	else
				if (day == 12)				str_replace( str3, str2, "%i", "th" );	else
				if (day == 13)				str_replace( str3, str2, "%i", "th" );	else
				if (day == 14)				str_replace( str3, str2, "%i", "th" );	else
				if (day == 15)				str_replace( str3, str2, "%i", "th" );	else
				if (day == 16)				str_replace( str3, str2, "%i", "th" );	else
				if (day == 17)				str_replace( str3, str2, "%i", "th" );	else
				if (day == 18)				str_replace( str3, str2, "%i", "th" );	else
				if (day == 19)				str_replace( str3, str2, "%i", "th" );	else
				if (day == 20)				str_replace( str3, str2, "%i", "th" );	else
				if (day == 21)				str_replace( str3, str2, "%i", "st" );	else
				if (day == 22)				str_replace( str3, str2, "%i", "nd" );	else
				if (day == 23)				str_replace( str3, str2, "%i", "rd" );	else
				if (day == 24)				str_replace( str3, str2, "%i", "th" );	else
				if (day == 25)				str_replace( str3, str2, "%i", "th" );	else
				if (day == 26)				str_replace( str3, str2, "%i", "th" );	else
				if (day == 27)				str_replace( str3, str2, "%i", "th" );	else
				if (day == 28)				str_replace( str3, str2, "%i", "th" );	else
				if (day == 29)				str_replace( str3, str2, "%i", "th" );	else
				if (day == 30)				str_replace( str3, str2, "%i", "th" );	else
				if (day == 31)				str_replace( str3, str2, "%i", "st" );

				strcpy( str2, str3 );

				str_replace( str3, str2, "%e", hour_text );


				strcpy( str2, str3 );

				str_replace( str3, str2, "%f", day_text );

			
				strptime( str5, "%Y-%m-%d", &t2 ); 
	
				strftime( str4, SMALL_STRING_BUFFER_SIZE, str3, &t2 );
				
				_calcsys_var_set_s( result, str4, source_file_id_txt );
			}
			
			return ((char *) result);			
		}
			
				
		char *_calc_tformat( var *result, var *arg1, var *arg2, char *source_file_id_txt )
		{
			char str5[MEDIUM_STRING_BUFFER_SIZE];
			char str4[MEDIUM_STRING_BUFFER_SIZE];
			char str6[MEDIUM_STRING_BUFFER_SIZE];
			struct tm t2;
			
			var_check_s( arg1, source_file_id_txt );
			var_check_s( arg2, source_file_id_txt );

			str_u32_to_u8( str5, arg1->data.svalue, MEDIUM_STRING_BUFFER_SIZE );
			str_u32_to_u8( str6, arg2->data.svalue, MEDIUM_STRING_BUFFER_SIZE );
						
			if (! check_time_valid( str5 ))
				runtime_error( source_file_id_txt, 1028, "Invalid time text", str5 );
				
			strptime( str5, "%H:%M:%S", &t2 ); 
			
			if (str6[0] == '%' && str6[1] == 'e')
				str6[1] = 'l';
				
			strftime( str4, SMALL_STRING_BUFFER_SIZE, str6, &t2 );
			
			_calcsys_var_set_s( result, str4, source_file_id_txt );
			
			return ((char *) result);			
		}
			
				
		char *_calc_dtformat( var *result, var *arg1, var *arg2, char *source_file_id_txt )
		{
			char str[SMALL_STRING_BUFFER_SIZE];
			char str2[MEDIUM_STRING_BUFFER_SIZE];
			char str3[MEDIUM_STRING_BUFFER_SIZE];
			char str4[MEDIUM_STRING_BUFFER_SIZE];
			char str5[MEDIUM_STRING_BUFFER_SIZE];
			struct tm t2;
			int day;
			int hour;
			char hour_text[10];
			char day_text[10];
			
			var_check_s( arg1, source_file_id_txt );
			var_check_s( arg2, source_file_id_txt );

			str_u32_to_u8( str5, arg1->data.svalue, MEDIUM_STRING_BUFFER_SIZE );
			
			if (! check_datetime_valid( str5, source_file_id_txt ))
				runtime_error( source_file_id_txt, 1029, "Invalid datetime text", str5 );
				
			strptime( str5, "%Y-%m-%d %H:%M:%S", &t2 ); 

			str_u32_to_u8( str2, arg2->data.svalue, MEDIUM_STRING_BUFFER_SIZE );

			day = atoi( smid( str, str5, 8, 2 ) );

			hour = atoi( smid( str, str5, 11, 2 ) );

			if (hour > 12)
				hour -= 12;

			if (hour == 0)
				hour = 12;
				
			sprintf( hour_text, "%d", hour );

			sprintf( day_text, "%d", day );
			
			strcpy( str3, str2 );
			
			if (day == 1)				str_replace( str3, str2, "%i", "st" );	else
			if (day == 2)				str_replace( str3, str2, "%i", "nd" );	else
			if (day == 3)				str_replace( str3, str2, "%i", "rd" );	else
			if (day == 4)				str_replace( str3, str2, "%i", "th" );	else
			if (day == 5)				str_replace( str3, str2, "%i", "th" );	else
			if (day == 6)				str_replace( str3, str2, "%i", "th" );	else
			if (day == 7)				str_replace( str3, str2, "%i", "th" );	else
			if (day == 8)				str_replace( str3, str2, "%i", "th" );	else
			if (day == 9)				str_replace( str3, str2, "%i", "th" );	else
			if (day == 10)				str_replace( str3, str2, "%i", "th" );	else
			if (day == 11)				str_replace( str3, str2, "%i", "th" );	else
			if (day == 12)				str_replace( str3, str2, "%i", "th" );	else
			if (day == 13)				str_replace( str3, str2, "%i", "th" );	else
			if (day == 14)				str_replace( str3, str2, "%i", "th" );	else
			if (day == 15)				str_replace( str3, str2, "%i", "th" );	else
			if (day == 16)				str_replace( str3, str2, "%i", "th" );	else
			if (day == 17)				str_replace( str3, str2, "%i", "th" );	else
			if (day == 18)				str_replace( str3, str2, "%i", "th" );	else
			if (day == 19)				str_replace( str3, str2, "%i", "th" );	else
			if (day == 20)				str_replace( str3, str2, "%i", "th" );	else
			if (day == 21)				str_replace( str3, str2, "%i", "st" );	else
			if (day == 22)				str_replace( str3, str2, "%i", "nd" );	else
			if (day == 23)				str_replace( str3, str2, "%i", "rd" );	else
			if (day == 24)				str_replace( str3, str2, "%i", "th" );	else
			if (day == 25)				str_replace( str3, str2, "%i", "th" );	else
			if (day == 26)				str_replace( str3, str2, "%i", "th" );	else
			if (day == 27)				str_replace( str3, str2, "%i", "th" );	else
			if (day == 28)				str_replace( str3, str2, "%i", "th" );	else
			if (day == 29)				str_replace( str3, str2, "%i", "th" );	else
			if (day == 30)				str_replace( str3, str2, "%i", "th" );	else
			if (day == 31)				str_replace( str3, str2, "%i", "st" );
			
			strcpy( str2, str3 );

			str_replace( str3, str2, "%e", hour_text );


			strcpy( str2, str3 );

			str_replace( str3, str2, "%f", day_text );
			
			
			strftime( str4, SMALL_STRING_BUFFER_SIZE, str3, &t2 );
			
			_calcsys_var_set_s( result, str4, source_file_id_txt );
			
			return ((char *) result);			
		}


		char _calc_dlast_day_of_the_month( long int arg1, long int arg2, char *source_file_id_txt )
		{
			int month, year;

			month = arg1;
			year = arg2;

			return ( last_day_of_the_month( year, month ) );
		}


		long int _calc_dis_last_day_of_the_month( var *arg1, char *source_file_id_txt )
		{
			int day, month, year;
			char text[MEDIUM_STRING_BUFFER_SIZE];
			char str[MEDIUM_STRING_BUFFER_SIZE];
			
			str_u32_to_u8( str, arg1->data.svalue, MEDIUM_STRING_BUFFER_SIZE );

			if (! check_date_valid( str, "yyyy-mm-dd", source_file_id_txt ))
				runtime_error( source_file_id_txt, 1029, "Invalid date text", str );

			day = atoi( sright( text, str, 2 ) );
			month = atoi( smid( text, str, 5, 2 ) );
			year = atoi( sleft( text, str, 4 ) );

			return ( day == last_day_of_the_month( year, month ) );
		}


		char *_calc_dadd( var *result, var *arg1, var *arg2, long int arg3, char *source_file_id_txt )
		{
			char str4[MEDIUM_STRING_BUFFER_SIZE];
			char str5[MEDIUM_STRING_BUFFER_SIZE];
			char str6[MEDIUM_STRING_BUFFER_SIZE];
			char text[SMALL_STRING_BUFFER_SIZE];
			int day, month, year;
			int days_to_add;
			int x;
			
			var_check_s( arg1, source_file_id_txt );
			var_check_s( arg2, source_file_id_txt );

			str_u32_to_u8( str5, arg1->data.svalue, MEDIUM_STRING_BUFFER_SIZE );
			str_u32_to_u8( str6, arg2->data.svalue, MEDIUM_STRING_BUFFER_SIZE );
			
			if (! check_date_valid( str5, "yyyy-mm-dd", source_file_id_txt ))
				runtime_error( source_file_id_txt, 1030, "Invalid date text", str5 );

			day = atoi( sright( text, str5, 2 ) );
			month = atoi( smid( text, str5, 5, 2 ) );
			year = atoi( sleft( text, str5, 4 ) );

			days_to_add = arg3;

			if (strcmp( str6, "week" ) == 0 || strcmp( str6, "weeks" ) == 0)
			{
				days_to_add *= 7;
			
				strcpy( str6, "day" );
			}
			
			if (strcmp( str6, "day" ) == 0 || strcmp( str6, "days" ) == 0)
			{
				while (day + days_to_add > last_day_of_the_month( year, month ))
				{
					days_to_add -= last_day_of_the_month( year, month ) - day + 1;
					
					day = 1;
					
					month++;

					if (month > 12)
					{
						year++;
						month = 1;
					}
				}
				
				day += days_to_add;

				date_from_parts( str4, day, month, year, source_file_id_txt );

				_calcsys_var_set_s( result, str4, source_file_id_txt );
			}
			else 
			{
				if (strcmp( str6, "month" ) == 0 ||
					strcmp( str6, "months" ) == 0)
				{
					month += arg3;
					
					while (month > 12)
					{
						month -= 12;
						year++;
					}
					
					if (day == 31 && (month == 9 || month == 4 || month == 6 || month == 11))
						day = 30;
				}
				else
				if (strcmp( str6, "year" ) == 0 ||
					strcmp( str6, "years" ) == 0)
				{
					year += arg3;
				}
				else
					runtime_error( source_file_id_txt, 1031, "Invalid date format", str6 );

				if (month == 2 && day > 29)
					day = 29;
				
				if (month == 2 && day >= 29 && (! is_leap_year( year )))
					day = 28;

				date_from_parts( text, day, month, year, source_file_id_txt );

				_calcsys_var_set_s( result, text, source_file_id_txt );
			}
			
			return ((char *) result);			
		}
			
		char *_calc_dtadd( var *result, var *arg1, var *arg2, long int arg3, char *source_file_id_txt )
		{
			char str4[MEDIUM_STRING_BUFFER_SIZE];
			char str5[MEDIUM_STRING_BUFFER_SIZE];
			char str6[MEDIUM_STRING_BUFFER_SIZE];
			char text[SMALL_STRING_BUFFER_SIZE];
			int hour, minute, second;
			int interval, curr_time;
			
			var_check_s( arg1, source_file_id_txt );
			var_check_s( arg2, source_file_id_txt );

			str_u32_to_u8( str5, arg1->data.svalue, MEDIUM_STRING_BUFFER_SIZE );
			str_u32_to_u8( str6, arg2->data.svalue, MEDIUM_STRING_BUFFER_SIZE );
			
			if (! check_time_valid( str5 ))
				runtime_error( source_file_id_txt, 1032, "Invalid time text", str5 );
			else
			{
				hour = atoi( sleft( text, str5, 2 ) );
				minute = atoi( smid( text, str5, 3, 2 ) );
				second = atoi( sright( text, str5, 2 ) );

				curr_time = hour * 60 * 60 + minute * 60 + second;
							
				if (strcmp( str6, "hour" ) == 0 ||
					strcmp( str6, "hours" ) == 0)
				{
					interval = arg3 * 60 * 60;
				}
				else
				if (strcmp( str6, "minute" ) == 0 ||
					strcmp( str6, "minutes" ) == 0)
				{
					interval = arg3 * 60;
				}
				else
				if (strcmp( str6, "second" ) == 0 ||
					strcmp( str6, "seconds" ) == 0)
				{
					interval = arg3;
				}
				else
					runtime_error( source_file_id_txt, 1033, "Invalid interval in dtadd()", str6 );
				
				curr_time += interval;
				
				curr_time = (int) (curr_time % (24*60*60));
				
				hour = (int) (curr_time / (60*60));

				minute = (int) ((curr_time - hour * (60*60)) / 60);
				 
				second = (int) (curr_time - hour * (60*60) - minute * 60);

				time_from_parts( text, hour, minute, second, source_file_id_txt );

				_calcsys_var_set_s( result, text, source_file_id_txt );
			}
			
			return ((char *) result);			
		}

				
		char *_calc_dsub( var *result, var *arg1, var *arg2, long int arg3, char *source_file_id_txt )
		{
			char str4[MEDIUM_STRING_BUFFER_SIZE];
			char str5[MEDIUM_STRING_BUFFER_SIZE];
			char str6[MEDIUM_STRING_BUFFER_SIZE];
			char text[SMALL_STRING_BUFFER_SIZE];
			int day, month, year;
			int days_to_subtract;
			
			var_check_s( arg1, source_file_id_txt );
			var_check_s( arg2, source_file_id_txt );

			str_u32_to_u8( str5, arg1->data.svalue, MEDIUM_STRING_BUFFER_SIZE );
			str_u32_to_u8( str6, arg2->data.svalue, MEDIUM_STRING_BUFFER_SIZE );
			
			if (! check_date_valid( str5, "yyyy-mm-dd", source_file_id_txt ))
				runtime_error( source_file_id_txt, 1034, "Invalid date text", str5 );

			day = atoi( sright( text, str5, 2 ) );
			month = atoi( smid( text, str5, 5, 2 ) );
			year = atoi( sleft( text, str5, 4 ) );

			days_to_subtract = arg3;

			if (strcmp( str6, "week" ) == 0 || strcmp( str6, "weeks" ) == 0)
			{
				days_to_subtract *= 7;
			
				strcpy( str6, "day" );
			}
			
			if (strcmp( str6, "day" ) == 0 || strcmp( str6, "days" ) == 0)
			{
				while (day - days_to_subtract < 1)
				{
					days_to_subtract -= day;
					
					month--;
					
					if (month < 1)
					{
						year--;
						month = 12;
					}
					
					day = last_day_of_the_month( year, month );						
				}
				
				day -= days_to_subtract;

				date_from_parts( str4, day, month, year, source_file_id_txt );

				_calcsys_var_set_s( result, str4, source_file_id_txt );
			}
			else
			{
				if (strcmp( str6, "month" ) == 0 ||
					strcmp( str6, "months" ) == 0)
				{
					month -= arg3;
					
					while (month < 1)
					{
						month += 12;
						year--;
					}
					
					if (day == 31 && (month == 9 || month == 4 || month == 6 || month == 11))
						day = 30;
				}
				else
				if (strcmp( str6, "year" ) == 0 ||
					strcmp( str6, "years" ) == 0)
				{
					year -= arg3;
				}
				else
					runtime_error( source_file_id_txt, 1035, "Invalid date format", str6 );
				
				if (month == 2 && day > 29)
					day = 29;
				
				if (month == 2 && day >= 29 && (! is_leap_year( year )))
					day = 28;
			
				date_from_parts( text, day, month, year, source_file_id_txt );

				_calcsys_var_set_s( result, text, source_file_id_txt );
			}
			
			return ((char *) result);			
		}
			
		char *_calc_dtsub( var *result, var *arg1, var *arg2, long int arg3, char *source_file_id_txt )
		{
			char str4[MEDIUM_STRING_BUFFER_SIZE];
			char str5[MEDIUM_STRING_BUFFER_SIZE];
			char str6[MEDIUM_STRING_BUFFER_SIZE];
			char text[SMALL_STRING_BUFFER_SIZE];
			int hour, minute, second;
			int interval, curr_time;
			
			var_check_s( arg1, source_file_id_txt );
			var_check_s( arg2, source_file_id_txt );

			str_u32_to_u8( str5, arg1->data.svalue, MEDIUM_STRING_BUFFER_SIZE );
			str_u32_to_u8( str6, arg2->data.svalue, MEDIUM_STRING_BUFFER_SIZE );
			
			if (! check_time_valid( str5 ))
				runtime_error( source_file_id_txt, 1036, "Invalid time text", str5 );
			else
			{
				hour = atoi( sleft( text, str5, 2 ) );
				minute = atoi( smid( text, str5, 3, 2 ) );
				second = atoi( sright( text, str5, 2 ) );

				curr_time = hour * 60 * 60 + minute * 60 + second;
							
				if (strcmp( str6, "hour" ) == 0 ||
					strcmp( str6, "hours" ) == 0)
				{
					interval = arg3 * 60 * 60;
				}
				else
				if (strcmp( str6, "minute" ) == 0 ||
					strcmp( str6, "minutes" ) == 0)
				{
					interval = arg3 * 60;
				}
				else
				if (strcmp( str6, "second" ) == 0 ||
					strcmp( str6, "seconds" ) == 0)
				{
					interval = arg3;
				}
				else
					runtime_error( source_file_id_txt, 1037, "Invalid interval in dtadd()", str6 );
				
				curr_time -= interval;
				
				while (curr_time < 0)
					curr_time += 24*60*60;
				
				hour = curr_time / (60*60);

				minute = (curr_time - hour * (60*60)) / 60;
				 
				second = (curr_time - hour * (60*60) - minute * 60);

				time_from_parts( text, hour, minute, second, source_file_id_txt );

				_calcsys_var_set_s( result, text, source_file_id_txt );
			}
			
			return ((char *) result);			
		}
			

		char *_calc_ddtadd( var *result, var *arg1, var *arg2, long int arg3, char *source_file_id_txt )
		{
			char str5[MEDIUM_STRING_BUFFER_SIZE];
			char str6[MEDIUM_STRING_BUFFER_SIZE];
			char text[SMALL_STRING_BUFFER_SIZE];
			char text2[SMALL_STRING_BUFFER_SIZE];
			int day, month, year;
			int hour, minute, second;
			int days_to_add;
			int seconds_per_day;
			int interval, curr_time;
			
			var_check_s( arg1, source_file_id_txt );
			var_check_s( arg2, source_file_id_txt );

			str_u32_to_u8( str5, arg1->data.svalue, MEDIUM_STRING_BUFFER_SIZE );
			str_u32_to_u8( str6, arg2->data.svalue, MEDIUM_STRING_BUFFER_SIZE );
			
			if (! check_datetime_valid( str5, source_file_id_txt ))
				runtime_error( source_file_id_txt, 1030, "Invalid date text", str5 );

			day = atoi( smid( text, str5, 8, 2 ) );
			month = atoi( smid( text, str5, 5, 2 ) );
			year = atoi( sleft( text, str5, 4 ) );

			hour = atoi( smid( text, str5, 11, 2 ) );
			minute = atoi( smid( text, str5, 14, 2 ) );
			second = atoi( sright( text, str5, 2 ) );

			curr_time = hour * 60 * 60 + minute * 60 + second;

			if (strcmp( str6, "hour" ) == 0 ||
				strcmp( str6, "hours" ) == 0)
			{
				interval = arg3 * 60 * 60;
			}
			else
			if (strcmp( str6, "minute" ) == 0 ||
				strcmp( str6, "minutes" ) == 0)
			{
				interval = arg3 * 60;
			}
			else
			if (strcmp( str6, "second" ) == 0 ||
				strcmp( str6, "seconds" ) == 0)
			{
				interval = arg3;
			}
			else
				runtime_error( source_file_id_txt, 1037, "Invalid interval in ddtadd()", str6 );

			curr_time += interval;
			
			seconds_per_day = 24*60*60;
			
			days_to_add = 0;
			
			while (curr_time > seconds_per_day)
			{
				days_to_add++;
				curr_time -= seconds_per_day;
			}

			hour = curr_time / (60*60);

			minute = (curr_time - hour * (60*60)) / 60;
			 
			second = (curr_time - hour * (60*60) - minute * 60);

			time_from_parts( text, hour, minute, second, source_file_id_txt );

			while (day + days_to_add > last_day_of_the_month( year, month ))
			{
				days_to_add -= last_day_of_the_month( year, month ) - day + 1;
				
				day = 1;
				
				month++;

				if (month > 12)
				{
					year++;
					month = 1;
				}
			}

			day += days_to_add;
			
			date_from_parts( text2, day, month, year, source_file_id_txt );
			
			strcat( text2, " " );
			strcat( text2, text );

			_calcsys_var_set_s( result, text2, source_file_id_txt );
			
			return ((char *) result);			
		}



		char *_calc_ddtsub( var *result, var *arg1, var *arg2, long int arg3, char *source_file_id_txt )
		{
			char str5[MEDIUM_STRING_BUFFER_SIZE];
			char str6[MEDIUM_STRING_BUFFER_SIZE];
			char text[SMALL_STRING_BUFFER_SIZE];
			char text2[SMALL_STRING_BUFFER_SIZE];
			int day, month, year;
			int hour, minute, second;
			int days_to_subtract;
			int seconds_per_day;
			int interval, curr_time;
			int days_to_add;
			int x;
			
			var_check_s( arg1, source_file_id_txt );
			var_check_s( arg2, source_file_id_txt );

			str_u32_to_u8( str5, arg1->data.svalue, MEDIUM_STRING_BUFFER_SIZE );
			str_u32_to_u8( str6, arg2->data.svalue, MEDIUM_STRING_BUFFER_SIZE );
			
			if (! check_datetime_valid( str5, source_file_id_txt ))
				runtime_error( source_file_id_txt, 1030, "Invalid date text", str5 );

			day = atoi( smid( text, str5, 8, 2 ) );
			month = atoi( smid( text, str5, 5, 2 ) );
			year = atoi( sleft( text, str5, 4 ) );

			hour = atoi( smid( text, str5, 11, 2 ) );
			minute = atoi( smid( text, str5, 14, 2 ) );
			second = atoi( sright( text, str5, 2 ) );

			curr_time = hour * 60 * 60 + minute * 60 + second;

			if (strcmp( str6, "hour" ) == 0 ||
				strcmp( str6, "hours" ) == 0)
			{
				interval = arg3 * 60 * 60;
			}
			else
			if (strcmp( str6, "minute" ) == 0 ||
				strcmp( str6, "minutes" ) == 0)
			{
				interval = arg3 * 60;
			}
			else
			if (strcmp( str6, "second" ) == 0 ||
				strcmp( str6, "seconds" ) == 0)
			{
				interval = arg3;
			}
			else
				runtime_error( source_file_id_txt, 1037, "Invalid interval in ddtsub()", str6 );

			curr_time -= interval;
			
			seconds_per_day = 24*60*60;
			
			days_to_subtract = 0;
			
			while (curr_time < 0)
			{
				days_to_subtract++;
				curr_time += seconds_per_day;
			}

			hour = curr_time / (60*60);

			minute = (curr_time - hour * (60*60)) / 60;
			 
			second = (curr_time - hour * (60*60) - minute * 60);

			time_from_parts( text, hour, minute, second, source_file_id_txt );

			while (day - days_to_subtract < 1)
			{
				days_to_subtract -= day;
				
				month--;
				
				if (month < 1)
				{
					year--;
					month = 12;
				}
				
				day = last_day_of_the_month( year, month );						
			}
			
			day -= days_to_subtract;
			
			date_from_parts( text2, day, month, year, source_file_id_txt );
			
			strcat( text2, " " );
			strcat( text2, text );

			_calcsys_var_set_s( result, text2, source_file_id_txt );
			
			return ((char *) result);			
		}
	
				
		long int _calc_ddiff( var *arg1, var *arg2, char *source_file_id_txt )
		{
			char str1[MEDIUM_STRING_BUFFER_SIZE];
			char str2[MEDIUM_STRING_BUFFER_SIZE];
			
			var_check_s( arg1, source_file_id_txt );
			var_check_s( arg2, source_file_id_txt );

			str_u32_to_u8( str1, arg1->data.svalue, MEDIUM_STRING_BUFFER_SIZE );
			str_u32_to_u8( str2, arg2->data.svalue, MEDIUM_STRING_BUFFER_SIZE );
						
			if (! check_date_valid( str1, "yyyy-mm-dd", source_file_id_txt ))
				runtime_error( source_file_id_txt, 1038, "Invalid date text", str1 );

			if (! check_date_valid( str2, "yyyy-mm-dd", source_file_id_txt ))
				runtime_error( source_file_id_txt, 1039, "Invalid date text", str2 );
				
			return ( convert_date_to_julian( str2, source_file_id_txt ) - convert_date_to_julian( str1, source_file_id_txt ) ); 
		}
			

		long int _calc_ddt_to_utime( var *arg1, var *arg2, char *source_file_id_txt )
		{
			char str1[MEDIUM_STRING_BUFFER_SIZE];
			char str2[MEDIUM_STRING_BUFFER_SIZE];
			
			var_check_s( arg1, source_file_id_txt );
			var_check_s( arg2, source_file_id_txt );

			str_u32_to_u8( str1, arg1->data.svalue, MEDIUM_STRING_BUFFER_SIZE );
			str_u32_to_u8( str2, arg2->data.svalue, MEDIUM_STRING_BUFFER_SIZE );
						
			if (! check_datetime_valid( str1, source_file_id_txt ))
				runtime_error( source_file_id_txt, 1149, "Invalid datetime text in ddt_to_utime()", str1 );


			struct tm tm = {0};
		    long int ts;
		    char oldtz[128] = {0};
		
		    // save previous TZ
		    const char *p = getenv("TZ");
		    if (p) strncpy(oldtz, p, sizeof(oldtz) - 1);
		
		    // set new TZ
		    setenv("TZ", str2, 1);
		    tzset();  // IMPORTANT: load zoneinfo
		
		    // parse input
		    sscanf(str1, "%4d-%2d-%2d %2d:%2d:%2d",
		           &tm.tm_year, &tm.tm_mon, &tm.tm_mday,
		           &tm.tm_hour, &tm.tm_min, &tm.tm_sec);
		
		    tm.tm_year -= 1900;
		    tm.tm_mon -= 1;
		    tm.tm_isdst = -1;  // let system decide daylight saving
		
		    // convert to timestamp
		    ts = (long int)mktime(&tm);
		
		    tzset();  // ensure DST finalized for mktime
		
		    // restore previous TZ
		    if (oldtz[0])
		        setenv("TZ", oldtz, 1);
		    else
		        unsetenv("TZ");
		
		    tzset();  // reload old zoneinfo
		
		    return ts;
		}



		char *_calc_dutime_to_dt( var *result, long int arg1, var *arg2, char *source_file_id_txt )
		{
			char str2[MEDIUM_STRING_BUFFER_SIZE];
			char str3[MEDIUM_STRING_BUFFER_SIZE];
			
			var_check_s( arg2, source_file_id_txt );

			str_u32_to_u8( str2, arg2->data.svalue, MEDIUM_STRING_BUFFER_SIZE );

		
		// Save current TZ to restore later
		    char *old_tz = getenv("TZ");
		    char *old_tz_copy = NULL;
		
		    if (old_tz)
		        old_tz_copy = strdup(old_tz);
		
		    // Set requested timezone
		    if (setenv("TZ", str2, 1) != 0)
				runtime_error( source_file_id_txt, 1150, "Error 1 in dutime_to_dt()", str2 );
		
		    tzset();
		
		    // Convert to broken-down time for this zone
		    struct tm loc;
		    if (localtime_r(&arg1, &loc) == NULL)
				runtime_error( source_file_id_txt, 1151, "Error 2 in dutime_to_dt()", "" );
		
		    // Format date/time including numeric UTC offset
		    // %z gives offset like +1100
		    if (strftime(str3, MEDIUM_STRING_BUFFER_SIZE-1, "%Y-%m-%d %H:%M:%S", &loc) == 0)
				runtime_error( source_file_id_txt, 1152, "Error 3 in dutime_to_dt()", "" );
		
		    // Restore original TZ
		    if (old_tz_copy)
		        setenv("TZ", old_tz_copy, 1);
		    else
		        unsetenv("TZ");
		
		    tzset();
		    free(old_tz_copy);
		

			_calcsys_var_set_s( result, str3, source_file_id_txt );
			
			return ((char *) result);			
		}
	

				
		char _calc_ddatestr_is_valid( var *arg1, var *arg2, char *source_file_id_txt )
		{
			char str1[MEDIUM_STRING_BUFFER_SIZE];
			char str2[MEDIUM_STRING_BUFFER_SIZE];
			int stat;
		
			var_check_s( arg1, source_file_id_txt );

			str_u32_to_u8( str1, arg1->data.svalue, MEDIUM_STRING_BUFFER_SIZE );
			str_u32_to_u8( str2, arg2->data.svalue, MEDIUM_STRING_BUFFER_SIZE );
			
			if (check_date_valid( str1, str2, source_file_id_txt ))
				stat = true;
			else
				stat = false;

			return ( stat );
		}

				
		char _calc_dtimestr_is_valid( var *arg1, char *source_file_id_txt )
		{
			char str1[MEDIUM_STRING_BUFFER_SIZE];
			int stat;
		
			var_check_s( arg1, source_file_id_txt );

			str_u32_to_u8( str1, arg1->data.svalue, MEDIUM_STRING_BUFFER_SIZE );
			
			if (check_time_valid( str1 ))
				stat = true;
			else
				stat = false;

			return ( stat );
		}

				
		char _calc_ddatetimestr_is_valid( var *arg1, char *source_file_id_txt )
		{
			char str1[MEDIUM_STRING_BUFFER_SIZE];
			int stat;
		
			var_check_s( arg1, source_file_id_txt );

			str_u32_to_u8( str1, arg1->data.svalue, MEDIUM_STRING_BUFFER_SIZE );
			
			if (check_datetime_valid( str1, source_file_id_txt ))
				stat = true;
			else
				stat = false;

			return ( stat );
		}
	
				
		long int _calc_dleap_year( long int arg1, char *source_file_id_txt )
		{
			int stat;
		
			if (is_leap_year( arg1 ))		
				stat = true;
			else
				stat = false;

			return ( stat );
		}
			
				
		long int _calc_dweekday( var *arg1, char *source_file_id_txt )
		{
			char str1[MEDIUM_STRING_BUFFER_SIZE];
			
			var_check_s( arg1, source_file_id_txt );
		
			str_u32_to_u8( str1, arg1->data.svalue, MEDIUM_STRING_BUFFER_SIZE );
			
			if (! check_date_valid( str1, "yyyy-mm-dd", source_file_id_txt ))
				runtime_error( source_file_id_txt, 1040, "Invalid date text", str1 );
		
			return ( jweekday( convert_date_to_julian( str1, source_file_id_txt ) ) );
		}
		
				
		long int _calc_dday( var *arg1, char *source_file_id_txt )
		{
			char str1[MEDIUM_STRING_BUFFER_SIZE];
			char str4[MEDIUM_STRING_BUFFER_SIZE];

			var_check_s( arg1, source_file_id_txt );

			str_u32_to_u8( str1, arg1->data.svalue, MEDIUM_STRING_BUFFER_SIZE );
			
			if (! check_date_valid( str1, "yyyy-mm-dd", source_file_id_txt ))
				runtime_error( source_file_id_txt, 1041, "Invalid date text", str1 );
		
			sright( str4, str1, 2 );
			
			return ( atoi( str4 ) );
		}
		
				
		long int _calc_dmonth( var *arg1, char *source_file_id_txt )
		{
			char str1[MEDIUM_STRING_BUFFER_SIZE];
			char str4[MEDIUM_STRING_BUFFER_SIZE];

			var_check_s( arg1, source_file_id_txt );
			
			str_u32_to_u8( str1, arg1->data.svalue, MEDIUM_STRING_BUFFER_SIZE );
			
			if (! check_date_valid( str1, "yyyy-mm-dd", source_file_id_txt ))
				runtime_error( source_file_id_txt, 1042, "Invalid date text", str1 );
		
			smid( str4, str1, 5, 2 );
			
			return ( atoi( str4 ) );
		}

				
		long int _calc_dyear( var *arg1, char *source_file_id_txt )
		{
			char str1[MEDIUM_STRING_BUFFER_SIZE];
			char str4[MEDIUM_STRING_BUFFER_SIZE];

			var_check_s( arg1, source_file_id_txt );
			
			str_u32_to_u8( str1, arg1->data.svalue, MEDIUM_STRING_BUFFER_SIZE );
			
			if (! check_date_valid( str1, "yyyy-mm-dd", source_file_id_txt ))
				runtime_error( source_file_id_txt, 1043, "Invalid date text", str1 );
		
			sleft( str4, str1, 4 );
			
			return ( atoi( str4 ) );
		}


		long int _calc_dhour( var *arg1, char *source_file_id_txt )
		{
			char str1[MEDIUM_STRING_BUFFER_SIZE];
			char str4[MEDIUM_STRING_BUFFER_SIZE];

			var_check_s( arg1, source_file_id_txt );
			
			str_u32_to_u8( str1, arg1->data.svalue, MEDIUM_STRING_BUFFER_SIZE );
			
			if (! check_time_valid( str1 ))
				runtime_error( source_file_id_txt, 1044, "Invalid time text", str1 );
		
			sleft( str4, str1, 2 );
			
			return ( atoi( str4 ) );
		}

		long int _calc_dminute( var *arg1, char *source_file_id_txt )
		{
			char str1[MEDIUM_STRING_BUFFER_SIZE];
			char str4[MEDIUM_STRING_BUFFER_SIZE];

			var_check_s( arg1, source_file_id_txt );
			
			str_u32_to_u8( str1, arg1->data.svalue, MEDIUM_STRING_BUFFER_SIZE );
			
			if (! check_time_valid( str1 ))
				runtime_error( source_file_id_txt, 1045, "Invalid time text", str1 );
		
			smid( str4, str1, 3, 2 );
			
			return ( atoi( str4 ) );
		}

		long int _calc_dsecond( var *arg1, char *source_file_id_txt )
		{
			char str1[MEDIUM_STRING_BUFFER_SIZE];
			char str4[MEDIUM_STRING_BUFFER_SIZE];

			var_check_s( arg1, source_file_id_txt );
			
			str_u32_to_u8( str1, arg1->data.svalue, MEDIUM_STRING_BUFFER_SIZE );
			
			if (! check_time_valid( str1 ))
				runtime_error( source_file_id_txt, 1046, "Invalid time text", str1 );
		
			sright( str4, str1, 2 );
			
			return ( atoi( str4 ) );
		}
				
		long int _calc_ddate_to_julian( var *arg1, char *source_file_id_txt )
		{
			char str1[MEDIUM_STRING_BUFFER_SIZE];

			var_check_s( arg1, source_file_id_txt );

			str_u32_to_u8( str1, arg1->data.svalue, MEDIUM_STRING_BUFFER_SIZE );
			
			if (! check_date_valid( str1, "yyyy-mm-dd", source_file_id_txt ))
				runtime_error( source_file_id_txt, 1047, "Invalid date text", str1 );
		
			return ( convert_date_to_julian( str1, source_file_id_txt ) );
		}

				
		char *_calc_djulian_to_date( var *result, var *arg1, char *source_file_id_txt )
		{
			char str4[MEDIUM_STRING_BUFFER_SIZE];
			
			convert_julian_to_date( str4, (long) arg1 );

			_calcsys_var_set_s( result, str4, source_file_id_txt );
			
			return ((char *) result);			
		}

				
		char *_calc_ddate_part( var *result, var *arg1, char *source_file_id_txt )
		{
			char str1[MEDIUM_STRING_BUFFER_SIZE];
			char str[SMALL_STRING_BUFFER_SIZE];
			
			var_check_s( arg1, source_file_id_txt );
			
			str_u32_to_u8( str1, arg1->data.svalue, MEDIUM_STRING_BUFFER_SIZE );
			
			if (! check_datetime_valid( str1, source_file_id_txt ))
				runtime_error( source_file_id_txt, 1048, "Invalid datetime text", str1 );
				
			_calcsys_var_set_s( result, sleft( str, str1, 10 ), source_file_id_txt );
			
			return ((char *) result);			
		}

				
		char *_calc_dtime_part( var *result, var *arg1, char *source_file_id_txt )
		{
			char str1[MEDIUM_STRING_BUFFER_SIZE];
			char str[SMALL_STRING_BUFFER_SIZE];
		
			var_check_s( arg1, source_file_id_txt );
			
			str_u32_to_u8( str1, arg1->data.svalue, MEDIUM_STRING_BUFFER_SIZE );
			
			if (! check_datetime_valid( str1, source_file_id_txt ))
				runtime_error( source_file_id_txt, 1049, "Invalid datetime text", str1 );
				
			_calcsys_var_set_s( result, sright( str, str1, 8 ), source_file_id_txt );
			
			return ((char *) result);			
		}
		
				
		char *_calc_lnull( var *result, var *arg1, var *arg2, char *source_file_id_txt )
		{
			*((char **) result) = NULL;
			
			return ((char *) result);			
		}


		char *_calc_ddate_from_parts( var *result, long int arg1, long int arg2, long int arg3, char *source_file_id_txt )
		{
			char text[SMALL_STRING_BUFFER_SIZE];
			
			date_from_parts( text, arg1, arg2, arg3, source_file_id_txt );
			
			_calcsys_var_set_s( result, text, source_file_id_txt );
			
			return ((char *) result);			
		}
			
		char *_calc_dtime_from_parts( var *result, long int arg1, long int arg2, long int arg3, char *source_file_id_txt )
		{
			char text[SMALL_STRING_BUFFER_SIZE];
			
			time_from_parts( text, arg1, arg2, arg3, source_file_id_txt );
			
			_calcsys_var_set_s( result, text, source_file_id_txt );

			return ((char *) result);			
		}


		char *_calc_ddatetime_from_vars( var *result, var *arg1, var *arg2, char *source_file_id_txt )
		{
			char text[SMALL_STRING_BUFFER_SIZE];
			
			strcpy( text, arg1->data.svalue );

			strcat( text, " " );

			strcat( text, arg2->data.svalue );
			
			_calcsys_var_set_s( result, text, source_file_id_txt );

			return ((char *) result);			
		}


		char *_calc_ddatetime_from_parts( var *result, long int arg1, long int arg2, long int arg3, long int arg4, long int arg5, long int arg6, char *source_file_id_txt )
		{
			char text[SMALL_STRING_BUFFER_SIZE];
			
			date_from_parts( text, arg1, arg2, arg3, source_file_id_txt );

			text[10] = ' ';
			
			time_from_parts( &text[11], arg4, arg5, arg6, source_file_id_txt );
			
			_calcsys_var_set_s( result, text, source_file_id_txt );

			return ((char *) result);			
		}
		
		
		void date_from_parts( char *text, int day, int month, int year, char *source_file_id_txt )
		{
			if (year < 50)
				year += 2000;
			else
			if (year < 100)
				year += 1900;
			
			sprintf( text, "%04d-%02d-%02d", year, month, day );
			
			if (! check_date_valid( text, "yyyy-mm-dd", source_file_id_txt ))
				runtime_error( source_file_id_txt, 1050, "Invalid date text:", text );
		}
	

		void time_from_parts( char *text, int hour, int minute, int second, char *source_file_id_txt )
		{
			sprintf( text, "%02d:%02d:%02d", hour, minute, second );
			
			if (! check_time_valid( text ))
				runtime_error( source_file_id_txt, 1051, "Invalid time text:", text );
		}
			

//--------------------------------------------------------------------------
// Binary
//--------------------------------------------------------------------------

/*
		void _calc_binit( var *arg1, char *source_file_id_txt )
		{
			free_curr_mem_1( (var *) arg1, source_file_id_txt );
			
			arg1->data.bvalue = NULL;
			arg1->var_type = VAR_BINARY;
		}
*/

		long int _calc_bsize( var *arg1, char *source_file_id_txt )
		{
			if (arg1->var_type != VAR_BINARY)
				runtime_error( source_file_id_txt, 1052, "Variable is not a binary variable", "" );

			return (*((int_64 *) (arg1->data.bvalue)));
		}


		long int _calc_bget_byte( var *arg1, long int arg2, char *source_file_id_txt )
		{
			int_64 len1;

			if (arg1->var_type != VAR_BINARY)
				runtime_error( source_file_id_txt, 1052, "Variable is not a binary variable", "" );
		
			len1 = *((int_64 *) (arg1->data.bvalue));

			if (arg2 < 0 || arg2 >= len1)
				runtime_error( source_file_id_txt, 1052, "Attempt to get a byte beyond the size of the data variable.", "" );

			return (arg1->data.bvalue[arg2 + sizeof( int_64 )]);
		}

				
		void _calc_bset_byte( var *arg1, long int arg2, long int arg3, char *source_file_id_txt )
		{
			int_64 len1;
			
			if (arg1->var_type != VAR_BINARY)
				runtime_error( source_file_id_txt, 1053, "Variable is not a binary variable", "" );
			
			len1 = *((int_64 *) (arg1->data.bvalue));

			if (arg2 < 0 || arg2 >= len1)
				runtime_error( source_file_id_txt, 1052, "Attempt to set a byte beyond the size of the data variable.", "" );
				
			arg1->data.bvalue[arg2 + sizeof( int_64 )] = (unsigned char) arg3;
		}			 


/*
		long int _calc_bget_bit( var *arg1, long int arg2, char *source_file_id_txt )
		{
			char num_text[SMALL_STRING_BUFFER_SIZE];
			int num;
			int byte_val;
			int_64 pos1, bit_pos;
			int_64 len1;
			
			if (arg1->var_type != VAR_BINARY)
				runtime_error( source_file_id_txt, 1054, "Variable is not a binary variable", "" );
		
			pos1 = (int) ((arg2) / 8);
			
			bit_pos = arg2 % 8;

			len1 = *((int_64 *) (arg1->data.bvalue));
			 		
			if (pos1 >= len1)
				num = 0;
			else
			{
				num = 0;
			
				
				if (bit_pos == 0) {if ((arg1->data.bvalue[pos1 + sizeof( int_64 )] & 0x80) != 0)				num = 1;		}	else
				if (bit_pos == 1) {if ((arg1->data.bvalue[pos1 + sizeof( int_64 )] & 0x40) != 0)				num = 1;		}	else
				if (bit_pos == 2) {if ((arg1->data.bvalue[pos1 + sizeof( int_64 )] & 0x20) != 0)				num = 1;		}	else
				if (bit_pos == 3) {if ((arg1->data.bvalue[pos1 + sizeof( int_64 )] & 0x10) != 0)				num = 1;		}	else
				if (bit_pos == 4) {if ((arg1->data.bvalue[pos1 + sizeof( int_64 )] & 0x08) != 0)				num = 1;		}	else
				if (bit_pos == 5) {if ((arg1->data.bvalue[pos1 + sizeof( int_64 )] & 0x04) != 0)				num = 1;		}	else
				if (bit_pos == 6) {if ((arg1->data.bvalue[pos1 + sizeof( int_64 )] & 0x02) != 0)				num = 1;		}	else
				if (bit_pos == 7) {if ((arg1->data.bvalue[pos1 + sizeof( int_64 )] & 0x01) != 0)				num = 1;		}

			}				
			
			return ( num );
		}
*/

/*
		void _calc_bset_bit( var *arg1, long int arg2, long int arg3, char *source_file_id_txt )
		{
			int_64 len1, len2;
			int_64 bit_pos;
			int_64 pos1;
			int bit_value;
			char *ptr;
			
			if (arg1->var_type != VAR_BINARY)
				runtime_error( source_file_id_txt, 1055, "Variable is not a binary variable", "" );
			
			pos1 = (int) ((arg2) / 8);
			
			bit_pos = arg2 - (pos1 * 8);
			
			bit_value = arg3;

			len2 = *((int_64 *) (arg1->data.bvalue));
					
			if (pos1 >= len2)
				runtime_error( source_file_id_txt, 1055, "Attempt to set a bit beyond the size of the data.", "" );

			if (bit_pos == 0 && bit_value == 1)			arg1->data.bvalue[pos1 + sizeof( int_64 )] |= 0x80;		else
			if (bit_pos == 1 && bit_value == 1)			arg1->data.bvalue[pos1 + sizeof( int_64 )] |= 0x40;		else
			if (bit_pos == 2 && bit_value == 1)			arg1->data.bvalue[pos1 + sizeof( int_64 )] |= 0x20;		else
			if (bit_pos == 3 && bit_value == 1)			arg1->data.bvalue[pos1 + sizeof( int_64 )] |= 0x10;		else
			if (bit_pos == 4 && bit_value == 1)			arg1->data.bvalue[pos1 + sizeof( int_64 )] |= 0x08;		else
			if (bit_pos == 5 && bit_value == 1)			arg1->data.bvalue[pos1 + sizeof( int_64 )] |= 0x04;		else
			if (bit_pos == 6 && bit_value == 1)			arg1->data.bvalue[pos1 + sizeof( int_64 )] |= 0x02;		else
			if (bit_pos == 7 && bit_value == 1)			arg1->data.bvalue[pos1 + sizeof( int_64 )] |= 0x01;		else
				
			if (bit_pos == 0 && bit_value == 0)			arg1->data.bvalue[pos1 + sizeof( int_64 )] &= 0x7F;		else
			if (bit_pos == 1 && bit_value == 0)			arg1->data.bvalue[pos1 + sizeof( int_64 )] &= 0xBF;		else
			if (bit_pos == 2 && bit_value == 0)			arg1->data.bvalue[pos1 + sizeof( int_64 )] &= 0xDF;		else
			if (bit_pos == 3 && bit_value == 0)			arg1->data.bvalue[pos1 + sizeof( int_64 )] &= 0xEF;		else
			if (bit_pos == 4 && bit_value == 0)			arg1->data.bvalue[pos1 + sizeof( int_64 )] &= 0xF7;		else
			if (bit_pos == 5 && bit_value == 0)			arg1->data.bvalue[pos1 + sizeof( int_64 )] &= 0xFB;		else
			if (bit_pos == 6 && bit_value == 0)			arg1->data.bvalue[pos1 + sizeof( int_64 )] &= 0xFD;		else
			if (bit_pos == 7 && bit_value == 0)			arg1->data.bvalue[pos1 + sizeof( int_64 )] &= 0xFE;
		}			 
*/

		void _calc_bset_size( var *arg1, long int arg2, char *source_file_id_txt )
		{
			int_64 len, len2;
			int_64 len_to_copy;
			char *ptr;
			
			if (arg1->var_type != VAR_EMPTY && arg1->var_type != VAR_BINARY)
				runtime_error( source_file_id_txt, 1056, "Variable is not empty or a binary variable", "" );
			
			len = arg2;
			
			if (arg1->var_type == VAR_BINARY)
			{
				len2 = *((int_64 *) (arg1->data.bvalue));
			
				if (len > len2)
				{
					ptr = (char *) _malloc( len + sizeof( int_64 ) );
					
					memcpy( ptr + sizeof( int_64 ), arg1->data.bvalue + sizeof( int_64 ), len2 );
				
					_free( arg1->data.bvalue );

					arg1->data.bvalue = (unsigned char *) ptr;
				}
				
				*((int_64 *) (arg1->data.bvalue)) = len;
			}
			else
			{
				ptr = (char *) _malloc( len + sizeof( int_64 ) );

				arg1->data.bvalue = (unsigned char *) ptr;

				*((int_64 *) (arg1->data.bvalue)) = len;
			
				arg1->var_type = VAR_BINARY;
			}
		}			 
	

		void _calc_bclear( var *arg1, long int arg2, char *source_file_id_txt )
		{
			int_64 pos, len;
			int_64 bit_pos, bit_value;
			int_64 pos1;
			char *ptr;
			
			if (arg1->var_type != VAR_BINARY)
				runtime_error( source_file_id_txt, 1057, "Variable is not a binary variable", "" );

			if (arg1->data.bvalue != NULL)
			{
				len = *((int_64 *) (arg1->data.bvalue));
			
				memset( arg1->data.bvalue + sizeof( int_64 ), arg2, len );
			}
		} 

		
		char *_calc_bint_to_hex( var *result, long int arg1, char arg2, char *source_file_id_txt )
		{
			char dest[SMALL_STRING_BUFFER_SIZE];
			
			dec_to_hex( dest, (unsigned char *) &(arg1), sizeof( int_64 ), false, arg2 );
			
			_calcsys_var_set_s( result, dest, source_file_id_txt );
			
			return ((char *) result);			
		}


		long int _calc_bhex_to_int( var *arg1, char *source_file_id_txt )
		{
			char str[MEDIUM_STRING_BUFFER_SIZE];
			int_64 dest;
			
			var_check_s( arg1, source_file_id_txt );
			
			str_u32_to_u8( str, arg1->data.svalue, MEDIUM_STRING_BUFFER_SIZE );
			
			dest = hex_to_int( str, source_file_id_txt );

			return ( dest );
		}



//--------------------------------------------------------------------------
// Internet
//--------------------------------------------------------------------------

/*
	void _calc_isend_email( var *result, var *arg1, var *arg2, char *source_file_id_txt )
	{
		$result =
		
*/
				
		char *_calc_iconvert_to_html( var *result, var *arg1, char *source_file_id_txt )
		{
			char *ptr, *ptr2;
			char *str, str2[MEDIUM_STRING_BUFFER_SIZE];
			char *str1; 
			int_64 i, len;
			int_64 len2, len3;
			char ch;
			
			var_check_s( arg1, source_file_id_txt );

			str1 = _malloc( *((int_64 *) (arg1->data.svalue)) * 4 + 1 );
			
			str_u32_to_u8( str1, arg1->data.svalue, MEDIUM_STRING_BUFFER_SIZE );

			len2 = strlen( str1 );
			
			len = 2 * len2;
			
			if (len < 1000)
				len = 1000;
							
			str = _malloc( len + 1 );
			
			str[0] = '\0';
           	str2[1] = '\0';
			
			for (i=0; i < len2; i++)
			{
				if (strlen( str ) > len - 50)
				{
					len3 = len;
					
					len = len * 1.3;
					
					ptr2 = _malloc( len + 1 );
					
					strcpy( ptr2, str );
					
					_free( str );
					
					str = ptr2;
				}
				
				ch = str1[i];
				
				if (ch == '\n')
					strcat( str, "<br>" );
				else
				if (ch == '&')
					strcat( str, "&amp;" );
				else
				if (ch == '"')
					strcat( str, "&quot;" );
				else
				if (ch == '\'')
					strcat( str, "&#039;" );
				else
				if (ch == '<')
					strcat( str, "&lt;" );
				else
				if (ch == '>')
					strcat( str, "&gt;" );
				else
				if (ch == '+')
					strcat( str, "&#43;" );
	            else
	            {
	            	str2[0]= ch;
					strcat( str, str2 );
				}
			}

			_calcsys_var_set_s( result, str, source_file_id_txt );
			
			_free( str1 );
			_free( str );
			
			return ((char *) result);			
		}
	
				
		char *_calc_iurlencode( var *result, var *arg1, char *source_file_id_txt )
		{
			char *ptr, *ptr2;
			char str[MEDIUM_STRING_BUFFER_SIZE], str2[MEDIUM_STRING_BUFFER_SIZE];
			char str3[MEDIUM_STRING_BUFFER_SIZE];
			int i;
			
			var_check_s( arg1, source_file_id_txt );

			*str = '\0';
           	str2[1] = '\0';
			
			str_u32_to_u8( str3, arg1->data.svalue, MEDIUM_STRING_BUFFER_SIZE );
			
			for (i=0; i < strlen( str3 ); i++)
			{
				ptr = &str3[i];

				if (*ptr == '=')
					strcat( str, "%3D" );
	            else
				if (*ptr == '&')
					strcat( str, "%26" );
	            else
				if (*ptr == '\'')
					strcat( str, "%27" );
	            else
				if (*ptr == ' ')
					strcat( str, "%20" );
	            else
				if (*ptr == '!')
					strcat( str, "%21" );
	            else
				if (*ptr == '"')
					strcat( str, "%22" );
	            else
				if (*ptr == '#')
					strcat( str, "%23" );
	            else
				if (*ptr == '$')
					strcat( str, "%24" );
	            else
				if (*ptr == '%')
					strcat( str, "%25" );
	            else
				if (*ptr == '(')
					strcat( str, "%28" );
	            else
				if (*ptr == ')')
					strcat( str, "%29" );
	            else
				if (*ptr == '*')
					strcat( str, "%2A" );
	            else
				if (*ptr == '+')
					strcat( str, "%2B" );
	            else
				if (*ptr == ',')
					strcat( str, "%2C" );
	            else
				if (*ptr == '-')
					strcat( str, "%2D" );
	            else
				if (*ptr == '.')
					strcat( str, "%2E" );
	            else
				if (*ptr == '?')
					strcat( str, "%3F" );
	            else
				if (*ptr == '@')
					strcat( str, "%40" );
	            else
	            {
	            	str2[0]= *ptr;
					strcat( str, str2 );
				}
			}

			_calcsys_var_set_s( result, str, source_file_id_txt );
			
			return ((char *) result);			
		}
		
				
		char *_calc_iurldecode( var *result, var *arg1, char *source_file_id_txt )
		{
			char *ptr, *ptr2;
			char str3[MEDIUM_STRING_BUFFER_SIZE];
			int_64 len2;
			char str[MEDIUM_STRING_BUFFER_SIZE], str2[MEDIUM_STRING_BUFFER_SIZE]; 
			int i;
			
			var_check_s( arg1, source_file_id_txt );

			str_u32_to_u8( str3, arg1->data.svalue, MEDIUM_STRING_BUFFER_SIZE );

			*str = '\0';
           	str2[1] = '\0';
			
			len2 = strlen( str3 );
			
			for (i=0; i < len2; i++)
			{
				ptr = &str3[i];
				
				if (strncmp( ptr, "%3D", 3 ) == 0)
				{
					strcat( str, "=" );		i += 2;
				}
				else
				if (strncmp( ptr, "%26", 3 ) == 0)
				{
					strcat( str, "&" );		i += 2;
				}
				else
				if (strncmp( ptr, "%27", 3 ) == 0)
				{
					strcat( str, "'" );		i += 2;
				}
				else
				if (strncmp( ptr, "%20", 3 ) == 0)
				{
					strcat( str, " " );		i += 2;
				}
				else
				if (strncmp( ptr, "%21", 3 ) == 0)
				{
					strcat( str, "!" );		i += 2;
				}
				else
				if (strncmp( ptr, "%22", 3 ) == 0)
				{
					strcat( str, "\"" );	i += 2;
				}
				else
				if (strncmp( ptr, "%23", 3 ) == 0)
				{
					strcat( str, "#" );		i += 2;
				}
				else
				if (strncmp( ptr, "%24", 3 ) == 0)
				{
					strcat( str, "$" );		i += 2;
				}
				else
				if (strncmp( ptr, "%25", 3 ) == 0)
				{
					strcat( str, "%" );		i += 2;
				}
				else
				if (strncmp( ptr, "%28", 3 ) == 0)
				{
					strcat( str, "(" );		i += 2;
				}
				else
				if (strncmp( ptr, "%29", 3 ) == 0)
				{
					strcat( str, ")" );		i += 2;
				}
				else
				if (strncmp( ptr, "%2A", 3 ) == 0)
				{
					strcat( str, "*" );		i += 2;
				}
				else
				if (strncmp( ptr, "%2B", 3 ) == 0)
				{
					strcat( str, "+" );		i += 2;
				}
				else
				if (strncmp( ptr, "%2C", 3 ) == 0)
				{
					strcat( str, "," );		i += 2;
				}
				else
				if (strncmp( ptr, "%2D", 3 ) == 0)
				{
					strcat( str, "-" );		i += 2;
				}
				else
				if (strncmp( ptr, "%2E", 3 ) == 0)
				{
					strcat( str, "." );		i += 2;
				}
				else
				if (strncmp( ptr, "%3F", 3 ) == 0)
				{
					strcat( str, "?" );		i += 2;
				}
				else
				if (strncmp( ptr, "%40", 3 ) == 0)
				{
					strcat( str, "@" );		i += 2;
				}
	            else
	            {
	            	str2[0]= *ptr;
					strcat( str, str2 );
				}
			}

			_calcsys_var_set_s( result, str, source_file_id_txt );

			return ((char *) result);			
		}

				
		void _calc_ijump_to_page( var *arg1, char *source_file_id_txt )
		{
			FILE *fp;
			char str[MEDIUM_STRING_BUFFER_SIZE];
			
			var_check_s( arg1, source_file_id_txt );
		
			if (redirect_filename == NULL)
		    {
	    		printf( "\nAttempted redirection on NULL redirect file." );
				exit(1);
		    }
		
			fp = fopen( redirect_filename, "w" );
			
		    if (fp == NULL)
		    {
	    		printf( "\nCan't open file for redirect: %s\n\n", redirect_filename );
				exit(1);
		    }
			
			str_u32_to_u8( str, arg1->data.svalue, MEDIUM_STRING_BUFFER_SIZE );
			
			fputs( str, fp );
			
			fclose( fp );
			
			calc_stdlib_exit( get_and_post_filename );
			
			exit( 2 );
		}
						
				
		void _calc_iexit_if_search_bot( var *result, char *source_file_id_txt )
		{
			; // not implemented yet
		}
						
				
		void _calc_iread_web_page( var *result, var *arg1, var *arg2, char *source_file_id_txt )
		{
			; // not implemented yet
		}
						
						
						
//--------------------------------------------------------------------------
// Data type conversion
//--------------------------------------------------------------------------

		
		short int _calc_cint_to_short_int( long int arg1, char *source_file_id_txt )
		{
			return ( (short int) arg1 );
		}

		int _calc_cint_to_medium_int( long int arg1, char *source_file_id_txt )
		{
			return ( (int) arg1 );
		}

		char _calc_cint_to_byte( long int arg1, char *source_file_id_txt )
		{
			return ( (char) arg1 );
		}
		
		long int _calc_cint_to_decimal( long int arg1, char *source_file_id_txt )
		{
			return ( (long int) ((long int) arg1 * (long int) VAR_DECIMAL_SCALE) );
		}
		
		float _calc_cint_to_float( long int arg1, char *source_file_id_txt )
		{
			return ( (float) arg1 );
		}

		double _calc_cint_to_double( long int arg1, char *source_file_id_txt )
		{
			return ( (double) arg1 );
		}

		long double _calc_cint_to_long_double( long int arg1, char *source_file_id_txt )
		{
			return ( (long double) arg1 );
		}
		
//--

		long int _calc_cshort_int_to_int( short int arg1, char *source_file_id_txt )
		{
			return ( (long int) arg1 );
		}

		int _calc_cshort_int_to_medium_int( short int arg1, char *source_file_id_txt )
		{
			return ( (int) arg1 );
		}

		char _calc_cshort_int_to_byte( short int arg1, char *source_file_id_txt )
		{
			return ( (char) arg1 );
		}
		
		long int _calc_cshort_int_to_decimal( short int arg1, char *source_file_id_txt )
		{
			return ( (long int) ((long int) arg1 * (long int) VAR_DECIMAL_SCALE) );
		}
		
		float _calc_cshort_int_to_float( short int arg1, char *source_file_id_txt )
		{
			return ( (float) arg1 );
		}

		double _calc_cshort_int_to_double( short int arg1, char *source_file_id_txt )
		{
			return ( (double) arg1 );
		}

		long double _calc_cshort_int_to_long_double( short int arg1, char *source_file_id_txt )
		{
			return ( (long double) arg1 );
		}
		
//--

		long int _calc_cmedium_int_to_int( int arg1, char *source_file_id_txt )
		{
			return ( (long int) arg1 );
		}
		
		short int _calc_cmedium_int_to_short_int( int arg1, char *source_file_id_txt )
		{
			return ( (short int) arg1 );
		}

		char _calc_cmedium_int_to_byte( int arg1, char *source_file_id_txt )
		{
			return ( (char) arg1 );
		}
		
		long int _calc_cmedium_int_to_decimal( int arg1, char *source_file_id_txt )
		{
			return ( (long int) ((long int) arg1 * (long int) VAR_DECIMAL_SCALE) );
		}
		
		float _calc_cmedium_int_to_float( int arg1, char *source_file_id_txt )
		{
			return ( (float) arg1 );
		}

		double _calc_cmedium_int_to_double( int arg1, char *source_file_id_txt )
		{
			return ( (double) arg1 );
		}

		long double _calc_cmedium_int_to_long_double( int arg1, char *source_file_id_txt )
		{
			return ( (long double) arg1 );
		}
		
//--

		long int _calc_cbyte_to_int( char arg1, char *source_file_id_txt )
		{
			return ( (long int) arg1 );
		}
		
		short int _calc_cbyte_to_short_int( char arg1, char *source_file_id_txt )
		{
			return ( (short int) arg1 );
		}

		int _calc_cbyte_to_medium_int( char arg1, char *source_file_id_txt )
		{
			return ( (int) arg1 );
		}
		
		long int _calc_cbyte_to_decimal( char arg1, char *source_file_id_txt )
		{
			return ( (long int) ((long int) arg1 * (long int) VAR_DECIMAL_SCALE) );
		}
		
		float _calc_cbyte_to_float( char arg1, char *source_file_id_txt )
		{
			return ( (float) arg1 );
		}

		double _calc_cbyte_to_double( char arg1, char *source_file_id_txt )
		{
			return ( (double) arg1 );
		}

		long double _calc_cbyte_to_long_double( char arg1, char *source_file_id_txt )
		{
			return ( (long double) arg1 );
		}

//--

		long int _calc_cdecimal_to_int( long int arg1, char *source_file_id_txt )
		{
			return ( (long int) roundl( (long double) arg1 / (long double) VAR_DECIMAL_SCALE ) );
		}
		
		short int _calc_cdecimal_to_short_int( long int arg1, char *source_file_id_txt )
		{
			return ( (short int) roundl( (long double) arg1 / (long double) VAR_DECIMAL_SCALE ) );
		}

		int _calc_cdecimal_to_medium_int( long int arg1, char *source_file_id_txt )
		{
			return ( (int) roundl( (long double) arg1 / (long double) VAR_DECIMAL_SCALE ) );
		}

		char _calc_cdecimal_to_byte( long int arg1, char *source_file_id_txt )
		{
			return ( (char) roundl( (long double) arg1 / (long double) VAR_DECIMAL_SCALE ) );
		}
		
		float _calc_cdecimal_to_float( long int arg1, char *source_file_id_txt )
		{
			return ( (float) ((long double) arg1 / (long double) VAR_DECIMAL_SCALE) );
		}

		double _calc_cdecimal_to_double( long int arg1, char *source_file_id_txt )
		{
			return ( (double) ((long double) arg1 / (long double) VAR_DECIMAL_SCALE) );
		}

		long double _calc_cdecimal_to_long_double( long int arg1, char *source_file_id_txt )
		{
			return ( (long double) ((long double) arg1 / (long double) VAR_DECIMAL_SCALE) );
		}
		
//--

		long int _calc_cfloat_to_int( float arg1, char *source_file_id_txt )
		{
			return ( (long int) arg1 );
		}
		
		short int _calc_cfloat_to_short_int( float arg1, char *source_file_id_txt )
		{
			return ( (short int) arg1 );
		}

		int _calc_cfloat_to_medium_int( float arg1, char *source_file_id_txt )
		{
			return ( (int) arg1 );
		}

		char _calc_cfloat_to_byte( float arg1, char *source_file_id_txt )
		{
			return ( (char) arg1 );
		}
		
		long int _calc_cfloat_to_decimal( float arg1, char *source_file_id_txt )
		{
			return ( (long int) ((long int) arg1 * (long int) VAR_DECIMAL_SCALE + 0.001 ) );
		}

		double _calc_cfloat_to_double( float arg1, char *source_file_id_txt )
		{
			return ( (double) arg1 );
		}

		long double _calc_cfloat_to_long_double( float arg1, char *source_file_id_txt )
		{
			return ( (long double) arg1 );
		}
//--

		long int _calc_cdouble_to_int( double arg1, char *source_file_id_txt )
		{
			return ( (long int) arg1 );
		}
		
		short int _calc_cdouble_to_short_int( double arg1, char *source_file_id_txt )
		{
			return ( (short int) arg1 );
		}

		int _calc_cdouble_to_medium_int( double arg1, char *source_file_id_txt )
		{
			return ( (int) arg1 );
		}

		char _calc_cdouble_to_byte( double arg1, char *source_file_id_txt )
		{
			return ( (char) arg1 );
		}
		
		long int _calc_cdouble_to_decimal( double arg1, char *source_file_id_txt )
		{
			return ( (long int) ((long int) arg1 * (long int) VAR_DECIMAL_SCALE + 0.001 ) );
		}
		
		float _calc_cdouble_to_float( double arg1, char *source_file_id_txt )
		{
			return ( (float) arg1 );
		}

		long double _calc_cdouble_to_long_double( double arg1, char *source_file_id_txt )
		{
			return ( (long double) arg1 );
		}
		
//--

		long int _calc_clong_double_to_int( long double arg1, char *source_file_id_txt )
		{
			return ( (long int) arg1 );
		}
		
		short int _calc_clong_double_to_short_int( long double arg1, char *source_file_id_txt )
		{
			return ( (short int) arg1 );
		}

		int _calc_clong_double_to_medium_int( long double arg1, char *source_file_id_txt )
		{
			return ( (int) arg1 );
		}

		char _calc_clong_double_to_byte( long double arg1, char *source_file_id_txt )
		{
			return ( (char) arg1 );
		}
		
		long int _calc_clong_double_to_decimal( long double arg1, char *source_file_id_txt )
		{
			return ( (long int) ((long int) arg1 * (long int) VAR_DECIMAL_SCALE + 0.001 ) );
		}
		
		float _calc_clong_double_to_float( long double arg1, char *source_file_id_txt )
		{
			return ( (float) arg1 );
		}

		double _calc_clong_double_to_double( long double arg1, char *source_file_id_txt )
		{
			return ( (double) arg1 );
		}
		
		
//-------------------------------------		
		

		char *_calc_cdate_to_datetime( var *result, var *arg1, char *source_file_id_txt )
		{
			char str[SMALL_STRING_BUFFER_SIZE];
			
			var_check_s( arg1, source_file_id_txt );

			if (check_date_valid( arg1->data.svalue, "yyyy-mm-dd", source_file_id_txt ))
			{
				strcpy( str, arg1->data.svalue );
				strcat( str, " 99:99:99" );
				
				_calcsys_var_set_s( result, str, source_file_id_txt );
			}

			return ((char *) result);			
		}
			
		char *_calc_cint_to_string( var *result, long int arg1, char *source_file_id_txt )
		{
			char str[SMALL_STRING_BUFFER_SIZE];
			
			sprintf( str, "%ld", arg1 );
			
			trim_trailing_zeros( str );
			
			_calcsys_var_set_s( result, str, source_file_id_txt );

			return ((char *) result);			
		}

		char *_calc_cdecimal_to_string( var *result, long int arg1, char *source_file_id_txt )
		{
			char str[SMALL_STRING_BUFFER_SIZE];
			
			sprintf( str, "%.2lf", (double) arg1 / (double) VAR_DECIMAL_SCALE );
			
			trim_trailing_zeros( str );
			
			_calcsys_var_set_s( result, str, source_file_id_txt );

			return ((char *) result);			
		}


		char *_calc_cdouble_to_string( var *result, double arg1, char *source_file_id_txt )
		{
			char str[SMALL_STRING_BUFFER_SIZE];
			
			if (arg1 != 0 && (arg1 > 1000000000000 || arg1 < -1000000000000 || fabs( arg1 ) < 0.000000000001))
				sprintf( str, "%e", arg1 );
			else
				sprintf( str, "%.13lf", arg1 );
			
			trim_trailing_zeros( str );
			
			_calcsys_var_set_s( result, str, source_file_id_txt );

			return ((char *) result);			
		}

		char *_calc_clong_double_to_string( var *result, long double arg1, char *source_file_id_txt )
		{
			char str[SMALL_STRING_BUFFER_SIZE];
			
			if (arg1 != 0 && (arg1 > 1000000000000000000 || arg1 < -1000000000000000000 || fabsl( arg1 ) < 0.000000000000000001))
				sprintf( str, "%Le", arg1 );
			else
				sprintf( str, "%.18Lf", arg1 );
			
			trim_trailing_zeros( str );
			
			_calcsys_var_set_s( result, str, source_file_id_txt );

			return ((char *) result);			
		}

		char *_calc_cbool_to_string( var *result, char arg1, char *source_file_id_txt )
		{
			char *text;
			
			if (arg1 != 0)
				text = "true";
			else
				text = "false";
			
			trim_trailing_zeros( text );
			
			_calcsys_var_set_s( result, text, source_file_id_txt );

			return ((char *) result);			
		}

		char *_calc_cdate_to_string( var *result, var *arg1, var *arg2, char *source_file_id_txt ) 
		{
			_calc_dformat( result, arg1, arg2, source_file_id_txt );

			return ((char *) result);			
		} 
			
		char *_calc_ctime_to_string( var *result, var *arg1, var *arg2, char *source_file_id_txt ) 
		{
			_calc_tformat( result, arg1, arg2, source_file_id_txt );			

			return ((char *) result);			
		} 

		char *_calc_cdatetime_to_string( var *result, var *arg1, var *arg2, char *source_file_id_txt ) 
		{
			_calc_dtformat( result, arg1, arg2, source_file_id_txt );

			return ((char *) result);			
		} 

		char *_calc_cbinary_to_string( var *result, var *arg1, char arg2, char *source_file_id_txt )
		{
			int_64 len;
			int_64 len2;
			char *ptr;
			char *ptr2;
			int_64 i;
			char str[MEDIUM_STRING_BUFFER_SIZE];
			
			if (arg1->var_type != VAR_BINARY)
				runtime_error( source_file_id_txt, 1058, "Variable is not a binary variable", "" );
			
			len2 = *((int_64 *) (arg1->data.bvalue));
			
			len = 2 * len2 + 1;

			if (len >= MEDIUM_STRING_BUFFER_SIZE-1)
				ptr = _malloc( len + sizeof( int_64 ) );
			else
				ptr = str;
				
			if (arg2)
			{
				dec_to_hex( ptr, arg1->data.svalue + sizeof( int_64 ), len2, true, false );
				_calcsys_var_set_s( result, ptr, source_file_id_txt );
			}
			else
			{
				memcpy( ptr + sizeof( int_64 ), arg1->data.svalue + sizeof( int_64 ), len2 );

				*((int_64 *) ptr) = len2;
									
				_calcsys_var_set_s_u32( result, ptr, false, source_file_id_txt );
			}
			
			if (len >= MEDIUM_STRING_BUFFER_SIZE-1)
				_free( ptr );

			return ((char *) result);			
		}

		short int _calc_cstring_to_short_int( var *arg1, char *source_file_id_txt ) 
		{
			char str[SMALL_STRING_BUFFER_SIZE];
			short int num;
			
			var_check_s( arg1, source_file_id_txt );
			
			str_u32_to_u8( str, arg1->data.svalue, SMALL_STRING_BUFFER_SIZE );
			
			num = (short int) atoi( str );
			
			return ( num );
		} 

		int _calc_cstring_to_medium_int( var *arg1, char *source_file_id_txt ) 
		{
			char str[SMALL_STRING_BUFFER_SIZE];
			int num;
			
			var_check_s( arg1, source_file_id_txt );
			
			str_u32_to_u8( str, arg1->data.svalue, SMALL_STRING_BUFFER_SIZE );
			
			num = atoi( str );
			
			return ( num );
		} 

		char _calc_cstring_to_byte( var *arg1, char *source_file_id_txt ) 
		{
			char str[SMALL_STRING_BUFFER_SIZE];
			char num;
			
			var_check_s( arg1, source_file_id_txt );
			
			str_u32_to_u8( str, arg1->data.svalue, SMALL_STRING_BUFFER_SIZE );
			
			num = (char) atoi( str );
			
			return ( num );
		} 

		long int _calc_cstring_to_int( var *arg1, char *source_file_id_txt ) 
		{
			char str[SMALL_STRING_BUFFER_SIZE];
			long int num;
			
			var_check_s( arg1, source_file_id_txt );
			
			str_u32_to_u8( str, arg1->data.svalue, SMALL_STRING_BUFFER_SIZE );
			
			num = atol( str );
			
			return ( num );
		} 

		long int _calc_cstring_to_decimal( var *arg1, char *source_file_id_txt ) 
		{
			char str[SMALL_STRING_BUFFER_SIZE];
			double num;
			
			var_check_s( arg1, source_file_id_txt );
			
			str_u32_to_u8( str, arg1->data.svalue, SMALL_STRING_BUFFER_SIZE );
			
			num = atof( str );
			
			return ( (long int) round( num * (double) VAR_DECIMAL_SCALE ) );
		} 

		float _calc_cstring_to_float( var *arg1, char *source_file_id_txt ) 
		{
			char str[SMALL_STRING_BUFFER_SIZE];
			double num;
			
			var_check_s( arg1, source_file_id_txt );
			
			str_u32_to_u8( str, arg1->data.svalue, SMALL_STRING_BUFFER_SIZE );
			
			num = (float) atof( str );
			
			return ( num );
		} 

		double _calc_cstring_to_double( var *arg1, char *source_file_id_txt ) 
		{
			char str[SMALL_STRING_BUFFER_SIZE];
			double num;
			
			var_check_s( arg1, source_file_id_txt );
			
			str_u32_to_u8( str, arg1->data.svalue, SMALL_STRING_BUFFER_SIZE );
			
			num = atof( str );
			
			return ( num );
		} 

		long double _calc_cstring_to_long_double( var *arg1, char *source_file_id_txt ) 
		{
			char str[SMALL_STRING_BUFFER_SIZE];
			long double num;
			
			var_check_s( arg1, source_file_id_txt );
			
			str_u32_to_u8( str, arg1->data.svalue, SMALL_STRING_BUFFER_SIZE );
			
			num = strtold( str, NULL );
			
			return ( num );
		} 

		char _calc_cstring_to_bool( var *arg1, char *source_file_id_txt ) 
		{
			char str[SMALL_STRING_BUFFER_SIZE];
			int stat;
			
			var_check_s( arg1, source_file_id_txt );
			
			str_u32_to_u8( str, arg1->data.svalue, MEDIUM_STRING_BUFFER_SIZE );
			
			if (strcmp( str, "true" ) == 0 || strcmp( str, "TRUE" ) == 0)
				stat = 1;
			else
				stat = 0;
				
			return ( (long int) stat );
		} 

		char *_calc_cstring_to_time( var *result, var *arg1, char *source_file_id_txt )
		{ 
			var_check_s( arg1, source_file_id_txt );
			
			if (arg1->storage_type == VAR_CONSTANT_STRING)
				_calcsys_var_set_s_u32( result, arg1->data.svalue, true, source_file_id_txt );
			else
				_calcsys_var_set_s_u32( result, arg1->data.svalue, false, source_file_id_txt );

			return ((char *) result);			
		}
		
		char *_calc_cstring_to_date( var *result, var *arg1, var *arg2, char *source_file_id_txt ) 
		{
			char str[SMALL_STRING_BUFFER_SIZE];
			char str1[MEDIUM_STRING_BUFFER_SIZE];
			char str2[MEDIUM_STRING_BUFFER_SIZE];
		
			var_check_s( arg1, source_file_id_txt );
			var_check_s( arg2, source_file_id_txt );
			
			str_u32_to_u8( str1, arg1->data.svalue, MEDIUM_STRING_BUFFER_SIZE );
			str_u32_to_u8( str2, arg2->data.svalue, MEDIUM_STRING_BUFFER_SIZE );
			
			if (strcmp( str2, "dd/mm/yyyy" ) != 00 &&
				strcmp( str2, "mm/dd/yyyy" ) != 00 &&
				strcmp( str2, "yyyy/mm/dd" ) != 00 &&
				strcmp( str2, "yyyy-mm-dd" ))
			{
//				sysfunc_error( $ic, $ic_ptr, "Date conversion error: type must be one of 'dd/mm/yyyy', 'mm/dd/yyyy', 'yyyy/mm/dd', 'yyyy-mm-dd'" );

				_calcsys_var_set_s( result, "0000-00-00", source_file_id_txt );
			}
			else
			if (strcmp( str2, "yyyy-mm-dd" ) == 0)
			{
				if (! check_date_valid( str1, "yyyy-mm-dd", source_file_id_txt ))
					runtime_error( source_file_id_txt, 1059, "Invalid date input", str1 );
				else
					_calcsys_var_set_s( result, str1, source_file_id_txt );
			}
			else
			{
				convert_date_to_yyyymmdd( str, str1, str2, source_file_id_txt );

				if (! check_date_valid( str, "yyyy-mm-dd", source_file_id_txt ))
					runtime_error( source_file_id_txt, 1060, "Invalid date input", str );
//				else
//					_calcsys_var_set_s( result, str1, source_file_id_txt );

				_calcsys_var_set_s( result, str, source_file_id_txt );
			}			

			return ((char *) result);			
		} 
		
		char *_calc_cstring_to_datetime( var *result, var *arg1, char *source_file_id_txt )
		{ 
			var_check_s( arg1, source_file_id_txt );
			
			if (arg1->storage_type == VAR_CONSTANT_STRING)
				_calcsys_var_set_s_u32( result, arg1->data.svalue, true, source_file_id_txt );
			else
				_calcsys_var_set_s_u32( result, arg1->data.svalue, false, source_file_id_txt );

			return ((char *) result);			
		}

		char *_calc_cstring_to_binary( var *result, var *arg1, char arg2, char *source_file_id_txt )
		{
			int_64 len2;
			char *ptr;
			int_64 i;
			char *bptr;
			char *ptr2;
		
			var_check_s( arg1, source_file_id_txt );

			len2 = *((int_64 *) (arg1->data.svalue));

			if (arg2 == true)
			{
				bptr = _malloc( len2 / 2 + sizeof( int_64 ) );
				ptr2 = _malloc( len2 + 1 );
				
				str_u32_to_u8( ptr2, arg1->data.svalue, len2 + 1 );
				
				hex_to_binary( bptr + sizeof( int_64 ), ptr2, source_file_id_txt );
				
				_free( ptr2 );
			}
			else
			{
				bptr = _malloc( len2 + sizeof( int_64 ) );
				
				memcpy( bptr + sizeof( int_64 ), arg1->data.svalue + sizeof( int_64 ), len2 );
			}
									
			free_curr_mem_1( (var *) result, source_file_id_txt );

			if (arg2 == true)
			{
				if (_calcsys_ascii_only)
					*((int_64 *) (bptr)) = len2 / 2;
				else
					*((int_64 *) (bptr)) = len2 / 8;
			}				
			else
				*((int_64 *) (bptr)) = len2;
										
			result->data.bvalue = bptr;

			result->var_type = VAR_BINARY;

			return ((char *) result);			
		}

/*
		long int _calc_cstring_to_byte( var *arg1, char *source_file_id_txt ) 
		{
			int_64 num;
			
			var_check_s( arg1, source_file_id_txt );

			if (*(arg1->data.svalue) == '\0')
				runtime_error( source_file_id_txt, 1061, "Empty string in cstring_to_byte()", "" );
			
			num = *(arg1->data.svalue) - '0';
			
			return ( num );
		} 
*/
/*
		char *_calc_cbyte_to_string( var *result, long int arg1, char *source_file_id_txt ) 
		{
			char str[SMALL_STRING_BUFFER_SIZE];
			
			if (arg1 < 0)
				runtime_error( source_file_id_txt, 1062, "Negative value in cbyte_to_string()", "" );
			
			if (arg1 > 255)
				runtime_error( source_file_id_txt, 1063, "Overflow in cbyte_to_string()", "" );
			
			str[0] = (char) (arg1 + '0');
			str[1] = '\0';
			
			_calcsys_var_set_s( result, str, source_file_id_txt );

			return ((char *) result);			
		} 
*/

		char *_calc_cdate_to_binary( var *result, var *arg1, char *source_file_id_txt )
		{
			int_64 len2;
			char *bptr;
		
			var_check_s( arg1, source_file_id_txt );

			len2 = *((int_64 *) (arg1->data.svalue));

			bptr = _malloc( len2 + sizeof( int_64 ) );
				
			memcpy( bptr + sizeof( int_64 ), arg1->data.svalue + sizeof( int_64 ), len2 );
									
			free_curr_mem_1( (var *) result, source_file_id_txt );

			*((int_64 *) (bptr)) = len2;
										
			result->data.bvalue = bptr;

			result->var_type = VAR_BINARY;

			return ((char *) result);			
		}

		char *_calc_ctime_to_binary( var *result, var *arg1, char *source_file_id_txt )
		{
			int_64 len2;
			char *bptr;
		
			var_check_s( arg1, source_file_id_txt );

			len2 = *((int_64 *) (arg1->data.svalue));

			bptr = _malloc( len2 + sizeof( int_64 ) );
				
			memcpy( bptr + sizeof( int_64 ), arg1->data.svalue + sizeof( int_64 ), len2 );
									
			free_curr_mem_1( (var *) result, source_file_id_txt );

			*((int_64 *) (bptr)) = len2;
										
			result->data.bvalue = bptr;

			result->var_type = VAR_BINARY;

			return ((char *) result);			
		}

		char *_calc_cdatetime_to_binary( var *result, var *arg1, char *source_file_id_txt )
		{
			int_64 len2;
			char *bptr;
		
			var_check_s( arg1, source_file_id_txt );

			len2 = *((int_64 *) (arg1->data.svalue));

			bptr = _malloc( len2 + sizeof( int_64 ) );
				
			memcpy( bptr + sizeof( int_64 ), arg1->data.svalue + sizeof( int_64 ), len2 );
									
			free_curr_mem_1( (var *) result, source_file_id_txt );

			*((int_64 *) (bptr)) = len2;
										
			result->data.bvalue = bptr;

			result->var_type = VAR_BINARY;
			
			return ((char *) result);			
		}


		char *_calc_cint_to_binary( var *result, long int arg1, char *source_file_id_txt )
		{ 
			char *bptr;
			int i;
 
			bptr = _malloc( 2 * sizeof( int_64 ) );

			free_curr_mem_1( (var *) result, source_file_id_txt );

			i = 1;

			if (*((char *) &i) == 1)			// little endian
			{
				for (i=0; i < sizeof( int_64 ); i++)
					*(bptr + sizeof( int_64 ) + i) = *(((char *) &(arg1)) + (sizeof( int_64 ) - 1 - i) );
			}
			else
			{
				for (i=0; i < sizeof( int_64 ); i++)
					*(bptr + sizeof( int_64 ) + i) = *(((char *) &(arg1)) + i);
			}			
			
			*((int_64 *) (bptr)) = sizeof( int_64 );
										
			result->data.bvalue = bptr;

			result->var_type = VAR_BINARY;

			return ((char *) result);			
		}

		char *_calc_cdecimal_to_binary( var *result, long int arg1, char *source_file_id_txt )
		{ 
			char *bptr;
			
			bptr = _malloc( 2 * sizeof( int_64 ) );
										
			free_curr_mem_1( (var *) result, source_file_id_txt );
												
//			if (result->var_type == VAR_STRING && result->data.svalue != NULL)
//				free( result->data.svalue );

//			if (result->var_type == VAR_BINARY && result->data.bvalue != NULL)
//				free( result->data.bvalue );

			memcpy( bptr + sizeof( int_64 ), &arg1, sizeof( int_64 ) );
			
			*((int_64 *) (bptr)) = sizeof( int_64 );
										
			result->data.bvalue = bptr;

			result->var_type = VAR_BINARY;

			return ((char *) result);			
		}

		char *_calc_cdouble_to_binary( var *result, double arg1, char *source_file_id_txt )
		{ 
			char *bptr;
			
			bptr = _malloc( sizeof( int_64 ) + sizeof( double ) );
							
			free_curr_mem_1( (var *) result, source_file_id_txt );
												
//			if (result->var_type == VAR_STRING && result->data.svalue != NULL)
//				free( result->data.svalue );

//			if (result->var_type == VAR_BINARY && result->data.bvalue != NULL)
//				free( result->data.bvalue );

			memcpy( bptr + sizeof( int_64 ), &(arg1), sizeof( double ) );
			
			*((int_64 *) (bptr)) = sizeof( double );
										
			result->data.bvalue = bptr;

			result->var_type = VAR_BINARY;

			return ((char *) result);			
		}


		char *_calc_cbinary_to_date( var *result, var *arg1, char *source_file_id_txt )
		{
			int_64 len;
			char str[MEDIUM_STRING_BUFFER_SIZE];
			char *ptr;
			
			if (arg1->var_type != VAR_BINARY)
				runtime_error( source_file_id_txt, 1058, "Variable is not a binary variable", "" );
			
			ptr = str;
			
			len = *((int_64 *) (arg1->data.bvalue));
				
			memcpy( ptr + sizeof( int_64 ), arg1->data.svalue + sizeof( int_64 ), len );

			*((int_64 *) ptr) = len;
									
			_calcsys_var_set_s_u32( result, ptr, false, source_file_id_txt );

			return ((char *) result);			
		}


		char *_calc_cbinary_to_time( var *result, var *arg1, char *source_file_id_txt )
		{
			int_64 len;
			char str[MEDIUM_STRING_BUFFER_SIZE];
			char *ptr;
			
			if (arg1->var_type != VAR_BINARY)
				runtime_error( source_file_id_txt, 1058, "Variable is not a binary variable", "" );
			
			ptr = str;
			
			len = *((int_64 *) (arg1->data.bvalue));
				
			memcpy( ptr + sizeof( int_64 ), arg1->data.svalue + sizeof( int_64 ), len );

			*((int_64 *) ptr) = len;
									
			_calcsys_var_set_s_u32( result, ptr, false, source_file_id_txt );

			return ((char *) result);			
		}


		char *_calc_cbinary_to_datetime( var *result, var *arg1, char *source_file_id_txt )
		{
			int_64 len;
			char str[MEDIUM_STRING_BUFFER_SIZE];
			char *ptr;
			
			if (arg1->var_type != VAR_BINARY)
				runtime_error( source_file_id_txt, 1058, "Variable is not a binary variable", "" );
			
			ptr = str;
			
			len = *((int_64 *) (arg1->data.bvalue));
				
			memcpy( ptr + sizeof( int_64 ), arg1->data.svalue + sizeof( int_64 ), len );

			*((int_64 *) ptr) = len;
									
			_calcsys_var_set_s_u32( result, ptr, false, source_file_id_txt );

			return ((char *) result);			
		}


		long int _calc_cbinary_to_int( var *arg1, char *source_file_id_txt )
		{
			char istr[20];
			int i;
			
			 if (arg1->var_type != VAR_BINARY)
				runtime_error( source_file_id_txt, 1064, "Variable is not a binary variable", "" );
			 
			i = 1;

			if (*((char *) &i) == 1)		// little endian
			{			 
				for (i=0; i < sizeof( int_64 ); i++)
					istr[i] = *(arg1->data.bvalue + sizeof( int_64 ) + (sizeof( int_64 ) - 1 - i));
			}
			else
			{
				for (i=0; i < sizeof( int_64 ); i++)
					istr[i] = *(arg1->data.bvalue + sizeof( int_64 ) + i);
			}
			
			return ( *((int_64 *) &istr) );
		}


		long int _calc_cbinary_to_decimal( var *arg1, char *source_file_id_txt )
		{
			 if (arg1->var_type != VAR_BINARY)
				runtime_error( source_file_id_txt, 1064, "Variable is not a binary variable", "" );
			 
			return ( *((int_64 *) (arg1->data.bvalue + sizeof( int_64 ))) );
		}


		double _calc_cbinary_to_double( var *arg1, char *source_file_id_txt )
		{
			 if (arg1->var_type != VAR_BINARY)
				runtime_error( source_file_id_txt, 1064, "Variable is not a binary variable", "" );
			 
			return ( *((double *) (arg1->data.bvalue + sizeof( int_64 ))) );
		}



//--------------------------------------------------------------------------
// Bit functions
//--------------------------------------------------------------------------

		long int _calc_bit_and( long int arg1, long int arg2, char *source_file_id_txt )
		{
			return ( arg1 & arg2 );
		}
				
		long int _calc_bit_or( long int arg1, long int arg2, char *source_file_id_txt )
		{
			return ( arg1 | arg2 );
		}
				
		long int _calc_bit_xor( long int arg1, long int arg2, char *source_file_id_txt )
		{
			return ( arg1 ^ arg2 );
		}
				
		long int _calc_bit_not( long int arg1, char *source_file_id_txt )
		{
			return ( ~ arg1 );
		}
				
		long int _calc_bit_shift_left( long int arg1, long int arg2, char *source_file_id_txt )
		{
			return ( arg1 << arg2 );
		}
				
		long int _calc_bit_shift_right( long int arg1, long int arg2, char *source_file_id_txt )
		{
			return ( arg1 >> arg2 );
		}
		
		char _calc_bit_is_set( long int arg1, long int arg2, char *source_file_id_txt )
		{
			int st;
			
			if ((arg1 & arg2) != 0)
				st = 1;
			else
				st = 0;
				
			return ( st );
		}
		

//ipost								// Make a POST request to a web page
//send SMS							// sends an SMS message

//--------------------------------------------------------------------------
// Misc
//--------------------------------------------------------------------------

		long int _calc_array_index_size( var *arg1, long int arg2, char *source_file_id_txt )
		{
			rarray *rarray_ptr;
			
			if (arg1->var_type != VAR_RESIZABLE_ARRAY)
					runtime_error( source_file_id_txt, 1065, "Parameter 1 to array_index_size must be a resizable array", "" );
			
			rarray_ptr = (rarray *) arg1->data.pvalue;

			if (arg2 < 1)
					runtime_error( source_file_id_txt, 1067, "Invalid index number in array_index_size", "" );

			if (arg2 > rarray_ptr->number_of_dimensions)
					runtime_error( source_file_id_txt, 1068, "Invalid index number in array_index_size", "" );

			return ( rarray_ptr->index_size[rarray_ptr->number_of_dimensions - arg2] );
		}


		long int _calc_array_number_of_dimensions( var *arg1, char *source_file_id_txt )
		{
			rarray *rarray_ptr;
			
			if (arg1->var_type != VAR_RESIZABLE_ARRAY)
					runtime_error( source_file_id_txt, 1069, "Parameter 1 to array_number_of_dimensions must be a resizable array", "" );
			
			rarray_ptr = (rarray *) arg1->data.pvalue;

			return ( rarray_ptr->number_of_dimensions );
		}
		
		
		int sort_compare_n_asc( const void *item1, const void *item2 )
		{
			int stat;
			
			if (((sort_item_n *) item1)->nvalue < ((sort_item_n *) item2)->nvalue)
				stat = -1;
			else
			if (((sort_item_n *) item1)->nvalue > ((sort_item_n *) item2)->nvalue)
				stat = 1;
			else
				stat = 0;
		
			return (stat);
		}

		int sort_compare_n_desc( const void *item1, const void *item2 )
		{
			int stat;
			
			if (((sort_item_n *) item1)->nvalue < ((sort_item_n *) item2)->nvalue)
				stat = 1;
			else
			if (((sort_item_n *) item1)->nvalue > ((sort_item_n *) item2)->nvalue)
				stat = -1;
			else
				stat = 0;
		
			return (stat);
		}

		int sort_compare_s_asc( const void *item1, const void *item2 )
		{
			int stat;
			
			if (item1 == NULL || item2 == NULL)
				stat = 0;
			else
				stat = strcmp( ((sort_item_s *) item1)->svalue, ((sort_item_s *) item2)->svalue );
		
			return (stat);
		}

		int sort_compare_s_desc( const void *item1, const void *item2 )
		{
			int stat;
			
			if (item1 == NULL || item2 == NULL)
				stat = 0;
			else
				stat = - strcmp( ((sort_item_s *) item1)->svalue, ((sort_item_s *) item2)->svalue );
		
			return (stat);
		}


		struct gsort_item
		{
			dyn_block *item1;
			dyn_block *item2;
			int compare_stat;
		};
		
		
		int sort_compare_g( const void *item1, const void *item2 )
		{
			int stat;
			struct gsort_item gs_item;
			dyn_block *ptr3, *ptr4;
			dyn_block db1, *ptr1;

			ptr3 = (void *) ((sort_item_p *) item1)->pvalue;
			ptr4 = (void *) ((sort_item_p *) item2)->pvalue;

/*			
			db3.data_ptr = (char *) ((dyn_block *) ptr3)->data_ptr;
			db3.status = 1;								// 1 = active, 2 = has been freed
			db3.block_size = sizeof( char * );
			db3.type_map = (char *) ((dyn_block *) ptr3)->type_map;

			db4.data_ptr = (char *) ((dyn_block *) ptr4)->data_ptr;
			db4.status = 1;								// 1 = active, 2 = has been freed
			db4.block_size = sizeof( char * );
			db4.type_map = (char *) ((dyn_block *) ptr4)->type_map;
*/

			gs_item.item1 = ptr3;
			gs_item.item2 = ptr4;
			
			db1.data_ptr = (char *) &gs_item;
			db1.status = 1;								// 1 = active, 2 = has been freed
			db1.block_size = sizeof( struct gsort_item );
			db1.type_map = "O<OQOQA>";
			
			ptr1 = &db1;
			
			if (item1 == NULL || item2 == NULL)
				stat = 0;
			else
			{
				(*_calcsys_function_table_ptr[_calcsys_sort_function_number])( (void *) &ptr1 );
				
				stat = gs_item.compare_stat;
			}
			
			return (stat);
		}

				
			// msort( resizable array of double num, resizable array of int keys, int number_of_elements, bool ascending );		// sort an array
		void _calc_msort( var *arg1, var *arg2, long int arg3, char arg4, char *source_file_id_txt )
		{
			int_64 i;
			int_64 num_items;
			int_64 array_len_in;
			int_64 array_len_out;
			rarray *ra_ptr_src;
			rarray *ra_ptr_dest;
			char *sp2;

			num_items = arg3;

			ra_ptr_src = (rarray *) arg1->data.pvalue;
			ra_ptr_dest = (rarray *) arg2->data.pvalue;
			
			if (arg1->var_type != VAR_RESIZABLE_ARRAY)
				runtime_error( source_file_id_txt, 1070, "Variable type is not a resizable array. Call setsize.", "" );

			if (arg2->var_type != VAR_RESIZABLE_ARRAY)
				runtime_error( source_file_id_txt, 1071, "Variable type is not a resizable array. Call setsize.", "" );
			
			array_len_in = ra_ptr_src->index_size[0];
			array_len_out = ra_ptr_dest->index_size[0];
	
			if (num_items < 0)
				runtime_error( source_file_id_txt, 1072, "The requested sort number of items is a negative number", "" );

			if (num_items > array_len_in)
				runtime_error( source_file_id_txt, 1073, "The requested sort exceeds the number of items in the input array", "" );

			if (num_items > array_len_out)
				runtime_error( source_file_id_txt, 1074, "The requested sort exceeds the number of items in the output array", "" );

		
			sort_items_n = _malloc( sizeof( sort_item_n ) * num_items );

		
			for (i=0; i < num_items; i++)
			{
				sort_items_n[i].input_array_key = i;
				sort_items_n[i].nvalue = *((double *) (ra_ptr_src->datap + i * sizeof( double )));
			}
			
			
			if (arg4 == 1)
				qsort( sort_items_n, num_items, sizeof( sort_item_n ), sort_compare_n_asc );
			else
				qsort( sort_items_n, num_items, sizeof( sort_item_n ), sort_compare_n_desc );
			
			
			for (i=0; i < num_items; i++)
				*((long int *) (ra_ptr_dest->datap + i * sizeof( long int ))) = sort_items_n[i].input_array_key; 
						
			_free( sort_items_n );
		}
				
		void _calc_ssort( var *arg1, var *arg2, long int arg3, char arg4, char *source_file_id_txt )
		{
			char str[MEDIUM_STRING_BUFFER_SIZE];
			int_64 i;
			int_64 num_items;
			int_64 array_len_in;
			int_64 array_len_out;
			rarray *ra_ptr_src;
			rarray *ra_ptr_dest;
			char *sp2;

			num_items = arg3;

			ra_ptr_src = (rarray *) arg1->data.pvalue;
			ra_ptr_dest = (rarray *) arg2->data.pvalue;

			if (arg1->var_type != VAR_RESIZABLE_ARRAY)
				runtime_error( source_file_id_txt, 1075, "Variable type is not a resizable array. Call setsize.", "" );

			if (arg2->var_type != VAR_RESIZABLE_ARRAY)
				runtime_error( source_file_id_txt, 1076, "Variable type is not a resizable array. Call setsize.", "" );
			
			array_len_in = ra_ptr_src->index_size[0];
			array_len_out = ra_ptr_dest->index_size[0];

			if (num_items < 0)
				runtime_error( source_file_id_txt, 1077, "The requested sort number of items is a negative number", "" );

			if (num_items > array_len_in)
				runtime_error( source_file_id_txt, 1078, "The requested sort exceeds the number of items in the input array", "" );

			if (num_items > array_len_out)
				runtime_error( source_file_id_txt, 1079, "The requested sort exceeds the number of items in the output array", "" );

			sort_items_s = _malloc( sizeof( sort_item_s ) * num_items );
		
			for (i=0; i < num_items; i++)
			{
				sort_items_s[i].input_array_key = i;

				str_u32_to_u8( str, ((var *) (ra_ptr_src->datap + i * sizeof( var )))->data.svalue, MEDIUM_STRING_BUFFER_SIZE );

				strncpy( sort_items_s[i].svalue, str, MAX_STR_SORT_SIGNIFICANT_CHARS );

				sort_items_s[i].svalue[MAX_STR_SORT_SIGNIFICANT_CHARS-1] = '\0';
			}
			
			if (arg4 == 1)
				qsort( sort_items_s, num_items, sizeof( sort_item_s ), sort_compare_s_asc );
			else
				qsort( sort_items_s, num_items, sizeof( sort_item_s ), sort_compare_s_desc );
			

			for (i=0; i < num_items; i++)
				*((long int *) (ra_ptr_dest->datap + i * sizeof( long int ))) = sort_items_s[i].input_array_key; 
				
			_free( sort_items_s );
		}

			// gsort( resizable array of double num, resizable array of int keys, int number_of_elements, string compare_function_name, bool ascending );		// sort an array
		void _calc_gsort( var *arg1, var *arg2, long int arg3, var *arg4, char *source_file_id_txt )
		{
			char compare_function_name[MEDIUM_STRING_BUFFER_SIZE];
			int_64 i;
			int_64 num_items;
			int_64 array_len_in;
			int_64 array_len_out;
			rarray *ra_ptr_src;
			rarray *ra_ptr_dest;
			char *sp2;

			var_check_s( arg4, source_file_id_txt );

			strcpy( compare_function_name, "_calc_" );

			str_u32_to_u8( &compare_function_name[6], arg4->data.svalue, MEDIUM_STRING_BUFFER_SIZE );

			_calcsys_sort_function_number = -1;

			for (i=0; i < _calcsys_num_function_table_items; i++)
			{
				if (strcmp( _calcsys_function_table_name[i], compare_function_name ) == 0)
					_calcsys_sort_function_number = i;
			}
	
			if (_calcsys_sort_function_number == -1)
				runtime_error( source_file_id_txt, 1104, "sort compare function not found, declare it with 'function_table'.", compare_function_name );

			num_items = arg3;

			ra_ptr_src = (rarray *) arg1->data.pvalue;
			ra_ptr_dest = (rarray *) arg2->data.pvalue;
			
			if (arg1->var_type != VAR_RESIZABLE_ARRAY)
				runtime_error( source_file_id_txt, 1070, "Variable type is not a resizable array. Call setsize.", "" );

			if (arg2->var_type != VAR_RESIZABLE_ARRAY)
				runtime_error( source_file_id_txt, 1071, "Variable type is not a resizable array. Call setsize.", "" );
			
			array_len_in = ra_ptr_src->index_size[0];
			array_len_out = ra_ptr_dest->index_size[0];
	
			if (num_items < 0)
				runtime_error( source_file_id_txt, 1072, "The requested sort number of items is a negative number", "" );

			if (num_items > array_len_in)
				runtime_error( source_file_id_txt, 1073, "The requested sort exceeds the number of items in the input array", "" );

			if (num_items > array_len_out)
				runtime_error( source_file_id_txt, 1074, "The requested sort exceeds the number of items in the output array", "" );

		
			sort_items_p = _malloc( sizeof( sort_item_p ) * num_items );

		
			for (i=0; i < num_items; i++)
			{
				sort_items_p[i].input_array_key = i;
				sort_items_p[i].pvalue = (char *) *((char **) (ra_ptr_src->datap + i * sizeof( char * )));
			}
			
			qsort( sort_items_p, num_items, sizeof( sort_item_p ), sort_compare_g );
			
			for (i=0; i < num_items; i++)
				*((long int *) (ra_ptr_dest->datap + i * sizeof( long int ))) = sort_items_p[i].input_array_key; 
						
			_free( sort_items_p );
		}

//--------------------------------------------------------------------------
// System
//--------------------------------------------------------------------------

				
		char *_calc_syget_get_parameter( var *result, var *arg1, char *source_file_id_txt )
		{
			char str[MEDIUM_STRING_BUFFER_SIZE];
			int i;
			int found;

			if (! is_web_page)
				runtime_error( source_file_id_txt, 1080, "Program must be compiled with the :is_web_page option to use syget_get_parameter()", "" );
			
			var_check_s( arg1, source_file_id_txt );
			
			found = false;
			
			str_u32_to_u8( str, arg1->data.svalue, MEDIUM_STRING_BUFFER_SIZE );
			
			for (i=0; i < num_get_items; i++)
			{
				if (strcmp( get_item_key[i], str ) == 0)
				{
					found = true;
					_calcsys_var_set_s( result, get_item_value[i], source_file_id_txt );
				}
			}
			
			if (! found)
				_calcsys_var_set_s( result, "", source_file_id_txt );

			return ((char *) result);			
		}
	
		long int _calc_syget_get_parameter_count( char *source_file_id_txt )
		{
			return ((long int) num_get_items);			
		}
	
		char *_calc_syget_get_parameter_key( var *result, long int arg1, char *source_file_id_txt )
		{
			if (! is_web_page)
				runtime_error( source_file_id_txt, 1080, "Program must be compiled with the :is_web_page option to use syget_get_parameter_key()", "" );

			if (arg1 < 0 || arg1 >= num_get_items)
			{
				runtime_error( source_file_id_txt, 1145, "Get number out of range", "" );
				_calcsys_var_set_s( result, "", source_file_id_txt );
			}
			else
				_calcsys_var_set_s( result, get_item_key[arg1], source_file_id_txt );

			return ((char *) result);			
		}


		char *_calc_syget_get_parameter_value( var *result, long int arg1, char *source_file_id_txt )
		{
			if (! is_web_page)
				runtime_error( source_file_id_txt, 1080, "Program must be compiled with the :is_web_page option to use syget_get_parameter_value()", "" );

			if (arg1 < 0 || arg1 >= num_get_items)
			{
				runtime_error( source_file_id_txt, 1146, "Get number out of range", "" );
				_calcsys_var_set_s( result, "", source_file_id_txt );
			}
			else
				_calcsys_var_set_s( result, get_item_value[arg1], source_file_id_txt );

			return ((char *) result);			
		}

				
		char *_calc_syget_post_parameter( var *result, var *arg1, char *source_file_id_txt )
		{
			int i;
			int found;
			char str[MEDIUM_STRING_BUFFER_SIZE];

			if (! is_web_page)
				runtime_error( source_file_id_txt, 1081, "Program must be compiled with the :is_web_page option to use syget_post_parameter()", "" );

			var_check_s( arg1, source_file_id_txt );
			
			found = false;
			
			str_u32_to_u8( str, arg1->data.svalue, MEDIUM_STRING_BUFFER_SIZE );
			
			for (i=0; i < num_post_items; i++)
			{
				if (strcmp( post_item_key[i], str ) == 0)
				{
					found = true;
					_calcsys_var_set_s( result, post_item_value[i], source_file_id_txt );
				}
			}
			
			if (! found)
				_calcsys_var_set_s( result, "", source_file_id_txt );
			
/* unchecked check boxes do not appear in the list
 			
			if (! found)
			{
				strcpy( str, arg1->data.svalue );
				strcat( str, ": get_and_post_filename: " );
				strcat( str, get_and_post_filename );
			
				runtime_error( source_file_id_txt, 1082, "POST parameter not found:", str);
			}
*/ 

			return ((char *) result);			
		}

	
		char *_calc_syget_post_parameter_key( var *result, long int arg1, char *source_file_id_txt )
		{
			if (! is_web_page)
				runtime_error( source_file_id_txt, 1080, "Program must be compiled with the :is_web_page option to use syget_post_parameter_key()", "" );

			if (arg1 < 0 || arg1 >= num_post_items)
			{
				runtime_error( source_file_id_txt, 1147, "Post number out of range", "" );
				_calcsys_var_set_s( result, "", source_file_id_txt );
			}
			else
				_calcsys_var_set_s( result, post_item_key[arg1], source_file_id_txt );

			return ((char *) result);			
		}


		char *_calc_syget_post_parameter_value( var *result, long int arg1, char *source_file_id_txt )
		{
			if (! is_web_page)
				runtime_error( source_file_id_txt, 1080, "Program must be compiled with the :is_web_page option to use syget_post_parameter_value()", "" );

			if (arg1 < 0 || arg1 >= num_post_items)
			{
				runtime_error( source_file_id_txt, 1148, "Post number out of range", "" );
				_calcsys_var_set_s( result, "", source_file_id_txt );
			}
			else
				_calcsys_var_set_s( result, post_item_value[arg1], source_file_id_txt );

			return ((char *) result);			
		}


		long int _calc_syget_post_parameter_count( char *source_file_id_txt )
		{
			return ((long int) num_post_items);			
		}

				
		char *_calc_syget_session_variable( var *result, var *arg1, var *arg2, char *source_file_id_txt )
		{
			char str[MEDIUM_STRING_BUFFER_SIZE];
			int i;
			int found;

			if (! is_web_page)
				runtime_error( source_file_id_txt, 1083, "Program must be compiled with the :is_web_page option to use syget_session_variable()", "" );

			var_check_s( arg1, source_file_id_txt );
			
			found = false;

			str_u32_to_u8( str, arg1->data.svalue, MEDIUM_STRING_BUFFER_SIZE );
			
			for (i=0; i < num_session_items; i++)
			{
				if (strcmp( session_item_key[i], str ) == 0)
				{
					found = true;
					_calcsys_var_set_s( result, session_item_value[i], source_file_id_txt );
				}
			}
			
			if (! found)
				_calcsys_var_set_s( result, "", source_file_id_txt );

			return ((char *) result);			
		}

		void _calc_syset_session_variable( var *varg1, var *varg2, var *arg3, char *source_file_id_txt )
		{
			int i;
			int found;
			char arg1[MEDIUM_STRING_BUFFER_SIZE];
			char arg2[MEDIUM_STRING_BUFFER_SIZE];

			if (! is_web_page)
				runtime_error( source_file_id_txt, 1084, "Program must be compiled with the :is_web_page option to use syget_set_session_variable()", "" );

			var_check_s( varg1, source_file_id_txt );
			var_check_s( varg2, source_file_id_txt );
			
			str_u32_to_u8( arg1, varg1->data.svalue, MEDIUM_STRING_BUFFER_SIZE );
			str_u32_to_u8( arg2, varg2->data.svalue, MEDIUM_STRING_BUFFER_SIZE );
			
			found = false;
			
			for (i=0; i < num_session_items; i++)
			{
				if (strcmp( session_item_key[i], arg1 ) == 0)
				{
					found = true;
					
					_free( session_item_value[i] );
					
					session_item_value[i] = _malloc( strlen( arg2 ) + 1 );
					
					strcpy( session_item_value[i], arg2 );
				}
			}
			
			if (num_session_items >= MAX_SESSION_ITEMS)
			{
				printf( "Too many session items\n" );
				exit(1);
			}
			
			if (! found)
			{
				session_item_key[num_session_items] = _malloc( strlen( arg1 ) + 1 );
			
				if (session_item_key[num_session_items][strlen(session_item_key[num_session_items])-1] == '\n')
					session_item_key[num_session_items][strlen(session_item_key[num_session_items])-1] = '\0';
					
				strcpy( session_item_key[num_session_items], arg1 );
				
				
				session_item_value[num_session_items] = _malloc( strlen( arg2 ) + 1 );

				if (session_item_value[num_session_items][strlen(session_item_value[num_session_items])-1] == '\n')
					session_item_value[num_session_items][strlen(session_item_value[num_session_items])-1] = '\0';
					
				strcpy( session_item_value[num_session_items], arg2 );

				num_session_items++;
			}
		}
		
				
		char *_calc_syget_ip_address( var *result, char *source_file_id_txt )
		{
			_calcsys_var_set_s( result, ip_address, source_file_id_txt );

			return ((char *) result);			
		}

				
		char _calc_sylow_res_screen( char *source_file_id_txt )
		{
			if (low_res_screen)
				return ( 1 );
			else
				return ( 0 );
		}

		void _calc_syset_process_background_priority( char *source_file_id_txt )
		{
			nice( 8 );
		}
				
				
		void _calc_syexit( long int arg1, char *source_file_id_txt )
		{
			calc_stdlib_exit( get_and_post_filename );
		
			if (memory_report)
			{
				printf( "Stack size (bytes): %ld\n", stack_size );
				
				printf( "Peak stack usage (bytes): %ld\n", peak_stack_usage );
				
				printf( "Peak bytes dynamic memory allocated: %ld\n", peak_bytes_malloced );
			}
			
			exit( arg1 );
		}

	char *sleft( char *dest, char const *src, int_64 len )
	{
		if (len <= 0)
			*dest = '\0';
		else
		{
			strncpy( dest, src, len );
		
			dest[len] = '\0';
		}
		
		return (dest);
	}
	
				
	char *sright( char *dest, char const *src, int_64 len )
	{			
		if (len <= 0)
			*dest = '\0';
		else
		{		
			if (len >= strlen( src ))
				strcpy( dest, src );
			else
				strcpy( dest, &src[strlen( src ) - len] );
		}
		
		return (dest);
	}
				
	char *smid( char *dest, char const *src, int_64 start, int_64 len )
	{
		if (start < 0 || len <= 0 || start >= strlen( src ))
			*dest = '\0';
		else
		{ 
			strncpy( dest, &(src[start]), len ); 

			dest[len] = '\0';
		}
		
		return (dest);
	}	

	void dec_to_hex( char *dest, unsigned char *src, int_64 num_bytes, int asc, int pad_with_leading_zeros )
	{
		int i, j;
		unsigned char ch;
		unsigned char high_nibble;
		unsigned char low_nibble;
		char *ptr;
		
		j=0;
		
		if (asc)
		{
			for (i=0; i < num_bytes; i++)
			{
				ch = src[i];
				
				high_nibble = ch / 16;
				
				low_nibble = ch - high_nibble * 16;
				 
				dest[j++] = dec_to_hex_1_nibble( high_nibble ); 
				
				dest[j++] = dec_to_hex_1_nibble( low_nibble );
			}
		}
		else
		{
			for (i=num_bytes-1;  i >= 0; i--)
			{
				ch = src[i];
				
				high_nibble = ch / 16;
				
				low_nibble = ch - high_nibble * 16;
				 
				dest[j++] = dec_to_hex_1_nibble( high_nibble ); 
				
				dest[j++] = dec_to_hex_1_nibble( low_nibble );
			}
		}
		
		dest[j] = '\0';
		
			// trunc leading 0's
			
		if (! pad_with_leading_zeros)
		{
			for (ptr=dest; *ptr == '0'; ptr++) ;
			
			if (*ptr == '\0')
				strcpy( dest, "0" );
			else
				strcpy( dest, ptr );
		}			
	}
	
	
	void hex_to_binary( unsigned char *dest, char *src, char *source_file_id_txt )
	{
		int_64 i, j;
		
		if (strlen( src ) % 2 == 1)
			runtime_error( source_file_id_txt, 1085, "Text string must be a multiple of 2 in length", "" );
		
		j=0;
		
		for (i=0; i < strlen( src ); i += 2)
			dest[j++] = hex_to_dec_1_char(src[i]) * 16 + hex_to_dec_1_char(src[i+1]);
	}
	

	int_64 hex_to_int( char *src, char *source_file_id_txt )
	{
		int_64 i;
		int_64 result;
		int_64 multiplier;
		
		result = 0;
		multiplier = 1;
		
		for (i = strlen( src )-1; i >= 0; i--)
		{
			result += multiplier * hex_to_dec_1_char( src[i] );
			multiplier *= 16;
		}
		
		return (result);
	}


	unsigned char dec_to_hex_1_nibble( unsigned char i )
	{
		unsigned char dest;
		
		dest = 0;
		
		if (i == 0)				dest = '0';		else		
		if (i == 1)				dest = '1';		else		
		if (i == 2)				dest = '2';		else		
		if (i == 3)				dest = '3';		else		
		if (i == 4)				dest = '4';		else		
		if (i == 5)				dest = '5';		else		
		if (i == 6)				dest = '6';		else		
		if (i == 7)				dest = '7';		else		
		if (i == 8)				dest = '8';		else		
		if (i == 9)				dest = '9';		else		
		if (i == 10)			dest = 'A';		else
		if (i == 11)			dest = 'B';		else
		if (i == 12)			dest = 'C';		else
		if (i == 13)			dest = 'D';		else
		if (i == 14)			dest = 'E';		else
		if (i == 15)			dest = 'F';
	
		return (dest);
	}


	unsigned char hex_to_dec_1_char( char ch )
	{
		unsigned char dest;
	
		dest = 0;
		
		ch = toupper( ch );
		
		if (ch == '0')			dest = 0;		else
		if (ch == '1')			dest = 1;		else
		if (ch == '2')			dest = 2;		else
		if (ch == '3')			dest = 3;		else
		if (ch == '4')			dest = 4;		else
		if (ch == '5')			dest = 5;		else
		if (ch == '6')			dest = 6;		else
		if (ch == '7')			dest = 7;		else
		if (ch == '8')			dest = 8;		else
		if (ch == '9')			dest = 9;		else
		if (ch == 'A')			dest = 10;		else
		if (ch == 'B')			dest = 11;		else
		if (ch == 'C')			dest = 12;		else
		if (ch == 'D')			dest = 13;		else
		if (ch == 'E')			dest = 14;		else
		if (ch == 'F')			dest = 15;
			
		return (dest);
	}
	
	
	void convert_date_to_yyyymmdd( char *dt, char *this_date, char *date_format, char *source_file_id_txt )
	{
		int i, j;
		char *day, *month, *year;
		char parts[3][SMALL_STRING_BUFFER_SIZE];
		char str[SMALL_STRING_BUFFER_SIZE];

		if (*this_date == '\0')
			runtime_error( source_file_id_txt, 1088, "Blank date.", "" );
		else
		{
			j = 0;
	
			parts[0][0] = '\0';
			parts[1][0] = '\0';
			parts[2][0] = '\0';
	
			for (i=0; i < strlen(this_date) && j <= 2; i++)
			{
				if (is_digit( this_date[i] ))
				{
					str[0] = this_date[i];
					str[1] = '\0';
					
					strcat( &parts[j][0], str );
				}
				else
					j = j + 1;
			}
	
	        if (*date_format == '\0')
	        {
	            strcpy( dt, "0000-00-00" );
	        }
	        else
			if (strcmp( date_format, "dd/mm/yyyy" ) == 0)
			{
				day = &parts[0][0];
				month = &parts[1][0];
				year = &parts[2][0];
			}
			else
			if (strcmp( date_format, "mm/dd/yyyy" ) == 0)
			{
				month = &parts[0][0];
				day = &parts[1][0];
				year = &parts[2][0];
			}
			else
			if (strcmp( date_format, "yyyy/mm/dd" ) == 0)
			{
				year = &parts[0][0];
				month = &parts[1][0];
				day = &parts[2][0];
			}
			else
				runtime_error( source_file_id_txt, 1086, "Invalid date format", date_format );
	
			if (strlen( day ) == 1)
			{
				str[0] = '0';
				str[1] = '\0';
				
				strcat( str, day );
				strcpy( day, str );
			}
			
			if (strlen( month ) == 1)
			{
				str[0] = '0';
				str[1] = '\0';
				
				strcat( str, month );
				strcpy( month, str );
			}
	
			
			if (strlen( year) == 2)
			{
				if (atoi( year ) < 50)
				{
					str[0] = '2';
					str[1] = '0';
					str[2] = '\0';
				}
				else
				{
					str[0] = '1';
					str[1] = '9';
					str[2] = '\0';
				}
				
				strcat( str, year );
				strcpy( year, str );
			}
		
	
	//        if ((! is_numeric( $day )) || (! is_numeric( $month )) || (! is_numeric( $year )))
	//            return ("0000-00-00");
	//        else
	
			strcpy( dt, year );
			strcat( dt, "-" );
			strcat( dt, month );
			strcat( dt, "-" );
			strcat( dt, day );
			
			if (! check_date_valid( dt, "yyyy-mm-dd", source_file_id_txt ))
				runtime_error( source_file_id_txt, 1087, "Invalid date.", dt );
		}
	}


	int last_day_of_the_month( int year, int month )
	{
		int result;
		
		if (month == 2)
		{
			if (is_leap_year( year ))
				result = 29;
			else
				result = 28;
		}
		else
		if (month == 4 ||
			month == 6 ||
			month == 9 ||
			month == 11)
				result = 30;
		else
			result = 31;
			
		return (result);
	}

	
		// returns true for date ok and false if a date is invalid.
		
	int check_date_valid( char const *date_text2, char const *format, char const *source_file_id_txt )
	{
        char day_text[SMALL_STRING_BUFFER_SIZE];
        char month_text[SMALL_STRING_BUFFER_SIZE];
        char year_text[SMALL_STRING_BUFFER_SIZE];
		int iday;
		int imonth;
		int iyear;
		int ok;
	
	    if (strlen( date_text2 ) != 10 || strcmp( date_text2, "0000-00-00" ) == 0)
			ok =  false;
        else
        {
			if (strcmp( format, "yyyy-mm-dd" ) == 0 || strcmp( format, "yyyy/mm/dd" ) == 0)
			{
	            smid( day_text, date_text2, 8, 2 );
	            smid( month_text, date_text2, 5, 2 );
	            smid( year_text, date_text2, 0, 4 );
			}
			else
			if (strcmp( format, "dd/mm/yyyy" ) == 0)
			{
	            smid( day_text, date_text2, 0, 2 );
	            smid( month_text, date_text2, 3, 2 );
	            smid( year_text, date_text2, 6, 4 );
			}
			else
			if (strcmp( format, "mm/dd/yyyy" ) == 0)
			{
	            smid( day_text, date_text2, 3, 2 );
	            smid( month_text, date_text2, 0, 2 );
	            smid( year_text, date_text2, 6, 4 );
			}
			else
				runtime_error( source_file_id_txt, 1105, "Invalid date format in check_date_valid()", format );
			
			ok = true;
		
            if ((! is_digit( day_text[0] ))   ||
                (! is_digit( day_text[1] ))   ||
                (! is_digit( month_text[0] )) ||
                (! is_digit( month_text[1] )) ||
                (! is_digit( year_text[0] ))  ||
                (! is_digit( year_text[1] ))  ||
                (! is_digit( year_text[2] ))  ||
                (! is_digit( year_text[3] )))
    			ok =  false;
            else
            {
				iday = atoi( day_text );
				imonth = atoi( month_text );
				iyear = atoi( year_text );
                        
	            if (imonth == 0 || imonth > 12 || iday == 0)
	    			ok =  false;
	            else
	            {
	            	switch (imonth)
	            	{
	            		case 1:
	            		
	                		if (iday > 31)
	        					ok =  false;
	        				break;

	            		case 2:
	        				
			                if (is_leap_year( iyear ) && iday > 29 )
			        			ok =  false;
			        		else
			                if ((! is_leap_year( iyear )) && iday > 28 )
			        			ok =  false;
							break;
							
	            		case 3:

	                		if (iday > 31)
	        					ok =  false;
	        				break;

	            		case 4:

	                		if (iday > 30)
	        					ok =  false;
	        				break;
	        		
	            		case 5:

	                		if (iday > 31)
	        					ok =  false;
	        				break;
	        		
	            		case 6:

	                		if (iday > 30)
	        					ok =  false;
	        				break;
	        		
	            		case 7:

	                		if (iday > 31)
	        					ok =  false;
	        				break;
	        		
	            		case 8:

	                		if (iday > 31)
	        					ok =  false;
	        				break;
	        		
	            		case 9:

	                		if (iday > 30)
	        					ok =  false;
	        				break;
	        		
	            		case 10:

	                		if (iday > 31)
	        					ok =  false;
	        				break;
	        		
	            		case 11:

	                		if (iday > 30)
	        					ok =  false;
	        				break;
	        		
	            		case 12:

	                		if (iday > 31)
	        					ok =  false;
	        				break;
			    	}			    		
	        	}
	    	}
        }

		return (ok);
	}

		// returns true for time ok and false if a date is invalid. HH:MM:SS format.
		
	int check_time_valid( char const *time_text )
	{
		char str4[SMALL_STRING_BUFFER_SIZE];
		int ok;
		int hour, minute, seconds;
		
		ok = true;
		
	    if ((! is_digit( time_text[0] ))   ||
            (! is_digit( time_text[1] ))   ||
            (! is_digit( time_text[3] )) ||
            (! is_digit( time_text[4] )) ||
            (! is_digit( time_text[6] ))  ||
            (! is_digit( time_text[7] )))
				ok = false;

	    if (time_text[2] != ':')
			ok = false;

	    if (time_text[5] != ':')
			ok = false;
				
		if (ok)
		{
			hour = atoi( sleft( str4, time_text, 2 ) );
			minute = atoi( smid( str4, time_text, 3, 2 ) );
			seconds = atoi( sright( str4, time_text, 2 ) );
			 
			if (hour > 23 || minute > 59 || seconds > 59)
				ok = false;
		}
		
		return (ok);
	}


	int check_datetime_valid( char const *datetime_text, char const *source_file_id_txt )
	{
		int ok;
		char date_txt[SMALL_STRING_BUFFER_SIZE];
		char time_txt[SMALL_STRING_BUFFER_SIZE];
		
		ok = true;
		
		if (strlen( datetime_text ) != 19)
			ok = false;
		else
		{
			if (datetime_text[10] != ' ')
				ok = false;
			else
			{
				sleft( date_txt, datetime_text, 10 );
				sright( time_txt, datetime_text, 8 );
				
				if ((! check_date_valid( date_txt, "yyyy-mm-dd", source_file_id_txt )) || (! check_time_valid( time_txt )))
					ok = false;
			}
		}
		
		return (ok);
	}
					

	int is_digit( char ch )
	{
	    int stat;
	    
	    if (ch >= '0' && ch <= '9')
	        stat = true;
	    else
	        stat = false;
	        
		return (stat);
	}
	
	
    int is_leap_year( int year )
    {
    	int leap_year;
    	
        leap_year = false;
        
        if ((year / 4) == ((double) year / 4))
            leap_year = true;

        if ((year / 100) == ((double) year / 100))
            leap_year = false;
            
        if ((year / 400)  == ((double) year / 400))
            leap_year = true;
    
        return (leap_year);
    }


	
		// input date YYYY-MM-DD
		
		// Days since January 1 4713 BC
		
	long convert_date_to_julian( char *this_date, char *source_file_id_txt )
	{
		char day_text[SMALL_STRING_BUFFER_SIZE];
		char month_text[SMALL_STRING_BUFFER_SIZE];
		char year_text[SMALL_STRING_BUFFER_SIZE];
		double day, month, year;
		long julian_date;
		
		if (check_date_valid( this_date, "yyyy-mm-dd", source_file_id_txt ))
		{
			sright( day_text, this_date, 2 );
			smid( month_text, this_date, 5, 2 );
			sleft( year_text, this_date, 4 );
			
			day = atoi( day_text );
			month = atoi( month_text );
			year = atoi( year_text );
			
			julian_date = jtrunc(1461 * (year + 4800 + jtrunc((month - 14)/12))/4) + jtrunc((367 * (jtrunc((month - 2 - 12 * jtrunc((month - 14)/12)))/12)) ) - jtrunc((3 * ((year + 4900 + jtrunc((month - 14)/12))/100))/4) + day - 32075;
		}
		else
			runtime_error( source_file_id_txt, 1088, "Invalid date text in convert_date_to_julian()", this_date );
				
		return (julian_date);
	}

		// output date YYYY-MM-DD
		
	void convert_julian_to_date( char *str, long J )
	{
		double y, j, r, v, u, w, B, C, f, g;
		int h, s, n, m, e, p;
		
		int day;
		int month;
		int year;
	
		y = (double) 4716;	
		j = (double) 1401;	
		m = (double) 2;
		n = (double) 12;	
		r = (double) 4;	
		p = (double) 1461;	
		v = (double) 3;
		u = (double) 5;
		s = (double) 153;
		w = (double) 2;
		B = (double) 274277;
		C = (double) -38;

		f = J + j + jtrunc((jtrunc((4 * J + B) / 146097) * 3) / 4) + C;
		e = r * f + v;
		g = jtrunc( (e % p) / r );
		h = u * g + w;
		
		day = jtrunc((h % s) / u) + 1;
		month = ((int) (jtrunc(h / s) + m) % n) + 1;
		year = jtrunc(e / p) - y + jtrunc((n + m - month) / n);
		
		sprintf( str, "%04d-%02d-%02d", year, month, day );
	}
	
			// 0 = Sunday
			
	int jweekday( long julian_date )
	{
		return ((julian_date + 1) % 7);	
	}
	
		// truncate towards 0
		
	double jtrunc( double num )
	{
		double num2;
		
		if (num >= 0)
			num2 = floor( num );
		else
			num2 = ceil( num );
		
		return (num2);	
	}


	double max( double num1, double num2 )
	{
		double num3;
		
		if (num1 > num2)
			num3 = num1;
		else
			num3 = num2;
			
		return (num3);
	}	


	void setup_get_and_post_arrays( char *get_and_post_filename )
	{
	    char str[MAX_POST_ITEM_SIZE];
	    char str2[MAX_POST_ITEM_SIZE];
	    char base[MEDIUM_STRING_BUFFER_SIZE];
	    char filename[MEDIUM_STRING_BUFFER_SIZE];
	    FILE *fp;
	    char *ptr;

		num_get_items = 0;
		
		num_post_items = 0;
	    
	    num_session_items = 0;
	    
	    fp = fopen( get_and_post_filename, "r" );
	    
	    if (fp == NULL)
	    {
	    	printf( "\nCan't open get_and_post file: %s\n\n", get_and_post_filename );
			exit(1);
	    }

	    while (! feof( fp ))
	    {
	    	fgets( str, MAX_POST_ITEM_SIZE, fp );
	    	
	    	str[strlen(str)-1] = '\0';

	    	if (strcmp( str, "IP_ADDRESS" ) == 0)
	    	{
		    	fgets( ip_address, MAX_POST_KEY_SIZE, fp );
		    	
		    	ip_address[strlen(ip_address)-1] = '\0';
	    	}
	    	else
	    	if (strcmp( str, "LOW_RES_SCREEN" ) == 0)
	    	{
		    	fgets( str, MAX_POST_KEY_SIZE, fp );
		    	str[strlen(str)-1] = '\0';
		    	
		    	if (strcmp( str, "1" ) == 0)
		    		low_res_screen = true;
		    	else
		    		low_res_screen = false;
	    	}
	    	else
	    	if (strcmp( str, "POST" ) == 0)
			{	    	
		    	fgets( str, MAX_POST_KEY_SIZE, fp );
		    	str[strlen(str)-1] = '\0';
	    		strncpy( post_item_key[num_post_items], str, MAX_POST_KEY_SIZE );
	    		post_item_key[num_post_items][MAX_POST_KEY_SIZE] = '\0';

		    	fgets( str, MAX_POST_ITEM_SIZE, fp );
		    	str[strlen(str)-1] = '\0';

		    	str_replace( str2, str, "\\n", "\n" );
		    	
		    	post_item_value[num_post_items] = _malloc( strlen(str2) + 1 ); 

	    		strcpy( post_item_value[num_post_items], str2 );
	    		
	    		num_post_items++;
	    	}
	    	else
	    	if (strcmp( str, "SESSION" ) == 0)
			{	    	
		    	fgets( str, MAX_SESSION_KEY_SIZE, fp );
		    	
				session_item_key[num_session_items] = _malloc( strlen( str ) + 1 );
		    	
	    		strcpy( session_item_key[num_session_items], str );

		    	fgets( str, MAX_SESSION_ITEM_SIZE, fp );
		    	
		    	str_replace( str2, str, "\\n", "\n" );
		    	
		    	session_item_value[num_session_items] = _malloc( strlen(str2) + 1 ); 

	    		strcpy( session_item_value[num_session_items], str2 );
	    		
				if (session_item_key[num_session_items][strlen(session_item_key[num_session_items])-1] == '\n')
					session_item_key[num_session_items][strlen(session_item_key[num_session_items])-1] = '\0';
					
				if (session_item_value[num_session_items][strlen(session_item_value[num_session_items])-1] == '\n')
					session_item_value[num_session_items][strlen(session_item_value[num_session_items])-1] = '\0';
	    		
	    		num_session_items++;
	    	}
	    	else
	    	if (strcmp( str, "GET" ) == 0)
			{	    	
		    	fgets( str, MAX_GET_KEY_SIZE, fp );
		    	str[strlen(str)-1] = '\0';
	    		strncpy( get_item_key[num_get_items], str, MAX_GET_KEY_SIZE );
	    		get_item_key[num_get_items][MAX_GET_KEY_SIZE] = '\0';

		    	fgets( str, MAX_GET_ITEM_SIZE, fp );
		    	str[strlen(str)-1] = '\0';
	    		strncpy( get_item_value[num_get_items], str, MAX_GET_ITEM_SIZE );
	    		get_item_value[num_get_items][MAX_GET_ITEM_SIZE] = '\0';
	    		
	    		num_get_items++;
	    	}
	    }
	    
	    fclose( fp );
	}		


	void str_replace( char *dest, char *src, char *search, char *replace )
	{
		char *ptr1;
		char *ptr2;
		int_64 len;
		
		ptr1 = src;
		ptr2 = dest;
		len = strlen( search );
		
		*ptr2 = '\0';
		
		while (*ptr1 != '\0')
		{
			if (strncmp( ptr1, search, len ) == 0)
			{
				strcat( ptr2, replace );
				
				ptr2 += strlen( replace );
				
				ptr1 += strlen( search );
			}
			else
			{
				*ptr2++ = *ptr1++;
			}
			
			*ptr2 = '\0';
		}
		
		*ptr2 = '\0';		
	}


	int_64 str_search( char *src, char *search )
	{
		char *ptr1;
		int_64 len;
		int_64 pos;
		
		pos = -1;
		
		ptr1 = src;
		
		len = strlen( search );
		
		while (*ptr1 != '\0' && pos == -1)
		{
			if (strncmp( ptr1, search, len ) == 0)
				pos = ptr1 - src;
			else
				ptr1++;
		}
		
		return (pos);		
	}

	int_64 str_rsearch( char *src, char *search )
	{
		char *ptr1;
		int len;
		int pos;
		
		pos = -1;
		
		len = strlen( search );
		
		if (len > 0)
		{ 
			ptr1 = src + strlen( src ) - 1;
			
			while (ptr1 >= src && pos == -1)
			{
				if (strncmp( ptr1, search, len ) == 0)
					pos = ptr1 - src;
				else
					ptr1--;
			}
		}
				
		return (pos);		
	}


//	function sysfunc_error( $ic, $ic_ptr, $text )
//	{
//		echo "Runtime error system functions: Line ".$ic[$ic_ptr]['line_number'].": ".$ic[$ic_ptr]['input_filename'].": ".$text."<br>";
//
//			var_set_n( result, 31, source_file_id_txt );
//	}


