//
// (c) Mark McIlroy June 2022. Author of the design of the Bitstream Tree.
//
//

extern "C" bst_tree *c_bst_init2( int options );
extern "C" int c_bst_insert( bst_tree *tree_nptr, char const *key_bits, int num_key_bytes, void *data_ptr );
extern "C" bst_tree_node *c_bst_search( bst_tree *tree_nptr, char const *key_bits, int num_key_bytes, int *found );
extern "C" int c_bst_key_is_in_tree( bst_tree *tree_nptr, char const *key_bits, int num_key_bytes );
extern "C" int c_bst_delete_item( bst_tree *tree_nptr, char const *key_bits, int num_key_bytes );
extern "C" bst_tree_node *c_bst_scan( bst_tree_node *bst_nptr, bst_tree_node *curr_nptr );
extern "C" bst_tree_node *c_bst_free( bst_tree *bst_nptr );
extern "C" bst_tree_node *c_bst_tree_first_item( bst_tree *bst_nptr, int ascending, char *source_file_id_txt );
extern "C" bst_tree_node *c_bst_tree_next_item( bst_tree_node *bst_nptr, int ascending );



#define MAX_KEY_LEN 10000



char *_ci_calc_c_bst_init( long int var_arg1, char *source_file_id_txt )
{
	dyn_block *ptr;
	
	ptr = (dyn_block *) new dyn_block;
	
	ptr->status = 1;
	ptr->block_size = 1;
	ptr->type_map = "";
	
	ptr->data_ptr = (char *) c_bst_init2( var_arg1 );
	
	return ((char *) ptr);
					
//	return ((char *) c_bst_init2( var_arg1 ); 
}


char *_ci_calc_bst_get_key( ci_var *result, ci_var *var_arg1, char *source_file_id_txt )
{
	if (var_arg1 == NULL)
	{
		printf( "NULL node ptr in bst_get_key()\n" );
		exit( 1 );
	}

	ci_var_set_b_2( result, ((bst_tree_node *) (var_arg1))->key_bits, ((bst_tree_node *) (var_arg1))->num_key_bytes );
	
	return ((char *) result);
}


char *_ci_calc_bst_get_data_ptr( char *var_arg1, char *source_file_id_txt )
{
	if (var_arg1 == NULL)
	{
		printf( "NULL node ptr in bst_get_data_ptr()\n" );
		exit( 1 );
	}
	
	return ((char *) ((bst_tree_node *) var_arg1)->data_ptr);
}

long int _ci_calc_bst_insert_b( char *var_arg1, ci_var *var_arg2, char *var_arg3, char *source_file_id_txt )
{
	int len;
	char key[MAX_KEY_LEN];
	char *ptr;
	bst_tree *bst;
	
	if (var_arg1 == NULL)
	{
		printf( "NULL tree in bst_insert_bkey()\n" );
		exit( 1 );
	}

	if (var_arg2->data.bvalue == NULL)
	{
		printf( "NULL key in bst_insert_bkey\n" );
		exit( 1 );
	}
	
	len = (int) *((int_64 *) var_arg2->data.bvalue);
	
	ptr = (char *) var_arg2->data.bvalue + sizeof( int_64 );
	
	return (c_bst_insert( (bst_tree *) ((dyn_block *) var_arg1)->data_ptr, ptr, len, var_arg3 ));
}


long int _ci_calc_bst_insert_s( char *var_arg1, ci_var *var_arg2, char *var_arg3, char *source_file_id_txt )
{
	int len;
	char key[MAX_KEY_LEN];
	char *ptr;
	bst_tree *bst;
	
	if (var_arg1 == NULL)
	{
		printf( "NULL tree in bst_insert_s()\n" );
		exit( 1 );
	}

	if (var_arg2->data.bvalue == NULL)
	{
		printf( "NULL key in bst_insert_s\n" );
		exit( 1 );
	}
	
	len = (int) *((int_64 *) var_arg2->data.svalue);
	
	ptr = var_arg2->data.svalue + sizeof( int_64 );
	
	return (c_bst_insert( (bst_tree *) ((dyn_block *) var_arg1)->data_ptr, ptr, len, var_arg3 ));
}



long int _ci_calc_bst_insert_i( char *var_arg1, long int var_arg2, char *var_arg3, char *source_file_id_txt )
{
	bst_tree *bst;
	
	if (var_arg1 == NULL)
	{
		printf( "NULL tree in bst_insert_i()\n" );
		exit( 1 );
	}
	
	return (c_bst_insert( (bst_tree *) ((dyn_block *) var_arg1)->data_ptr, (const char *) &var_arg2, sizeof( long int ), var_arg3 ));
}



char *_ci_calc_bst_search_b( char *var_arg1, ci_var *var_arg2, long int *var_arg3, char *source_file_id_txt )
{
	int found;
	int len;
	char key[MAX_KEY_LEN];
	char *ptr;

	if (var_arg1 == NULL)
	{
		printf( "NULL tree in bst_search_b()\n" );
		exit( 1 );
	}
	
	if (var_arg2->data.bvalue == NULL)
	{
		printf( "NULL key in bst_search_b()\n" );
		exit( 1 );
	}
	
	len = *((int_64 *) var_arg2->data.bvalue);
		
	ptr = (char *) var_arg2->data.bvalue + sizeof( int_64 );
		

	ptr = (char *) c_bst_search( (bst_tree *) ((dyn_block *) var_arg1)->data_ptr, ptr, len, &found );
	
	*var_arg3 = found;
	
	return ((char *) ptr);
}


char *_ci_calc_bst_search_s( char *var_arg1, ci_var *var_arg2, long int *var_arg3, char *source_file_id_txt )
{
	int found;
	int len;
	char key[MAX_KEY_LEN];
	char *ptr;

	if (var_arg1 == NULL)
	{
		printf( "NULL tree in bst_search_s()\n" );
		exit( 1 );
	}
	
	if (var_arg2->data.bvalue == NULL)
	{
		printf( "NULL key in bst_search_s()\n" );
		exit( 1 );
	}
	
	len = *((int_64 *) var_arg2->data.svalue);
		
	ptr = var_arg2->data.svalue + sizeof( int_64 );

	ptr = (char *) c_bst_search( (bst_tree *) ((dyn_block *) var_arg1)->data_ptr, ptr, len, &found );
	
	*var_arg3 = found;
	
	return ((char *) ptr);
}


char *_ci_calc_bst_search_i( char *var_arg1, long int var_arg2, long int *var_arg3, char *source_file_id_txt )
{
	int found;
	char *ptr;

	if (var_arg1 == NULL)
	{
		printf( "NULL tree in bst_search_s()\n" );
		exit( 1 );
	}

	ptr = (char *) c_bst_search( (bst_tree *) ((dyn_block *) var_arg1)->data_ptr, (const char *) &var_arg2, sizeof( long int ), &found );
	
	*var_arg3 = found;
	
	return ((char *) ptr);
}



char _ci_calc_bst_key_is_in_tree_b( char *var_arg1, ci_var *var_arg2, char *source_file_id_txt )
{
	int len;

	if (var_arg1 == NULL)
	{
		printf( "NULL tree in bst_key_is_in_tree_b()\n" );
		exit( 1 );
	}
	
	if (var_arg2->data.bvalue == NULL)
	{
		printf( "NULL key in bst_key_is_in_tree_b()\n" );
		exit( 1 );
	}
	
	len = *((int_64 *) (var_arg2->data.bvalue));
	
	return (c_bst_key_is_in_tree( (bst_tree *) ((dyn_block *) var_arg1)->data_ptr, (char *) var_arg2->data.bvalue + sizeof( int_64 ), len ));
}


char _ci_calc_bst_key_is_in_tree_s( char *var_arg1, ci_var *var_arg2, char *source_file_id_txt )
{
	int len;

	if (var_arg1 == NULL)
	{
		printf( "NULL tree in bst_key_is_in_tree_s()\n" );
		exit( 1 );
	}
	
	if (var_arg2->data.bvalue == NULL)
	{
		printf( "NULL key in bst_key_is_in_tree_s()\n" );
		exit( 1 );
	}
	
	len = *((int_64 *) (var_arg2->data.svalue));
	
	return (c_bst_key_is_in_tree( (bst_tree *) ((dyn_block *) var_arg1)->data_ptr, var_arg2->data.svalue + sizeof( int_64 ), len ));
}



char _ci_calc_bst_key_is_in_tree_i( char *var_arg1, long int var_arg2, char *source_file_id_txt )
{
	if (var_arg1 == NULL)
	{
		printf( "NULL tree in bst_key_is_in_tree_i()\n" );
		exit( 1 );
	}
	
	return (c_bst_key_is_in_tree( (bst_tree *) ((dyn_block *) var_arg1)->data_ptr, (const char *) &var_arg2, sizeof( long int ) ));
}


char _ci_calc_bst_delete_item_b( char *var_arg1, ci_var *var_arg2, char *source_file_id_txt )
{
	int len;

	if (var_arg1 == NULL)
	{
		printf( "NULL tree in bst_delete_item_b()\n" );
		exit( 1 );
	}

	if (var_arg2->data.bvalue == NULL)
	{
		printf( "NULL key in bst_delete_item_b()\n" );
		exit( 1 );
	}
	
	len = *((int_64 *) var_arg2->data.bvalue);
	
	return (c_bst_delete_item( (bst_tree *) ((dyn_block *) var_arg1)->data_ptr, (char *) var_arg2->data.bvalue + sizeof( int_64 ), len ));
}



char _ci_calc_bst_delete_item_s( char *var_arg1, ci_var *var_arg2, char *source_file_id_txt )
{
	int len;

	if (var_arg1 == NULL)
	{
		printf( "NULL tree in bst_delete_item_s()\n" );
		exit( 1 );
	}

	if (var_arg2->data.bvalue == NULL)
	{
		printf( "NULL key in bst_delete_item_s()\n" );
		exit( 1 );
	}
	
	len = *((int_64 *) var_arg2->data.svalue);
	
	return (c_bst_delete_item( (bst_tree *) ((dyn_block *) var_arg1)->data_ptr, (char *) var_arg2->data.svalue + sizeof( int_64 ), len ));
}


char _ci_calc_bst_delete_item_i( char *var_arg1, long int var_arg2, char *source_file_id_txt )
{
	if (var_arg1 == NULL)
	{
		printf( "NULL tree in bst_delete_item_i()\n" );
		exit( 1 );
	}
	
	return (c_bst_delete_item( (bst_tree *) ((dyn_block *) var_arg1)->data_ptr, (const char *) &var_arg2, sizeof( long int ) ));
}


void _ci_calc_bst_free( char *var_arg1, char *source_file_id_txt )
{
	c_bst_free( (bst_tree *) ((dyn_block *) var_arg1)->data_ptr );
}


char *_ci_calc_bst_tree_first_item2( char *var_arg1, char var_arg2, char *source_file_id_txt )
{
	if (var_arg1 == NULL)
	{
		printf( "NULL tree in bst_tree_first_item2()\n" );
		exit( 1 );
	}

	return ((char *) c_bst_tree_first_item( (bst_tree *) ((dyn_block *) var_arg1)->data_ptr, var_arg2, source_file_id_txt ));
}

char *_ci_calc_bst_tree_next_item2( char *var_arg1, char var_arg2, char *source_file_id_txt )
{
	if (var_arg1 == NULL)
	{
		printf( "NULL tree in bst_tree_next_item2()\n" );
		exit( 1 );
	}

	return ((char *) c_bst_tree_next_item( (bst_tree_node *) var_arg1, var_arg2 ));
}

long int _ci_calc_bst_unique_items_in_list( char *var_arg1, char *source_file_id_txt )
{
	if (var_arg1 == NULL)
	{
		printf( "NULL tree value in bst_unique_items_in_tree()\n" );
		exit( 1 );
	}

	return (((bst_tree *) (var_arg1))->unique_items_in_tree );
}

long int _ci_calc_bst_total_items_in_list( char *var_arg1, char *source_file_id_txt )
{
	if (var_arg1 == NULL)
	{
		printf( "NULL tree value in bst_total_items_in_tree()\n" );
		exit( 1 );
	}

	return (((bst_tree *) (var_arg1))->total_items_in_tree );
}

