//<?		// Turn on editor syntax highlighting

                              // (c) Copyright Mark McIlroy 2023
    using namespace std;

    #include <string>
	#include <cstdlib>
	                                  
	#include "ci_calc.h"
	#include "library.cpph"

                               
 
//function bst_tree *bst_create( int options );		// call this function at the start

extern "C" bst_tree *c_bst_init2( int options );
extern "C" int c_bst_insert( bst_tree *tree_nptr, char const *key_bits, int num_key_bytes, void *data_ptr );
extern "C" bst_tree_node *c_bst_search( bst_tree *tree_nptr, char const *key_bits, int num_key_bytes, int *found );
extern "C" int c_bst_key_is_in_tree( bst_tree *tree_nptr, char const *key_bits, int num_key_bytes );
extern "C" int c_bst_delete_item( bst_tree *tree_nptr, char const *key_bits, int num_key_bytes );
extern "C" bst_tree_node *c_bst_scan( bst_tree_node *bst_nptr, bst_tree_node *curr_nptr );
extern "C" void c_bst_free( bst_tree *tree_nptr );
extern "C" bst_tree_node *c_bst_tree_first_item( bst_tree *bst_nptr, int ascending, char *source_file_id_txt );
extern "C" bst_tree_node *c_bst_tree_next_item( bst_tree_node *bst_nptr, int ascending );


/*
bst_tree *c_bst_init( int options );

int bst_insert_s( bst_tree_cpp *tree_nptr, string key, void *data_ptr );

void *bst_search_s( bst_tree_cpp *tree_nptr, string key, bool *found );

bool bst_key_is_in_tree_s( bst_tree_cpp *tree_nptr, string key );

int bst_total_items_in_tree( bst_tree_cpp *bst_nptr );

int bst_unique_items_in_tree( bst_tree_cpp *bst_nptr );

bst_tree_node_cpp *bst_tree_first_item2( bst_tree_cpp *bst_tr, bool ascending );

bst_tree_node_cpp *bst_tree_next_item2( bst_tree_node_cpp *bst_current_nptr, bool ascending );

void *bst_get_data_ptr( bst_tree_node_cpp *bst_nptr );
*/


	void bst_tree_cpp::create( int options )
	{
		bst = c_bst_init2( options ); 
//		bst = bst_create( options );
		
		check_number = BST_CHECK_NUMBER;
	}
	
	int bst_tree_cpp::insert_s( string key, void *data_ptr )
	{
		if (check_number != BST_CHECK_NUMBER)
		{
			ci_print( "bst tree has not been initialised, call varname.create(0);" );
			exit(1);
		}

		if (key == "")
		{
			ci_print( "Can't insert an empty string key into a bst_tree." );
			exit(1);
		}

		return (c_bst_insert( bst, key.c_str(), key.length(), data_ptr ));
	}

/*	
	int bst_tree_cpp::insert_intkey( int key, void *data_ptr )
	{
		if (check_number != BST_CHECK_NUMBER)
		{
			ci_print( "bst tree has not been initialised, call varname.create(0);" );
			exit(1);
		}

		return (bst_insert_bkey( bst, cint_to_binary( key ), data_ptr ));
	}
*/
	
	void *bst_tree_cpp::search_s( string key, bool& found )
	{
		int found3;
		void *ptr;
		
		if (check_number != BST_CHECK_NUMBER)
		{
			ci_print( "bst tree has not been initialised, call varname.create(0);" );
			exit(1);
		}

		if (key == "")
		{
			ci_print( "Can't search for an empty string key in a bst_tree." );
			exit(1);
		}
		
		ptr = c_bst_search( bst, key.c_str(), key.length(), &found3 );
		
		if (found3 != 0)
			found = true;
		else
			found = false;
					
		return (ptr);
	}
	
/*	
	void *bst_tree_cpp::search_intkey( int key, bool found )
	{
		if (check_number != BST_CHECK_NUMBER)
		{
			ci_print( "bst tree has not been initialised, call varname.create(0);" );
			exit(1);
		}

		return (bst_search_bkey( bst, cint_to_binary( key ), ref found ));
	}
*/
	
	bool bst_tree_cpp::key_is_in_tree_s( string key )
	{
		if (check_number != BST_CHECK_NUMBER)
		{
			ci_print( "bst tree has not been initialised, call varname.create(0);" );
			exit(1);
		}
		
		return (c_bst_key_is_in_tree( bst, key.c_str(), key.length() ));
	}


	bool bst_tree_cpp::first_item( bst_tree_node_cpp& bst2, bool ascending )
	{
		bst_tree_node *ptr;
		bool finished;
		char *source_file_id_txt = (char *) "";
	
		if (check_number != BST_CHECK_NUMBER)
		{
			ci_print( "bst tree has not been initialised, call varname.create(0);" );
			exit(1);
		}

		ptr = c_bst_tree_first_item( bst, ascending, source_file_id_txt );
		
		bst2.node_ptr = ptr;
				
		if (ptr == NULL)
			finished = true;
		else
			finished = false;
		
		return (! finished);
	}
	
	
	bool bst_tree_cpp::next_item( bst_tree_node_cpp& nptr, bool ascending )
	{
		bst_tree_node *ptr;
		bool finished;
		
		if (check_number != BST_CHECK_NUMBER)
		{
			ci_print( "bst tree has not been initialised, call varname.create(0);" );
			exit(1);
		}
		
		ptr = c_bst_tree_next_item( nptr.node_ptr, ascending );
		
		nptr.node_ptr = ptr;
		
		if (ptr == NULL)
			finished = true;
		else
			finished = false;
		
		return (! finished);
	}

/*
	bool bst_tree_cpp::key_is_in_tree_intkey( int key )
	{
		if (check_number != BST_CHECK_NUMBER)
		{
			ci_print( "bst tree has not been initialised, call varname.create(0);" );
			exit(1);
		}

		return (bst_key_is_in_tree_bkey( bst, cint_to_binary( key ) ));
	}
*/	
	bool bst_tree_cpp::delete_item_s( string key )
	{
		if (check_number != BST_CHECK_NUMBER)
		{
			ci_print( "bst tree has not been initialised, call varname.create(0);" );
			exit(1);
		}

		return (c_bst_delete_item( bst, key.c_str(), key.length() ));
	}
/*	
	bool bst_tree_cpp::delete_item_intkey( int key )
	{
		if (check_number != BST_CHECK_NUMBER)
		{
			ci_print( "bst tree has not been initialised, call varname.create(0);" );
			exit(1);
		}

		return (bst_delete_item_bkey( bst, cint_to_binary( key ) ));
	}
	
	int bst_tree_cpp::insert_bkey( binary key_bits, void *data_ptr )
	{
		if (check_number != BST_CHECK_NUMBER)
		{
			ci_print( "bst tree has not been initialised, call varname.create(0);" );
			exit(1);
		}

		return (bst_insert_bkey( bst, key_bits, data_ptr ));
	}
	
	void *bst_tree_cpp::search_bkey( binary key_bits, bool found )
	{
		if (check_number != BST_CHECK_NUMBER)
		{
			ci_print( "bst tree has not been initialised, call varname.create(0);" );
			exit(1);
		}
		
		return (bst_search_bkey( bst, key_bits, &found ));
	}
	
	bool bst_tree_cpp::key_is_in_tree_bkey( binary key_bits )
	{
		if (check_number != BST_CHECK_NUMBER)
		{
			ci_print( "bst tree has not been initialised, call varname.create(0);" );
			exit(1);
		}
		
		return (bst_key_is_in_tree_bkey( bst, key_bits ));
	}
	
	bool bst_tree_cpp::delete_item_bkey( binary key_bits )
	{
		if (check_number != BST_CHECK_NUMBER)
		{
			ci_print( "bst tree has not been initialised, call varname.create(0);" );
			exit(1);
		}
		
		return (bst_delete_item_bkey( bst, key_bits ));
	}
	
	int bst_tree_cpp::total_items_in_tree()
	{
		if (check_number != BST_CHECK_NUMBER)
		{
			ci_print( "bst tree has not been initialised, call varname.create(0);" );
			exit(1);
		}
		
		return (bst_total_items_in_tree( bst ));
	}
	
	int bst_tree_cpp::unique_items_in_tree()
	{
		if (check_number != BST_CHECK_NUMBER)
		{
			ci_print( "bst tree has not been initialised, call varname.create(0);" );
			exit(1);
		}
		
		return (bst_unique_items_in_tree( bst ));
	}
*/

	string bst_tree_node_cpp::get_key_s()
	{
		char str[10000];
		string str2;
		struct bst_tree_nd2 *ptr;

		ptr = (struct bst_tree_nd2 *) node_ptr;

		if (ptr->num_key_bytes >= 10000)
			ci_runtime_error( 155, "BST key overflow" );
		
		memcpy( str, ptr->key_bits, ptr->num_key_bytes );
		
		str[ptr->num_key_bytes] = '\0';
		
		str2 = str;
		
		return (str2);
	}
	
/*	
	int bst_tree_node_cpp::get_intkey()
	{
		binary b;
		
		b = bst_get_key( node_ptr );
		
		return (cbinary_to_int( b ));
	}

	binary bst_tree_node_cpp::get_bkey()
	{
		return (bst_get_key( node_ptr ));
	}
*/

	void *bst_tree_node_cpp::get_data_ptr()
	{
		struct bst_tree_nd2 *ptr;

		ptr = (struct bst_tree_nd2 *) node_ptr;
		
		return (ptr->data_ptr);
	}

  

bool bst_tree_first_item( bst_tree_cpp bst, bst_tree_node_cpp bst2, bool ascending )
{
	bst_tree_node *ptr;
	bool finished;
	char *source_file_id_txt = (char *) "";
	
	if (bst.check_number != BST_CHECK_NUMBER)
	{
		ci_print( "bst tree has not been initialised, call varname.create(0);" );
		exit(1);
	}
		
	ptr = c_bst_tree_first_item( bst.bst, ascending, source_file_id_txt );
		
	bst2.node_ptr = ptr;
		
	if (ptr == NULL)
		finished = true;
	else
		finished = false;
	
	return (! finished);
}


bool bst_tree_next_item( bst_tree_node_cpp nptr, bool ascending )
{
	bst_tree_node *ptr;
	bool finished;

	ptr = c_bst_tree_next_item( nptr.node_ptr, ascending );
	
	nptr.node_ptr = ptr;
	
	if (ptr == NULL)
		finished = true;
	else
		finished = false;
	
	return (! finished);
}


char *bst_get_data_ptr( char *var_arg1 )
{
	if (var_arg1 == NULL)
	{
		printf( "NULL node ptr in bst_get_data_ptr()\n" );
		exit( 1 );
	}
	
	return ((char *) ((bst_tree_node *) var_arg1)->data_ptr);
}


	
	void bst_tree_cpp::free_list()
	{
		if (check_number != BST_CHECK_NUMBER)
		{
			ci_print( "bst tree has not been initialised, call varname.create(0);" );
			exit(1);
		}

		c_bst_free( bst );
	}



