
#include <iostream>
#include <cctype>
#include <math.h>

#include <string.h>

using namespace std;

#include "ci_calc.h"
#include "library.cpph"


#define SMALL_STRING_BUFFER_SIZE 200


const bool _calcsys_ascii_only = true;

const int _calcsys_bytes_per_char = 1;



char *ci_sleft2( char *dest, char const *src, long int len );
char *ci_sright2( char *dest, char const *src, long int len );
char *ci_smid2( char *dest, char const *src, long int start, long int len );
unsigned char ci_hex_to_dec_1_char( const char ch );
unsigned char ci_dec_to_hex_1_nibble( unsigned char i );
int ci_is_leap_year( const int year );
int ci_is_digit( const char ch );
bool ci_is_digit_s( string ch );

/*
class calc_string
{
private:
	char *data;
	
public:	
	int length;
	
	calc_string()
	{
		length = strlen( "" );
		
		data = malloc( length + 1 );
		
		strcpy( data, "" );
	}

	~calc_string()
	{
		free( data );
	}
		
	calc_string( calc_string& str )
	{
		length = strlen( str.data );
		
		data = malloc( length + 1 );
		
		strcpy( data, str.data );
	}

	calc_string( const char *str )
	{
		length = strlen( str );
		
		data = malloc( length + 1 );
		
		strcpy( data, str );
	}
	
	calc_string operator=( calc_string const& str )
	{
		free( data );
		
		length = strlen( str.data );
		
		data = malloc( length + 1 );
		
		strcpy( data, str.data );
	}

	calc_string operator+( calc_string const& str )
	{
		char *ptr;
		
		ptr = malloc( length + strlen( str.data ) + 1 );

		length += strlen( str.data );
		
		strcpy( ptr, data );
		
		strcat( ptr, str.data );
		
		free( data );
		
		data = ptr;
	}

	calc_string operator+=( calc_string const& str )
	{
		char *ptr;
		
		ptr = malloc( length + strlen( str.data ) + 1 );

		length += strlen( str.data );
		
		strcpy( ptr, data );
		
		strcat( ptr, str.data );
		
		free( data );
		
		data = ptr;
	}

	calc_string operator+( const char *str )
	{
		char *ptr;
		
		ptr = malloc( length + strlen( str ) + 1 );

		length += strlen( str );
		
		strcpy( ptr, data );
		
		strcat( ptr, str );
		
		free( data );
		
		data = ptr;
	}
	
	calc_string operator+=( const char *str )
	{
		char *ptr;
		
		ptr = malloc( length + strlen( str ) + 1 );

		length += strlen( str );
		
		strcpy( ptr, data );
		
		strcat( ptr, str );
		
		free( data );
		
		data = ptr;
	}
}
*/

	bool ci_scaseieq( string str1, string str2 )
	{
		int stat;
		long int i;
		long int len1, len2;
		char const *ptr1;
		char const *ptr2;

		stat = true;
	
		len1 = str1.length();
		len2 = str2.length();
	
		if (len1 != len2)
			stat = false;
		else
		{
			ptr1 = str1.c_str();
			ptr2 = str2.c_str();
		 
			if (_calcsys_ascii_only)
			{
				for (i=0; stat && (i < len1); i++)
				{
					if (toupper( *ptr1++ ) != toupper( *ptr2++ ))
						stat = false;
				}			
			}
			else				
		 	{
				for (i=0; stat && (i < len1); i+=4)
				{
					if (toupper( *ptr1++ ) != toupper( *ptr2++ ))
						stat = false;

					if (*ptr1++ != *ptr2++)
						stat = false;
						
					if (*ptr1++ != *ptr2++)
						stat = false;
						
					if (*ptr1++ != *ptr2++)
						stat = false;
				}
			}			
		}			

		return ( stat );
	}
			

	string ci_sreplace( string str1, string srch, string repl )
	{
		char *str, *str2; 
		char const *ptr1;
		char *ptr2, *ptr3, *ptr5;
		char *ptr4;
		string s_str;
		long int len1, len2, len3, len4;
		long int result_len;

		len1 = str1.length();
		len2 = srch.length();
		len3 = repl.length();
		
		result_len = _calcsys_bytes_per_char * len1 + 1;
		
		if (result_len < 1000)
			result_len = 1000;
		
		str = (char *) malloc( result_len );

		ptr1 = str1.c_str();
		ptr2 = (char *) srch.c_str();
		ptr3 = (char *) repl.c_str();
		ptr4 = str;

		ptr5 = (char *) (ptr1 + len1 - len2);
		
		while (ptr1 <= ptr5)			
		{
			if (memcmp( ptr1, ptr2, len2 ) == 0)
			{
				if ((ptr4 - str) + len3 >= result_len)
				{
					str2 = (char *) malloc( result_len * 2 );
					memcpy( str2, str, result_len );
					ptr4 = str2 + (ptr4 - str);
					free( str );
					str = str2;
					result_len *= 2;
				}
				
				memcpy( ptr4, ptr3, len3 );
				ptr1 += len2;
				ptr4 += len3;
			}
			else
			{
				if ((ptr4 - str) + _calcsys_bytes_per_char >= result_len)
				{
					str2 = (char *) malloc( result_len * 2 );
					memcpy( str2, str, result_len );
					ptr4 = str2 + (ptr4 - str);
					free( str );
					str = str2;
					result_len *= 2;
				}
				
				memcpy( ptr4, ptr1, _calcsys_bytes_per_char );
				ptr1 += _calcsys_bytes_per_char;
				ptr4 += _calcsys_bytes_per_char;
			}
		}
		
		*ptr4 = '\0';

		s_str = str;
		
		free( str );
		
		return (s_str);			
	}


string ci_iconvert_to_html( string str )
{
	return (str);
}

int ci_ssearch( string str, string srch )
{
	int pos;

	pos = str.find( srch );
		
	if (pos != string::npos)
		return (pos);
	else
		return (-1);
}


int ci_srsearch( string str, string srch )
{
	int pos;

	pos = str.rfind( srch );
		
	if (pos != string::npos)
		return (pos);
	else
		return (-1);
}


int ci_sexplode( string text, string delimiter, string *items, int max_items )
{
	string str;
	int len;
	int start_pos, i, j;
	
	len = text.length();

	j = 0;
		
	start_pos = 0;
	
	for (i=0; i < len; i++)
	{
		if (text.substr( i, 1 ) == delimiter)
		{
			if (j < max_items)
			{
				if (i == start_pos)
					items[j++] = "";
				else
					items[j++] = text.substr( start_pos, i - start_pos );
			}
			
			start_pos = i + 1;
		}
	}
	
	if (j < max_items && len > 0 )
	{
		if (i == start_pos)
			items[j++] = "";
		else
			items[j++] = text.substr( start_pos, i - start_pos );
	}
	
	return (j);
}


 string ci_sleft( string str, int len )
 {
 	if (len < 0)
 		return( "" );
 	else
 	if (len < str.length())
 		return( str.substr( 0, len ));
 	else
 		return( str );
 }

 
 string ci_smid( string str, int start, int len )
 {
 	if (len < 0 || start >= str.length())
 		return( "" );
 	else
 	if (start + len > str.length())
 		return( str.substr( start, str.length() - start ) );
 	else
 		return( str.substr( start, len ) );
}


 string ci_sright( string str, int len )
 {
 	if (len < 0)
 		return( "" );
 	else
 	if (len < str.length())
 		return( str.substr( str.length() - len, len ));
 	else
 		return( str );
 }


 string ci_sright_from_pos( string str, int pos )
 {
 	if (pos >= str.length())
 		return( "" );
 	else
 		return( str.substr( pos, str.length() - pos ));
 }
 
 string ci_schar( string str, int pos )
 {
 	if (pos < 0 || pos >= str.length())
 		return( "" );
 	else
 		return( str.substr( pos, 1 ) );
 }


long int ci_cstring_to_int( string str )
{
	long int num;
	
	try
	{
		num = (long int) stol( str );
	}
	catch (...)
	{
		ci_runtime_error( 176, "Invalid numerical constant: '" + str + "'" );
	}
	
	return (num);
}

long int ci_cstring_to_decimal( string str )
{
	long int num;
	
	try
	{
		num = (long int) round( stof( str ) * VAR_DECIMAL_SCALE );
	}
	catch (...)
	{
		ci_runtime_error( 177, "Invalid numerical constant: '" + str + "'" );
	}
	
	return (num);
}

double ci_cstring_to_double( string str )
{
	double num;
	
	try
	{
		num = (double) stold( str );
	}
	catch (...)
	{
		ci_runtime_error( 178, "Invalid numerical constant: '" + str + "'" );
	}
	
	return (num);
}


string ci_cint_to_string( int num )
{
	return (to_string( num ));
}


int ci_schar_to_int( string ch )
{
	int num;
	
	try
	{
		num = (int) *(ch.c_str());
	}
	catch (...)
	{
		ci_runtime_error( 179, "Invalid numerical constant: '" + ch + "'" );
	}
	
	return (num);
}

string ci_ffile_get_contents_text( string pathname )
{
	long int fsize;
	FILE *fp;
	char *ptr;
	string str2;
	char str[10000];

	fp = fopen( pathname.c_str(), "r" );
	
	if (fp == NULL)
	{
		printf( "File '%s' not found\n", pathname.c_str() );
		exit(1);
	}
	
	fseek( fp, (long) 0, SEEK_END );
	
	fsize = ftell( fp );

	ptr = (char *) malloc( fsize + 1 );

	fseek( fp, (long) 0, SEEK_SET );
	
	fread( ptr, fsize, 1, fp );
	
	fclose( fp );
	
	ptr[fsize] = '\0';

	str2 = ptr;
	
	free( ptr );
	
	return (str2);
}



void ci_runtime_error( int num, string s )
{
	string str;
	int i;

	cout << "Call stack         <br>\n";
	
	for (i=1; i <= gruntime_data->call_level; i++)
	{
		str = "File: " + gruntime_data->ginput_filenames[gruntime_data->err_filenumber[i]];

		str += ": Line: " + to_string( gruntime_data->err_linenumber[i] );

		str += ": Function: " + gruntime_data->gfunction_details[gruntime_data->err_function_number[i]].function_name;
		
		str += "          <br>\n";
		
		cout << str;
	}
	
	if (gruntime_data->ic_ptr >= 0 && gruntime_data->ic_ptr < gruntime_data->ic_end)
	{
		str = "File: " + gruntime_data->ginput_filenames[gruntime_data->ic[gruntime_data->ic_ptr].input_filenumber];
	
		str += ": Line: " + to_string( gruntime_data->ic[gruntime_data->ic_ptr].line_number );
	}
	
	str += "          <br>\n";
		
	cout << str;
	
	str = "Runtime error: ";
	
	str += to_string( num );
	
	str.append( ": " );
	str.append( s );
	
	cout << str;
	
	cout << "          <br>\n";
	
	exit( 1 );
}


void ci_print( string s )
{
	cout << s;
	
	cout << "\n";
}

void ci_output( string s )
{
	cout << s;
}


		
void ci_free_all_system_memory_allocations()
{
	bst_tree_node_cpp bst_ptr;
	bool not_finished;
	ci_var *vptr;
	int i, j;
	t_keywords 				*nptr_keywords_ptr;
	t_global_variable 		*nptr_global_variable;
	t_local_variable 		*nptr_local_variable;
	t_bst_function_number 	*nptr_function_number; 
	t_constants 			*nptr_constant_ptr;
	t_bst_string_constant 	*nptr_string_constant;
	t_type_cache 			*nptr_type_cache;


		//--------------------------
		// BST trees
		//--------------------------

		//--------------------------
		// gbst_keywords
		//--------------------------

	not_finished = gbst_keywords.first_item( bst_ptr, true );
			
	while (not_finished)
	{
		nptr_keywords_ptr = (t_keywords *) bst_ptr.get_data_ptr();

		if (nptr_keywords_ptr != NULL)
			delete nptr_keywords_ptr;
		
		not_finished = gbst_keywords.next_item( bst_ptr, true );
	}

	gbst_keywords.free_list();



		//--------------------------
		// gbst_global_variables
		//--------------------------

	not_finished = gbst_global_variables.first_item( bst_ptr, true );
			
	while (not_finished)
	{
		nptr_global_variable = (t_global_variable *) bst_ptr.get_data_ptr();

		if (nptr_global_variable != NULL)
			delete nptr_global_variable;
		
		not_finished = gbst_global_variables.next_item( bst_ptr, true );
	}

	gbst_global_variables.free_list();


		//--------------------------
		// gbst_local_variables
		//--------------------------

	not_finished = gbst_local_variables.first_item( bst_ptr, true );
			
	while (not_finished)
	{
		nptr_local_variable = (t_local_variable *) bst_ptr.get_data_ptr();

		if (nptr_local_variable != NULL)
			delete nptr_local_variable;
		
		not_finished = gbst_local_variables.next_item( bst_ptr, true );
	}

	gbst_local_variables.free_list();



		//--------------------------
		// gbst_function_numbers
		//--------------------------

	not_finished = gbst_function_numbers.first_item( bst_ptr, true );
			
	while (not_finished)
	{
		nptr_function_number = (t_bst_function_number *) bst_ptr.get_data_ptr();

		if (nptr_function_number != NULL)
			delete nptr_function_number;
		
		not_finished = gbst_function_numbers.next_item( bst_ptr, true );
	}

	gbst_function_numbers.free_list();



		//--------------------------
		// gbst_constants
		//--------------------------

	not_finished = gbst_constants.first_item( bst_ptr, true );
			
	while (not_finished)
	{
		nptr_constant_ptr = (t_constants *) bst_ptr.get_data_ptr();

		if (nptr_constant_ptr != NULL)
			delete nptr_constant_ptr;
		
		not_finished = gbst_constants.next_item( bst_ptr, true );
	}

	gbst_constants.free_list();


		//--------------------------
		// gbst_string_constants
		//--------------------------

	not_finished = gbst_string_constants.first_item( bst_ptr, true );
			
	while (not_finished)
	{
		nptr_string_constant = (t_bst_string_constant *) bst_ptr.get_data_ptr();

		if (nptr_string_constant != NULL)
			delete nptr_string_constant;
		
		not_finished = gbst_string_constants.next_item( bst_ptr, true );
	}

	gbst_string_constants.free_list();



		//--------------------------
		// gbst_type_cache
		//--------------------------

	not_finished = gbst_type_cache.first_item( bst_ptr, true );
			
	while (not_finished)
	{
		nptr_type_cache = (t_type_cache *) bst_ptr.get_data_ptr();

		if (nptr_type_cache != NULL)
			delete nptr_type_cache;
		
		not_finished = gbst_type_cache.next_item( bst_ptr, true );
	}
	
	gbst_type_cache.free_list();	


		//--------------------------
		// gglobal_variables_array[i].init_str_u32
		//--------------------------

	for (i=0; i < gnumber_of_global_variables; i++)
	{
		if (gglobal_variables_array[gnumber_of_global_variables].init_str_u32 != NULL)
		{
			_ci_free( gglobal_variables_array[gnumber_of_global_variables].init_str_u32 );
			
			gglobal_variables_array[gnumber_of_global_variables].init_str_u32 = NULL;
		}
	}


		//--------------------------
		// glocal_variables_array[i][j].init_str_u32
		//--------------------------
	
	for (i=0; i < gnumber_of_user_functions; i++)
	{
		for (j=0; j < gruntime_data->gfunction_details[i].number_of_local_variables; j++)
		{
			if (glocal_variables_array[i][j].init_str_u32 != NULL)
			{ 
				_ci_free( glocal_variables_array[i][j].init_str_u32 );
				
				glocal_variables_array[i][j].init_str_u32 = NULL;
			}
		}
	}


		//--------------------------
		// free stacks
		//--------------------------
		
	for (i=0; i < STACK_SIZE; i++)
	{
		if (gruntime_data->stack[i].var_type != VAR_EMPTY)
			ci_free_curr_mem_1( &(gruntime_data->stack[i]) );
	}
		
	for (i=0; i < STACK3_SIZE; i++)
	{
		if (gruntime_data->stack3[i].var_type != VAR_EMPTY)
			ci_free_curr_mem_1( &(gruntime_data->stack3[i]) );
	}
	
	
		//--------------------------
		// globals segment
		//--------------------------

	for (i=0; i < gruntime_data->gglobal_variables_section_size; i++)
	{
		vptr = gruntime_data->global_variable_segment + i;
		
		if (vptr->var_type != VAR_EMPTY)
			ci_free_curr_mem_1( vptr );
	}
	
	_ci_free( gruntime_data->global_variable_segment );
	
	gruntime_data->global_variable_segment = NULL;
	
}

		
		//---------------------------------------------------------------------------------------------------------------------
		// Duplicate a u32 string
		//---------------------------------------------------------------------------------------------------------------------
		
	char *duplicate_u32( char *str_src_u32 )
	{
		char *str_dest_u32;
		int_64 len;
		
		len = *((int_64 *) str_src_u32);
		
		str_dest_u32 = (char *) _ci_malloc( sizeof( int_64 ) + len );
		
		memcpy( str_dest_u32, str_src_u32, sizeof( int_64 ) + len );
		
		return (str_dest_u32);
	}	
	
		
	long int ci_hex_to_int( char const *src )
	{
		long int i;
		long int result;
		long int multiplier;
		
		result = 0;
		multiplier = 1;
		
		for (i = strlen( src )-1; i >= 0; i--)
		{
			result += multiplier * (int) ci_hex_to_dec_1_char( src[i] );
			multiplier *= 16;
		}
		
		return (result);
	}


	double ci_mtrunc( double num )
	{
		return ((double) ((long int) num));	
	}

	
	char *ci_sleft2( char *dest, char const *src, long int len )
	{
		if (len <= 0)
			*dest = '\0';
		else
		{
			strncpy( dest, src, len );
		
			dest[len] = '\0';
		}
		
		return (dest);
	}
	
				
	char *ci_sright2( char *dest, char const *src, long int len )
	{			
		if (len <= 0)
			*dest = '\0';
		else
		{		
			if (len >= strlen( src ))
				strcpy( dest, src );
			else
				strcpy( dest, &src[strlen( src ) - len] );
		}
		
		return (dest);
	}
				
	char *ci_smid2( char *dest, char const *src, long int start, long int len )
	{
		if (start < 0 || len <= 0 || start >= strlen( src ))
			*dest = '\0';
		else
		{ 
			strncpy( dest, &(src[start]), len ); 

			dest[len] = '\0';
		}
		
		return (dest);
	}



/*
Options

CHECK_NUMERIC_DISALLOW_NEGATIVES
CHECK_NUMERIC_DISALLOW_DECIMALS
CHECK_NUMERIC_ALLOW_SCIENTIFIC_NOTATION
*/

string ci_text_is_valid_number( string text, int options, bool& is_numeric )
{
	int pos;
	int len;
	int state;
	string text2;
	string result;
	string append_ch;
	string ch;
	bool has_digit;
	
	is_numeric = true;
	
	has_digit = false;
	
	pos = 0;
	
	text2 = text;
//	text2 = strim( text );
	
	len = text2.length();
	
	state = 1;
	
	result = "";
	
	while (pos < len && is_numeric)
	{
		ch = ci_schar( text2, pos );
		
		append_ch = ch;
		
		if (! has_digit)
		{
			if (ci_is_digit_s( ch ))
				has_digit = true;
		}
		
		if ((options & CHECK_NUMERIC_DISALLOW_DECIMALS) != 0 && ch == ".")
			is_numeric = false;
		
		switch (state)
		{
			case 1:								// first character
			
				if (ch == "-")
				{
					if ((options & CHECK_NUMERIC_DISALLOW_NEGATIVES) != 0)
						is_numeric = false;
					else
						state = 6;
				}
				else
				if (ch == ".")
				{
					append_ch = "0.";
					state = 3;
				}
				else
				if (ci_is_digit_s( ch ))
					state = 2;
				else
					is_numeric = false;
					
				break;
				
			case 2:								// string of digits before '.'
			
				if (ch == ".")
					state = 3;		
				else				
				if (! ci_is_digit_s( ch ))
					is_numeric = false;
			
				break;
				
			case 3:								// string of digits after '.'

				if (ch == "e" || ch == "E")
				{
					if ((options & CHECK_NUMERIC_ALLOW_SCIENTIFIC_NOTATION) != 0)
						state = 4;
					else
						is_numeric = false;
				}
				else
				if (! ci_is_digit_s( ch ))
					is_numeric = false;

				break;

			case 4:								// first character after 'e' or 'E'

				if (ch == "-")
					state = 5;
				else
				if (! ci_is_digit_s( ch ))
					is_numeric = false;
				else
					state = 5;

				break;
					
			case 5:								// string of digits after 'e' or 'E'
				if (! ci_is_digit_s( ch ))
					is_numeric = false;

				break;
				
			case 6:								// second digit after a '-'
			
				if (ch == ".")
				{
					append_ch = "0.";
					state = 3;
				}		
				else				
				if (! ci_is_digit_s( ch ))
					is_numeric = false;
				else
					state = 2;

			break;
					
		}

		result += append_ch;
		
		pos++;
	}

	if (! has_digit)
		is_numeric = false;
	
	if (! is_numeric)
		result = text;
		
	return (result);
}


bool ci_is_digit_s( string ch )
{
	bool result;
	
	if (ch >= "0" && ch <= "9")
		result = true;
	else
		result = false;
		
	return (result);
}
