//<?		// Turn on editor syntax highlighting

                              // (c) Copyright Mark McIlroy 2022

    using namespace std;
                              
    #include <string>
    #include <iostream>
    
    #include "ci_calc.h"
    #include "library.cpph"
	

	bool is_separation_char( string& s );
	
	void next_token2( int include_file_level, string& s, int slen, int& i, int current_filenumber, int& current_line_number );
	void next_token3( int include_file_level, string& s, int slen, int& i, int current_filenumber, int& current_line_number );
	void input_error( int error_number, string current_filename, int current_line_number, string text );
	void process_newline( int include_file_level, string& s, int slen, int& i, int current_filenumber, int& current_line_number );
 	void skip_whitespace( int include_file_level, string& s, int slen, int& i, int current_file_number, int& current_line_number );
	string process_escape_sequences( string& s );
	void process_conditional_comp();
	void process_conditional_comp_1_section( int& scan_entry_number, int indent_level );
	void process_conditional_comp_set_not_active_code( int& scan_entry_number );
	bool parse_cc_expr( int& scan_entry_number );
	bool parse_cc_item_expr( int& scan_entry_number );
	void next_cc_expr_item( int& scan_entry_number );
	void check_for_not_eof( int error_number, int scan_entry_number, string msg );
	void input_error2( int error_number, int scan_entry_number, string msg );


	int num_keywords;

	int start_of_line_pos;
	string gcurrent_filename2;

	string gsource_file_id_txt;
	void scan_file( string input_filename, string& program, string include_paths[MAX_INCLUDE_PATHS], string source_code_language_file );


	void get_token_details( string source_code_language_file )
	{			
		FILE *fp;
		t_bst_string_constant *nptr_string_constant;
		t_keywords *keywords_ptr;
		int num_items;
		char str[10000];
		string items[100];
		string text;

/*		
		string program_text[1000];
		int slen2[1000];
		int input_pos[1000];
		int inc_current_line_number[1000]; 
		int inc_current_filenumber[1000];
		int pos, include_file_level, current_filenumber;
		int curr_token_number;
		string pathname;
		int prev_ipos;
		bool found;
		int i, j, k;
		int curr_pos;
		int curr_slen;
		int curr_filenumber;
		int curr_line_number;
		FILE *fp, *fp2;
		string pathname2, pathname3;
		int i2;
*/

		fp = fopen( source_code_language_file.c_str(), "r" );
		
		if (fp == NULL)
		{
			ci_print( "Can't open source code language file: " + source_code_language_file );
			exit( 1 );
		}

		gbst_keywords.create( 0 );
		gbst_function_numbers.create( 0 );
		gbst_constants.create( 0 );
//		gbst_function_arguments.create( 0 );
		gbst_local_variables.create( 0 );
		gbst_string_constants.create( 0 );

			// don't initialise to 0 as the may be entries from the command line
			
		cc_constants[num_cc_constants] = "compiler";
		cc_constants_value[num_cc_constants] = "false";
		num_cc_constants++;

		cc_constants[num_cc_constants] = "interpreter";
		cc_constants_value[num_cc_constants] = "true";
		num_cc_constants++;
		
		cc_constants[num_cc_constants] = "embedded";
		
		if (gis_embedded_environment)
			cc_constants_value[num_cc_constants] = "true";
		else
			cc_constants_value[num_cc_constants] = "false";
		
		num_cc_constants++;
			
				
		
		num_keywords = 0;	
		
		while (! feof( fp ))
		{
			text = fgets( str, 10000-1, fp );
			
			num_items = ci_sexplode( text, ",", items, 100 );
			
			if (num_items == 3)
			{
				if (items[0] == "token_text")
				{
					keywords_ptr = new t_keywords; 
					keywords_ptr->keyword = items[1];
					keywords_ptr->token_number = ci_cstring_to_int( items[2] );
					
					gbst_keywords.insert_s( items[1], keywords_ptr );

					if (ci_cstring_to_int( items[2] ) > 0 && ci_cstring_to_int( items[2] ) < 200)
						token_text[ci_cstring_to_int( items[2] )] = items[1];
					
					num_keywords++;
				}
			}
		}

		fclose( fp );
		
		token_text_int = token_text[TOK_INT];
		token_text_decimal = token_text[TOK_DECIMAL];
		token_text_double = token_text[TOK_DOUBLE];
		token_text_string = token_text[TOK_STRING];
		token_text_bool = token_text[TOK_BOOL];
		token_text_date = token_text[TOK_DATE];
		token_text_time = token_text[TOK_TIME];
		token_text_datetime = token_text[TOK_DATETIME];
		token_text_binary = token_text[TOK_BINARY];
		token_text_void = token_text[TOK_VOID];
		token_text_array = token_text[TOK_ARRAY];
		token_text_of = token_text[TOK_OF];
		token_text_to = token_text[TOK_TO];
		token_text_link = token_text[TOK_LINK];
		token_text_object = token_text[TOK_OBJECT];
		token_text_general = token_text[TOK_GENERAL];
		token_text_resizable = token_text[TOK_RESIZABLE];
		token_text_true = token_text[TOK_TRUE];
		token_text_true_uppercase = token_text[TOK_TRUE_UPPERCASE];
		token_text_false = token_text[TOK_FALSE];
		token_text_false_uppercase = token_text[TOK_FALSE_UPPERCASE];
		token_text_main = token_text[TOK_MAIN];
		token_text_secondary = token_text[TOK_SECONDARY];
		
		token_text_array_plus_one_space = token_text_array + " ";
		token_text_link_plus_one_space = token_text_link + " ";
		token_text_resizable_plus_one_space = token_text_resizable + " ";

		length_token_text_array_plus_1 = token_text_array.length() + 1;
		length_token_text_resizable_plus_1 = token_text_resizable.length() + 1;
		length_token_text_link_plus_1 = token_text_link.length() + 1;
		

		gstring_constants[0].string_number = 0;
		gstring_constants[0].str_value = "";

		
		add_constant( "NULL_DATE", "0000-00-00", token_text_date );

		gstring_constants[1].string_number = 1;
		gstring_constants[1].str_value = "0000-00-00";

		nptr_string_constant = new t_bst_string_constant;
		nptr_string_constant->string_number = 1;
		nptr_string_constant->str_value = "0000-00-00";
		
		gbst_string_constants.insert_s( "0000-00-00", nptr_string_constant );

		add_constant( "NULL_TIME", "99:99:99", token_text_time );

		gstring_constants[2].string_number = 2;
		gstring_constants[2].str_value = "99:99:99";

		nptr_string_constant = new t_bst_string_constant;
		nptr_string_constant->string_number = 2;
		nptr_string_constant->str_value = "99:99:99";
		gbst_string_constants.insert_s( "99:99:99", nptr_string_constant );


		add_constant( "NULL_DATETIME", "0000-00-00 99:99:99", token_text_datetime );

		gstring_constants[3].string_number = 3;
		gstring_constants[3].str_value = "0000-00-00 99:99:99";

		nptr_string_constant = new t_bst_string_constant;
		nptr_string_constant->string_number = 3;
		nptr_string_constant->str_value = "0000-00-00 99:99:99";
		gbst_string_constants.insert_s( "0000-00-00 99:99:99", nptr_string_constant );


		add_constant( "NULL_LINK", "0", token_text_link + " " + token_text_to + " " + token_text_general );

	
		gnum_string_constants = 4;
		
		gnum_constants = 4;
	}	

	
				
	void scan_file( string& input_filename, string& program, string include_paths[MAX_INCLUDE_PATHS] )
	{
		t_keywords *keywords_ptr;
		string program_text[1000];
		int slen2[1000];
		int input_pos[1000];
		int inc_current_line_number[1000]; 
		int inc_current_filenumber[1000];
		t_bst_string_constant *nptr_string_constant;
		int pos, include_file_level, current_filenumber;
		int curr_token_number;
		string pathname;
		int prev_ipos;
		bool found;
		string s2, text;
		int i, j, k;
		int curr_pos;
		int curr_slen;
		int curr_filenumber;
		int curr_line_number;
		FILE *fp, *fp2;
		string pathname2, pathname3;
		int num_items;
		string items[100];
		char str[10000];
		int i2;

		arr_number_of_files = INITIAL_NUMBER_OF_FILES;

		arr_lines_per_file = INITIAL_LINES_PER_FILE;

		gcurrent_filename2 = input_filename;

		curr_pos = 0;
		curr_line_number = 1;
		
		ginput_text[0][0] = "";
		ginput_text[0][1] = "";
		
		program_text[0] = program;
		
		slen2[0] = program.length();
		
		curr_slen = slen2[0];
		 		
		input_pos[0] = 0;
		
		pos = input_filename.rfind( "/" );
		
		if (pos != string::npos)
			input_filename = ci_sright( input_filename, input_filename.length() - pos - 1 );
		
		gruntime_data->ginput_filenames[0] = input_filename;
		  
		inc_current_filenumber[0] = 0;
		inc_current_line_number[0] = 1;
		curr_filenumber = 0;
		
		include_file_level = 0;

		current_filenumber = 0;
				
		gcurr_tok = 0;
		gcurr_token_text = "";
		
		curr_token_number = 0;
		start_of_line_pos = 0;
		
		i2 = 0;
		
		while (include_file_level >= 0 && i2++ < 500000-10)
		{
			prev_ipos = curr_pos;
			
			next_token2( include_file_level, program_text[include_file_level], curr_slen, curr_pos, curr_filenumber, curr_line_number );
			 
			if (gcurr_tok == TOK_EOF)
			{
				if (curr_pos > start_of_line_pos)
					ginput_text[curr_filenumber][curr_line_number] = ci_smid( program_text[include_file_level], start_of_line_pos, (curr_pos-start_of_line_pos) + 1 );
				else
					ginput_text[curr_filenumber][curr_line_number] = "";
				
				include_file_level--;
				
				if (include_file_level >= 0)
				{
					curr_pos = input_pos[include_file_level];
					curr_slen = slen2[include_file_level];
					curr_filenumber = inc_current_filenumber[include_file_level];
					curr_line_number = inc_current_line_number[include_file_level];
					
					next_token2( include_file_level, program_text[include_file_level], curr_slen, curr_pos, curr_filenumber, curr_line_number );
				
					if (gcurr_tok != TOK_SEMICOLON)
						input_error( 17, gcurrent_filename2, curr_line_number, "Expected a ';' after an 'include'" );

					gcurrent_filename2 = gruntime_data->ginput_filenames[curr_filenumber];
				}
			}
			else
			{
				if (curr_pos == prev_ipos)
				{
					ci_print( "Scanner error file: " + gcurrent_filename2 + " line: " + to_string( curr_line_number ) + " position: " +  to_string( curr_pos - start_of_line_pos ) );
					exit(1);
				}
				
				if (gcurr_tok == TOK_INCLUDE) 
				{
					next_token2( include_file_level, program_text[include_file_level], curr_slen, curr_pos, curr_filenumber, curr_line_number );
				
					if (gcurr_tok != TOK_STRING_CONSTANT)
						input_error( 16, gcurrent_filename2, curr_line_number, "Expected a pathname after 'include'" );
				
					pathname = gcurr_token_text;
				
					found = false;
					
					if (include_paths[0] == "")
						input_error( 273, gcurrent_filename2, curr_line_number, "Include paths must be specified with the :I option." );

					if (ci_sleft( pathname, 5 ) == "https" || ci_sleft( pathname, 1 ) == "/")
					{
						s2 = ci_ffile_get_contents_text( pathname );
						found = true;
					}
					else
					{
						i=0;
											
						while ((! found) && include_paths[i] != "")
						{
							pathname2 = include_paths[i] + "/" + pathname;
						
							fp2 = fopen( pathname2.c_str(), "r" );
							
							if (fp2 != NULL)
							{
								fclose( fp2 );
								
								found = true;
							
								pathname3 = pathname;
							
								pos = pathname3.rfind( "/" );
								
								if (pos != string::npos)
									pathname3 = ci_sright( pathname3, pathname3.length() - pos - 1 );
							
								for (j=0; j <= current_filenumber-1; j++)
								{
									if (pathname3 == gruntime_data->ginput_filenames[j])
									{
										gruntime_data->ginput_filenames_inclusion_count[j]++;
										
										if (gruntime_data->ginput_filenames_inclusion_count[j] > 20)
										{
											ci_print( "Cycle in include files detected." );
											
											for (k=0; k <= current_filenumber; k++)
												ci_print( gruntime_data->ginput_filenames[k] + "\n" );
											
											exit(1);
										}
									}
								}
											
								s2 = ci_ffile_get_contents_text( pathname2 );
							}
							
							i++;
						}		
					}
										
					if (! found)
					{
						ci_print( gcurrent_filename2 + ": Include file '" + pathname + "' not found." );
						exit(1);
					}
					
					input_pos[include_file_level] = curr_pos;

					inc_current_filenumber[include_file_level] = curr_filenumber;

					inc_current_line_number[include_file_level] = curr_line_number;
					
					include_file_level++;

					current_filenumber++;

					pos = pathname.rfind( "/" );
					
					if (pos != string::npos)
						pathname = ci_sright( pathname, pathname.length() - pos - 1 );
					
					
					gruntime_data->ginput_filenames[current_filenumber] = pathname;  
					
					program_text[include_file_level] = s2;
					
					slen2[include_file_level] = s2.length();
					
					curr_slen = slen2[include_file_level];
					
					input_pos[include_file_level] = 0;
					
					curr_pos = 0;

					gcurrent_filename2 = pathname;
									
					inc_current_filenumber[include_file_level] = current_filenumber;
					
					curr_filenumber = current_filenumber;
					
					inc_current_line_number[include_file_level] = 1;
					
					curr_line_number = 1;
				}
				else
				{
					gcurrent_filenumber[curr_token_number] 		= curr_filenumber;
					gcurrent_line_number[curr_token_number] 	= curr_line_number;
										
					gall_curr_tok[curr_token_number] 			= gcurr_tok;
					gall_curr_token_text[curr_token_number] 	= gcurr_token_text;
					gall_curr_token_active[curr_token_number] 	= true;
									
					curr_token_number++;
				}
			}
		}

		if (i2 >= 500000-10)
		{
			ci_print( "Partial input processed, increase 'max_tokens_in_input'." );
			exit(1);
		}

		gnum_tokens = curr_token_number;
		
		gnum_input_files = current_filenumber + 1; 
		
		gall_curr_tok[curr_token_number] = gcurr_tok;
		
		gall_curr_token_active[curr_token_number] = true;

		
			// process #if etc.
			
		process_conditional_comp();


		gcurr_token_number = 0;

		while (! gall_curr_token_active[gcurr_token_number] && gcurr_token_number < gnum_tokens-1)
			gcurr_token_number++;

		if (! gall_curr_token_active[gcurr_token_number])
		{
			ci_print( "No active code in the input file" );
			exit( 1 );
		}
		
		gcurr_tok = gall_curr_tok[gcurr_token_number];
		
		gcurr_token_text = gall_curr_token_text[gcurr_token_number];
			
	}

	
	void next_token()
	{
		bool finished;
		
		if (gcurr_token_number >= gnum_tokens-1)
		{
			gcurr_tok = TOK_EOF;
			gcurr_token_text = "";
		}
		else
		{
			gcurr_token_number++;
			
			finished = gall_curr_token_active[gcurr_token_number];
			
			while (not finished)
			{
				if (gcurr_token_number >= gnum_tokens-1)
				{
					gcurr_tok = TOK_EOF;
					gcurr_token_text = "";
					finished = true;
				}
				else
				{
					gcurr_token_number++;
			
					finished = gall_curr_token_active[gcurr_token_number];
				}
			}
				
			if (gcurr_token_number <= gnum_tokens-1)
			{
				gcurr_tok = gall_curr_tok[gcurr_token_number];
				gcurr_token_text = gall_curr_token_text[gcurr_token_number];
			}
			
			if (gcurr_token_number < gnum_tokens-2)
			{
				glookahead_tok = gall_curr_tok[gcurr_token_number+1];
			
				glookahead_token_text = gall_curr_token_text[gcurr_token_number+1];
			}
		}
		
//		ci_print( "x2: " + to_string( gcurr_token_number ) + " " + to_string( gcurr_tok ) + " " + gcurr_token_text );
	}
	

	void prev_token()
	{
		bool finished;
		
		if (gcurr_token_number <= 0)
		{
			gcurr_tok = TOK_EOF;
			gcurr_token_text = "";
		}
		else
		{
			gcurr_token_number--;
			
			finished = gall_curr_token_active[gcurr_token_number];
			
			while (not finished)
			{
				if (gcurr_token_number < 0)
				{
					gcurr_tok = TOK_EOF;
					gcurr_token_text = "";
					finished = true;
				}
				else
				{
					gcurr_token_number--;
			
					finished = gall_curr_token_active[gcurr_token_number];
				}
			}
				
			if (gcurr_token_number >= 0)
			{
				gcurr_tok = gall_curr_tok[gcurr_token_number];
				gcurr_token_text = gall_curr_token_text[gcurr_token_number];
			}
			else
				gcurr_token_number = 0;
				
			
			glookahead_tok = gall_curr_tok[gcurr_token_number+1];
			
			glookahead_token_text = gall_curr_token_text[gcurr_token_number+1];
		}		
	}

	
	void next_token2( int include_file_level, string& s, int slen, int& i, int current_filenumber, int& current_line_number )
	{

		next_token3( include_file_level, s, slen, i, current_filenumber, current_line_number );
	}


		//----------------------------------------------------------------------------
		// Process #set, #if etc
		//----------------------------------------------------------------------------

	void process_conditional_comp()
	{
		int scan_entry_number;
		
		scan_entry_number = 0;
		
		
		process_conditional_comp_1_section( scan_entry_number, 1 );

		
/*	
		scan_entry_number = 0;
		
		while (gall_curr_tok[scan_entry_number] != TOK_EOF)
		{
			ci_print( to_string( gall_curr_tok[scan_entry_number] ) + " " + gall_curr_token_text[scan_entry_number] + " " + to_string( gall_curr_token_active[scan_entry_number] ) );
			scan_entry_number++;
		}

		ci_print( "" );
		ci_print( "" );
		ci_print( "" );
*/ 
	} 
	

		//----------------------------------------------------------------------------
		// Process one section of code between #if #end, #if #else, or #else #end
		//
		// Exit with EOF or the #else or #end as the current token
		//----------------------------------------------------------------------------
			
	void process_conditional_comp_1_section( int &scan_entry_number, int indent_level )
	{
		while (gall_curr_tok[scan_entry_number] != TOK_HASH_ELSE and gall_curr_tok[scan_entry_number] != TOK_HASH_END and gall_curr_tok[scan_entry_number] != TOK_EOF)
		{
			if (gall_curr_tok[scan_entry_number] == TOK_HASH_SET)
			{
				check_for_not_eof( 421, scan_entry_number, "incomplete #set at end of file" );
				check_for_not_eof( 421, scan_entry_number+1, "incomplete #set at end of file" );

				if (gall_curr_tok[scan_entry_number+2] != TOK_BOOLEAN_CONSTANT)
					input_error2( 422, scan_entry_number, "Expected 'true' or 'false' after #set variable name: " + gall_curr_token_text[scan_entry_number+1] + " " + gall_curr_token_text[scan_entry_number+2] );
				
				cc_constants[num_cc_constants] = gall_curr_token_text[scan_entry_number+1];				// The '#set' variable name
				cc_constants_value[num_cc_constants] = gall_curr_token_text[scan_entry_number+2];		// The '#set' variable value
				
				num_cc_constants++;
				
				gall_curr_token_active[scan_entry_number] = false;
				gall_curr_token_active[scan_entry_number+1] = false;
				gall_curr_token_active[scan_entry_number+2] = false;
				
				scan_entry_number += 3;
				
				// = this_scan_item..next..next..next;
			}
			else
			if (gall_curr_tok[scan_entry_number] == TOK_HASH_IF)
			{
				check_for_not_eof( 429, scan_entry_number, "#if at end of file" );

				gall_curr_token_active[scan_entry_number] = false;
						
				scan_entry_number++;

					// if IF condition true
				
				if (parse_cc_expr( scan_entry_number ))
				{
					process_conditional_comp_1_section( scan_entry_number, indent_level+1 );
					
					if (gall_curr_tok[scan_entry_number] == TOK_HASH_ELSE)
					{
						gall_curr_token_active[scan_entry_number] = false;
						
						check_for_not_eof( 427, scan_entry_number, "#else at end of file" );
						
						scan_entry_number++;
						
						process_conditional_comp_set_not_active_code( scan_entry_number );
						
						if (gall_curr_tok[scan_entry_number] == TOK_HASH_ELSE)
							input_error2( 430, scan_entry_number, "Duplicated #else" );
						else					
						if (gall_curr_tok[scan_entry_number] == TOK_EOF)
							input_error2( 427, scan_entry_number, "#else at end of file" );
						else
						{
							gall_curr_token_active[scan_entry_number] = false;
						
							scan_entry_number++;
						}
					}
					else
					if (gall_curr_tok[scan_entry_number] == TOK_EOF)
						check_for_not_eof( 430, scan_entry_number, "Expected #end" );
					else
					{
						gall_curr_token_active[scan_entry_number] = false;
						
						check_for_not_eof( 427, scan_entry_number, "Unexpected end of file" );
						
						scan_entry_number++;
					}
				}
				else
				{
					// if IF condition false
									
					process_conditional_comp_set_not_active_code( scan_entry_number );
								
					if (gall_curr_tok[scan_entry_number] == TOK_HASH_ELSE)
					{
						gall_curr_token_active[scan_entry_number] = false;
						
						check_for_not_eof( 427, scan_entry_number, "#else at end of file" );
						
						scan_entry_number++;
						
						process_conditional_comp_1_section( scan_entry_number, indent_level+1 );
						
						if (gall_curr_tok[scan_entry_number] == TOK_HASH_ELSE)
							input_error2( 430, scan_entry_number, "Duplicated #else" );
						else					
						if (gall_curr_tok[scan_entry_number] == TOK_EOF)
							input_error2( 427, scan_entry_number, "#else at end of file" );
						else
						{
							gall_curr_token_active[scan_entry_number] = false;
						
							scan_entry_number++;
						}
					}
					else
					if (gall_curr_tok[scan_entry_number] == TOK_EOF)
						check_for_not_eof( 430, scan_entry_number, "Expected #end" );
					else
					{
						gall_curr_token_active[scan_entry_number] = false;
						
						scan_entry_number++;
					}
				}
			}
			else
				scan_entry_number++;
		}

		if (indent_level > 1) 
			check_for_not_eof( 426, scan_entry_number, "No closing #end at end of file" );
	}


		//----------------------------------------------------------------------------
		// set all code to non-active from here to the next #ELSE or #END, allowing for nested #if/#end within the section
		//
		// Enter this function with the current token as the token after the #if or #else
		//
		// Exit this function with the #else, #end or EOF as the current token
		//----------------------------------------------------------------------------
		
	void process_conditional_comp_set_not_active_code( int& scan_entry_number )
	{
		int indent_level2;
						
		indent_level2 = 1;

		if (gall_curr_tok[scan_entry_number] == TOK_HASH_IF)
		{
			indent_level2++;

			check_for_not_eof( 428, scan_entry_number, "Unexpected end of file" );
			
			gall_curr_token_active[scan_entry_number] = false;
		
			scan_entry_number++;
		}
		
		if (gall_curr_tok[scan_entry_number] == TOK_HASH_END)
		{
			check_for_not_eof( 428, scan_entry_number, "Unexpected end of file" );
		}
		else
		{
			while (indent_level2 >= 1 and gall_curr_tok[scan_entry_number] != TOK_EOF and 
						not (indent_level2 <= 1 and gall_curr_tok[scan_entry_number] == TOK_HASH_END or gall_curr_tok[scan_entry_number] == TOK_HASH_ELSE))
			{
				if (gall_curr_tok[scan_entry_number] == TOK_HASH_IF)
					indent_level2++;
	
				if (gall_curr_tok[scan_entry_number] == TOK_HASH_END)
					indent_level2--;
	
				check_for_not_eof( 428, scan_entry_number, "Unexpected end of file" );
										 
				gall_curr_token_active[scan_entry_number] = false;
			
				scan_entry_number++;
			}
					
			if (indent_level2 > 0)
				check_for_not_eof( 423, scan_entry_number, "No closing #end at end of file" );
		}
	}



		//--------------------------------------------------------------------------
		// Process a #if expression
		//--------------------------------------------------------------------------
		
	bool parse_cc_expr( int& scan_entry_number )
	{
		int op;
		bool cc_expr_value;
		bool cc_expr_value2;
		
		cc_expr_value = parse_cc_item_expr( scan_entry_number );
		
		while (gall_curr_tok[scan_entry_number] == TOK_AND || gall_curr_tok[scan_entry_number] == TOK_OR)
		{
			op = gall_curr_tok[scan_entry_number];

			next_cc_expr_item( scan_entry_number );
		
			cc_expr_value2 = parse_cc_item_expr( scan_entry_number );
	
			if (op == TOK_AND)
				cc_expr_value = cc_expr_value && cc_expr_value2; 
	
			if (op == TOK_OR)
				cc_expr_value = cc_expr_value || cc_expr_value2; 
		}
		
		return (cc_expr_value);
	}
	

	bool parse_cc_item_expr( int& scan_entry_number )
	{
		bool stat;
		bool found;
		int j;
		
		if (gall_curr_tok[scan_entry_number] == TOK_NOT)
		{
			next_cc_expr_item( scan_entry_number );

			stat = ! parse_cc_item_expr( scan_entry_number );
		}
		else
		if (gall_curr_tok[scan_entry_number] == TOK_LPARENTHESIS)
		{
			next_cc_expr_item( scan_entry_number );
			
			stat = parse_cc_expr( scan_entry_number ); 

			if (gall_curr_tok[scan_entry_number] != TOK_RPARENTHESIS)
			{
				ci_print( "Expected an ')' in #if expression." );
				exit(1);
			}
			
			next_cc_expr_item( scan_entry_number );
		}
		else 
		{
			stat = false;
			found = false;
			
			for (j=0; j < num_cc_constants; j++)
			{
//				ci_print( "x1: " + cc_constants[j] );
							
				if (cc_constants[j] == gall_curr_token_text[scan_entry_number])
				{
					found = true;
					stat = (cc_constants_value[j] == "true" || cc_constants_value[j] == "TRUE");
				}
			}
			
			if (! found)
			{
				ci_print( "#if variable '" + gall_curr_token_text[scan_entry_number] + "' has not been defined using #set" );
				exit( 1 );
			}
			
			next_cc_expr_item( scan_entry_number );
		}
		
		return (stat);
	}
 	

		//--------------------------------------------------------------------------
		// Move to the next item in a #if expression
		//--------------------------------------------------------------------------

	void next_cc_expr_item( int& scan_entry_number )
	{
		gall_curr_token_active[scan_entry_number] = false;
		
		scan_entry_number++;
		
		if (scan_entry_number >= gnum_tokens-1)
		{
			ci_print( "Unexpected end-of-file in #if expression" );
			exit( 1 );
		}
	}
	

		//--------------------------------------------------------------------------
		// Check for end of file while more input is expected
		//--------------------------------------------------------------------------
			
	void check_for_not_eof( int error_number, int scan_entry_number, string msg )
	{
		if (scan_entry_number >= gnum_tokens-1)
		{
			ci_print( "Error " + to_string( error_number ) + ": " + msg );
			exit( 1 );
		}
	}



	void input_error2( int error_number, int scan_entry_number, string msg )
	{
		ci_print( "Error " + to_string( error_number ) + ": " + gruntime_data->ginput_filenames[gcurrent_filenumber[scan_entry_number]] + ": Line: " + to_string( gcurrent_line_number[scan_entry_number] ) + ": " + msg );
	}
	
	
	void next_token3( int include_file_level, string& s, int slen, int& i, int current_filenumber, int& current_line_number )
	{
		t_keywords *keywords_ptr;
		t_bst_string_constant *nptr_string_constant;
		bool already_processed;
		bool is_numeric;
		bool found;
		string text, text3;
		int tok;
		int ch_i;
		int start_pos;
		int start_text;
		int tok_len, j, k, num;
		string ch, text2;
		
		already_processed = false;
		
		found = false;
		
		tok = 0;

		if (i >= slen)
			tok = TOK_EOF;
		else
		{
			skip_whitespace( include_file_level, s, slen, i, current_filenumber, current_line_number );
			
			start_text = i;
	
			gcurr_token_text = "";
			
			if (i >= slen)
			{
				tok = TOK_EOF;
				tok_len = 1;
				gcurr_token_text = "";
			}
			else
			{
				ch = ci_schar( s, i );
	
				if (ch == "#")
				{
					found = true;
					
					if (ci_smid( s, i, 3 ) == "#if")
					{
						if (i+3 >= slen)
						{
							tok = TOK_HASH_IF;
							gcurr_token_text = "#if";
						}
						else
						{
							ch = ci_schar( s, i+3 );
							
							if (is_separation_char( ch ))
							{
								tok = TOK_HASH_IF;
								gcurr_token_text = "#if";
							}
							else
							{
								cout << "'#' command not recognised (2)." + ci_smid( s, i, 4 );
								exit( 1 );
							}
						}
						
						i += 3;
					}
					else
					if (ci_smid( s, i, 4 ) == "#end")
					{
						if (i+4 >= slen)
						{
							tok = TOK_HASH_END;
							gcurr_token_text = "#end";
						}
						else
						{
							ch = ci_schar( s, i+4 );
							
							if (is_separation_char( ch ))
							{
								tok = TOK_HASH_END;
								gcurr_token_text = "#end";
							}
							else
							{
								cout << "'#' command not recognised (3)." + ci_smid( s, i, 5 );
								cout << ci_smid( s, i, 5 );
								exit( 1 );
							}
						}
						
						i += 4;
					}
					else
					if (ci_smid( s, i, 5 ) == "#else")
					{
						if (i+5 >= slen)
						{
							tok = TOK_HASH_ELSE;
							gcurr_token_text = "#else";
						}
						else
						{
							ch = ci_schar( s, i+5 );
							
							if (is_separation_char( ch ))
							{
								tok = TOK_HASH_ELSE;
								gcurr_token_text = "#else";
							}
							else
							{
								cout << "'#' command not recognised (5)." + ci_smid( s, i, 6 );
								exit( 1 );
							}
						}
						
						i += 5;
					}
					else
					if (ci_smid( s, i, 4 ) == "#set")
					{
						if (i+4 >= slen)
						{
							tok = TOK_HASH_SET;
							gcurr_token_text = "#set";
						}
						else
						{
							ch = ci_schar( s, i+4 );
							
							if (is_separation_char( ch ))
							{
								tok = TOK_HASH_SET;
								gcurr_token_text = "#set";
							}
							else
							{
								cout << "'#' command not recognised (3)." + ci_smid( s, i, 5 );
								exit( 1 );
							}
						}
						
						i += 4;
					}
					else
					{
						cout << "'#' command not recognised (4): " + ci_smid( s, i, 10 );
						exit( 1 );
					}
				}

				if (not found)
				{
//					text1 = ch;
					
					tok = -1;

					if (ch == ",")	{	tok = TOK_COMMA;			tok_len = 1;	}
					else
					if (ch == "(")	{	tok = TOK_LPARENTHESIS;		tok_len = 1;	}
					else
					if (ch == ")")	{	tok = TOK_RPARENTHESIS;		tok_len = 1;	}
					else
					if (ch == "{")	{	tok = TOK_LBRACE;			tok_len = 1;	}
					else
					if (ch == "}")	{	tok = TOK_RBRACE;			tok_len = 1;	}
					else
					if (ch == "[")	{	tok = TOK_LBRACKET;			tok_len = 1;	}
					else
					if (ch == "]")	{	tok = TOK_RBRACKET;			tok_len = 1;	}
					else
					if (ch == ";")	{	tok = TOK_SEMICOLON;		tok_len = 1;	}
					else
					if (ch == ".")	{	tok = TOK_DOT;				tok_len = 1;	}
					else
					if (ch == ":")	{	tok = TOK_COLON;			tok_len = 1;	}
					else
					if (ch == "^")	{	tok = TOK_POW;				tok_len = 1;	}
 

					if (tok == -1)
					{
						text2 = ci_smid( s, i, 2 );
						
						if (text2 == "!=")	{	tok = TOK_NE;					tok_len = 2;	}
					}
			

					if (tok == -1)
					{
						if (ch == "=")	
						{	
							if (text2 == "==")	{	tok = TOK_EQ;					tok_len = 2;	}
							else				{	tok = TOK_ASSIGN;				tok_len = 1;	}	
						}
						else
						if (ch == "&")	
						{	
							if (text2 == "&=")	{	tok = TOK_ASSIGN_STRCONCAT;		tok_len = 2;	}
							else				{	tok = TOK_ADDR_STRCONCAT;		tok_len = 1;	}	
						}
						else
						if (ch == "<")	
						{	
							if (text2 == "<=")	{	tok = TOK_LE;					tok_len = 2;	}
							else
							if (text2 == "<<")	{	tok = TOK_OPEN_HASH;			tok_len = 2;	}
							else				{	tok = TOK_LT;					tok_len = 1;	}	
						}
						else
						if (ch == ">")	
						{	
							if (text2 == ">=")	{	tok = TOK_GE;					tok_len = 2;	}
							else					
							if (text2 == ">>")	{	tok = TOK_CLOSE_HASH;			tok_len = 2;	}
							else				{	tok = TOK_GT;					tok_len = 1;	}	
						}
						else
						if (ch == "+")	
						{
							if (text2 == "++")	{	tok = TOK_INC;					tok_len = 2;	}
							else
							if (text2 == "+=")	{	tok = TOK_ASSIGN_INC;			tok_len = 2;	}
							else				{	tok = TOK_PLUS;					tok_len = 1;	}
						}
						else
						if (ch == "-")	
						{	
							if (text2 == "--")	{	tok = TOK_DEC;					tok_len = 2;	}
							else
							if (text2 == "-=")	{	tok = TOK_ASSIGN_DEC;			tok_len = 2;	}
							else				{	tok = TOK_SUBTRACT_MINUS;		tok_len = 1;	}	
						}
						else
						if (ch == "*")	
						{	
							if (text2 == "*=")	{	tok = TOK_ASSIGN_MULT;			tok_len = 2;	}
							else				{	tok = TOK_MULT;					tok_len = 1;	}	
						}
						else
						if (ch == "/")	
						{	
							if (text2 == "/=")	{	tok = TOK_ASSIGN_DIV;			tok_len = 2;	}
							else				{	tok = TOK_DIV;					tok_len = 1;	}	
						}
					}	

		
					if (tok == -1)
					{
//						text2 = smid( s, i, 2 );
						
						if (ch == "\"")
						{
							tok_len = 1;
			
							j = i;
							
							j++;
			
							ch = ci_schar( s, j );
			
							while (j < slen && ch != "\"")
							{
								text2 = ci_smid( s, j, 2 );
								
								if (ch == "\n")
								{
									if (i > start_of_line_pos)
										ginput_text[current_filenumber][current_line_number] = ci_smid( s, start_of_line_pos, (i-start_of_line_pos) + 1 );
									else
										ginput_text[current_filenumber][current_line_number] = "";
													
									start_of_line_pos = i + 1;
									
									current_line_number++;
									
//									if (gshow_scan_trace)
//										print( "Input line: " + to_string( current_line_number ) + "<br>\n" );
								}
								
								
								if (text2 == "\\\\")
								{
									j++;
									tok_len++;
								}
								else
								if (text2 == "\\\"")
								{
									j++;
									tok_len++;
								}
			
								j++;
								tok_len++;
			
								ch = ci_schar( s, j );
							}
							
							tok = TOK_STRING_CONSTANT;
							
							tok_len++;
						}		
						else
						if (text2 == "0x")
						{
							tok_len = 0;
			
							j = i + 2;
			
							ch = ci_schar( s, j );
												
							while (j < slen && ((ch >= "0" && ch <= "9") || (ch >= "A" && ch <= "F"))) 
							{
								j++;
								tok_len++;
			
								ch = ci_schar( s, j );
							}
							
							text = ci_smid( s, i+2, tok_len );
							
							tok = TOK_NUMBER;
						
							gcurr_token_text = ci_cint_to_string( ci_hex_to_int( text.c_str() ) );
			
							i += tok_len + 2;
							
							already_processed = true;
						}
						else
						if (text2 == "0b")
						{
							tok_len = 0;
			
							j = i + 2;
			
							ch = ci_schar( s, j );
												
							while (j < slen && ch >= "0" && ch <= "1")
							{
								j++;
								tok_len++;
			
								ch = ci_schar( s, j );
							}
							
							text = ci_smid( s, i+2, tok_len );
							
							tok = TOK_NUMBER;
						
							num = 0;
							
							j = 1;
							
							for (k = text.length()-1; k >= 0; k--)
							{
								ch = ci_schar( text, k );
								
								if (ch == "1")
									num += j;
								else
								if (ch != "0")
									input_error( 188, gcurrent_filename2, current_line_number, "Invalid character '" + ch + "' in binary constant" );
														
								j *= 2; 
							}
							
							gcurr_token_text = ci_cint_to_string( num );
			
							i += tok_len + 2;
							
							already_processed = true;
						}
						else
						if (ch == "'")
						{
							tok_len = 1;
			
							j = i;
							
							j++;
			
							ch = ci_schar( s, j );
												
							while (j < slen && ch != "'")
							{
								j++;
								tok_len++;
			
								ch = ci_schar( s, j );
							}
							
							tok_len++;
							
							text = ci_smid( s, i+1, tok_len );
							
							if (tok_len == 12)
							{
								tok = TOK_DATE_CONSTANT;
			
								text = ci_sleft( text, 10 );
								
								if (! ci_check_date_valid( text.c_str(), "yyyy-mm-dd" ))
									input_error( 142, gcurrent_filename2, current_line_number, "Invalid date format: " + text );
							}
							else
							if (tok_len == 10)
							{
								tok = TOK_TIME_CONSTANT;
								
								text = ci_sleft( text, 8 );
								
								if (! ci_check_time_valid( text.c_str() ))
									input_error( 143, gcurrent_filename2, current_line_number, "Invalid time format: " + text );
							}
							else						
							if (tok_len == 21)
							{
								tok = TOK_DATETIME_CONSTANT;
			
								text = ci_sleft( text, 19 );
														
								if (! ci_check_datetime_valid( text.c_str() ))
									input_error( 144, gcurrent_filename2, current_line_number, "Invalid datetime format: " + text );
							}
							else
							{
								input_error( 101, gcurrent_filename2, current_line_number, "Single quotes should only be used for date and time constants, Expected a date 'YYYY-MM-DD', time 'HH:MM:SS' or datetime 'YYYY-MM-DD HH:MM:SS': " + ch );
								gerror_occured = true;
							}
						}
						else
						if (ch >= "0" && ch <= "9")
						{
							tok = TOK_NUMBER;
							
							tok_len = 0;
							
							j = i;
							
							text2 = ch;
							
							while (j < slen && ((ch >= "0" && ch <= "9") || ch == "." || ch == "e" || ch == "E"))
							{
								j++;
								
								ch = ci_schar( s, j );
							    
								text2.append( ch );
								
								tok_len++;
							}
						}
						else
						{						// name
							tok = TOK_NAME;
							
							j = i;
							
							while (j < slen && ! is_separation_char( ch ))
							{
								j++;
								
								ch = ci_schar( s, j );
							}
	
							tok_len = j - i;
							
							if (j == i)
							{
								ci_print( "Illegal character: " + ci_schar( s, j ) );
								j++;
								tok_len = 1;
							}
						
							text = ci_smid( s, i, tok_len );
							
							if (text == token_text_true ||
								 text == token_text_true_uppercase ||
								 text == token_text_false ||
								 text == token_text_false_uppercase)
										tok = TOK_BOOLEAN_CONSTANT;
							else
							{
								keywords_ptr = (t_keywords *) gbst_keywords.search_s( text, found );
			
								if (keywords_ptr != NULL)
								{
									tok = keywords_ptr->token_number;
								}
							}
						}
					}
		
					if (! already_processed)
					{
						if (tok == TOK_STRING_CONSTANT ||
							tok == TOK_DATE_CONSTANT ||
							tok == TOK_TIME_CONSTANT ||
							tok == TOK_DATETIME_CONSTANT)
						{
							gcurr_token_text = ci_smid( s, i+1, tok_len - 2 );
							
							if (tok == TOK_STRING_CONSTANT)
								gcurr_token_text = process_escape_sequences( gcurr_token_text );
	  					}
						else
							gcurr_token_text = ci_smid( s, i, tok_len );
	
						i += tok_len;
	
						if (tok == TOK_DOUBLE && gcurr_token_text == "number")
							gcurr_token_text = "double";
					}
				}
				
				if (gshow_scan_trace)
					ci_print( "Scan: " + to_string( tok ) + ": '" + gcurr_token_text + "'          <br>" );
			}
	
			if (tok == TOK_FLOAT || tok == TOK_LONG_DOUBLE)
			{
				tok = TOK_DOUBLE;
				gcurr_token_text = token_text_double;	
			}
	
			if (tok == TOK_BYTE || tok == TOK_SHORT_INT || tok == TOK_MEDIUM_INT)
			{
				tok = TOK_INT;
				gcurr_token_text = token_text_int;	
			}
			
			if (tok == TOK_NUMBER)
			{ 
				ci_text_is_valid_number( gcurr_token_text, CHECK_NUMERIC_ALLOW_SCIENTIFIC_NOTATION, is_numeric );
				
				if (! is_numeric)
					input_error( 102, gcurrent_filename2, current_line_number, "Invalid numeric literal: '" + gcurr_token_text + "'" );
			}			
		}
			
		gcurr_tok = tok;
	}

	
	
	bool is_separation_char( string& s )
	{
		bool stat;
		int ch_i;
		
		stat = false;
		
		if (s == " " ||
			s == "," ||
			s == "\t" ||
			s == "\n" ||
			s == "\r" ||
			s == "(" ||
			s == ")" ||
			s == "=" ||
			s == "<" ||
			s == ">" ||
			s == "+" ||
			s == "-" ||
			s == "*" ||
			s == "/" ||
			s == "[" ||
			s == "]" ||
			s == "{" ||
			s == "}" ||
			s == "\"" ||
			s == "!" ||
			s == "." ||
			s == ";" ||
			s == "&" ||
			s == "^" ||
			s == "#" ||
			s == ":")
			
				stat = true;
		
		return (stat);
	}


	string process_escape_sequences( string& s )
	{
		int pos;
		string s2, ch, ch2;
		
		pos = 0;

		s2 = "";

		while (pos < s.length())
		{
			ch = ci_schar( s, pos );
			ch2 = ci_smid( s, pos, 2 );
			
			if (ch2 == "\\n")
			{
				s2.append( "\n" );
				pos++;
			}
			else
			if (ch2 == "\\r")
			{
				s2.append( "\r" );
				pos++;
			}
			else
			if (ch2 == "\\t")
			{
				s2.append( "\t" );
				pos++;
			}
			else
			if (ch2 == "\\\"")
			{
				s2.append( "\"" );
				pos++;
			}
			else
			if (ch2 == "\\\\")
			{
				s2.append( "\\" );
				pos++;
			}
			else
				s2.append( ch );
			
			pos++;
		}
		
		return (s2);
	}


 	void skip_whitespace( int include_file_level, string& s, int slen, int& i, int current_file_number, int& current_line_number )
	{
		int state, nesting_level;
		string ch;
		
		state = 1;
		nesting_level = 0;

		while (i < slen && state != 0)
		{
			ch = ci_schar( s, i );	
			
			if (ch == "\n")
				process_newline( include_file_level, s, slen, i, current_file_number, current_line_number );
			
			switch (state)
			{
				case 1:
				{
					if (ch == " " ||
						ch == "\n" || 
						ch == "\r" || 
						ch == "\t")
						i++;
					else
					if (ch == "/")			//			/
					{
						state = 2;
						i++;
					}
					else					
						state = 0;
				}
				break;
				
				case 2:
				{
					if (ch == "/")			//			//
					{
						state = 3;
						i++;
					}
					else
					if (ch == "*")			//			/*
					{
						nesting_level++;
						state = 4;
						i++;
					}
					else
					{
						i--;
						state = 0;
					}
				}	
				break;
				
				case 3:						// 		// comment
				{
					if (ch == "\n")
						state = 1;
									
					i++;			
				}
				break;
	
				case 4:						// 	/* comment
				{
					if (ch == "/")			//		/*	/
						state = 5;
					else
					if (ch == "*")			//		/*	*
						state = 6;
					
					i++;
				}	
				break;
	
				case 5:
				{
					if (ch == "*")			//		/*	/*
						nesting_level++;
					
					state = 4;
					i++;
				}	
				break;
	
				case 6:
				{
					if (ch != "*")			//		/*	**/
						state = 4;
					
					if (ch == "/")			//		/*	*/
					{
						nesting_level--;
	
						if (nesting_level == 0)
							state = 1;
					}
					
					i++;
				}
			}
		}
	}


	void process_newline( int include_file_level, string& s, int slen, int& i, int current_filenumber, int& current_line_number )
	{
		if (i > start_of_line_pos)
			ginput_text[current_filenumber][current_line_number] = ci_smid( s, start_of_line_pos, (i-start_of_line_pos) + 1 );
		else
			ginput_text[current_filenumber][current_line_number] = "";
						
		start_of_line_pos = i + 1;
		
		current_line_number++;
					
//		if (gshow_scan_trace)
//			print( "Input line: " + to_string( current_line_number ) + "<br>\n" );
	}
	
	
	void input_error( int error_number, string current_filename, int current_line_number, string text )
	{
		gerror_occured = true;
		
//		if (glast_error_line != current_line_number)
		{
			ci_print( "Error number: " + to_string( error_number ) + ": Line " + to_string( current_line_number ) + ": " + current_filename + ": " + text );

			ci_print( "<br>" );

			glast_error_line = current_line_number;
		}
		
//		if (syexit_on_first_error)
			exit(1);
	}	
	
