
//<? Turn on PHP editor syntax highlighting

using namespace std;

#include <string>
#include <iostream>

#include <stdio.h>
#include <execinfo.h>
#include <unistd.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>

#include "ci_calc.h"
#include "library.cpph"


#define DEBUG


//extern ci_var *sp;
//extern ci_var **sp2;
//extern int_64 ic_ptr;
extern int_64 offset;
extern int_64 push_flags;
extern int var_type;
extern ci_var *vptr;
extern ci_var *vptr_to;
extern ci_var *vptr_from;
extern ci_var *vptr_start;
extern ci_var *vptr_from_init;

extern int_64 peak_bytes_malloced;
extern int_64 curr_bytes_malloced;

extern int show_large_strings_warnings;


void ci_warning_only( int error_number, string text );


void ci_rarray_cp_item( rarray *rarray_ptr, rarray *rarray_prev, int_64 *curr_item, int sizeof2 );


ci_var *ci_rarray_calc_pos( rarray *rarray_ptr, int_64 *curr_item );

/*
void push_function_arg_int( int value )
{
	var_set_i( sp, value );
	
	sp++;	
}


void push_function_arg_decimal( int value )
{
	var_set_d( sp, value );
	
	sp++;	
}


void push_function_arg_double( double value )
{
	var_set_n( sp, value );
	
	sp++;	
}


void push_function_arg_string( char *str )
{
	var_set_s( sp, str );
	
	sp++;	
}


void push_function_arg_byreference( ci_var *value )
{
	var_set_p( sp, (char *) value );
	
	sp++;	
}


void pop_function_return_value( ci_var *ret_value )
{
	sp--;	
	
	copy_var( ret_value, sp );
}
*/

	void ci_op_setsize( int_64 element_size, string element_type )
	{
		int i;
		int number_dimensions;
		rarray *rarray_ptr;
		rarray *rarray_prev;
		int_64 num_items[ MAX_RARRAY_DIMENSIONS ];
		int_64 curr_item[ MAX_RARRAY_DIMENSIONS ];
		int curr_item_indx;
		int_64 total_size;
		char *ptr2;
		ci_var *vptr;
					
		number_dimensions = gruntime_data->sp->data.ivalue;

 		element_size *= sizeof( ci_var );
 
		if (number_dimensions >= MAX_RARRAY_DIMENSIONS)
			ci_runtime_error( 157, "Too many dimensions in array resize." );

		rarray_ptr = (rarray *) _ci_malloc( sizeof( rarray ) );
		
		rarray_ptr->number_of_dimensions = number_dimensions;
		
		rarray_ptr->sizeof_array_element = element_size;
		
		gruntime_data->sp--;
		
		total_size = 1;
		
		for (i=0; i < number_dimensions; i++)
		{
			if (gruntime_data->sp->data.ivalue < 0)
				ci_runtime_error( 158, "Negative array size in 'setsize'." );
		
			total_size *= gruntime_data->sp->data.ivalue;
		 
		 	rarray_ptr->index_size[i] = gruntime_data->sp->data.ivalue;
		 
			gruntime_data->sp--;
		}

		rarray_ptr->total_size = total_size * element_size;
					
		ptr2 = (char *) _ci_malloc( rarray_ptr->total_size ); 
		
		memset( ptr2, 0, rarray_ptr->total_size ); 

		rarray_ptr->datap = ptr2;
		
		vptr = (ci_var *) (gruntime_data->sp->data.pvalue);
		
		if (vptr->var_type == VAR_STRING && vptr->data.svalue != NULL && (! vptr->is_constant_string))
			_ci_free( vptr->data.svalue );

		if (vptr->var_type == VAR_BINARY && vptr->data.bvalue != NULL)
			_ci_free( vptr->data.bvalue );

		if (vptr->var_type == VAR_RESIZABLE_ARRAY)
		{
			rarray_prev = (rarray *) vptr->data.pvalue;

			if (rarray_ptr->number_of_dimensions == 1 && rarray_prev->number_of_dimensions == 1)
			{
				if (rarray_ptr->total_size >= rarray_prev->total_size)
					memcpy( rarray_ptr->datap, rarray_prev->datap, rarray_prev->total_size );
				else
					memcpy( rarray_ptr->datap, rarray_prev->datap, rarray_ptr->total_size );
			}
			else			
			if (rarray_ptr->number_of_dimensions == rarray_prev->number_of_dimensions)
			{
				for (i=0; i < rarray_ptr->number_of_dimensions; i++)
				{
				 	if (rarray_ptr->index_size[i] > rarray_prev->index_size[i])
				 	{
						num_items[i] = rarray_prev->index_size[i] - 1;
						curr_item[i] = rarray_prev->index_size[i] - 1;
					}
					else
					{
						num_items[i] = rarray_ptr->index_size[i] - 1;
						curr_item[i] = rarray_ptr->index_size[i] - 1;
					}
				}
				
		 		curr_item_indx = rarray_ptr->number_of_dimensions - 1;
			 	
			 	while (curr_item[0] >= 0)
			 	{
			 		ci_rarray_cp_item( rarray_ptr, rarray_prev, curr_item, sizeof( ci_var ) ); 
			 		
			 		curr_item[curr_item_indx]--;
			 		
			 		while (curr_item_indx > 0 && curr_item[curr_item_indx] < 0)
			 		{
			 			curr_item_indx--;
			 			
			 			curr_item[curr_item_indx]--;
			 		}
			 		
		 			curr_item_indx++;
		 			
		 			while (curr_item_indx < rarray_ptr->number_of_dimensions)
		 			{
			 			curr_item[curr_item_indx] = num_items[curr_item_indx];
			 			curr_item_indx++;
			 		}
			 		
			 		curr_item_indx = rarray_ptr->number_of_dimensions - 1;
			 	}
			} 
		}
		else
		{
			for (i=0; i < rarray_ptr->total_size; i += element_size)
			{
				init_data_type( (ci_var *) (rarray_ptr->datap + i), element_type );
			}		
		}

		vptr->var_type = VAR_RESIZABLE_ARRAY;
		vptr->data.pvalue = (char *) rarray_ptr;
	}


	void ci_rarray_cp_item( rarray *rarray_ptr, rarray *rarray_prev, int_64 *curr_item, int sizeof2 )
	{
		ci_var *vptr_src;
		ci_var *vptr_end;
		ci_var *vptr_dest;
		
		vptr_src = ci_rarray_calc_pos( rarray_prev, curr_item );
		
		vptr_dest = ci_rarray_calc_pos( rarray_ptr, curr_item );
	
		vptr_end = vptr_src + rarray_ptr->sizeof_array_element / sizeof( ci_var );
		
		while (vptr_src < vptr_end)
		{ 
			ci_copy_var( vptr_dest, vptr_src );
			
			vptr_src++;
			vptr_dest++;
		}
	}


	ci_var *ci_rarray_calc_pos( rarray *rarray_ptr, int_64 *curr_item )
	{
		int i;
		int_64 subarray_size;
		int number_dimensions;
		int_64 offset;
		
		number_dimensions = rarray_ptr->number_of_dimensions;
		
		offset = curr_item[0];
		
		subarray_size = 1;
					 
		for (i=1; i < number_dimensions; i++)
		{
			subarray_size *= rarray_ptr->index_size[i-1];

			offset += curr_item[i] * subarray_size;
		}

		return ((ci_var *) (&rarray_ptr->datap[offset * rarray_ptr->sizeof_array_element]));
	}

							
		void ci_copy_var( ci_var *vptr_dest, ci_var *vptr_src )
		{
			if (vptr_dest != vptr_src)
			{
				if (vptr_src->var_type == VAR_STRING)
				{
					if (show_large_strings_warnings)
					{
						if (vptr_src->data.svalue != NULL)
						{
							if (*((int_64 *) vptr_src->data.svalue) > 5000)
								ci_warning_only( 1093, "Large string copy will slow program performance" );
						}
					}
					
					ci_var_set_s_u32( vptr_dest, vptr_src->data.svalue, vptr_src->is_constant_string );
				}
				else
				if (vptr_src->var_type == VAR_BINARY)
					ci_var_set_b( vptr_dest, vptr_src );
				else
				if (vptr_src->var_type == VAR_RESIZABLE_ARRAY)
					ci_var_copy_rarray_p( vptr_dest, vptr_src, sizeof( ci_var ) );
				else 
				{			
					ci_free_curr_mem_1( vptr_dest );
	
					vptr_dest->var_type = vptr_src->var_type;
					
					vptr_dest->data = vptr_src->data;
				}
			}
		}
	
	
		void ci_copy_var_no_debug( ci_var *vptr_dest, ci_var *vptr_src )
		{
			if (vptr_dest != vptr_src)
			{
				if (vptr_src->var_type == VAR_STRING)
					ci_var_set_s_u32( vptr_dest, vptr_src->data.svalue, vptr_src->is_constant_string );
				else
				if (vptr_src->var_type == VAR_BINARY)
					ci_var_set_b( vptr_dest, vptr_src );
				else
				if (vptr_src->var_type == VAR_RESIZABLE_ARRAY)
					ci_var_copy_rarray_p( vptr_dest, vptr_src, sizeof( ci_var ) );
				else 
				{			
					ci_free_curr_mem_1( vptr_dest );
	
					vptr_dest->var_type = vptr_src->var_type;
					
					vptr_dest->data = vptr_src->data;
				}
			}
		}
	
/*	
	int isset( ci_var *vptr )
	{
		int stat;

		if (vptr->var_type == VAR_EMPTY)
			stat = 0;
		else
			stat = 1;

		return (stat);
	}

*/
	
	void ci_var_set_i( ci_var *vptr, int_64 n )
	{
		if (vptr->var_type != VAR_INT)
		{
			ci_free_curr_mem_1( vptr );

			vptr->var_type = VAR_INT;
		}
		
		vptr->data.ivalue = n;
	}

	void ci_var_set_d( ci_var *vptr, int_64 n )
	{
		if (vptr->var_type != VAR_DECIMAL)
		{
			ci_free_curr_mem_1( vptr );

			vptr->var_type = VAR_DECIMAL;
		}
		
		vptr->data.dvalue = n;
	}

	void ci_var_set_n( ci_var *vptr, double n )
	{
		if (vptr->var_type != VAR_DOUBLE)
		{
			ci_free_curr_mem_1( vptr );

			vptr->var_type = VAR_DOUBLE;
		}
		
		vptr->data.nvalue = n;
	}
	
	
	void ci_var_set_as_empty( ci_var *vptr )
	{
		ci_free_curr_mem_1( vptr );

		vptr->var_type = VAR_EMPTY;
	}
	


#define TMP_BUFFER	10000

	void ci_var_set_s( ci_var *vptr, const char *s )
	{
		int_64 len;
		char *s_u32;
		char str[4*TMP_BUFFER + sizeof( int_64 )];
		
		len = strlen( s );
		
		if (len < TMP_BUFFER)
			s_u32 = str;
		else
			s_u32 = (char *) _ci_malloc( len * 4 + sizeof( int_64 ) );
		
		ci_str_u8_to_u32( s_u32, s );
		
		ci_var_set_s_u32( vptr, s_u32, false );

		if (len >= TMP_BUFFER)
			_ci_free( s_u32 );
	}

	void ci_var_set_s_u32( ci_var *vptr, char *s, int is_constant_string )
	{
		int do_alloc;
		int_64 len, len2;

		if (vptr->var_type == VAR_BINARY && vptr->data.bvalue != NULL)
		{
			ci_free_curr_mem_1( vptr );
		}
		else
		if (vptr->var_type == VAR_RESIZABLE_ARRAY && vptr->data.pvalue != NULL)
		{
			ci_free_curr_mem_1( vptr );
		}

		len = *((int_64 *) s);
		
		if (vptr->var_type == VAR_STRING && vptr->data.svalue != NULL && (! vptr->is_constant_string))
		{
			len2 = *((int_64 *) (vptr->data.svalue));
			
			if (len > len2)
			{
				do_alloc = true;

				ci_free_curr_mem_1( vptr );
			}
			else
				do_alloc = false;
		}
		else
			do_alloc = true;
		
		if (is_constant_string)
			vptr->data.svalue = s;
		else
		{
			if (do_alloc)
				vptr->data.svalue = (char *) _ci_malloc( len + sizeof( int_64 ) );
	
			memcpy( vptr->data.svalue, s, len + sizeof( int_64 ) );
		}
				
		vptr->is_constant_string = is_constant_string;
		
		vptr->var_type = VAR_STRING;
	}
	
	
	void ci_var_set_b( ci_var *vptr, ci_var *vptr_src )
	{
		int_64 len1, len2;
		unsigned char *ptr;

		len1 = *((int_64 *) (vptr_src->data.bvalue));

		if (vptr->var_type == VAR_BINARY)
		{
			len2 = *((int_64 *) (vptr->data.bvalue));
		
			if (len1 > len2)
			{
				ptr = (unsigned char *) _ci_malloc( len1 + sizeof( int_64 ) );
			
				_ci_free( vptr->data.bvalue );

				vptr->data.bvalue = (unsigned char *) ptr;
			}
		}
		else
		{							
			ci_free_curr_mem_1( vptr );
	
			len1 = *((int_64 *) (vptr_src->data.bvalue));
					
			vptr->data.bvalue = (unsigned char *) _ci_malloc( len1 + sizeof( int_64 ) );
			
			vptr->var_type = VAR_BINARY;
		}

		memcpy( vptr->data.bvalue + sizeof( int_64 ), vptr_src->data.bvalue + sizeof( int_64 ), len1 );
					
		*((int_64 *) vptr->data.bvalue) = len1;
	}


	void ci_var_set_b_2( ci_var *vptr, char *bits, int num_bytes )
	{
		int_64 len1;

		ci_free_curr_mem_1( vptr );

		if (bits == 0)
			vptr->data.bvalue = NULL;
		else
		{
			vptr->data.bvalue = (unsigned char *) _ci_malloc( num_bytes + sizeof( int_64 ) );

			memcpy( vptr->data.bvalue + sizeof( int_64 ), bits, num_bytes );
			
			*((int_64 *) vptr->data.bvalue) = num_bytes;
		}

		vptr->var_type = VAR_BINARY;
	}


/*
	void var_clear_b( ci_var *vptr )
	{
		int_64 len1;
	
		ci_free_curr_mem_1( vptr );

		vptr->data.bvalue = NULL;

		vptr->var_type = VAR_BINARY;
	}
*/

	void ci_var_set_p( ci_var *vptr, void *ptr )
	{
		if (vptr->var_type != VAR_POINTER)
		{
			ci_free_curr_mem_1( vptr );

			vptr->var_type = VAR_POINTER;
		}
		
		vptr->data.pvalue = (char *) ptr;
	}
	

	void ci_free_curr_mem( ci_var *vptr, int sizeof_var, int_64 len )
	{
		ci_var *vptr_end;
		rarray *rarray_ptr;
		
		vptr_end = vptr + len / sizeof_var;

		while (vptr < vptr_end)
		{		 
			ci_free_curr_mem_1( vptr );
		
			vptr++;
		}
	}


	void ci_free_curr_mem_1( ci_var *vptr )
	{
		rarray *rarray_ptr;
		int_64 len;
		
		if (vptr->var_type == VAR_STRING && vptr->data.svalue != NULL && (! vptr->is_constant_string))
		{
			len = *((int_64 *) (vptr->data.svalue));
			
			_ci_free( vptr->data.svalue );
			
			vptr->data.svalue = NULL;
			
			vptr->var_type = VAR_EMPTY;
		}
		else
		if (vptr->var_type == VAR_BINARY && vptr->data.bvalue != NULL)
		{
			len = *((int_64 *) (vptr->data.bvalue));
			
			_ci_free( vptr->data.bvalue );
			
			vptr->data.bvalue = NULL;

			vptr->var_type = VAR_EMPTY;
		}
		else
		if (vptr->var_type == VAR_RESIZABLE_ARRAY && vptr->data.pvalue != NULL)
		{
			rarray_ptr = (rarray *) vptr->data.pvalue;
		
			ci_free_curr_mem( (ci_var *) rarray_ptr->datap, sizeof( ci_var ), rarray_ptr->total_size );
			
			_ci_free( rarray_ptr->datap );  
			
			_ci_free( vptr->data.pvalue );
			
			vptr->data.pvalue = NULL;

			vptr->var_type = VAR_EMPTY;
		}
	}


	void ci_warning_only( int error_number, string text )
	{
		void *bt[1000];
		char **ptr;
		int i;
		size_t size;
/*
		printf( "\nCall stack\n\n" );
				
		for (i=0; i < call_level; i++)
		{
			if (err_filename[i] != NULL)
				printf( "File: %s: Line number: %d\n", err_filename[i], err_linenumber[i] );
		}

		printf( "\n" );
*/				
		printf( "Runtime warning: %d: Line: %d: File: %s: %s<br>\n", error_number, 2, "", text.c_str() );

/*
		size = backtrace( bt, 1000 );

		ptr = backtrace_symbols( bt, size );

		for (i=0; i < size; i++)
			printf( "%s<br>", ptr[i] );
*/		
	}

	void ci_trim_trailing_zeros( char *s )
	{
		int_64 pos;

		if (index( s, '.') != NULL)
		{
			pos = strlen( s ) - 1;

			while (s[pos] == '0')
				pos--;

			if (s[pos] == '.')
				s[pos] = '\0';
			else
				s[pos+1] = '\0';
		}
	}

			// Convert a UTF-8 string to fixed width UTF-32

			// Returns the destination string length in bytes, excluding the 8 byte leading length value 
						
	int ci_str_u8_to_u32( char *dest, const char *src )
	{
		char *start;
		unsigned char *ptr;
		int count;
		int length;

		if (src == NULL)
		{
			printf( "NULL src in str_u8_to_u32" );
			exit(1);
		}

		if (dest == NULL)
		{
			printf( "NULL dest in str_u8_to_u32" );
			exit(1);
		}

		start = dest;

		dest += sizeof( int_64 );

		ptr = (unsigned char *) src;

		length = 0;

		while (*ptr != '\0')
		{
			if (((*ptr) & 0x80) == 0)		// ASCII character
			{
				*dest++ = *ptr++;
				*dest++ = '\0';
				*dest++ = '\0';
				*dest++ = '\0';
			}
			else
			{
				*dest++ = *ptr++;

				count = 1;

				while (((*ptr) & 0x80) != 0 && ((*ptr) & 0x40) == 0)
				{
					*dest++ = *ptr++;
					count++;
				} 

				while (count < 4)
				{
					*dest++ = '\0';
					count++;
				}
			}

			length += 4;
		}

		*((int_64 *) start) = length;

		return (length);
	}


			// Convert a fixed width UTF-32 string to a UTF-8

			// Returns the destination string length without the terminating '\0' 

	void ci_str_u32_to_u8( char *dest, const char *src, int dest_size )
	{
		char const *ptr;
		char const *lst;
		int_64 src_length;
		int_64 length;
		char *ptr2;
		
		if (src == NULL)
		{
			printf( "NULL src in str_u32_to_u8" );
			exit(1);
		}

		if (dest == NULL)
		{
			printf( "NULL dest in str_u32_to_u8" );
			exit(1);
		}
		
		src_length = *((int_64 *) src);
	
		if (src_length > dest_size-1)
			ci_runtime_error( 159, "Source value too large in str_u32_to_u8()." );
		
		ptr = src + sizeof( int_64 );

		lst = src + sizeof( int_64 ) + src_length;
		
		length = 0;
		
		ptr2 = dest;
				
		while (ptr < lst)
		{
			if (*ptr != '\0')
			{
				*dest++ = *ptr++;
				length++;
			}
			else
				ptr++;
		}
		
		*dest = '\0';
	}


		// Returns length of a UTF-32 string in bytes, excluding the 8 byte leading length value 
/*		
	int_64 str_u32_length( char *str )
	{
		return (*((int_64 *) str));
	}
*/

		// Returns 0 if two u32 strings are the same
		
	int ci_str_u32_cmp( char *str1, char *str2 )
	{
		int_64 len, len1, len2;
		int stat;
		
		len1 = *((int_64 *) str1);
		len2 = *((int_64 *) str2);

		len = len1;
		
		if (len > len2)
			len = len2;

		stat = memcmp( str1 + sizeof( int_64 ), str2 + sizeof( int_64 ), len );
		
		if (stat == 0)
		{
			if (len1 > len2)
				stat = 1;
			else
			if (len1 < len2)
				stat = -1;
		}

		return (stat);		
	}

		// Returns 1 if two u32 strings are the same
		
	int ci_str_u32_eq( char *str1, char *str2 )
	{
		int stat;
		
		stat = 0;

		if (*((int_64 *) str1) == *((int_64 *) str2))
		{
			if (memcmp( str1 + sizeof( int_64 ), str2 + sizeof( int_64 ), *((int_64 *) str1) ) == 0)
				stat = 1;
		}
		
		return (stat);		
	}
		
		
		
	void *_ci_malloc( int_64 size )
	{
		char *ptr;

//		curr_bytes_malloced += size;

//		if (curr_bytes_malloced > peak_bytes_malloced)
//			peak_bytes_malloced = curr_bytes_malloced;
			 
		ptr = (char *) malloc( size + sizeof( short ) );

		if (ptr == NULL)
			ci_runtime_error( 160, "Out of heap space." );

		*((short *) ptr) = 5678;
		
		return (ptr + sizeof( short ));
	}


	void _ci_free( void *ptr )
	{
		char *ptr2;
		
		ptr2 = (char *) ptr;
		
		ptr2 -= sizeof( short );
		
		if (*((short *) ptr2) == 6789)
		{
			printf( "Attempted free of already freed block" );
			exit( 1 );
		}

		if (*((short *) ptr2) != 5678)
		{
			printf( "Attempted free of non malloced block" );
			exit( 1 );
		}
	
		*((short *) ptr2) = 6789;
		
		free( ptr2 );
	}
	

	void ci_var_check_s( ci_var *vptr )
	{
		char str[100];
	
		if (vptr->var_type != VAR_STRING)
		{
			sprintf( str, "Invalid var_type in var_check_s, not a string. Possible uninitialised variable. Type: %d", vptr->var_type );
			
			ci_runtime_error( 161, str );
		}
	}


	void ci_var_copy_rarray_p( ci_var *vptr_dest, ci_var *vptr_src, int sizeof2 )
	{
		rarray *rarray_src;
		rarray *rarray_dest;
		int i;
		ci_var *ptr_src;
		ci_var *ptr_dest;
		ci_var *ptr_end;
		
		if (vptr_src->var_type != VAR_RESIZABLE_ARRAY)
			ci_runtime_error( 162, "Variable type is not a resizable array. Call 'setsize'." );
		
		if (vptr_dest->var_type == VAR_STRING && vptr_dest->data.svalue != NULL && (! vptr_dest->is_constant_string))
		{
			_ci_free( vptr_dest->data.svalue );
			vptr_dest->data.svalue = NULL;
		}

		if (vptr_dest->var_type == VAR_BINARY && vptr_dest->data.bvalue != NULL)
		{
			_ci_free( vptr_dest->data.bvalue );
			vptr_dest->data.bvalue = NULL;
		}

		rarray_src = (rarray *) vptr_src->data.pvalue;

		if (rarray_src == NULL)
			ci_runtime_error( 163, "Attempting to copy a NULL resizable array." );
		
		rarray_dest = (rarray *) _ci_malloc( sizeof( rarray ) );

		rarray_dest->datap = (char *) _ci_malloc( rarray_src->total_size );
	
		memset( rarray_dest->datap, 0, rarray_src->total_size ); 
	
		rarray_dest->number_of_dimensions = rarray_src->number_of_dimensions;
		rarray_dest->sizeof_array_element = rarray_src->sizeof_array_element;
		rarray_dest->total_size = rarray_src->total_size;
		
		for (i=0; i < rarray_src->number_of_dimensions; i++)
			rarray_dest->index_size[i] = rarray_src->index_size[i];

		ptr_src = (ci_var *) rarray_src->datap;
		ptr_dest = (ci_var *) rarray_dest->datap;
		ptr_end = ((ci_var *) rarray_src->datap) + rarray_src->total_size / sizeof( ci_var );
		
		while (ptr_src < ptr_end)   		
		{
			ci_copy_var( ptr_dest, ptr_src );
			
			ptr_src++;
			ptr_dest++;
		}

		vptr_dest->data.pvalue = (char *) rarray_dest;

		vptr_dest->var_type = VAR_RESIZABLE_ARRAY;
	}


	void ci_op_array_dereference_rtc()
	{
		int_64 number_dimensions;
		int_64 total_size;
		int_64 subarray_size;
		rarray *rarray_ptr;
		int i;

		number_dimensions = gruntime_data->sp->data.ivalue;

		gruntime_data->sp--;
	
		offset = gruntime_data->sp->data.ivalue;

		if (number_dimensions == 1)
		{
			if (((ci_var *) (((gruntime_data->sp - 1))->data.pvalue))->var_type != VAR_RESIZABLE_ARRAY)
				ci_runtime_error( 164, "Variable type is not a resizable array. Call 'setsize'." );

			gruntime_data->sp--;
				
			rarray_ptr = (rarray *) (((ci_var *) (gruntime_data->sp->data.pvalue))->data.pvalue);

			if (rarray_ptr == NULL)
				ci_runtime_error( 165, "NULL resizable array value." );
	
			if (rarray_ptr->number_of_dimensions != 1)
				ci_runtime_error( 166, "Mismatch in the number of array dimensions." );
										
			if (offset < 0)
				ci_runtime_error( 167, "Array negative index." );
					
			if (offset >= rarray_ptr->index_size[0])
				ci_runtime_error( 168, "Array bounds overflow." );
					
			gruntime_data->sp->data.pvalue = &rarray_ptr->datap[offset * rarray_ptr->sizeof_array_element];
		}
		else
		{
			if (((ci_var *) ((gruntime_data->sp - number_dimensions)->data.pvalue))->var_type != VAR_RESIZABLE_ARRAY)
				ci_runtime_error( 169, "Variable type is not a resizable array. Call 'setsize'." );
	
			rarray_ptr = (rarray *) (((ci_var *) ((gruntime_data->sp - number_dimensions)->data.pvalue))->data.pvalue);
	
			if (rarray_ptr == NULL)
				ci_runtime_error( 170, "NULL resizable array value." );
	
			if (rarray_ptr->number_of_dimensions != number_dimensions)
				ci_runtime_error( 171, "Mismatch in the number of array dimensions." );
														
			if (gruntime_data->sp->data.ivalue < 0)
				ci_runtime_error( 172, "Array negative index." );
					
			if (gruntime_data->sp->data.ivalue > rarray_ptr->index_size[0]-1)
				ci_runtime_error( 173, "Array bounds overflow." );
			
			subarray_size = 1;
	
			gruntime_data->sp--;
						 
			for (i=1; i < number_dimensions; i++)
			{
				if (gruntime_data->sp->data.ivalue < 0)
					ci_runtime_error( 174, "Array negative index." );
							
				if (gruntime_data->sp->data.ivalue >= rarray_ptr->index_size[i])
					ci_runtime_error( 175, "Array bounds overflow." );
			
				subarray_size *= rarray_ptr->index_size[i-1];
	
				offset += gruntime_data->sp->data.ivalue * subarray_size;
				
				gruntime_data->sp--;
			}
	
			gruntime_data->sp->data.pvalue = &rarray_ptr->datap[offset * rarray_ptr->sizeof_array_element];
		}		
	}


	void ci_op_array_dereference()
	{
		int_64 number_dimensions;
		int_64 total_size;
		int_64 subarray_size;
		rarray *rarray_ptr;
		int i;

		number_dimensions = gruntime_data->sp->data.ivalue;

		gruntime_data->sp--;
	
		offset = gruntime_data->sp->data.ivalue;

		if (number_dimensions == 1)
		{
			gruntime_data->sp--;

			rarray_ptr = (rarray *) ((ci_var *) gruntime_data->sp->data.pvalue)->data.pvalue;
	
			gruntime_data->sp->data.pvalue = &rarray_ptr->datap[offset * rarray_ptr->sizeof_array_element];
		}
		else
		{
			rarray_ptr = (rarray *) (((ci_var *)(gruntime_data->sp - number_dimensions)->data.pvalue)->data.pvalue);
	
			subarray_size = 1;
	
			gruntime_data->sp--;
						 
			for (i=1; i < number_dimensions; i++)
			{
				subarray_size *= rarray_ptr->index_size[i-1];
	
				offset += gruntime_data->sp->data.ivalue * subarray_size;
				
				gruntime_data->sp--;
			}
	
			gruntime_data->sp->data.pvalue = &rarray_ptr->datap[offset * rarray_ptr->sizeof_array_element];
		}
	}
	
	
	void _ci_op_strconcat()
	{
		ci_var *vptr;
		char *ptr;
		
		int_64 len1, len2, len3;
		
		vptr = gruntime_data->sp - 1;
	
		len1 = *((int_64 *) vptr->data.svalue);
		len2 = *((int_64 *) gruntime_data->sp->data.svalue);

		ptr = (char *) _ci_malloc( len1 + len2 + sizeof( int_64 ) );

		memcpy( ptr + sizeof( int_64 ), vptr->data.svalue + sizeof( int_64 ), len1 ); 
		memcpy( ptr + sizeof( int_64 ) + len1, gruntime_data->sp->data.svalue + sizeof( int_64 ), len2 ); 

		ci_free_curr_mem( vptr, sizeof( ci_var ), sizeof( ci_var ) );

		*((int_64 *) ptr) = len1 + len2;

		vptr->data.svalue = ptr;
		vptr->is_constant_string = false;
		vptr->var_type = VAR_STRING;
	}


	void _ci_op_strconcat_n_items_no_debug( int num_items )
	{
		ci_var *vptr;
		char *ptr, *ptr1;
		int_64 len, len1;
		int_64 i;
		
		vptr = gruntime_data->sp;
		
		len = *((int_64 *)vptr->data.svalue);
	
		for (i=1; i < num_items; i++)
		{
			vptr--;
			
			len += *((int_64 *)vptr->data.svalue);
		}

		ptr = (char *) _ci_malloc( len + sizeof( int_64 ) );
		
		ptr1 = ptr + sizeof( int_64 );
		
//		vptr = gruntime_data->sp - (num_items-1) * sizeof( ci_var );

		for (i=0; i < num_items; i++)
		{
			len1 = *((int_64 *)vptr->data.svalue);
			
			memcpy( ptr1, vptr->data.svalue + sizeof( int_64 ), len1 );
			
			ptr1 += len1;
			
			vptr++;
		}
	
		vptr = gruntime_data->sp - (num_items-1);
	
		ci_free_curr_mem( vptr, sizeof( ci_var ), sizeof( ci_var ) );

		*((int_64 *) ptr) = len;

		vptr->data.svalue = ptr;
		vptr->is_constant_string = false;
		vptr->var_type = VAR_STRING;
		
		if (num_items > 2)
			gruntime_data->sp -= (num_items-2);
	}


	void _ci_op_strconcat_n_items( int num_items )
	{
		ci_var *vptr;
		char *ptr, *ptr1;
		int_64 len, len1;
		int_64 i;
		
		vptr = gruntime_data->sp;
		
		ci_var_check_s( vptr );
		
		len = *((int_64 *) vptr->data.svalue);
	
		for (i=1; i < num_items; i++)
		{
			vptr--;
			
			ci_var_check_s( vptr );
			
			len += *((int_64 *)vptr->data.svalue);
		}

		ptr = (char *) _ci_malloc( len + sizeof( int_64 ) );
		
		ptr1 = ptr + sizeof( int_64 );
		
		vptr = gruntime_data->sp - (num_items-1);

		for (i=0; i < num_items; i++)
		{
			len1 = *((int_64 *)vptr->data.svalue);
			
			memcpy( ptr1, vptr->data.svalue + sizeof( int_64 ), len1 );
			
			ptr1 += len1;
			
			vptr++;
		}
	
		vptr = gruntime_data->sp - (num_items-1);
	
		ci_free_curr_mem( vptr, sizeof( ci_var ), sizeof( ci_var ) );

		*((int_64 *) ptr) = len;

		vptr->data.svalue = ptr;
		vptr->is_constant_string = false;
		vptr->var_type = VAR_STRING;
		
		if (num_items > 2)
			gruntime_data->sp -= (num_items-2);
	}

