<?php

//	define( "debug", true );
	define( "debug", false );

//	define( "speed_check", true );
	define( "speed_check", false );


			// (c) Copyright Mark McIlroy 2022

	function gen_c_code( &$parse_param, &$ic, &$ic_end, &$vars, $show_execution_trace, $initialise_variables, $runtime_checks, $include_output_comments )
	{
		load_arrays(	$parse_param, $ic, $ic_end, $vars,
						$ic_ops,
						$jump_address,
						$ic_value,
						$ic_type,
						$ic_size,
						$ic_text,
						$ic_error_text,
						$ic_line_number,
						$ic_input_filename,
						$ic_input_filenumber,
						$ic_argument_count,
						$ic_function_number,
						$ic_function_name,
						$local_variables_stackframe_size2,
						$function_arguments_stackframe_size2,
						$ic_return_variable_size,
						$call_addresses );

		$module_name = "main";

		for ($ic_ptr=0; $ic_ptr < $ic_end; $ic_ptr++)
		{
			if ($ic_ops[$ic_ptr] == OP_MODULE_NAME)
				$module_name = $ic_text[$ic_ptr];
		}

		if ($parse_param->output_filename != "")
			$output_filename = $parse_param->output_filename;
		else
		{
			$output_filename = $parse_param->main_input_filename;
	
					
			$pos = strrpos( $output_filename, "/" );
			
			if ($pos !== false)
				$output_filename = sright( $output_filename, strlen( $output_filename ) - $pos - 1 );
	
			$pos = strrpos( $output_filename, "." );
			
			if ($pos === false)
				$output_filename .= ".c";
			else
				$output_filename = sleft( $output_filename, $pos ).".c";

			$output_filename = "/home/aitkencv/public_html/calc/".$output_filename;
		}
		
		$fp = fopen( $output_filename, "w" );

		$op_descriptions = set_op_descriptions( $op_number_of_operands );

		fputs( $fp, "#include <stdio.h>\n" );
		fputs( $fp, "#include <stdlib.h>\n" );
		fputs( $fp, "#include <string.h>\n" );
		fputs( $fp, "#include <math.h>\n" );
		fputs( $fp, "#include \"/home/aitkencv/public_html/calc/calc.h\"\n" );
		fputs( $fp, "\n" );

		fputs( $fp, "\n" );

		fputs( $fp, "void *_malloc( int_64 size );" );
		fputs( $fp, "\n" );


		if ($parse_param->output_file_type == 'main')
			$ext = "";
		else 
			$ext = "extern ";
			
			
		fputs( $fp, $ext."char *stack_value;\n" );
		fputs( $fp, $ext."unsigned char *stack_value_flags;\n" );
		fputs( $fp, $ext."int_64 *stackframe_base;\n" );

		fputs( $fp, "\n" );

		fputs( $fp, $ext."int_64 ic_input_filenumber[".($ic_end+1)."];\n" );
		fputs( $fp, $ext."var *ic_init[".($ic_end+1)."];\n" );
		fputs( $fp, $ext."int_64 number_of_function_arguments;\n" );
		fputs( $fp, $ext."char *redirect_filename;\n" );
		fputs( $fp, $ext."int i1, i2, i3, i4, i5, i6, i7, i8, i9, i10;\n" );
		fputs( $fp, $ext."char *vptr, *vptr_from_init, *vptr_from, *vptr_to, *vptr_start, *vptr_end;\n" );
		fputs( $fp, $ext."var *arg1;\n" );
		fputs( $fp, $ext."var *arg2;\n" );
		fputs( $fp, $ext."var *arg3;\n" );
		fputs( $fp, $ext."var *arg4;\n" );
		fputs( $fp, $ext."var *arg5;\n" );
		fputs( $fp, $ext."var *arg6;\n" );
		fputs( $fp, $ext."var *arg7;\n" );
		fputs( $fp, $ext."var *arg8;\n" );
		fputs( $fp, $ext."var *arg9;\n" );
		fputs( $fp, $ext."var *arg10;\n" );
		fputs( $fp, $ext."var *arg11;\n" );
		fputs( $fp, $ext."int process_exit_code;\n" );
		
		fputs( $fp, "\n" );

		fputs( $fp, $ext."char *input_filenames[MAX_INPUT_FILES];\n" );

		fputs( $fp, $ext."int_64 i, j, k, sp, sp2, sp3, sp_from, sp_to, op;\n" );
		fputs( $fp, $ext."int_64 values_start, ic_ptr;\n" );
		fputs( $fp, $ext."int_64 call_level, line_number;\n" );
		fputs( $fp, $ext."int_64 stat, stat2;\n" );
		fputs( $fp, $ext."int_64 size, sp_end;\n" );
		fputs( $fp, $ext."int var_type;\n" );
		fputs( $fp, $ext."char *ptr;\n" );
		fputs( $fp, $ext."char small_str_buffer[200];\n" );
		fputs( $fp, $ext."char small_str_buffer2[200];\n" );
		fputs( $fp, $ext."char str_buffer[STRING_BUFFER_SIZE];\n" );
		fputs( $fp, $ext."var result;\n" );
		fputs( $fp, $ext."int_64 array_index_length;\n" );
		fputs( $fp, $ext."int_64 push_flags;\n" );
		fputs( $fp, $ext."int_64 return_value_starts;\n" );
		fputs( $fp, $ext."char *base;\n" );
		fputs( $fp, $ext."int_64 offset;\n" );
		fputs( $fp, $ext."int_64 count, len;\n" );
		fputs( $fp, $ext."char *function_name;\n" );
														
		
		fputs( $fp, "\n" );

		for ($j=0; $j < $vars['number_of_global_variables']; $j++)
		{
			fputs( $fp, "char *_calc_var_".$vars['global_variables'][$j]['name'].";\n" );
//			fputs( $fp, "int_64 _calc_var_".$vars['global_variables'][$j]['name']."_size;\n" );
		}
			
		fputs( $fp, "\n" );

		for ($i=0; $i < $parse_param->vars['number_of_user_functions']; $i++)
		{
			if (! $parse_param->vars['builtin_function'][$i])
				fputs( $fp, "void _user_function_".$parse_param->vars['function_name'][$i]."();\n" );
		}

		fputs( $fp, "\n" );
		fputs( $fp, $module_name."_setup_tables()\n" );
		fputs( $fp, "{\n" );

		fputs( $fp, "\tint_64 i;\n" );

		fputs( $fp, "\n" );

		fputs( $fp, "\n" );

		$item = 0;

		for ($j=0; $j < $vars['number_of_global_variables']; $j++)
		{
			if (sleft( $vars['global_variables'][$j]['size'], 6 ) == "array ")
			{
				fputs( $fp, "_calc_var_".$vars['global_variables'][$j]['name']." = _malloc( ".$vars['global_variables'][$j]['size']." + ".SIZEOF_VAR." );\n" );
	
				fputs( $fp, "*((int_64 *) &_calc_var_".$vars['global_variables'][$j]['name']."[0]) = ".$vars['global_variables'][$j]['size'].";\n" );
	
				fputs( $fp, "memset( &_calc_var_".$vars['global_variables'][$j]['name']."[".SIZEOF_VAR."], 0, ".$vars['global_variables'][$j]['size']." );\n" );
			}
			else
			{
				fputs( $fp, "_calc_var_".$vars['global_variables'][$j]['name']." = _malloc( ".$vars['global_variables'][$j]['size']." );\n" );

				fputs( $fp, "memset( _calc_var_".$vars['global_variables'][$j]['name'].", 0, ".$vars['global_variables'][$j]['size']." );\n" );
			}
		}
		

		fputs( $fp, "\n" );

		if ($parse_param->output_file_type == "main")
		{
			fputs( $fp, "\t\tmemset( (void *) stack_value, 0, STACK_SIZE_BYTES );\n" );
			fputs( $fp, "\t\tmemset( (void *) stack_value_flags, 0, STACK_SIZE_BYTES );\n" );
		}

		fputs( $fp, "\n" );
		fputs( $fp, "\n" );
		fputs( $fp, "\n" );

		for ($i=0; $i < $ic_end; $i++)
		{
//			if (isset( $jump_address[$i] )) 						fputs( $fp, "\tjump_address[".$i."] = ".$jump_address[$i].";\n" );

			if (gettype( $ic_value[$i] ) == 'string')
			{
				$s = $ic_value[$i];

				$s = str_replace( "\"", "\\\"", $s );
				$s = str_replace( "\n", "\\n", $s );
				$s = str_replace( "\t", "\\t", $s );
				$s = str_replace( "\r", "\\r", $s );

				$ic_value[$i] = $s;
			}

			if (isset( $ic_text[$i] ))
			{
				$s = $ic_text[$i];

				$s = str_replace( "\"", "\\\"", $s );
				$s = str_replace( "\n", "\\n", $s );
				$s = str_replace( "\t", "\\t", $s );
				$s = str_replace( "\r", "\\r", $s );

//				fputs( $fp, "\tic_text[".$i."] = \"".$s."\";\n" );
			}
		}

		fputs( $fp, "\n" );

		if ($initialise_variables)
		{
/*			
			for ($i=0; $i < $parse_param->vars['global_variables']['init_num_items']; $i++)
			{
				fputs( $fp, "\t((var *) &stack_value[".($i+1)." * SIZEOF_VAR])->var_type = VAR_EMPTY;\n" );
				fputs( $fp, "\t((var *) &stack_value[".($i+1)." * SIZEOF_VAR])->data.ivalue = 0;\n" );

				if ($parse_param->vars['global_variables']['init'][$i]['type'] == 'int')
					fputs( $fp, "\tvar_set_i( (var *) &stack_value[".($i+1)." * SIZEOF_VAR], ".$parse_param->vars['global_variables']['init'][$i]['value']." );\n" );
				else
				if ($parse_param->vars['global_variables']['init'][$i]['type'] == 'decimal')
					fputs( $fp, "\tvar_set_d( (var *) &stack_value[".($i+1)." * SIZEOF_VAR], ".$parse_param->vars['global_variables']['init'][$i]['value']." );\n" );
				else
				if ($parse_param->vars['global_variables']['init'][$i]['type'] == 'double')
					fputs( $fp, "\tvar_set_n( (var *) &stack_value[".($i+1)." * SIZEOF_VAR], ".$parse_param->vars['global_variables']['init'][$i]['value']." );\n" );
				else
				if ($parse_param->vars['global_variables']['init'][$i]['type'] == 'bool')
					fputs( $fp, "\tvar_set_i( (var *) &stack_value[".($i+1)." * SIZEOF_VAR], ".$parse_param->vars['global_variables']['init'][$i]['value']." );\n" );
				else
				if ($parse_param->vars['global_variables']['init'][$i]['type'] == 'link')
					fputs( $fp, "\tvar_set_i( (var *) &stack_value[".($i+1)." * SIZEOF_VAR], ".$parse_param->vars['global_variables']['init'][$i]['value']." );\n" );
				else
					fputs( $fp, "\tvar_set_s( (var *) &stack_value[ ".($i+1)." * SIZEOF_VAR], \"".$parse_param->vars['global_variables']['init'][$i]['value']."\", true );\n" );
			}
*/ 
		}


		fputs( $fp, "}\n" );

		gen_code2( $parse_param, $fp, $ic, $ic_end, $op_descriptions,
						$ic_ops,
						$jump_address,
						$ic_value,
						$ic_type,
						$ic_size,
						$ic_text,
						$ic_error_text,
						$ic_line_number,
						$ic_input_filename,
						$ic_input_filenumber,
						$ic_argument_count,
						$ic_function_number,
						$ic_function_name,
						$local_variables_stackframe_size2,
						$function_arguments_stackframe_size2,
						$ic_return_variable_size,
						$call_addresses,
						$initialise_variables,
						$runtime_checks,
						$op_number_of_operands,
						$module_name );

		fclose( $fp );
	}


function gen_code2( &$parse_param, $fp, $ic, $ic_end, $op_descriptions,
						$ic_ops,
						$jump_address,
						$ic_value,
						$ic_type,
						$ic_size,
						$ic_text,
						$ic_error_text,
						$ic_line_number,
						$ic_input_filename,
						$ic_input_filenumber,
						$ic_argument_count,
						$ic_function_number,
						$ic_function_name,
						$local_variables_stackframe_size2,
						$function_arguments_stackframe_size2,
						$ic_return_variable_size,
						$call_addresses,
						$initialise_variables,
						$runtime_checks,
						$op_number_of_operands,
						$module_name )
{

	$count = 0;
	$error_item = 1;

	for ($ic_ptr=0; $ic_ptr < $ic_end; $ic_ptr++)
	{
		if ($ic_ops[$ic_ptr] == OP_INCLUDE_C)
			fputs( $fp, $ic_text[$ic_ptr]."\n" );
	}

	if ($parse_param->output_file_type == "main")
	{
		fputs( $fp, "int main( int argc, char *argv[] )\n" );
		fputs( $fp, "{\n" );
	
		fputs( $fp, "\n" );
		fputs( $fp, "char *ptr1, *ptr2;\n" );
	
		fputs( $fp, "stack_value = 		 _malloc( STACK_SIZE_BYTES );\n" );
		fputs( $fp, "stack_value_flags = _malloc( STACK_SIZE_BYTES );\n" );
		fputs( $fp, "stackframe_base =   _malloc( MAX_NESTED_FUNCTION_CALLS * sizeof( int_64 ) );\n" );
	
		fputs( $fp, "sp = 0;\n" );
		fputs( $fp, "\n" );
	
		fputs( $fp, "stackframe_base[0] = sp;\n" );
		fputs( $fp, "ic_ptr = 0;\n" );
		fputs( $fp, "call_level = 0;\n" );
		fputs( $fp, "line_number = 0;\n" );
		fputs( $fp, "count = 0;\n" );
		fputs( $fp, "process_exit_code = 0;\n" );
			
	
		fputs( $fp, "\n" );
	
		fputs( $fp, $module_name."_setup_tables();\n" );
		
		for ($ic_ptr=0; $ic_ptr < $ic_end; $ic_ptr++)
		{
			if ($ic_ops[$ic_ptr] == OP_LINK_MODULE)
				fputs( $fp, $ic_text[$ic_ptr]."_setup_tables();\n" );
		}
		
		fputs( $fp, "\n" );
	
		fputs( $fp, "ptr1 = argv[1];\n" );
		fputs( $fp, "ptr2 = argv[2];\n" );
	
		fputs( $fp, "if (argc < 3)\n" );
		fputs( $fp, "{\n" );
		fputs( $fp, "    ptr1 = \"/home/aitkencv/public_html/accounts/get_and_post/reports_p_and_l_get_and_post.txt\";\n" );
		fputs( $fp, "    ptr2 = \".\";\n" );
		fputs( $fp, "}\n" );
		fputs( $fp, "\n" );
	
		fputs( $fp, "\tredirect_filename = ptr2;\n" );
	
		fputs( $fp, "\tcalc_stdlib_init( ptr1 );\n" );
	
		fputs( $fp, "\n" );
	}

	fputs( $fp, "\n" );

	$in_user_function = false;

	if (speed_check)
	{
		fputs( $fp, "
		struct timeval time;

		gettimeofday(&time, NULL);

		long microsec1 = ((unsigned long long)time.tv_sec * 1000000) + time.tv_usec;
		" );
	}


	for ($level=1; $level <= 2; $level++)
	{
		$in_user_function = false;

		for ($ic_ptr=0; $ic_ptr < $ic_end; $ic_ptr++)
		{
			$count++;

			$error_item++;

			$op = $ic_ops[$ic_ptr];

			if ( ($op == OP_RETURN && $level == 2) ||
				 ($level == 1 && ! $in_user_function) ||
				 ($level == 2 && $in_user_function))
			{
				if ($runtime_checks)
				{
					$num_operands = $op_number_of_operands[$op];

					if ($num_operands >= 1)
					{
						
					fputs( $fp, "		

							check_var_1( ".$error_item.", ".$ic_ptr.", \"".$op_descriptions[$op]."\" );
					" );

						$error_item++;
					}

					if ($num_operands >= 2)
					{
						
					fputs( $fp, "
							
							check_var_2( ".$error_item.", ".$ic_ptr.", \"".$op_descriptions[$op]."\" );
					" );

						$error_item++;
					}

					if ($num_operands >= 3)
					{
						
					fputs( $fp, "
								
							check_var_3( ".$error_item.", ".$ic_ptr.", \"".$op_descriptions[$op]."\" );
					" );

						$error_item++;
					}

					if ($num_operands >= 4)
					{
						
					fputs( $fp, "		

							check_var_4( ".$error_item.", ".$ic_ptr.", \"".$op_descriptions[$op]."\" );
					" );

						$error_item++;
					}
				}

				if (debug)
					fputs( $fp, "printf( \"Op item: %d\\n\", ".$ic_ptr." );\n\n" );

				if ($parse_param->include_output_comments)
				{
					$s = $parse_param->input_text[$ic_input_filenumber[$ic_ptr]][$ic_line_number[$ic_ptr]];

					$s = str_replace( "\n", "", $s );

					fputs( $fp, "\n// Line ".$ic_line_number[$ic_ptr].": ".$s."\n" );
				}
			}

			if ($op == OP_START_FUNCTION)
			{
				$in_user_function = true;

				if ($level == 2)
				{
					fputs( $fp, "\n// ".$op_descriptions[$op]."\n\n" );

					fputs( $fp, "// Ic_ptr ".$ic_ptr."\n\n" );

					fputs( $fp, "

						void _user_function_".$ic_function_name[$ic_ptr]."()
						{

						sp += ".SIZEOF_VAR.";

					" );


					if ($runtime_checks)
					{
						fputs( $fp, "

						if (sp + ".$local_variables_stackframe_size2[$ic_ptr]." > STACK_SIZE_BYTES - STACK_SIZE_BUFFER_BYTES)
							runtime_error( ".$ic_line_number[$ic_ptr].", \"".$parse_param->input_filenames[$ic_input_filenumber[$ic_ptr]]."\", ".$error_item.", ".$ic_ptr.", 103, \"Stack overflow\", \"\" );
						
						" );
					}

					if ($local_variables_stackframe_size2[$ic_ptr] > 0)
					{
						fputs( $fp, "
									
							memset( (void *) &stack_value_flags[sp], 0, ".$local_variables_stackframe_size2[$ic_ptr].");

						" );

						fputs( $fp, "\t sp += ".$local_variables_stackframe_size2[$ic_ptr].";	" );
						
					}
							
	/*						
							for ($i=0; $i < $local_variables_stackframe_size2[$ic_ptr]; $i += SIZEOF_VAR)
							{
								if ($initialise_variables)
								{
									
									$j = $i / SIZEOF_VAR;
									
									if ($parse_param->vars['local_variables'][$ic[$ic_ptr]['function_number']]['init'][$j]['type'] == 'int')
										fputs( $fp, "\tvar_set_i( (var *) &stack_value[sp], ".$parse_param->vars['local_variables'][$ic[$ic_ptr]['function_number']]['init'][$j]['value']." );\n" );
									else
									if ($parse_param->vars['local_variables'][$ic[$ic_ptr]['function_number']]['init'][$j]['type'] == 'decimal')
										fputs( $fp, "\tvar_set_d( (var *) &stack_value[sp], ".$parse_param->vars['local_variables'][$ic[$ic_ptr]['function_number']]['init'][$j]['value']." );\n" );
									else
									if ($parse_param->vars['local_variables'][$ic[$ic_ptr]['function_number']]['init'][$j]['type'] == 'double')
										fputs( $fp, "\tvar_set_n( (var *) &stack_value[sp], ".$parse_param->vars['local_variables'][$ic[$ic_ptr]['function_number']]['init'][$j]['value']." );\n" );
									else
									if ($parse_param->vars['local_variables'][$ic[$ic_ptr]['function_number']]['init'][$j]['type'] == 'bool')
										fputs( $fp, "\tvar_set_i( (var *) &stack_value[sp], ".$parse_param->vars['local_variables'][$ic[$ic_ptr]['function_number']]['init'][$j]['value']." );\n" );
									else
									if ($parse_param->vars['local_variables'][$ic[$ic_ptr]['function_number']]['init'][$j]['type'] == 'link')
										fputs( $fp, "\tvar_set_i( (var *) &stack_value[sp], ".$parse_param->vars['local_variables'][$ic[$ic_ptr]['function_number']]['init'][$j]['value']." );\n" );
									else
										fputs( $fp, "\tvar_set_s( (var *) &stack_value[sp], \"".$parse_param->vars['local_variables'][$ic[$ic_ptr]['function_number']]['init'][$j]['value']."\", true );\n" );
								}
	
								fputs( $fp, "
	
									stack_value_flags[sp] = 0;
	
									sp += SIZEOF_VAR;
	
								" );
							}
	*/ 
//						}
/*
						else
						{
							if ($local_variables_stackframe_size2[$ic_ptr] > 0)
							{
								fputs( $fp, "
											
									memset( (void *) &stack_value_flags[sp], 0, ".$local_variables_stackframe_size2[$ic_ptr].");
		
									sp += ".$local_variables_stackframe_size2[$ic_ptr].";
		
								" );
							}
	
	//								fputs( $fp, "copy_var( (var *) &stack_value[sp], &ic_init[".$ic_ptr."][i], ".$error_item.", ic_ptr ); " );
*/
				}
			}
			else
			if ($op == OP_RETURN)
			{
				if ($level == 2)
				{
					fputs( $fp, "\n// ".$op_descriptions[$op]."\n\n" );

					fputs( $fp, "// Ic_ptr ".$ic_ptr."\n\n" );

					$found = false;

					for ($j=0; $j < $ic_end; $j++)
					{
						if ($jump_address[$j] == $ic_ptr)
							$found = true;
					}

					if ($found && $ic_ptr != 0)
						fputs( $fp, "\nC_".$ic_ptr.":\n\n" );

	//					if (show_execution_trace)
	//						printf( \"%s\\n\", \"return from \".vars['function_name'][ic_value[".$ic_ptr."]];

					fputs( $fp, "

						if (sp != stackframe_base[call_level] + ".$local_variables_stackframe_size2[$ic_ptr]." + ".SIZEOF_VAR.")
							runtime_error( ".$ic_line_number[$ic_ptr].", \"".$parse_param->input_filenames[$ic_input_filenumber[$ic_ptr]]."\", ".$error_item.", ".$ic_ptr.", 183, \"Stack not empty on return from function\", \"\" );

						sp -= ".$local_variables_stackframe_size2[$ic_ptr].";

						return_value_starts = sp;

						sp -= ".SIZEOF_VAR.";

//						return_address = ((var *) &stack_value[sp])->data.ivalue;

						sp -= ".$function_arguments_stackframe_size2[$ic_ptr]."; " );

						if ($ic_return_variable_size[$ic_ptr] > 0)
						{
							
							fputs( $fp, "

								vptr_from = &stack_value[return_value_starts];
										
								vptr_to = &stack_value[sp];
								
								vptr_start = vptr_to;
							 " );

							$type = $ic_type[$ic_ptr];
								
							gen_bulk_copy( $parse_param, $fp, $type, 1, $error_item, $ic_ptr );
							

							fputs( $fp, "

								sp += vptr_to - vptr_start;
										
							 " );
						}

						fputs( $fp, "

							call_level--;

						}

						" );

					$error_item++;
				}

				$in_user_function = false;
		}
		else
		if (($level == 1 && ! $in_user_function) || ($level == 2 && $in_user_function))
		{
			if ($parse_param->include_output_comments)
			{
				fputs( $fp, "\n// ".$op_descriptions[$op]."\n\n" );

				fputs( $fp, "// Ic_ptr ".$ic_ptr."\n\n" );
			}

			$found = false;

			for ($j=0; $j < $ic_end; $j++)
			{
				if ($jump_address[$j] == $ic_ptr)
					$found = true;
			}

			if ($found && $ic_ptr != 0)
				fputs( $fp, "\nC_".$ic_ptr.":\n\n" );

			if (debug)
			{
				fputs( $fp, "\nprintf( \"SP: %d: \", sp );\n" );
				fputs( $fp, "printf( \"".$op_descriptions[$op].": \");\n" );
				fputs( $fp, "printf( \"".$ic_value[$ic_ptr]."\\n\" );\n\n" );
			}

			if (speed_check)
				fputs( $fp, "count++;\n" );


				switch ($op)
				{
	 				case OP_JMP_FALSE_DONT_POP:

					fputs( $fp, "

						if (((var *) &stack_value[sp - ".SIZEOF_VAR."])->data.ivalue == 0)
							goto C_".$jump_address[$ic_ptr].";

					" );

					break;
					case OP_JMP_TRUE_DONT_POP:

					fputs( $fp, "

						if (((var *) &stack_value[sp - ".SIZEOF_VAR."])->data.ivalue != 0)
							goto C_".$jump_address[$ic_ptr].";

					" );

					break;
					case OP_JMP_FALSE:

					fputs( $fp, "

						sp -= ".SIZEOF_VAR.";

						if (((var *) &stack_value[sp])->data.ivalue == 0)
							goto C_".$jump_address[$ic_ptr].";

					" );

					break;
					case OP_JMP_TRUE:

					fputs( $fp, "

						sp -= ".SIZEOF_VAR.";

						if (((var *) &stack_value[sp])->data.ivalue != 0)
							goto C_".$jump_address[$ic_ptr].";

					" );

					break;
					case OP_POP_JMP_GE:

					fputs( $fp, "

						sp -= ".SIZEOF_VAR.";

						if (((var *) &stack_value[sp - ".SIZEOF_VAR."])->data.ivalue >= ((var *) &stack_value[sp])->data.ivalue)
							goto C_".$jump_address[$ic_ptr].";

					" );

					break;
					case OP_POP_JMP_LT:

					fputs( $fp, "

						sp -= ".SIZEOF_VAR.";

						if (((var *) &stack_value[sp - ".SIZEOF_VAR."])->data.ivalue < ((var *) &stack_value[sp])->data.ivalue)
							goto C_".$jump_address[$ic_ptr].";

					 " );

					break;
					case OP_POP_JMP_GT:

					fputs( $fp, "

						sp -= ".SIZEOF_VAR.";

						if (((var *) &stack_value[sp - ".SIZEOF_VAR."])->data.ivalue > ((var *) &stack_value[sp])->data.ivalue)
							goto C_".$jump_address[$ic_ptr].";

					" );

					break;
					case OP_POP_JMP_LE:

					fputs( $fp, "

						sp -= ".SIZEOF_VAR.";

						if (((var *) &stack_value[sp - ".SIZEOF_VAR."])->data.ivalue <= ((var *) &stack_value[sp])->data.ivalue)
							goto C_".$jump_address[$ic_ptr].";

					" );

					break;
					case OP_JMP:

					fputs( $fp, "

						goto C_".$jump_address[$ic_ptr].";

					" );


							//--------------------------------------------------------
							// Push and Pop
					 		//--------------------------------------------------------

					break;

					case OP_PUSH_ABS_ADDR_BASE:

						fputs( $fp, "

							var_set_p( (var *) &stack_value[sp], _calc_var_".$ic_text[$ic_ptr]." );

							stack_value_flags[sp] = 0;

							sp += ".SIZEOF_VAR.";

						" );

					break;
					
					case OP_PUSH_REL_ADDR_BASE:

					fputs( $fp, "

						if (call_level == -1)
							runtime_error( ".$ic_line_number[$ic_ptr].", \"".$parse_param->input_filenames[$ic_input_filenumber[$ic_ptr]]."\", ".$error_item.", ".$ic_ptr.", 108, \"Internal error: REL address outside a function\", \"\" );

							
						sp2 = stackframe_base[call_level] + (int) ".$ic_value[$ic_ptr].";		// base of variable

										
						if (stack_value_flags[sp2] == 1)
						{
							vptr = ((var *) &stack_value[sp2])->data.pvalue;
							stack_value_flags[sp] = 1;
						}	
						else
						{
							vptr = &stack_value[sp2];
							stack_value_flags[sp] = 0;
						}
							
						var_set_p( (var *) &stack_value[sp], vptr );

						sp += ".SIZEOF_VAR.";

					" );

					break;

					case OP_PUSH_REL_VARIABLE_ADDR:

					fputs( $fp, "

						sp -= ".SIZEOF_VAR.";

						offset = ((var *) &stack_value[sp])->data.ivalue;						// offset within the variable

						sp -= ".SIZEOF_VAR.";

						vptr = ((var *) &stack_value[sp])->data.pvalue;

						var_set_p( (var *) &stack_value[sp], vptr + offset );

						sp += ".SIZEOF_VAR.";

					" );

					break;
					
					case OP_SET_INDIRECTION_FLAG:

					fputs( $fp, "

						stack_value_flags[sp - ".SIZEOF_VAR."] = 1;

					" );

					break;
					
					case OP_PUSH_VAR:
						
					$size = $ic_size[$ic_ptr];
						
					fputs( $fp, "
						
						size = ".$size.";

						" );
										
					if ($runtime_checks)
					{
						fputs( $fp, "

						if (sp + ".$size." > STACK_SIZE_BYTES - STACK_SIZE_BUFFER_BYTES)
							runtime_error( ".$ic_line_number[$ic_ptr].", \"".$parse_param->input_filenames[$ic_input_filenumber[$ic_ptr]]."\", ".$error_item.", ".$ic_ptr.", 103, \"Stack overflow\", \"\" );
						
						" );
					}

					fputs( $fp, "
				
						sp -= ".SIZEOF_VAR.";
				
						push_flags = ((var *) &stack_value[sp])->data.ivalue;
				
						sp -= ".SIZEOF_VAR.";
						
						vptr_from = ((var *) &stack_value[sp])->data.pvalue;
								
						vptr_from_init = vptr_from;
						
						if (push_flags != 0)
							pre_inc( vptr_from, push_flags, ".$error_item.", ".$ic_ptr." );

										
						vptr_to = &stack_value[sp];
								
						vptr_start = vptr_to;
						
						stack_value_flags[sp] = 0;
				
					 " );

						$type = $ic_type[$ic_ptr];
								
						gen_bulk_copy( $parse_param, $fp, $type, 1, $error_item, $ic_ptr );
							
					
						fputs( $fp, "
				
							sp += vptr_to - vptr_start;
														
							if (push_flags != 0)
								post_inc( vptr_from_init, push_flags, ".$error_item.", ".$ic_ptr." );
	
						" );

					break;
					case OP_POP_VAR:

					$size = $ic_size[$ic_ptr];
 											
					fputs( $fp, "

						size = ".$size.";
						
						values_start = sp - ".$size.";

						sp -= (".$size." + ".SIZEOF_VAR.");

						vptr_to = ((var *) &stack_value[sp])->data.pvalue;				// addr
						
						vptr_from = &stack_value[values_start];
							
						 " );

						$type = $ic_type[$ic_ptr];
							
						gen_bulk_copy( $parse_param, $fp, $type, 1, $error_item, $ic_ptr );
							

					break;
					case OP_BULK_COPY:
					
					$size = $ic_size[$ic_ptr];
						
					fputs( $fp, "

						size = ".$size.";
						
						sp -= ".SIZEOF_VAR.";
						
						vptr_from = ((var *) &stack_value[sp])->data.pvalue;
						
						sp -= ".SIZEOF_VAR.";
	
						vptr_to = ((var *) &stack_value[sp])->data.pvalue;

						" );						

						$type = $ic_type[$ic_ptr];
															
						gen_bulk_copy( $parse_param, $fp, $type, 1, $error_item, $ic_ptr );
					
					break;
					
					case OP_INC_SP:

						fputs( $fp, "

							sp += ".$ic_value[$ic_ptr].";

						" );

					break;
										
					case OP_POP_DISCARD:

					fputs( $fp, "

						sp -= ".SIZEOF_VAR.";

						sp -= ((var *) &stack_value[sp])->data.ivalue;				// num_to_dis;

					" );

					break;

					case OP_PUSH_CONST_INT:
				
						fputs( $fp, "	var_set_i( (var *) &stack_value[sp], ".$ic_value[$ic_ptr]." );

							stack_value_flags[sp] = 0;
						
							sp += ".SIZEOF_VAR.";

						" );
					
					break;
					
					case OP_PUSH_0:
				
						fputs( $fp, "	var_set_i( (var *) &stack_value[sp], 0 );

							stack_value_flags[sp] = 0;
						
							sp += ".SIZEOF_VAR.";

						" );
					
					break;

					case OP_PUSH_1:
				
						fputs( $fp, "	var_set_i( (var *) &stack_value[sp], 1 );

							stack_value_flags[sp] = 0;
						
							sp += ".SIZEOF_VAR.";

						" );
					
					break;

					case OP_PUSH_CONST_DECIMAL:
					
							fputs( $fp, "	var_set_d( (var *) &stack_value[sp], (long int) (round( (double) ".$ic_value[$ic_ptr]." * (double) VAR_DECIMAL_SCALE ) ) );

							stack_value_flags[sp] = 0;

							sp += ".SIZEOF_VAR.";

						" );
					
					break;


					case OP_PUSH_CONST_DOUBLE:
				
							fputs( $fp, "	var_set_n( (var *) &stack_value[sp], ".$ic_value[$ic_ptr]." );

							stack_value_flags[sp] = 0;
							
							sp += ".SIZEOF_VAR.";

						" );
					
					break;
					
					case OP_PUSH_CONST_STRING:
					case OP_PUSH_CONST_BOOL:
					case OP_PUSH_CONST_BINARY:
					case OP_PUSH_CONST_DATE:
					case OP_PUSH_CONST_TIME:
					case OP_PUSH_CONST_DATETIME:

						fputs( $fp, "	var_set_s( (var *) &stack_value[sp], \"".$ic_value[$ic_ptr]."\", true );

							stack_value_flags[sp] = 0;
						
							sp += ".SIZEOF_VAR.";

						" );

					break;

							//--------------------------------------------------------
							// VAR_INC, VAR_DEC
							//--------------------------------------------------------
							
					case OP_VAR_INC:
						
					fputs( $fp, "
						
							sp -= ".SIZEOF_VAR.";
							
							vptr = ((var *) &stack_value[sp])->data.pvalue;
							
							var_type = ((var *) vptr)->var_type;
							
							if (var_type == VAR_INT)
							{
								((var *) vptr)->data.ivalue++;
							}
							else
							if (var_type == VAR_DECIMAL)
							{
								((var *) vptr)->data.dvalue += VAR_DECIMAL_SCALE;
							}
							else
							if (var_type == VAR_DOUBLE)
							{
								((var *) vptr)->data.nvalue++;
							}
	
						" );

					break;

					case OP_VAR_DEC:
						
					fputs( $fp, "
						
							sp -= ".SIZEOF_VAR.";
							
							vptr = ((var *) &stack_value[sp])->data.pvalue;
							
							var_type = ((var *) vptr)->var_type;
							
							if (var_type == VAR_INT)
							{
								((var *) vptr)->data.ivalue--;
							}
							else
							if (var_type == VAR_DECIMAL)
							{
								((var *) vptr)->data.dvalue -= VAR_DECIMAL_SCALE;
							}
							else
							if (var_type == VAR_DOUBLE)
							{
								((var *) vptr)->data.nvalue--;
							}
	
						" );

					break;
							//--------------------------------------------------------
							// Numeric type conversions
					 		//--------------------------------------------------------

					break;
					case OP_CONV_INT_TO_DECIMAL:

					if ($runtime_checks)
						fputs( $fp, "

							check_param_type( stack_value, sp - ".$ic_value[$ic_ptr].", VAR_INT, ".$ic_line_number[$ic_ptr].", \"".$parse_param->input_filenames[$ic_input_filenumber[$ic_ptr]]."\", ".$error_item.", ".$ic_ptr.", 200, \"Conversion from int is not an int type\" );
						
					" );

					fputs( $fp, "

						var_set_d( (var *) &stack_value[sp- ".$ic_value[$ic_ptr]."], (long int) ((var *) &stack_value[sp- ".$ic_value[$ic_ptr]."])->data.ivalue * VAR_DECIMAL_SCALE);

					" );


					break;
					case OP_CONV_DECIMAL_TO_DOUBLE:

					if ($runtime_checks)
						fputs( $fp, "

						check_param_type( stack_value, sp - ".$ic_value[$ic_ptr].", VAR_DECIMAL, ".$ic_line_number[$ic_ptr].", \"".$parse_param->input_filenames[$ic_input_filenumber[$ic_ptr]]."\", ".$error_item.", ".$ic_ptr.", 201, \"Conversion from decimal is not a decimal type\" );
						
					" );

					fputs( $fp, "

						var_set_n( (var *) &stack_value[sp- ".$ic_value[$ic_ptr]."], (double) (((var *) &stack_value[sp- ".$ic_value[$ic_ptr]."])->data.dvalue / (double) VAR_DECIMAL_SCALE) );

					" );

					break;
					case OP_CONV_INT_TO_DOUBLE:

					if ($runtime_checks)
						fputs( $fp, "

						check_param_type( stack_value, sp - ".$ic_value[$ic_ptr].", VAR_INT, ".$ic_line_number[$ic_ptr].", \"".$parse_param->input_filenames[$ic_input_filenumber[$ic_ptr]]."\", ".$error_item.", ".$ic_ptr.", 202, \"Conversion from int is not an int type\" );
						
					" );

					fputs( $fp, "

						var_set_n( (var *) &stack_value[sp- ".$ic_value[$ic_ptr]."], (double) ((var *) &stack_value[sp- ".$ic_value[$ic_ptr]."])->data.ivalue );

					" );

					break;
					case OP_CONV_DECIMAL_TO_INT:

					if ($runtime_checks)
						fputs( $fp, "

						check_param_type( stack_value, sp - ".$ic_value[$ic_ptr].", VAR_DECIMAL, ".$ic_line_number[$ic_ptr].", \"".$parse_param->input_filenames[$ic_input_filenumber[$ic_ptr]]."\", ".$error_item.", ".$ic_ptr.", 203, \"Conversion from decimal is not a decimal type\" );
						
					" );

					fputs( $fp, "

						var_set_i( (var *) &stack_value[sp- ".$ic_value[$ic_ptr]."], (int) (round( ((var *) &stack_value[sp- ".$ic_value[$ic_ptr]."])->data.dvalue / (double) VAR_DECIMAL_SCALE) ));

					" );

					break;
					case OP_CONV_DOUBLE_TO_INT:

					if ($runtime_checks)
						fputs( $fp, "

						check_param_type( stack_value, sp - ".$ic_value[$ic_ptr].", VAR_DOUBLE, ".$ic_line_number[$ic_ptr].", \"".$parse_param->input_filenames[$ic_input_filenumber[$ic_ptr]]."\", ".$error_item.", ".$ic_ptr.", 204, \"Conversion from double is not a double type\" );
						
					" );

					fputs( $fp, "

						var_set_i( (var *) &stack_value[sp- ".$ic_value[$ic_ptr]."], (int) ((var *) &stack_value[sp- ".$ic_value[$ic_ptr]."])->data.nvalue );

					" );

					break;
					case OP_CONV_DOUBLE_TO_DECIMAL:

					if ($runtime_checks)
						fputs( $fp, "

						check_param_type( stack_value, sp - ".$ic_value[$ic_ptr].", VAR_DOUBLE, ".$ic_line_number[$ic_ptr].", \"".$parse_param->input_filenames[$ic_input_filenumber[$ic_ptr]]."\", ".$error_item.", ".$ic_ptr.", 205, \"Conversion from double is not a double type\" );

					" );

					fputs( $fp, "

						var_set_d( (var *) &stack_value[sp- ".$ic_value[$ic_ptr]."], (long int) round( (double) ((var *) &stack_value[sp- ".$ic_value[$ic_ptr]."])->data.nvalue * (double) VAR_DECIMAL_SCALE ) );

					" );

							//--------------------------------------------------------
							// Conversions to string and binary
					 		//--------------------------------------------------------

					break;
					case OP_CONV_BOOL_TO_STRING:

					if ($runtime_checks)
						fputs( $fp, "

						check_param_type( stack_value, sp - ".$ic_value[$ic_ptr].", VAR_INT, ".$ic_line_number[$ic_ptr].", \"".$parse_param->input_filenames[$ic_input_filenumber[$ic_ptr]]."\", ".$error_item.", ".$ic_ptr.", 206, \"Conversion from int is not an int type\" );
						
					" );

					fputs( $fp, "

						if (((var *) &stack_value[sp - ".SIZEOF_VAR."])->data.ivalue == 0)
							var_set_s( (var *) &stack_value[sp - ".SIZEOF_VAR."], \"false\", true );
						else
							var_set_s( (var *) &stack_value[sp - ".SIZEOF_VAR."], \"true\", true );

					" );

					break;
					case OP_CONV_LINK_TO_STRING:

					fputs( $fp, "

						strcpy( small_str_buffer, \"<link to \" );

						sprintf( small_str_buffer2, \"%lf\", ((var *) &stack_value[sp - ".SIZEOF_VAR."])->data.ivalue );

						strcat( small_str_buffer, small_str_buffer2 );

						strcat( small_str_buffer, \">\" );

						var_set_s( (var *) &stack_value[sp - ".SIZEOF_VAR."], small_str_buffer, false );

					" );

					break;
					case OP_CONV_STRING_TO_BINARY:


					break;
					case OP_CONV_INT_TO_STRING:

					if ($runtime_checks)
						fputs( $fp, "

						check_param_type( stack_value, sp - ".$ic_value[$ic_ptr].", VAR_INT, ".$ic_line_number[$ic_ptr].", \"".$parse_param->input_filenames[$ic_input_filenumber[$ic_ptr]]."\", ".$error_item.", ".$ic_ptr.", 207, \"Conversion from int is not an int type\" );
						
					" );

					fputs( $fp, "

						sprintf( small_str_buffer, \"%d\", ((var *) &stack_value[sp - ".SIZEOF_VAR."])->data.ivalue );

						var_set_s( (var *) &stack_value[sp - ".SIZEOF_VAR."], small_str_buffer, false );

						" );

					break;
					case OP_CONV_DECIMAL_TO_STRING:

					if ($runtime_checks)
						fputs( $fp, "

						check_param_type( stack_value, sp - ".$ic_value[$ic_ptr].", VAR_DECIMAL, ".$ic_line_number[$ic_ptr].", \"".$parse_param->input_filenames[$ic_input_filenumber[$ic_ptr]]."\", ".$error_item.", ".$ic_ptr.", 208, \"Conversion from decimal is not a decimal type\" );
						
					" );

					fputs( $fp, "

						sprintf( small_str_buffer, \"%2.2lf\", ((var *) &stack_value[sp - ".SIZEOF_VAR."])->data.dvalue / (double) VAR_DECIMAL_SCALE );

						trim_trailing_zeros( small_str_buffer );

						var_set_s( (var *) &stack_value[sp - ".SIZEOF_VAR."], small_str_buffer, false );

						" );

					break;
					case OP_CONV_DOUBLE_TO_STRING:

					if ($runtime_checks)
						fputs( $fp, "

						check_param_type( stack_value, sp - ".$ic_value[$ic_ptr].", VAR_DOUBLE, ".$ic_line_number[$ic_ptr].", \"".$parse_param->input_filenames[$ic_input_filenumber[$ic_ptr]]."\", ".$error_item.", ".$ic_ptr.", 209, \"Conversion from double is not a double type\" );
						
					" );

					fputs( $fp, "

						sprintf( small_str_buffer, \"%lf\", ((var *) &stack_value[sp - ".SIZEOF_VAR."])->data.nvalue );

						trim_trailing_zeros( small_str_buffer );

						var_set_s( (var *) &stack_value[sp - ".SIZEOF_VAR."], small_str_buffer, false );

						" );

					break;
					case OP_CONV_BINARY_TO_STRING:
					case OP_CONV_DATE_TO_STRING:
					case OP_CONV_TIME_TO_STRING:
					case OP_CONV_DATETIME_TO_STRING:


					fputs( $fp, "

						" );

					break;

								//--------------------------------------------------------
								// Boolean operators and, or, not
								//--------------------------------------------------------

					case OP_AND:
	
					fputs( $fp, "

						if (((var *) &stack_value[sp - 2 * ".SIZEOF_VAR."])->data.ivalue!= 0 && ((var *) &stack_value[sp - ".SIZEOF_VAR."])->data.ivalue != 0)
							var_set_i( (var *) &stack_value[sp - 2 * ".SIZEOF_VAR."], 1 );
						else
							var_set_i( (var *) &stack_value[sp - 2 * ".SIZEOF_VAR."], 0 );

						sp -= ".SIZEOF_VAR.";

					" );

					break;
					case OP_OR:

					fputs( $fp, "

						if (((var *) &stack_value[sp - 2 * ".SIZEOF_VAR."])->data.ivalue != 0 || ((var *) &stack_value[sp - ".SIZEOF_VAR."])->data.ivalue != 0)
							var_set_i( (var *) &stack_value[sp - 2 * ".SIZEOF_VAR."], 1 );
						else
							var_set_i( (var *) &stack_value[sp - 2 * ".SIZEOF_VAR."], 0 );

						sp -= ".SIZEOF_VAR.";

					" );

					break;
					case OP_NOT:

					fputs( $fp, "

						if (((var *) &stack_value[sp - ".SIZEOF_VAR."])->data.ivalue == 1)
							var_set_i( (var *) &stack_value[sp - ".SIZEOF_VAR."], 0 );
						else
							var_set_i( (var *) &stack_value[sp - ".SIZEOF_VAR."], 1 );

					" );


							//--------------------------------------------------------
					 		// Relational operators =, !=, <, >, <=, >=
							//--------------------------------------------------------

					break;
					case OP_EQ_INT:
					case OP_EQ_BOOL:
					case OP_EQ_LINK:

					fputs( $fp, "

						if (((var *) &stack_value[sp - 2 * ".SIZEOF_VAR."])->data.ivalue == ((var *) &stack_value[sp - ".SIZEOF_VAR."])->data.ivalue)
							stat = 1;
						else
							stat = 0;

						var_set_i( (var *) &stack_value[sp - 2 * ".SIZEOF_VAR."], stat );

						sp -= ".SIZEOF_VAR.";

					" );

					break;
					case OP_EQ_DECIMAL:
	
					fputs( $fp, "

						stat = 0;
						
						if (((var *) &stack_value[sp - 2 * ".SIZEOF_VAR."])->data.dvalue == ((var *) &stack_value[sp - ".SIZEOF_VAR."])->data.dvalue)
							stat = 1;

						var_set_i( (var *) &stack_value[sp - 2 * ".SIZEOF_VAR."], stat );

						sp -= ".SIZEOF_VAR.";

					" );

					break;
					case OP_EQ_DOUBLE:

					fputs( $fp, "

						stat = 0;

						if (((var *) &stack_value[sp - ".SIZEOF_VAR."])->data.nvalue == 0)
						{
							if (fabs(((var *) &stack_value[sp-2])->data.nvalue - ((var *) &stack_value[sp - ".SIZEOF_VAR."])->data.nvalue) < 0.0000000000001)
								stat = 1;
						}
						else
						if (fabs( (((var *) &stack_value[sp - 2 * ".SIZEOF_VAR."])->data.nvalue / ((var *) &stack_value[sp - ".SIZEOF_VAR."])->data.nvalue) - 1) < 0.0000000000001)
							stat = 1;

						var_set_i( (var *) &stack_value[sp - 2 * ".SIZEOF_VAR."], stat );

						sp -= ".SIZEOF_VAR.";

					" );

					break;
					case OP_EQ_DATE_AND_TIME:
					case OP_EQ_STRING:
					case OP_EQ_BINARY:

					if ($runtime_checks)
					{
						fputs( $fp, "
	
							var_check_s( (var *) &stack_value[sp - ".SIZEOF_VAR."], ".$error_item.", ".$ic_ptr." );
							var_check_s( (var *) &stack_value[sp - 2 * ".SIZEOF_VAR."], ".$error_item.", ".$ic_ptr." );
						
						" );
					}										
					
					fputs( $fp, "

						if (strcmp( ((var *) &stack_value[sp - 2 * ".SIZEOF_VAR."])->data.svalue, ((var *) &stack_value[sp - ".SIZEOF_VAR."])->data.svalue ) == 0)
							stat = 1;
						else
							stat = 0;

						var_set_i( (var *) &stack_value[sp - 2 * ".SIZEOF_VAR."], stat );

						sp -= ".SIZEOF_VAR.";

					" );

					break;
					case OP_NE_INT:
					case OP_NE_BOOL:
					case OP_NE_LINK:

					fputs( $fp, "

						if (((var *) &stack_value[sp - 2 * ".SIZEOF_VAR."])->data.ivalue != ((var *) &stack_value[sp - ".SIZEOF_VAR."])->data.ivalue)
							stat = 1;
						else
							stat = 0;

						var_set_i( (var *) &stack_value[sp - 2 * ".SIZEOF_VAR."], stat );

						sp -= ".SIZEOF_VAR.";

					" );

					break;
					case OP_NE_DECIMAL:
	
					fputs( $fp, "

						stat = 0;
						
						if (((var *) &stack_value[sp - 2 * ".SIZEOF_VAR."])->data.dvalue != ((var *) &stack_value[sp - ".SIZEOF_VAR."])->data.dvalue)
							stat = 1;

						var_set_i( (var *) &stack_value[sp - 2 * ".SIZEOF_VAR."], stat );

						sp -= ".SIZEOF_VAR.";

					" );

					break;
					case OP_NE_DOUBLE:

					fputs( $fp, "

						stat = 0;

						if (((var *) &stack_value[sp - ".SIZEOF_VAR."])->data.nvalue == 0)
						{
							if (fabs(((var *) &stack_value[sp - 2 * ".SIZEOF_VAR."])->data.nvalue - ((var *) &stack_value[sp - ".SIZEOF_VAR."])->data.nvalue) > 0.0000000000001)
								stat = 1;
						}
						else
						if (fabs( (((var *) &stack_value[sp - 2 * ".SIZEOF_VAR."])->data.nvalue / ((var *) &stack_value[sp - ".SIZEOF_VAR."])->data.nvalue) - 1) > 0.0000000000001)
							stat = 1;

						var_set_i( (var *) &stack_value[sp - 2 * ".SIZEOF_VAR."], stat );

						sp -= ".SIZEOF_VAR.";

					" );

					break;
					case OP_NE_DATE_AND_TIME:
					case OP_NE_STRING:
					case OP_NE_BINARY:

					if ($runtime_checks)
					{
						fputs( $fp, "

							var_check_s( (var *) &stack_value[sp - ".SIZEOF_VAR."], ".$error_item.", ".$ic_ptr." );
							var_check_s( (var *) &stack_value[sp - 2 * ".SIZEOF_VAR."], ".$error_item.", ".$ic_ptr." );
	
						" );
					}
						
					fputs( $fp, "

						if (strcmp( ((var *) &stack_value[sp - 2 * ".SIZEOF_VAR."])->data.svalue, ((var *) &stack_value[sp - ".SIZEOF_VAR."])->data.svalue ) != 0)
							stat = 1;
						else
							stat = 0;
	

						var_set_i( (var *) &stack_value[sp - 2 * ".SIZEOF_VAR."], stat );

						sp -= ".SIZEOF_VAR.";

					" );

					break;
					case OP_LE_INT:

					fputs( $fp, "

						if (((var *) &stack_value[sp - 2 * ".SIZEOF_VAR."])->data.ivalue <= ((var *) &stack_value[sp - ".SIZEOF_VAR."])->data.ivalue)
							stat = 1;
						else
							stat = 0;

						var_set_i( (var *) &stack_value[sp - 2 * ".SIZEOF_VAR."], stat );

						sp -= ".SIZEOF_VAR.";

					" );

					break;
					case OP_LE_DECIMAL:

					fputs( $fp, "

						if (((var *) &stack_value[sp - 2 * ".SIZEOF_VAR."])->data.dvalue <= ((var *) &stack_value[sp - ".SIZEOF_VAR."])->data.dvalue)
							stat = 1;
						else
							stat = 0;

						var_set_i( (var *) &stack_value[sp - 2 * ".SIZEOF_VAR."], stat );

						sp -= ".SIZEOF_VAR.";

					" );

					break;
					case OP_LE_DOUBLE:

					fputs( $fp, "

						if (((var *) &stack_value[sp - 2 * ".SIZEOF_VAR."])->data.nvalue <= ((var *) &stack_value[sp - ".SIZEOF_VAR."])->data.nvalue)
							stat = 1;
						else
							stat = 0;

						var_set_i( (var *) &stack_value[sp - 2 * ".SIZEOF_VAR."], stat );

						sp -= ".SIZEOF_VAR.";

					" );

					break;
					case OP_LE_DATE_AND_TIME:
					case OP_LE_STRING:

					if ($runtime_checks)
					{
						fputs( $fp, "

							var_check_s( (var *) &stack_value[sp - ".SIZEOF_VAR."], ".$error_item.", ".$ic_ptr." );
							var_check_s( (var *) &stack_value[sp - 2 * ".SIZEOF_VAR."], ".$error_item.", ".$ic_ptr." );

						" );
					}	
					
					fputs( $fp, "

						if (strcmp( ((var *) &stack_value[sp - 2 * ".SIZEOF_VAR."])->data.svalue, ((var *) &stack_value[sp - ".SIZEOF_VAR."])->data.svalue ) <= 0)
							stat = 1;
						else
							stat = 0;

						var_set_i( (var *) &stack_value[sp - 2 * ".SIZEOF_VAR."], stat );

						sp -= ".SIZEOF_VAR.";

					" );

					break;
					case OP_LT_INT:

					fputs( $fp, "

						if (((var *) &stack_value[sp - 2 * ".SIZEOF_VAR."])->data.ivalue < ((var *) &stack_value[sp - ".SIZEOF_VAR."])->data.ivalue)
							stat = 1;
						else
							stat = 0;

						var_set_i( (var *) &stack_value[sp - 2 * ".SIZEOF_VAR."], stat );

						sp -= ".SIZEOF_VAR.";

					" );

					break;
					case OP_LT_DECIMAL:

					fputs( $fp, "

						if (((var *) &stack_value[sp - 2 * ".SIZEOF_VAR."])->data.dvalue < ((var *) &stack_value[sp - ".SIZEOF_VAR."])->data.dvalue)
							stat = 1;
						else
							stat = 0;

						var_set_i( (var *) &stack_value[sp - 2 * ".SIZEOF_VAR."], stat );

						sp -= ".SIZEOF_VAR.";

					" );

					break;
					case OP_LT_DOUBLE:

					fputs( $fp, "

						if (((var *) &stack_value[sp - 2 * ".SIZEOF_VAR."])->data.nvalue < ((var *) &stack_value[sp - ".SIZEOF_VAR."])->data.nvalue)
							stat = 1;
						else
							stat = 0;

						var_set_i( (var *) &stack_value[sp - 2 * ".SIZEOF_VAR."], stat );

						sp -= ".SIZEOF_VAR.";

					" );

					break;
					case OP_LT_DATE_AND_TIME:
					case OP_LT_STRING:

					if ($runtime_checks)
					{
						fputs( $fp, "

							var_check_s( (var *) &stack_value[sp - ".SIZEOF_VAR."], ".$error_item.", ".$ic_ptr." );
							var_check_s( (var *) &stack_value[sp - 2 * ".SIZEOF_VAR."], ".$error_item.", ".$ic_ptr." );
							
						" );
					}
					
					fputs( $fp, "

						if (strcmp( ((var *) &stack_value[sp - 2 * ".SIZEOF_VAR."])->data.svalue, ((var *) &stack_value[sp - ".SIZEOF_VAR."])->data.svalue ) < 0)
							stat = 1;
						else
							stat = 0;

						var_set_i( (var *) &stack_value[sp - 2 * ".SIZEOF_VAR."], stat );

						sp -= ".SIZEOF_VAR.";

					" );

					break;
					case OP_GE_INT:

					fputs( $fp, "

						if (((var *) &stack_value[sp - 2 * ".SIZEOF_VAR."])->data.ivalue >= ((var *) &stack_value[sp - ".SIZEOF_VAR."])->data.ivalue)
							stat = 1;
						else
							stat = 0;

						var_set_i( (var *) &stack_value[sp - 2 * ".SIZEOF_VAR."], stat );

						sp -= ".SIZEOF_VAR.";

					" );

					break;
					case OP_GE_DECIMAL:

					fputs( $fp, "

						if (((var *) &stack_value[sp - 2 * ".SIZEOF_VAR."])->data.dvalue >= ((var *) &stack_value[sp - ".SIZEOF_VAR."])->data.dvalue)
							stat = 1;
						else
							stat = 0;

						var_set_i( (var *) &stack_value[sp - 2 * ".SIZEOF_VAR."], stat );

						sp -= ".SIZEOF_VAR.";

					" );

					break;
					case OP_GE_DOUBLE:

					fputs( $fp, "

						if (((var *) &stack_value[sp - 2 * ".SIZEOF_VAR."])->data.nvalue >= ((var *) &stack_value[sp - ".SIZEOF_VAR."])->data.nvalue)
							stat = 1;
						else
							stat = 0;

						var_set_i( (var *) &stack_value[sp - 2 * ".SIZEOF_VAR."], stat );

						sp -= ".SIZEOF_VAR.";

					" );

					break;
					case OP_GE_DATE_AND_TIME:
					case OP_GE_STRING:

					if ($runtime_checks)
					{
						fputs( $fp, "

							var_check_s( (var *) &stack_value[sp - ".SIZEOF_VAR."], ".$error_item.", ".$ic_ptr." );
							var_check_s( (var *) &stack_value[sp - 2 * ".SIZEOF_VAR."], ".$error_item.", ".$ic_ptr." );
							
						" );
					}
					
					fputs( $fp, "

						if (strcmp( ((var *) &stack_value[sp - 2 * ".SIZEOF_VAR."])->data.svalue, ((var *) &stack_value[sp - ".SIZEOF_VAR."])->data.svalue ) >= 0)
							stat = 1;
						else
							stat = 0;

						var_set_i( (var *) &stack_value[sp - 2 * ".SIZEOF_VAR."], stat );

						sp -= ".SIZEOF_VAR.";

					" );

					break;
					case OP_GT_INT:

					fputs( $fp, "

						if (((var *) &stack_value[sp - 2 * ".SIZEOF_VAR."])->data.ivalue > ((var *) &stack_value[sp - ".SIZEOF_VAR."])->data.ivalue)
							stat = 1;
						else
							stat = 0;

						var_set_i( (var *) &stack_value[sp - 2 * ".SIZEOF_VAR."], stat );

						sp -= ".SIZEOF_VAR.";

					" );

					break;
					case OP_GT_DECIMAL:

					fputs( $fp, "

						if (((var *) &stack_value[sp - 2 * ".SIZEOF_VAR."])->data.dvalue > ((var *) &stack_value[sp - ".SIZEOF_VAR."])->data.dvalue)
							stat = 1;
						else
							stat = 0;

						var_set_i( (var *) &stack_value[sp - 2 * ".SIZEOF_VAR."], stat );

						sp -= ".SIZEOF_VAR.";

					" );

					break;
					case OP_GT_DOUBLE:

					fputs( $fp, "

						if (((var *) &stack_value[sp - 2 * ".SIZEOF_VAR."])->data.nvalue > ((var *) &stack_value[sp - ".SIZEOF_VAR."])->data.nvalue)
							stat = 1;
						else
							stat = 0;

						var_set_i( (var *) &stack_value[sp - 2 * ".SIZEOF_VAR."], stat );

						sp -= ".SIZEOF_VAR.";

					" );

					break;
					case OP_GT_DATE_AND_TIME:
					case OP_GT_STRING:

					if ($runtime_checks)
					{
						fputs( $fp, "

							var_check_s( (var *) &stack_value[sp - ".SIZEOF_VAR."], ".$error_item.", ".$ic_ptr." );
							var_check_s( (var *) &stack_value[sp - 2 * ".SIZEOF_VAR."], ".$error_item.", ".$ic_ptr." );
							
						" );
					}
					
					fputs( $fp, "

						if (strcmp( ((var *) &stack_value[sp - 2 * ".SIZEOF_VAR."])->data.svalue, ((var *) &stack_value[sp - ".SIZEOF_VAR."])->data.svalue ) > 0)
							stat = 1;
						else
							stat = 0;

						var_set_i( (var *) &stack_value[sp - 2 * ".SIZEOF_VAR."], stat );

						sp -= ".SIZEOF_VAR.";

					" );

							//--------------------------------------------------------
							// String concatenation
					 		//--------------------------------------------------------

					break;
					case OP_STRCONCAT:

					if ($runtime_checks)
					{
						fputs( $fp, "

							var_check_s( (var *) &stack_value[sp - ".SIZEOF_VAR."], ".$error_item.", ".$ic_ptr." );
							var_check_s( (var *) &stack_value[sp - 2 * ".SIZEOF_VAR."], ".$error_item.", ".$ic_ptr." );
							
						" );
					}
										
					fputs( $fp, "

						sp -= ".SIZEOF_VAR.";

						len = strlen( ((var *) &stack_value[sp - ".SIZEOF_VAR."])->data.svalue ) + strlen( ((var *) &stack_value[sp])->data.svalue ) + 1;

						if (len >= STRING_BUFFER_SIZE-1)
							ptr = _malloc( len );
						else
							ptr = str_buffer;

						strcpy( ptr, ((var *) &stack_value[sp - ".SIZEOF_VAR."])->data.svalue );
						strcat( ptr, ((var *) &stack_value[sp])->data.svalue );

						var_set_s( (var *) &stack_value[sp - ".SIZEOF_VAR."], ptr, false );

						if (len >= STRING_BUFFER_SIZE-1)
							free( ptr );

					" );

							//--------------------------------------------------------
							// Arithmetic operators +, -, *, /, ^, mod
					 		//--------------------------------------------------------

					break;
					case OP_ADD_INT:

					fputs( $fp, "

						sp -= ".SIZEOF_VAR.";
	
					" );
					
					if ($runtime_checks)
					{
						fputs( $fp, "

							check_param_type( stack_value, sp - ".SIZEOF_VAR.", VAR_INT, ".$ic_line_number[$ic_ptr].", \"".$parse_param->input_filenames[$ic_input_filenumber[$ic_ptr]]."\", ".$error_item.", ".$ic_ptr.", 216, \"Operand type is not an int\" );
						
							check_param_type( stack_value, sp, VAR_INT, ".$ic_line_number[$ic_ptr].", \"".$parse_param->input_filenames[$ic_input_filenumber[$ic_ptr]]."\", ".$error_item.", ".$ic_ptr.", 216, \"Operand type is not an int\" );
						
						" );
					
						$error_item ++;
					}
	
					fputs( $fp, "

						((var *) &stack_value[sp - ".SIZEOF_VAR."])->data.ivalue = ((var *) &stack_value[sp - ".SIZEOF_VAR."])->data.ivalue + ((var *) &stack_value[sp])->data.ivalue;

					" );

					break;
					case OP_ADD_TO_POINTER:

					fputs( $fp, "

						sp -= ".SIZEOF_VAR.";
	
					" );
					
					if ($runtime_checks)
					{
						fputs( $fp, "

							check_param_type( stack_value, sp - ".SIZEOF_VAR.", VAR_POINTER, ".$ic_line_number[$ic_ptr].", \"".$parse_param->input_filenames[$ic_input_filenumber[$ic_ptr]]."\", ".$error_item.", ".$ic_ptr.", 216, \"Operand type is not a pointer\" );
						
							check_param_type( stack_value, sp, VAR_INT, ".$ic_line_number[$ic_ptr].", \"".$parse_param->input_filenames[$ic_input_filenumber[$ic_ptr]]."\", ".$error_item.", ".$ic_ptr.", 216, \"Operand type is not an int\" );
								
						" );
					
						$error_item ++;
					}
	
					fputs( $fp, "

						((var *) &stack_value[sp - ".SIZEOF_VAR."])->data.pvalue = ((var *) &stack_value[sp - ".SIZEOF_VAR."])->data.pvalue + ((var *) &stack_value[sp])->data.ivalue;

					" );

					break;
					case OP_ADD_DECIMAL:

					fputs( $fp, "

						sp -= ".SIZEOF_VAR.";
	
					" );
	
					if ($runtime_checks)
					{
						fputs( $fp, "

								check_param_type( stack_value, sp - ".SIZEOF_VAR.", VAR_DECIMAL, ".$ic_line_number[$ic_ptr].", \"".$parse_param->input_filenames[$ic_input_filenumber[$ic_ptr]]."\", ".$error_item.", ".$ic_ptr.", 216, \"Operand type is not a decimal\" );
						
								check_param_type( stack_value, sp, VAR_DECIMAL, ".$ic_line_number[$ic_ptr].", \"".$parse_param->input_filenames[$ic_input_filenumber[$ic_ptr]]."\", ".$error_item.", ".$ic_ptr.", 216, \"Operand type is not a decimal\" );
								
						" );
					
						$error_item ++;
					}
	
					fputs( $fp, "

						((var *) &stack_value[sp - ".SIZEOF_VAR."])->data.dvalue = ((var *) &stack_value[sp - ".SIZEOF_VAR."])->data.dvalue + ((var *) &stack_value[sp])->data.dvalue;

					" );

					break;
					case OP_ADD_DOUBLE:

					fputs( $fp, "

						sp -= ".SIZEOF_VAR.";
	
					" );

	
					if ($runtime_checks)
					{
						fputs( $fp, "

							check_param_type( stack_value, sp - ".SIZEOF_VAR.", VAR_DOUBLE, ".$ic_line_number[$ic_ptr].", \"".$parse_param->input_filenames[$ic_input_filenumber[$ic_ptr]]."\", ".$error_item.", ".$ic_ptr.", 216, \"Operand type is not a double\" );
						
							check_param_type( stack_value, sp, VAR_DOUBLE, ".$ic_line_number[$ic_ptr].", \"".$parse_param->input_filenames[$ic_input_filenumber[$ic_ptr]]."\", ".$error_item.", ".$ic_ptr.", 216, \"Operand type is not a double\" );

						" );
					
						$error_item ++;
					}
	
					fputs( $fp, "

						((var *) &stack_value[sp - ".SIZEOF_VAR."])->data.nvalue = ((var *) &stack_value[sp - ".SIZEOF_VAR."])->data.nvalue + ((var *) &stack_value[sp])->data.nvalue;

					" );

					break;
					case OP_SUBTRACT_INT:

					fputs( $fp, "

						sp -= ".SIZEOF_VAR.";
	
					" );
	
					if ($runtime_checks)
					{
						fputs( $fp, "

							check_param_type( stack_value, sp - ".SIZEOF_VAR.", VAR_INT, ".$ic_line_number[$ic_ptr].", \"".$parse_param->input_filenames[$ic_input_filenumber[$ic_ptr]]."\", ".$error_item.", ".$ic_ptr.", 216, \"Operand type is not an int\" );
						
							check_param_type( stack_value, sp, VAR_INT, ".$ic_line_number[$ic_ptr].", \"".$parse_param->input_filenames[$ic_input_filenumber[$ic_ptr]]."\", ".$error_item.", ".$ic_ptr.", 216, \"Operand type is not an int\" );
								
						" );
					
						$error_item ++;
					}
	
					fputs( $fp, "

						((var *) &stack_value[sp - ".SIZEOF_VAR."])->data.ivalue = ((var *) &stack_value[sp - ".SIZEOF_VAR."])->data.ivalue - ((var *) &stack_value[sp])->data.ivalue;

					" );

					break;
					case OP_SUBTRACT_DECIMAL:

					fputs( $fp, "

						sp -= ".SIZEOF_VAR.";
	
					" );

					if ($runtime_checks)
					{
						fputs( $fp, "

							check_param_type( stack_value, sp - ".SIZEOF_VAR.", VAR_DECIMAL, ".$ic_line_number[$ic_ptr].", \"".$parse_param->input_filenames[$ic_input_filenumber[$ic_ptr]]."\", ".$error_item.", ".$ic_ptr.", 216, \"Operand type is not a decimal\" );
						
							check_param_type( stack_value, sp, VAR_DECIMAL, ".$ic_line_number[$ic_ptr].", \"".$parse_param->input_filenames[$ic_input_filenumber[$ic_ptr]]."\", ".$error_item.", ".$ic_ptr.", 216, \"Operand type is not a decimal\" );
								
						" );
					
						$error_item ++;
					}
	
					fputs( $fp, "

						((var *) &stack_value[sp - ".SIZEOF_VAR."])->data.dvalue = ((var *) &stack_value[sp - ".SIZEOF_VAR."])->data.dvalue - ((var *) &stack_value[sp])->data.dvalue;

					" );

					break;
					case OP_SUBTRACT_DOUBLE:

					fputs( $fp, "

						sp -= ".SIZEOF_VAR.";
	
					" );
	
					if ($runtime_checks)
					{
						fputs( $fp, "

							check_param_type( stack_value, sp - ".SIZEOF_VAR.", VAR_DOUBLE, ".$ic_line_number[$ic_ptr].", \"".$parse_param->input_filenames[$ic_input_filenumber[$ic_ptr]]."\", ".$error_item.", ".$ic_ptr.", 216, \"Operand type is not a double\" );
						
							check_param_type( stack_value, sp, VAR_DOUBLE, ".$ic_line_number[$ic_ptr].", \"".$parse_param->input_filenames[$ic_input_filenumber[$ic_ptr]]."\", ".$error_item.", ".$ic_ptr.", 216, \"Operand type is not a double\" );
								
						" );
					
						$error_item ++;
					}
	
					fputs( $fp, "

						((var *) &stack_value[sp - ".SIZEOF_VAR."])->data.nvalue = ((var *) &stack_value[sp - ".SIZEOF_VAR."])->data.nvalue - ((var *) &stack_value[sp])->data.nvalue;

					" );

					break;
					case OP_MULT_INT:

					fputs( $fp, "

						sp -= ".SIZEOF_VAR.";
	
					" );
	
					if ($runtime_checks)
					{
						fputs( $fp, "

							check_param_type( stack_value, sp - ".SIZEOF_VAR.", VAR_INT, ".$ic_line_number[$ic_ptr].", \"".$parse_param->input_filenames[$ic_input_filenumber[$ic_ptr]]."\", ".$error_item.", ".$ic_ptr.", 216, \"Operand type is not an int\" );
						
							check_param_type( stack_value, sp, VAR_INT, ".$ic_line_number[$ic_ptr].", \"".$parse_param->input_filenames[$ic_input_filenumber[$ic_ptr]]."\", ".$error_item.", ".$ic_ptr.", 216, \"Operand type is not an int\" );
								
						" );
					
						$error_item ++;
					}
	
					fputs( $fp, "

						((var *) &stack_value[sp - ".SIZEOF_VAR."])->data.ivalue = ((var *) &stack_value[sp - ".SIZEOF_VAR."])->data.ivalue * ((var *) &stack_value[sp])->data.ivalue;

					" );

					break;
					case OP_MULT_DECIMAL:

					fputs( $fp, "

						sp -= ".SIZEOF_VAR.";
	
					" );
	
					if ($runtime_checks)
					{
						fputs( $fp, "

							check_param_type( stack_value, sp - ".SIZEOF_VAR.", VAR_DECIMAL, ".$ic_line_number[$ic_ptr].", \"".$parse_param->input_filenames[$ic_input_filenumber[$ic_ptr]]."\", ".$error_item.", ".$ic_ptr.", 216, \"Operand type is not a decimal\" );
						
							check_param_type( stack_value, sp, VAR_DECIMAL, ".$ic_line_number[$ic_ptr].", \"".$parse_param->input_filenames[$ic_input_filenumber[$ic_ptr]]."\", ".$error_item.", ".$ic_ptr.", 216, \"Operand type is not a decimal\" );
								
						" );
					
						$error_item ++;
					}
	
					fputs( $fp, "

						((var *) &stack_value[sp - ".SIZEOF_VAR."])->data.dvalue = (round( (double) ((var *) &stack_value[sp - ".SIZEOF_VAR."])->data.dvalue * (double) ((var *) &stack_value[sp])->data.dvalue) / VAR_DECIMAL_SCALE );

					" );

					break;
					case OP_MULT_DOUBLE:

					fputs( $fp, "

						sp -= ".SIZEOF_VAR.";
	
					" );
	
					if ($runtime_checks)
					{
						fputs( $fp, "

							check_param_type( stack_value, sp - ".SIZEOF_VAR.", VAR_DOUBLE, ".$ic_line_number[$ic_ptr].", \"".$parse_param->input_filenames[$ic_input_filenumber[$ic_ptr]]."\", ".$error_item.", ".$ic_ptr.", 216, \"Operand type is not a double\" );
						
							check_param_type( stack_value, sp, VAR_DOUBLE, ".$ic_line_number[$ic_ptr].", \"".$parse_param->input_filenames[$ic_input_filenumber[$ic_ptr]]."\", ".$error_item.", ".$ic_ptr.", 216, \"Operand type is not a double\" );
								
						" );
					
						$error_item ++;
					}
	
					fputs( $fp, "

						((var *) &stack_value[sp - ".SIZEOF_VAR."])->data.nvalue = ((var *) &stack_value[sp - ".SIZEOF_VAR."])->data.nvalue * ((var *) &stack_value[sp])->data.nvalue;

					" );

					break;
					case OP_DIV_INT:

					fputs( $fp, "

						sp -= ".SIZEOF_VAR.";
	
					" );
	
					if ($runtime_checks)
					{
						fputs( $fp, "

							check_param_type( stack_value, sp - ".SIZEOF_VAR.", VAR_INT, ".$ic_line_number[$ic_ptr].", \"".$parse_param->input_filenames[$ic_input_filenumber[$ic_ptr]]."\", ".$error_item.", ".$ic_ptr.", 216, \"Operand type is not an int\" );
						
							check_param_type( stack_value, sp, VAR_INT, ".$ic_line_number[$ic_ptr].", \"".$parse_param->input_filenames[$ic_input_filenumber[$ic_ptr]]."\", ".$error_item.", ".$ic_ptr.", 216, \"Operand type is not an int\" );
								
						" );
					
						$error_item ++;
					}
		
					fputs( $fp, "

						if (((var *) &stack_value[sp])->data.ivalue == 0)
							runtime_error( ".$ic_line_number[$ic_ptr].", \"".$parse_param->input_filenames[$ic_input_filenumber[$ic_ptr]]."\", ".$error_item.", ".$ic_ptr.", 105, \"divide by zero\", \"\" );
						else
						{
							((var *) &stack_value[sp - ".SIZEOF_VAR."])->data.ivalue = ((var *) &stack_value[sp - ".SIZEOF_VAR."])->data.ivalue / ((var *) &stack_value[sp])->data.ivalue;
						}

					" );

					break;
					case OP_DIV_DECIMAL:

					fputs( $fp, "

						sp -= ".SIZEOF_VAR.";
	
					" );
	
					if ($runtime_checks)
					{
						fputs( $fp, "

							check_param_type( stack_value, sp - ".SIZEOF_VAR.", VAR_DECIMAL, ".$ic_line_number[$ic_ptr].", \"".$parse_param->input_filenames[$ic_input_filenumber[$ic_ptr]]."\", ".$error_item.", ".$ic_ptr.", 216, \"Operand type is not a decimal\" );
						
							check_param_type( stack_value, sp, VAR_DECIMAL, ".$ic_line_number[$ic_ptr].", \"".$parse_param->input_filenames[$ic_input_filenumber[$ic_ptr]]."\", ".$error_item.", ".$ic_ptr.", 216, \"Operand type is not a decimal\" );
								
						" );
					
						$error_item ++;
					}
	
					fputs( $fp, "

						if (((var *) &stack_value[sp])->data.dvalue == 0)
							runtime_error( ".$ic_line_number[$ic_ptr].", \"".$parse_param->input_filenames[$ic_input_filenumber[$ic_ptr]]."\", ".$error_item.", ".$ic_ptr.", 105, \"divide by zero\", \"\" );
						else
						{
							((var *) &stack_value[sp - ".SIZEOF_VAR."])->data.dvalue = (round( (double) ((var *) &stack_value[sp - ".SIZEOF_VAR."])->data.dvalue / (double) ((var *) &stack_value[sp])->data.dvalue) * VAR_DECIMAL_SCALE );
						}

					" );

					break;
					case OP_DIV_DOUBLE:

					fputs( $fp, "

						sp -= ".SIZEOF_VAR.";
	
					" );
	
					if ($runtime_checks)
					{
						fputs( $fp, "

							check_param_type( stack_value, sp - ".SIZEOF_VAR.", VAR_DOUBLE, ".$ic_line_number[$ic_ptr].", \"".$parse_param->input_filenames[$ic_input_filenumber[$ic_ptr]]."\", ".$error_item.", ".$ic_ptr.", 216, \"Operand type is not a double\" );
						
							check_param_type( stack_value, sp, VAR_DOUBLE, ".$ic_line_number[$ic_ptr].", \"".$parse_param->input_filenames[$ic_input_filenumber[$ic_ptr]]."\", ".$error_item.", ".$ic_ptr.", 216, \"Operand type is not a double\" );
								
						" );
					
						$error_item ++;
					}
	
					fputs( $fp, "

						if (((var *) &stack_value[sp])->data.nvalue == 0)
							runtime_error( ".$ic_line_number[$ic_ptr].", \"".$parse_param->input_filenames[$ic_input_filenumber[$ic_ptr]]."\", ".$error_item.", ".$ic_ptr.", 105, \"divide by zero\", \"\" );
						else
						{
							((var *) &stack_value[sp - ".SIZEOF_VAR."])->data.nvalue = ((var *) &stack_value[sp - ".SIZEOF_VAR."])->data.nvalue / ((var *) &stack_value[sp])->data.nvalue;
						}

					" );

					break;
					case OP_MOD_INT:
	
					fputs( $fp, "

						sp -= ".SIZEOF_VAR.";
	
					" );
		
					if ($runtime_checks)
					{
						fputs( $fp, "

							check_param_type( stack_value, sp - ".SIZEOF_VAR.", VAR_INT, ".$ic_line_number[$ic_ptr].", \"".$parse_param->input_filenames[$ic_input_filenumber[$ic_ptr]]."\", ".$error_item.", ".$ic_ptr.", 216, \"Operand type is not an int\" );
						
							check_param_type( stack_value, sp, VAR_INT, ".$ic_line_number[$ic_ptr].", \"".$parse_param->input_filenames[$ic_input_filenumber[$ic_ptr]]."\", ".$error_item.", ".$ic_ptr.", 216, \"Operand type is not an int\" );
								
						" );
					
						$error_item ++;
					}
	
					fputs( $fp, "

						((var *) &stack_value[sp - ".SIZEOF_VAR."])->data.ivalue = ((var *) &stack_value[sp - ".SIZEOF_VAR."])->data.ivalue % ((var *) &stack_value[sp])->data.ivalue;

					" );

					break;
					case OP_MOD_DECIMAL:

					fputs( $fp, "

						sp -= ".SIZEOF_VAR.";
	
					" );
	
					if ($runtime_checks)
					{
						fputs( $fp, "

							check_param_type( stack_value, sp - ".SIZEOF_VAR.", VAR_DECIMAL, ".$ic_line_number[$ic_ptr].", \"".$parse_param->input_filenames[$ic_input_filenumber[$ic_ptr]]."\", ".$error_item.", ".$ic_ptr.", 216, \"Operand type is not a decimal\" );
						
							check_param_type( stack_value, sp, VAR_DECIMAL, ".$ic_line_number[$ic_ptr].", \"".$parse_param->input_filenames[$ic_input_filenumber[$ic_ptr]]."\", ".$error_item.", ".$ic_ptr.", 216, \"Operand type is not a decimal\" );
								
						" );
					
						$error_item ++;
					}
	
					fputs( $fp, "

						((var *) &stack_value[sp - ".SIZEOF_VAR."])->data.dvalue = ((var *) &stack_value[sp - ".SIZEOF_VAR."])->data.dvalue % ((var *) &stack_value[sp])->data.dvalue;

					" );

					break;
					case OP_MOD_DOUBLE:

					fputs( $fp, "

						sp -= ".SIZEOF_VAR.";
	
					" );
	
					if ($runtime_checks)
					{
						fputs( $fp, "

							check_param_type( stack_value, sp - ".SIZEOF_VAR.", VAR_DOUBLE, ".$ic_line_number[$ic_ptr].", \"".$parse_param->input_filenames[$ic_input_filenumber[$ic_ptr]]."\", ".$error_item.", ".$ic_ptr.", 216, \"Operand type is not a double\" );
						
							check_param_type( stack_value, sp, VAR_DOUBLE, ".$ic_line_number[$ic_ptr].", \"".$parse_param->input_filenames[$ic_input_filenumber[$ic_ptr]]."\", ".$error_item.", ".$ic_ptr.", 216, \"Operand type is not a double\" );
								
						" );
					
						$error_item ++;
					}
	
					fputs( $fp, "

						((var *) &stack_value[sp - ".SIZEOF_VAR."])->data.nvalue = ((var *) &stack_value[sp - ".SIZEOF_VAR."])->data.nvalue % ((var *) &stack_value[sp])->data.nvalue;

					" );

					break;
					case OP_POW_INT:

					fputs( $fp, "

						sp -= ".SIZEOF_VAR.";
	
					" );
		
					if ($runtime_checks)
					{
						fputs( $fp, "

							check_param_type( stack_value, sp - ".SIZEOF_VAR.", VAR_INT, ".$ic_line_number[$ic_ptr].", \"".$parse_param->input_filenames[$ic_input_filenumber[$ic_ptr]]."\", ".$error_item.", ".$ic_ptr.", 216, \"Operand type is not an int\" );
						
							check_param_type( stack_value, sp, VAR_INT, ".$ic_line_number[$ic_ptr].", \"".$parse_param->input_filenames[$ic_input_filenumber[$ic_ptr]]."\", ".$error_item.", ".$ic_ptr.", 216, \"Operand type is not an int\" );
								
						" );
					
						$error_item ++;
					}
	
					fputs( $fp, "

						(var *) &stack_value[sp - ".SIZEOF_VAR."])->data.ivalue = (int) pow( (double) (var *) &stack_value[sp - ".SIZEOF_VAR."])->data.ivalue, (double) (var *) &stack_value[sp])->data.ivalue );

					" );

					break;
					case OP_POW_DECIMAL:

					fputs( $fp, "

						sp -= ".SIZEOF_VAR.";
	
					" );
	
					if ($runtime_checks)
					{
						fputs( $fp, "

							check_param_type( stack_value, sp - ".SIZEOF_VAR.", VAR_DECIMAL, ".$ic_line_number[$ic_ptr].", \"".$parse_param->input_filenames[$ic_input_filenumber[$ic_ptr]]."\", ".$error_item.", ".$ic_ptr.", 216, \"Operand type is not a decimal\" );
						
							check_param_type( stack_value, sp, VAR_DECIMAL, ".$ic_line_number[$ic_ptr].", \"".$parse_param->input_filenames[$ic_input_filenumber[$ic_ptr]]."\", ".$error_item.", ".$ic_ptr.", 216, \"Operand type is not a decimal\" );
								
						" );
					
						$error_item ++;
					}
	
					fputs( $fp, "

						((var *) &stack_value[sp - ".SIZEOF_VAR."])->data.dvalue = pow( (double) (((var *) &stack_value[sp - ".SIZEOF_VAR."])->data.dvalue / VAR_DECIMAL_SCALE), (double) ((var *) &stack_value[sp])->data.dvalue / VAR_DECIMAL_SCALE));

					" );

					break;
					case OP_POW_DOUBLE:

					fputs( $fp, "

						sp -= ".SIZEOF_VAR.";
	
					" );
	
					if ($runtime_checks)
					{
						fputs( $fp, "

							check_param_type( stack_value, sp - ".SIZEOF_VAR.", VAR_DOUBLE, ".$ic_line_number[$ic_ptr].", \"".$parse_param->input_filenames[$ic_input_filenumber[$ic_ptr]]."\", ".$error_item.", ".$ic_ptr.", 216, \"Operand type is not a double\" );
						
							check_param_type( stack_value, sp, VAR_DOUBLE, ".$ic_line_number[$ic_ptr].", \"".$parse_param->input_filenames[$ic_input_filenumber[$ic_ptr]]."\", ".$error_item.", ".$ic_ptr.", 216, \"Operand type is not a double\" );
								
						" );
					
						$error_item ++;
					}
	
					fputs( $fp, "

						((var *) &stack_value[sp - ".SIZEOF_VAR."])->data.nvalue = pow( ((var *) &stack_value[sp - ".SIZEOF_VAR."])->data.nvalue, ((var *) &stack_value[sp])->data.nvalue );

					" );


							//--------------------------------------------------------
							// ++ and --
					 		//--------------------------------------------------------

					break;
					case OP_INC_INT:

					fputs( $fp, "

						((var *) &stack_value[sp - ".SIZEOF_VAR."])->data.ivalue++;

					" );

					break;
					case OP_INC_DECIMAL:

					fputs( $fp, "

						((var *) &stack_value[sp - ".SIZEOF_VAR."])->data.dvalue += VAR_DECIMAL_SCALE;

					" );

					break;
					case OP_INC_DOUBLE:

					fputs( $fp, "

						((var *) &stack_value[sp - ".SIZEOF_VAR."])->data.nvalue++;

					" );

					break;
					case OP_DEC_INT:

					fputs( $fp, "

						((var *) &stack_value[sp - ".SIZEOF_VAR."])->data.ivalue--;

					" );

					break;
					case OP_DEC_DECIMAL:

					fputs( $fp, "

						((var *) &stack_value[sp - ".SIZEOF_VAR."])->data.dvalue -= VAR_DECIMAL_SCALE;

					" );

					break;
					case OP_DEC_DOUBLE:

					fputs( $fp, "

						((var *) &stack_value[sp - ".SIZEOF_VAR."])->data.nvalue--;

					" );

							//--------------------------------------------------------
					 		//--------------------------------------------------------

					break;
					case OP_NEGATE_INT:

					if ($runtime_checks)
					{
						fputs( $fp, "

							check_param_type( stack_value, sp - ".SIZEOF_VAR." , VAR_INT, ".$ic_line_number[$ic_ptr].", \"".$parse_param->input_filenames[$ic_input_filenumber[$ic_ptr]]."\", ".$error_item.", ".$ic_ptr.", 216, \"Operand type is not an int\" );
								
						" );
					
						$error_item ++;
					}
					
					fputs( $fp, "

						((var *) &stack_value[sp - ".SIZEOF_VAR."])->data.ivalue = - ((var *) &stack_value[sp - ".SIZEOF_VAR."])->data.ivalue;

					" );

					break;
					case OP_NEGATE_DECIMAL:

					if ($runtime_checks)
					{
						fputs( $fp, "

							check_param_type( stack_value, sp - ".SIZEOF_VAR.", VAR_DECIMAL, ".$ic_line_number[$ic_ptr].", \"".$parse_param->input_filenames[$ic_input_filenumber[$ic_ptr]]."\", ".$error_item.", ".$ic_ptr.", 216, \"Operand type is not a decimal\" );
								
						" );
					
						$error_item ++;
					}

					fputs( $fp, "

						((var *) &stack_value[sp - ".SIZEOF_VAR."])->data.dvalue = - ((var *) &stack_value[sp - ".SIZEOF_VAR."])->data.dvalue;

					" );

					break;
					case OP_NEGATE_DOUBLE:

					if ($runtime_checks)
					{
						fputs( $fp, "

							check_param_type( stack_value, sp - ".SIZEOF_VAR.", VAR_DOUBLE, ".$ic_line_number[$ic_ptr].", \"".$parse_param->input_filenames[$ic_input_filenumber[$ic_ptr]]."\", ".$error_item.", ".$ic_ptr.", 216, \"Operand type is not a double\" );
								
						" );
					
						$error_item ++;
					}

					fputs( $fp, "

						((var *) &stack_value[sp - ".SIZEOF_VAR."])->data.nvalue = - ((var *) &stack_value[sp - ".SIZEOF_VAR."])->data.nvalue;

					" );

					break;
					case OP_PUSH_NEW_ALLOC:

					fputs( $fp, "
					
						size = ((var *) &stack_value[sp - ".SIZEOF_VAR."])->data.ivalue;

						ptr = _malloc( size + sizeof( int_64 ) );
						
						*((int_64 *) ptr) = 1;		// links pting to 
						
						var_set_p( (var *) &stack_value[sp - ".SIZEOF_VAR."], ptr + sizeof( int_64 ) );

					" );

					break;
					case OP_PUSH_DEREFERENCE:

					fputs( $fp, "

						sp -= ".SIZEOF_VAR.";

						offset = ((var *) &stack_value[sp])->data.ivalue;

						sp -= ".SIZEOF_VAR.";

						base = ((var *) &stack_value[sp])->data.pvalue;

						if (((var *) (&base[offset]))->data.pvalue == NULL)
							runtime_error( ".$ic_line_number[$ic_ptr].", \"".$parse_param->input_filenames[$ic_input_filenumber[$ic_ptr]]."\", ".$error_item.", ".$ic_ptr.", 193, \"Attempt to access a link destination on a null link.\", \"\" );

						var_set_p( (var *) &stack_value[sp], ((var *) (&base[offset]))->data.pvalue );

						sp += ".SIZEOF_VAR.";

					" );

					break;
					case OP_DUPLICATE:

					fputs( $fp, "

						copy_var( (var *) &stack_value[sp], (var *) &stack_value[sp - ".SIZEOF_VAR."], ".$error_item.", ".$ic_ptr." );

						sp += ".SIZEOF_VAR.";

					" );


							//--------------------------------------------------------
							// Call and return
					 		//--------------------------------------------------------

					break;
					break;
					case OP_CALL_USER_FUNCTION:

					fputs( $fp, "

						call_level++;

						stackframe_base[call_level] = sp;
						
						memset( &stack_value_flags[sp], 0, ".$local_variables_stackframe_size2[$ic_ptr].");

//						var_set_i( (var *) &stack_value[sp], ic_ptr + 1 );		// return address

						_user_function_".$ic_function_name[$ic_ptr]."();
					" );

					break;
					case OP_CALL_SYSTEM_FUNCTION:

					$function_name = $ic_value[$ic_ptr];

					fputs( $fp, "

						number_of_function_arguments = ".$ic_argument_count[$ic_ptr].";

						var_clear( &result );

						" );
/*
						if ($ic_argument_count[$ic_ptr] > 0)
							fputs( $fp, "\targ1 = (var *) &stack_value[sp - (number_of_function_arguments) * ".SIZEOF_VAR."];\n" );
						if ($ic_argument_count[$ic_ptr] > 1)
							fputs( $fp, "\targ2 = (var *) &stack_value[sp - (number_of_function_arguments-1) * ".SIZEOF_VAR."];\n" );
						if ($ic_argument_count[$ic_ptr] > 2)
							fputs( $fp, "\targ3 = (var *) &stack_value[sp - (number_of_function_arguments-2) * ".SIZEOF_VAR."];\n" );
						if ($ic_argument_count[$ic_ptr] > 3)
							fputs( $fp, "\targ4 = (var *) &stack_value[sp - (number_of_function_arguments-3) * ".SIZEOF_VAR."];\n" );
						if ($ic_argument_count[$ic_ptr] > 4)
							fputs( $fp, "\targ5 = (var *) &stack_value[sp - (number_of_function_arguments-4) * ".SIZEOF_VAR."];\n" );
						if ($ic_argument_count[$ic_ptr] > 5)
							fputs( $fp, "\targ6 = (var *) &stack_value[sp - (number_of_function_arguments-5) * ".SIZEOF_VAR."];\n" );
						if ($ic_argument_count[$ic_ptr] > 6)
							fputs( $fp, "\targ7 = (var *) &stack_value[sp - (number_of_function_arguments-6) * ".SIZEOF_VAR."];\n" );
						if ($ic_argument_count[$ic_ptr] > 7)
							fputs( $fp, "\targ8 = (var *) &stack_value[sp - (number_of_function_arguments-7) * ".SIZEOF_VAR."];\n" );
						if ($ic_argument_count[$ic_ptr] > 8)
							fputs( $fp, "\targ9 = (var *) &stack_value[sp - (number_of_function_arguments-8) * ".SIZEOF_VAR."];\n" );
						if ($ic_argument_count[$ic_ptr] > 9)
							fputs( $fp, "\targ10 = (var *) &stack_value[sp - (number_of_function_arguments-9) * ".SIZEOF_VAR."];\n" );
						if ($ic_argument_count[$ic_ptr] > 10)
							fputs( $fp, "\targ11 = (var *) &stack_value[sp - (number_of_function_arguments-10) * ".SIZEOF_VAR."];\n" );
*/						
						
						if ($ic_argument_count[$ic_ptr] > 0)
							fputs( $fp, "\tvptr = follow_indirect_address( ".$error_item.", ".$ic_ptr.", sp - (number_of_function_arguments) * ".SIZEOF_VAR." ); 	arg1 = (var *) vptr;\n" );
						if ($ic_argument_count[$ic_ptr] > 1)
							fputs( $fp, "\tvptr = follow_indirect_address( ".$error_item.", ".$ic_ptr.", sp - (number_of_function_arguments-1) * ".SIZEOF_VAR." ); 	arg2 = (var *) vptr;\n" );
						if ($ic_argument_count[$ic_ptr] > 2)
							fputs( $fp, "\tvptr = follow_indirect_address( ".$error_item.", ".$ic_ptr.", sp - (number_of_function_arguments-2) * ".SIZEOF_VAR." ); 	arg3 = (var *) vptr;\n" );
						if ($ic_argument_count[$ic_ptr] > 3)
							fputs( $fp, "\tvptr = follow_indirect_address( ".$error_item.", ".$ic_ptr.", sp - (number_of_function_arguments-3) * ".SIZEOF_VAR." ); 	arg4 = (var *) vptr;\n" );
						if ($ic_argument_count[$ic_ptr] > 4)
							fputs( $fp, "\tvptr = follow_indirect_address( ".$error_item.", ".$ic_ptr.", sp - (number_of_function_arguments-4) * ".SIZEOF_VAR." ); 	arg5 = (var *) vptr;\n" );
						if ($ic_argument_count[$ic_ptr] > 5)
							fputs( $fp, "\tvptr = follow_indirect_address( ".$error_item.", ".$ic_ptr.", sp - (number_of_function_arguments-5) * ".SIZEOF_VAR." ); 	arg6 = (var *) vptr;\n" );
						if ($ic_argument_count[$ic_ptr] > 6)
							fputs( $fp, "\tvptr = follow_indirect_address( ".$error_item.", ".$ic_ptr.", sp - (number_of_function_arguments-6) * ".SIZEOF_VAR." ); 	arg7 = (var *) vptr;\n" );
						if ($ic_argument_count[$ic_ptr] > 7)
							fputs( $fp, "\tvptr = follow_indirect_address( ".$error_item.", ".$ic_ptr.", sp - (number_of_function_arguments-7) * ".SIZEOF_VAR." ); 	arg8 = (var *) vptr;\n" );
						if ($ic_argument_count[$ic_ptr] > 8)
							fputs( $fp, "\tvptr = follow_indirect_address( ".$error_item.", ".$ic_ptr.", sp - (number_of_function_arguments-8) * ".SIZEOF_VAR." ); 	arg9 = (var *) vptr;\n" );
						if ($ic_argument_count[$ic_ptr] > 9)
							fputs( $fp, "\tvptr = follow_indirect_address( ".$error_item.", ".$ic_ptr.", sp - (number_of_function_arguments-9) * ".SIZEOF_VAR." ); 	arg10 = (var *) vptr;\n" );
						if ($ic_argument_count[$ic_ptr] > 10)
							fputs( $fp, "\tvptr = follow_indirect_address( ".$error_item.", ".$ic_ptr.", sp - (number_of_function_arguments-10) * ".SIZEOF_VAR." ); 	arg11 = (var *) vptr;\n" );


						fputs( $fp, "\n" );

						if ($ic_argument_count[$ic_ptr] == 0)
							fputs( $fp, "\t_calc_".$function_name."( &result, ".$ic_ptr." );\n" );
						else
						if ($ic_argument_count[$ic_ptr] == 1)
							fputs( $fp, "\t_calc_".$function_name."( &result, arg1, ".$ic_ptr." );\n" );
						else
						if ($ic_argument_count[$ic_ptr] == 2)
							fputs( $fp, "\t_calc_".$function_name."( &result, arg1, arg2, ".$ic_ptr." );\n" );
						else
						if ($ic_argument_count[$ic_ptr] == 3)
							fputs( $fp, "\t_calc_".$function_name."( &result, arg1, arg2, arg3, ".$ic_ptr." );\n" );
						else
						if ($ic_argument_count[$ic_ptr] == 4)
							fputs( $fp, "\t_calc_".$function_name."( &result, arg1, arg2, arg3, arg4, ".$ic_ptr." );\n" );
						else
						if ($ic_argument_count[$ic_ptr] == 5)
							fputs( $fp, "\t_calc_".$function_name."( &result, arg1, arg2, arg3, arg4, arg5, ".$ic_ptr." );\n" );
						else
						if ($ic_argument_count[$ic_ptr] == 6)
							fputs( $fp, "\t_calc_".$function_name."( &result, arg1, arg2, arg3, arg4, arg5, arg6, ".$ic_ptr." );\n" );
						else
						if ($ic_argument_count[$ic_ptr] == 7)
							fputs( $fp, "\t_calc_".$function_name."( &result, arg1, arg2, arg3, arg4, arg5, arg6, arg7, ".$ic_ptr." );\n" );
						else
						if ($ic_argument_count[$ic_ptr] == 8)
							fputs( $fp, "\t_calc_".$function_name."( &result, arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, ".$ic_ptr." );\n" );
						else
						if ($ic_argument_count[$ic_ptr] == 9)
							fputs( $fp, "\t_calc_".$function_name."( &result, arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9, ".$ic_ptr." );\n" );
						else
						if ($ic_argument_count[$ic_ptr] == 10)
							fputs( $fp, "\t_calc_".$function_name."( &result, arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9, arg10, ".$ic_ptr." );\n" );
						else
						if ($ic_argument_count[$ic_ptr] == 11)
							fputs( $fp, "\t_calc_".$function_name."( &result, arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9, arg10, arg11, ".$ic_ptr." );\n" );

 
					if ($function_arguments_stackframe_size2[$ic_ptr] != 0)
					{
						fputs( $fp, "

							sp -= ".$function_arguments_stackframe_size2[$ic_ptr].";

						" );
					}
					
					fputs( $fp, "

						copy_var( (var *) &stack_value[sp], &result, ".$error_item.", ".$ic_ptr." );

					" );

					if ($ic_return_variable_size[$ic_ptr] > 0)
					{
						fputs( $fp, "

							sp += ".$ic_return_variable_size[$ic_ptr].";

						" );
					}

					break;
					case OP_LABEL:

fputs( $fp, "

" );

					break;
					case OP_INCLUDE_C:
					case OP_MODULE_NAME:
					case OP_LINK_MODULE:


					break;
					case OP_SYS_EXIT:

fputs( $fp, "
						
						vptr = &stack_value[stackframe_base[call_level] + ".RETURN_VARIABLE_OFFSET."];
						
						process_exit_code = ((var *) vptr)->data.ivalue;
						
						}
" );

					break;

					case OP_ERROR:


fputs( $fp, "			runtime_error( ".$ic_line_number[$ic_ptr].", \"".$parse_param->input_filenames[$ic_input_filenumber[$ic_ptr]]."\", ".$error_item.", ".$ic_ptr.", 0, \"".$ic_error_text[$ic_ptr]."\", \"\" );

						exit(0);
" );

					break;

					default:
					{

					fputs( $fp, "

						runtime_error( ".$ic_line_number[$ic_ptr].", \"".$parse_param->input_filenames[$ic_input_filenumber[$ic_ptr]]."\", ".$error_item.", ".$ic_ptr.", 122, \"Unrecognised opcode\", \"\" );

						exit(0);
					" );

					}
				}
			}
		}

		if ($level == 1)
		{
			if ($parse_param->output_file_type == "main")
			{
				fputs( $fp, "\n_user_function_main();\n\n" );

				fputs( $fp, "exit( process_exit_code );\n" );
	
				if (speed_check)
				{
					fputs( $fp, "
					gettimeofday(&time, NULL);\n\n
	
					long microsec2 = ((unsigned long long)time.tv_sec * 1000000) + time.tv_usec;\n\n
	
					printf( \"Operations/sec %lf\\n\", (double) count / (((double) microsec2 - (double) microsec1) / 1000000) );\n\n
					" );
				}
	
				fputs( $fp, "}\n\n" );
			}
		}
	}

	fputs( $fp, "

	" );
	

	}


		//---------------------------------------------------------------------------------------------------------------------
		// Generate code for a copy of data items, 1 or a bulk copy.
		//
		// Requires 'sp_from', 'sp_to' and 'size' to be set.
		//
		// $indent_level should be 1 for the outermost copy
		//---------------------------------------------------------------------------------------------------------------------

	function gen_bulk_copy( $parse_param, $fp, $type, $indent_level, $error_item, $ic_ptr )
	{
		$found = false;
		
		if (is_simple_data_type( $parse_param, $type ) || sleft( $type, 5 ) == 'link ') 
		{
			$found = true;
			
			copy_1( $parse_param, $fp, $type, $error_item, $ic_ptr );
		}		
		else
		if (sleft( $type, 6 ) == 'array ' )
		{								
			$found = true;
			
			$size = get_type_total_size( $parse_param, $type );
			
			$num_elements = array_type_number_of_elements( $type );
			
			$element_type = array_element_type( $parse_param, $type );

			if ($indent_level == 1)
			{			
				fputs( $fp, "
									
					vptr_end = vptr_to + size;
					
					while (vptr_to < vptr_end)
					{ " );
					
						gen_bulk_copy( $parse_param, $fp, $element_type, $indent_level+1, $error_item, $ic_ptr );

				fputs( $fp, "
					}
						" );
			}
			else
			{	
				fputs( $fp, "
				
					for (i".$indent_level."=0; i".$indent_level." < ".$num_elements."; i".$indent_level."++)
					{
						" );
					
					gen_bulk_copy( $parse_param, $fp, $element_type, $indent_level+1, $error_item, $ic_ptr );
	
				fputs( $fp, "
					}							
				");
			}
		}
		else
		{
			for ($i=0; $i < $parse_param->num_user_defined_types; $i++)
			{			
				if ($parse_param->user_defined_types[$i]['type_name'] == $type) 
				{
					$found = true;
					
					if ($parse_param->user_defined_types[$i]['num_items'] == 0)		// user defined smpl type
					{
						copy_1( $parse_param, $fp, $parse_param->user_defined_types[$i]['item_type'][0], $error_item, $ic_ptr );
					}
					else
					{					
						for ($j=0; $j < $parse_param->user_defined_types[$i]['num_items']; $j++)
						{
							gen_bulk_copy( $parse_param, $fp, $parse_param->user_defined_types[$i]['item_type'][$j], $indent_level+1, $error_item, $ic_ptr );
						}
					}
				}
			}
		}
		
		if (! $found)
			echo "Internal error in gen_push type '".$type."' not found<br>";
	}


	function copy_1( $parse_param, $fp, $type, $error_item, $ic_ptr )
	{
		$size = get_type_total_size( $parse_param, $type );
		
		if ($type == "string" || $type == "date" || $type == "time" || $type == "datetime" || $type == "binary")
		{
			fputs( $fp, "
			
				copy_var( (var *) vptr_to, (var *) vptr_from, ".$error_item.", ".$ic_ptr." );
	
				vptr_from += ".SIZEOF_VAR.";
				
				vptr_to += ".SIZEOF_VAR.";
				
			" );
		}
		else
		{
//			memcpy( (void *) vptr_to, (void *) vptr_from, sizeof( var ) );

			fputs( $fp, "
	
				memcpy( (void *) vptr_to, (void *) vptr_from, ".$size." );
	
				vptr_from += ".$size.";
				
				vptr_to += ".$size.";
							
			" );
		}
	}
	
	
	