<?php
			// (c) Copyright Mark McIlroy 2021

    define( "sitecode", "CALC" );
			
    define( "sitename", "ACV Calc" );
    define( "database_name", "aitkencv_aitkencv" );
	define( "common_data_database_name", "aitkencv_commondata" );
	define( "pathroot", "/home/aitkencv/public_html/calcscript" );
	define( "forms_library", "/home/aitkencv/public_html/common_code/forms_library.php" );
	define( "error_log_filename", "/home/aitkencv/public_html/calcscript/error_log.txt" );
	define( "domain", "financeresources1.com" );
	define( "full_site_url", "https://financeresources1.com" );
	define( "display_site_url", "www.financeresources1.com" );
    define( "admin_email_address", "mark.mcilroy@outlook.com" );

    define( "PUSH_FLAGS_PRE_INC", 1 );
    define( "PUSH_FLAGS_PRE_DEC", 2 );
    define( "PUSH_FLAGS_POST_INC", 4 );
    define( "PUSH_FLAGS_POST_DEC", 8 );

    define( "POP_FLAGS_IS_ARRAY", 1 );

    define( "SIZEOF_BOOL", 			1 );
    define( "SIZEOF_INT8", 			1 );
    define( "SIZEOF_INT64", 		8 );
    define( "SIZEOF_POINTER",		8 );

    define( "RETURN_VARIABLE_OFFSET",	16 );

	define( "TOK_EQ", 1 );
	define( "TOK_NE", 2 );
	define( "TOK_LT", 3 );
	define( "TOK_LE", 4 );
	define( "TOK_GT", 5 );
	define( "TOK_GE", 6 );
	
	define( "TOK_PLUS", 7 );
	define( "TOK_SUBTRACT_MINUS", 8 );
	define( "TOK_MULT", 9 );
	define( "TOK_DIV", 10 );
	
	define( "TOK_NAME", 11 );
	define( "TOK_NUMBER", 12 );

	define( "TOK_LPARENTHESIS", 13 );
	define( "TOK_RPARENTHESIS", 14 );

	define( "TOK_LBRACE", 15 );
	define( "TOK_RBRACE", 16 );

	define( "TOK_COMMA", 17 );
	define( "TOK_ASSIGN", 18 );

	define( "TOK_IF", 19 );
	define( "TOK_WHILE", 20 );
	define( "TOK_FUNCTION", 21 );
	define( "TOK_DECLARE", 22 );
	define( "TOK_VAR", 23 );

	define( "TOK_AND", 24 );
	define( "TOK_OR", 25 );
	define( "TOK_NOT", 26 );

	define( "TOK_SEMICOLON", 27 );
	define( "TOK_ELSE", 28 );
	define( "TOK_POW", 29 );
	define( "TOK_ADDR_STRCONCAT", 30 );
	define( "TOK_STRING_CONSTANT", 31 );
			
	define( "TOK_LBRACKET", 32 );
	define( "TOK_RBRACKET", 33 );

	define( "TOK_INT", 34 );
	define( "TOK_DOUBLE", 35 );
	define( "TOK_STRING", 36 );
	define( "TOK_BOOL", 37 );
	define( "TOK_DECIMAL", 38 );
	define( "TOK_BINARY", 39 );
	define( "TOK_DATE", 40 );
	define( "TOK_TIME", 41 );
	define( "TOK_DATETIME", 42 );
		
	define( "TOK_DATE_CONSTANT", 43 );
	define( "TOK_TIME_CONSTANT", 44 );
	define( "TOK_DATETIME_CONSTANT", 45 );
	define( "TOK_BOOLEAN_CONSTANT", 46 );
	define( "TOK_CONST", 47 );
	define( "TOK_INCLUDE", 48 );
	define( "TOK_ARRAY", 49 );
	define( "TOK_BUILTIN", 50 );
	define( "TOK_FOR", 51 );
	define( "TOK_TO", 52 );
	define( "TOK_STEP", 53 );
	define( "TOK_INC", 54 );
	define( "TOK_DEC", 55 );
	define( "TOK_VOID", 56 );
	define( "TOK_ASSIGN_INC", 57 );
	define( "TOK_ASSIGN_DEC", 58 );
	define( "TOK_ASSIGN_STRCONCAT", 59 );
	define( "TOK_TYPE", 60 );
	define( "TOK_STRUCT", 61 );
	define( "TOK_DOT", 62 );
	define( "TOK_ASSIGN_MULT", 63 );
	define( "TOK_ASSIGN_DIV", 64 );
	define( "TOK_MOD", 65 );
	define( "TOK_LINK", 66 );
	define( "TOK_NEW", 67 );
	define( "TOK_VARIABLE", 68 );
	define( "TOK_INCLUDE_C", 69 );
	define( "TOK_MODULE_NAME", 70 );
	define( "TOK_LINK_MODULE", 71 );
	define( "TOK_MODULE_TYPE", 72 );
	define( "TOK_OUTPUT_FILENAME", 73 );
	define( "TOK_C_INCLUDE", 74 );
	define( "TOK_PHP_INCLUDE", 75 );
	define( "TOK_GENERAL", 76 );
	
	define( "TOK_EOF", 200 );


	define( "OP_JMP_FALSE", 				1 );
	define( "OP_JMP", 						2 );
//	define( "OP_PUSH_CONST",				3 );
	define( "OP_OR",						4 );
	define( "OP_AND",						5 );
	define( "OP_EQ_INT",					6 );
	define( "OP_NE_INT",					7 );
	define( "OP_GE_INT",					8 );
	define( "OP_GT_INT",					9 );
	define( "OP_LE_INT",					10 );
	define( "OP_LT_INT",					11 );
	define( "OP_STRCONCAT",					12 );
	define( "OP_ADD_INT",					13 );
	define( "OP_SUBTRACT_INT",				14 );
	define( "OP_MULT_INT",					15 );
	define( "OP_DIV_INT",					16 );
	define( "OP_POW_INT",					17 );
	define( "OP_INC_INT",					18 );
	define( "OP_DEC_INT",					19 );
	define( "OP_NEGATE_INT",				20 );
	define( "OP_NOT",						21 );
	define( "OP_PUSH_VAR",					22 );
	define( "OP_PUSH_0",					23 );
//	define( "OP_PUSH_0_x_2",				24 );
	define( "OP_PUSH_1",					25 );
	define( "OP_JMP_TRUE",					26 );
	define( "OP_JMP_FALSE_DONT_POP",		27 );
	define( "OP_JMP_TRUE_DONT_POP",			28 );
	define( "OP_PUSH_REL_VARIABLE_ADDR",	29 );
	define( "OP_CONV_BINARY_TO_STRING",		30 );
	define( "OP_CONV_LINK_TO_STRING",		31 );
	define( "OP_POP_VAR",					32 );
//	define( "OP_PUSH_ADDR_REL",				33 );
//	define( "OP_PUSH_ADDR_ABS",				34 );
	define( "OP_CONV_DOUBLE_TO_DECIMAL",	35 );
	define( "OP_DUPLICATE",					36 );
	define( "OP_POP_DISCARD",				37 );
	define( "OP_CALL_SYSTEM_FUNCTION",		38 );
	define( "OP_CALL_USER_FUNCTION",		39 );
	define( "OP_RETURN",					40 );
	define( "OP_LABEL",						41 );
	define( "OP_START_FUNCTION",			42 );
	define( "OP_CONV_INT_TO_STRING",		43 );
	define( "OP_CONV_DOUBLE_TO_STRING",		44 );
	define( "OP_CONV_DECIMAL_TO_STRING",	45 );
	define( "OP_CONV_BOOL_TO_STRING",		46 );
	define( "OP_CONV_DATE_TO_STRING",		47 );
	define( "OP_CONV_TIME_TO_STRING",		48 );
	define( "OP_CONV_DATETIME_TO_STRING",	49 );
	define( "OP_POP_JMP_GE",				50 );
	define( "OP_POP_JMP_LE",				51 );
	define( "OP_POP_JMP_LT",				52 );
	define( "OP_POP_JMP_GT",				53 );
	define( "OP_ERROR",						54 );
	define( "OP_MOD_INT",					55 );
	define( "OP_CONV_STRING_TO_BINARY",		56 );
	define( "OP_PUSH_REL_ADDR_BASE",		57 );
	define( "OP_NULL_ENTRY",				58 );
	define( "OP_PUSH_NEW_ALLOC",			59 );
	define( "OP_PUSH_DEREFERENCE",			60 );
	define( "OP_CONV_INT_TO_DECIMAL",		61 );
	define( "OP_CONV_DECIMAL_TO_DOUBLE",	62 );
	define( "OP_CONV_INT_TO_DOUBLE",		63 );
	define( "OP_CONV_DECIMAL_TO_INT",		64 );
	define( "OP_CONV_DOUBLE_TO_INT",		65 );
	define( "OP_SET_INDIRECTION_FLAG",		66 );
	define( "OP_PUSH_REL_VARIABLE_ADDR_0",	67 );
	define( "OP_PUSH_VAR_1",				68 );
	define( "OP_PUSH_DEREFERENCE_0",		69 );
	define( "OP_POP_VAR_1",					70 );
	define( "OP_ADD_DECIMAL",				71 );
	define( "OP_SUBTRACT_DECIMAL",			72 );
	define( "OP_MULT_DECIMAL",				73 );
	define( "OP_DIV_DECIMAL",				74 );
	define( "OP_POW_DECIMAL",				75 );
	define( "OP_INC_DECIMAL",				76 );
	define( "OP_DEC_DECIMAL",				77 );
	define( "OP_NEGATE_DECIMAL",			78 );
	define( "OP_ADD_DOUBLE",				79 );
	define( "OP_SUBTRACT_DOUBLE",			80 );
	define( "OP_MULT_DOUBLE",				81 );
	define( "OP_DIV_DOUBLE",				82 );
	define( "OP_POW_DOUBLE",				83 );
	define( "OP_INC_DOUBLE",				84 );
	define( "OP_DEC_DOUBLE",				85 );
	define( "OP_NEGATE_DOUBLE",				86 );
	define( "OP_MOD_DECIMAL",				87 );
	define( "OP_MOD_DOUBLE",				88 );
	define( "OP_EQ_DECIMAL",				89 );
	define( "OP_NE_DECIMAL",				90 );
	define( "OP_GE_DECIMAL",				91 );
	define( "OP_GT_DECIMAL",				92 );
	define( "OP_LE_DECIMAL",				93 );
	define( "OP_LT_DECIMAL",				94 );
	define( "OP_EQ_DOUBLE",					95 );
	define( "OP_NE_DOUBLE",					96 );
	define( "OP_GE_DOUBLE",					97 );
	define( "OP_GT_DOUBLE",					98 );
	define( "OP_LE_DOUBLE",					99 );
	define( "OP_LT_DOUBLE",					100 );
	define( "OP_EQ_DATE_AND_TIME",			101 );
	define( "OP_NE_DATE_AND_TIME",			102 );
	define( "OP_GE_DATE_AND_TIME",			103 );
	define( "OP_GT_DATE_AND_TIME",			104 );
	define( "OP_LE_DATE_AND_TIME",			105 );
	define( "OP_LT_DATE_AND_TIME",			106 );
	define( "OP_EQ_STRING",					107 );
	define( "OP_NE_STRING",					108 );
	define( "OP_GE_STRING",					109 );
	define( "OP_GT_STRING",					110 );
	define( "OP_LE_STRING",					111 );
	define( "OP_LT_STRING",					112 );
	define( "OP_EQ_BOOL",					113 );
	define( "OP_NE_BOOL",					114 );
	define( "OP_EQ_BINARY",					115 );
	define( "OP_NE_BINARY",					116 );
	define( "OP_EQ_LINK",					117 );
	define( "OP_NE_LINK",					118 );
	define( "OP_PUSH_ABS_ADDR_BASE",			119 );
	define( "OP_PUSH_CONST_INT", 			120 );
	define( "OP_PUSH_CONST_DECIMAL", 		121 );
	define( "OP_PUSH_CONST_DOUBLE", 		122 );
	define( "OP_PUSH_CONST_STRING", 		123 );
	define( "OP_PUSH_CONST_BOOL", 			124 );
	define( "OP_PUSH_CONST_BINARY", 		125 );
	define( "OP_PUSH_CONST_DATE", 			126 );
	define( "OP_PUSH_CONST_TIME", 			127 );
	define( "OP_PUSH_CONST_DATETIME", 		128 );
/*	
	define( "OP_PUSH_VAR_INT", 				129 );
	define( "OP_PUSH_VAR_DECIMAL", 			130 );
	define( "OP_PUSH_VAR_DOUBLE", 			131 );
	define( "OP_PUSH_VAR_STRING", 			132 );
	define( "OP_PUSH_VAR_BOOL", 			133 );
	define( "OP_PUSH_VAR_BINARY", 			134 );
	define( "OP_PUSH_VAR_DATE", 			135 );
	define( "OP_PUSH_VAR_TIME", 			136 );
	define( "OP_PUSH_VAR_DATETIME", 		137 );
*/ 
	define( "OP_POP_VAR_INT", 				138 );
	define( "OP_POP_VAR_DECIMAL", 			139 );
	define( "OP_POP_VAR_DOUBLE", 			140 );
	define( "OP_POP_VAR_STRING", 			141 );
	define( "OP_POP_VAR_BOOL", 				142 );
	define( "OP_POP_VAR_BINARY", 			143 );
	define( "OP_POP_VAR_DATE", 				144 );
	define( "OP_POP_VAR_TIME", 				145 );
	define( "OP_POP_VAR_DATETIME", 			146 );
	define( "OP_BULK_COPY", 				147 );
//	define( "OP_PUSH_VAR_ABS",				148 );
//	define( "OP_POP_VAR_ABS",				149 );
//	define( "OP_SET_INDIRECTION_FLAG_ABS_ADDR",		150 );
	define( "OP_ADD_TO_POINTER",			151 );
	define( "OP_INC_SP",					152 );
	define( "OP_INCLUDE_C",					153 );
	define( "OP_MODULE_NAME", 				154 );
	define( "OP_LINK_MODULE", 				155 );
	define( "OP_PUSH_REL_ADDRESS", 			156 );
	define( "OP_VAR_INC",		 			157 );
	define( "OP_VAR_DEC", 					158 );
	define( "OP_SYS_EXIT", 					159 );
			
	define( "NUM_OPS",						159 );
				
							
//	define( "OP_PUSH_ABS_ARRAY",23 );
//	define( "OP_PUSH_REL",		24 );
//	define( "OP_PUSH_REL_ARRAY",25 );
//	define( "OP_PUSH_ADDR_REL",	26 );
//	define( "OP_PUSH_ADDR_ABS",	27 );
//	define( "OP_POP_ABS",		28 );
//	define( "OP_INC_ABS",		29 );
//	define( "OP_DEC_ABS",		30 );
//	define( "OP_POP_ABS_ARRAY",	31 );
//	define( "OP_POP_VAR",		32 );
//	define( "OP_INC_REL",		33 );
//	define( "OP_DEC_REL",		34 );
//	define( "OP_POP_REL_ARRAY",	35 );


	define( "mail_library", "/home/aitkencv/public_html/common_code/mail_library.php" );

	include "/home/aitkencv/public_html/common_code/common_library.php";
	include "/home/aitkencv/public_html/common_code/forms_library.php";

	
class parse_parameters
{
	public $show_parse_trace;
	public $show_scan_trace;
	public $show_warnings;
	public $include_output_comments;
	public $main_input_filename;
	public $output_file_type;
	public $output_filename;
	public $command_line_mode;
	
	public $current_filename;
	public $current_line_number;
	public $curr_tok;
	public $curr_token_text;
	public $input_text;
	public $input_filenames;
	public $num_input_files;
	
	public $lookahead_tok;				// next token after the current one
	public $lookahead_token_text;
	public $lookahead_tok_2_steps;
	
	public $all_curr_tok;
	public $all_curr_token_text;
	
	public $curr_token_number;
	public $num_tokens;

	public $c_output;	
	public $constants;
	public $num_user_defined_types;
	public $decimal_arithmetic;
	public $user_defined_types;
	public $error_occured;
	public $in_function;
	public $label_num;
	public $last_error_line;
	public $for_control_variables;
}

		
	function set_op_descriptions( &$op_number_of_operands )
	{
		$op_descriptions[1] = "OP_JMP_FALSE";
		$op_descriptions[2] = "OP_JMP";
//		$op_descriptions[3] = "OP_PUSH_CONST";
		$op_descriptions[4] = "OP_OR";
		$op_descriptions[5] = "OP_AND";
		$op_descriptions[6] = "OP_EQ_INT";
		$op_descriptions[7] = "OP_NE_INT";
		$op_descriptions[8] = "OP_GE_INT";
		$op_descriptions[9] = "OP_GT_INT";
		$op_descriptions[10] = "OP_LE_INT";
		$op_descriptions[11] = "OP_LT_INT";
		$op_descriptions[12] = "OP_STRCONCAT";
		$op_descriptions[13] = "OP_ADD_INT";
		$op_descriptions[14] = "OP_SUBTRACT_INT";
		$op_descriptions[15] = "OP_MULT_INT";
		$op_descriptions[16] = "OP_DIV_INT";
		$op_descriptions[17] = "OP_POW_INT";
		$op_descriptions[18] = "OP_INC_INT";
		$op_descriptions[19] = "OP_DEC_INT";
		$op_descriptions[20] = "OP_NEGATE_INT";
		$op_descriptions[21] = "OP_NOT";
		$op_descriptions[22] = "OP_PUSH_VAR";
		$op_descriptions[23] = "OP_PUSH_0";
		$op_descriptions[24] = "OP_PUSH_0_x_2";
		$op_descriptions[25] = "OP_PUSH_1";
		$op_descriptions[26] = "OP_JMP_TRUE";
		$op_descriptions[27] = "OP_JMP_FALSE_DONT_POP";
		$op_descriptions[28] = "OP_JMP_TRUE_DONT_POP";
		$op_descriptions[29] = "OP_PUSH_REL_VARIABLE_ADDR";
		$op_descriptions[30] = "OP_CONV_BINARY_TO_STRING";
		$op_descriptions[31] = "OP_CONV_LINK_TO_STRING";
		$op_descriptions[32] = "OP_POP_VAR";
		$op_descriptions[33] = "OP_PUSH_ADDR_REL";
		$op_descriptions[34] = "OP_PUSH_ADDR_ABS";
		$op_descriptions[35] = "OP_CONV_DOUBLE_TO_DECIMAL";
		$op_descriptions[36] = "OP_DUPLICATE";
		$op_descriptions[37] = "OP_POP_DISCARD";
		$op_descriptions[38] = "OP_CALL_SYSTEM_FUNCTION";
		$op_descriptions[39] = "OP_CALL_USER_FUNCTION";
		$op_descriptions[40] = "OP_RETURN";
		$op_descriptions[41] = "OP_LABEL";
		$op_descriptions[42] = "OP_START_FUNCTION";
		$op_descriptions[43] = "OP_CONV_INT_TO_STRING";
		$op_descriptions[44] = "OP_CONV_DOUBLE_TO_STRING";
		$op_descriptions[45] = "OP_CONV_DECIMAL_TO_STRING";
		$op_descriptions[46] = "OP_CONV_BOOL_TO_STRING";
		$op_descriptions[47] = "OP_CONV_DATE_TO_STRING";
		$op_descriptions[48] = "OP_CONV_TIME_TO_STRING";
		$op_descriptions[49] = "OP_CONV_DATETIME_TO_STRING";
		$op_descriptions[50] = "OP_POP_JMP_GE";
		$op_descriptions[51] = "OP_POP_JMP_LE";
		$op_descriptions[52] = "OP_POP_JMP_LT";
		$op_descriptions[53] = "OP_POP_JMP_GT";
		$op_descriptions[54] = "OP_ERROR";
		$op_descriptions[55] = "OP_MOD_INT";
		$op_descriptions[56] = "OP_CONV_STRING_TO_BINARY";
		$op_descriptions[57] = "OP_PUSH_REL_ADDR_BASE";
		$op_descriptions[58] = "OP_NULL_ENTRY";
		$op_descriptions[59] = "OP_PUSH_NEW_ALLOC";
		$op_descriptions[60] = "OP_PUSH_DEREFERENCE";
		$op_descriptions[61] = "OP_CONV_INT_TO_DECIMAL";
		$op_descriptions[62] = "OP_CONV_DECIMAL_TO_DOUBLE";
		$op_descriptions[63] = "OP_CONV_INT_TO_DOUBLE";
		$op_descriptions[64] = "OP_CONV_DECIMAL_TO_INT";
		$op_descriptions[65] = "OP_CONV_DOUBLE_TO_INT";
		$op_descriptions[66] = "OP_SET_INDIRECTION_FLAG";
		$op_descriptions[67] = "OP_PUSH_REL_VARIABLE_ADDR_0";
		$op_descriptions[68] = "OP_PUSH_VAR_1";
		$op_descriptions[69] = "OP_PUSH_DEREFERENCE_0";
		$op_descriptions[70] = "OP_POP_VAR_1";
		$op_descriptions[71] = "OP_ADD_DECIMAL";
		$op_descriptions[72] = "OP_SUBTRACT_DECIMAL";
		$op_descriptions[73] = "OP_MULT_DECIMAL";
		$op_descriptions[74] = "OP_DIV_DECIMAL";
		$op_descriptions[75] = "OP_POW_DECIMAL";
		$op_descriptions[76] = "OP_INC_DECIMAL";
		$op_descriptions[77] = "OP_DEC_DECIMAL";
		$op_descriptions[78] = "OP_NEGATE_DECIMAL";
		$op_descriptions[79] = "OP_ADD_DOUBLE";
		$op_descriptions[80] = "OP_SUBTRACT_DOUBLE";
		$op_descriptions[81] = "OP_MULT_DOUBLE";
		$op_descriptions[82] = "OP_DIV_DOUBLE";
		$op_descriptions[83] = "OP_POW_DOUBLE";
		$op_descriptions[84] = "OP_INC_DOUBLE";
		$op_descriptions[85] = "OP_DEC_DOUBLE";
		$op_descriptions[86] = "OP_NEGATE_DOUBLE";
		$op_descriptions[87] = "OP_MOD_DECIMAL";
		$op_descriptions[88] = "OP_MOD_DOUBLE";
		$op_descriptions[89] = "OP_EQ_DECIMAL";
		$op_descriptions[90] = "OP_NE_DECIMAL";
		$op_descriptions[91] = "OP_GE_DECIMAL";
		$op_descriptions[92] = "OP_GT_DECIMAL";
		$op_descriptions[93] = "OP_LE_DECIMAL";
		$op_descriptions[94] = "OP_LT_DECIMAL";
		$op_descriptions[95] = "OP_EQ_DOUBLE";
		$op_descriptions[96] = "OP_NE_DOUBLE";
		$op_descriptions[97] = "OP_GE_DOUBLE";
		$op_descriptions[98] = "OP_GT_DOUBLE";
		$op_descriptions[99] = "OP_LE_DOUBLE";
		$op_descriptions[100] = "OP_LT_DOUBLE";
		$op_descriptions[101] = "OP_EQ_DATE_AND_TIME";
		$op_descriptions[102] = "OP_NE_DATE_AND_TIME";
		$op_descriptions[103] = "OP_GE_DATE_AND_TIME";
		$op_descriptions[104] = "OP_GT_DATE_AND_TIME";
		$op_descriptions[105] = "OP_LE_DATE_AND_TIME";
		$op_descriptions[106] = "OP_LT_DATE_AND_TIME";
		$op_descriptions[107] = "OP_EQ_STRING";
		$op_descriptions[108] = "OP_NE_STRING";
		$op_descriptions[109] = "OP_GE_STRING";
		$op_descriptions[110] = "OP_GT_STRING";
		$op_descriptions[111] = "OP_LE_STRING";
		$op_descriptions[112] = "OP_LT_STRING";
		$op_descriptions[113] = "OP_EQ_BOOL";
		$op_descriptions[114] = "OP_NE_BOOL";
		$op_descriptions[115] = "OP_EQ_BINARY";
		$op_descriptions[116] = "OP_NE_BINARY";
		$op_descriptions[117] = "OP_EQ_LINK";
		$op_descriptions[118] = "OP_NE_LINK";
		$op_descriptions[119] = "OP_PUSH_ABS_ADDR_BASE";
		$op_descriptions[120] = "OP_PUSH_CONST_INT";
		$op_descriptions[121] = "OP_PUSH_CONST_DECIMAL";
		$op_descriptions[122] = "OP_PUSH_CONST_DOUBLE";
		$op_descriptions[123] = "OP_PUSH_CONST_STRING";
		$op_descriptions[124] = "OP_PUSH_CONST_BOOL";
		$op_descriptions[125] = "OP_PUSH_CONST_BINARY";
		$op_descriptions[126] = "OP_PUSH_CONST_DATE";
		$op_descriptions[127] = "OP_PUSH_CONST_TIME";
		$op_descriptions[128] = "OP_PUSH_CONST_DATETIME";
/*		
		$op_descriptions[129] = "OP_PUSH_VAR_INT";
		$op_descriptions[130] = "OP_PUSH_VAR_DECIMAL";
		$op_descriptions[131] = "OP_PUSH_VAR_DOUBLE";
		$op_descriptions[132] = "OP_PUSH_VAR_STRING";
		$op_descriptions[133] = "OP_PUSH_VAR_BOOL";
		$op_descriptions[134] = "OP_PUSH_VAR_BINARY";
		$op_descriptions[135] = "OP_PUSH_VAR_DATE";
		$op_descriptions[136] = "OP_PUSH_VAR_TIME";
		$op_descriptions[137] = "OP_PUSH_VAR_DATETIME";
*/ 
		$op_descriptions[138] = "OP_POP_VAR_INT";
		$op_descriptions[139] = "OP_POP_VAR_DECIMAL";
		$op_descriptions[140] = "OP_POP_VAR_DOUBLE";
		$op_descriptions[141] = "OP_POP_VAR_STRING";
		$op_descriptions[142] = "OP_POP_VAR_BOOL";
		$op_descriptions[143] = "OP_POP_VAR_BINARY";
		$op_descriptions[144] = "OP_POP_VAR_DATE";
		$op_descriptions[145] = "OP_POP_VAR_TIME";
		$op_descriptions[146] = "OP_POP_VAR_DATETIME";
		$op_descriptions[147] = "OP_BULK_COPY";
//		$op_descriptions[148] = "OP_PUSH_VAR_ABS";
//		$op_descriptions[149] = "OP_POP_VAR_ABS";
//		$op_descriptions[150] = "OP_SET_INDIRECTION_FLAG_ABS_ADDR";
		$op_descriptions[151] = "OP_ADD_TO_POINTER";
		$op_descriptions[152] = "OP_INC_SP";
		$op_descriptions[153] = "OP_INCLUDE_C";
		$op_descriptions[154] = "OP_MODULE_NAME";
		$op_descriptions[155] = "OP_LINK_MODULE";
		$op_descriptions[156] = "OP_PUSH_REL_ADDRESS";
		$op_descriptions[157] = "OP_VAR_INC";
		$op_descriptions[158] = "OP_VAR_DEC";
		$op_descriptions[159] = "OP_SYS_EXIT";
		
			
		$op_number_of_operands[1] = 1;		// "OP_JMP_FALSE";
		$op_number_of_operands[2] = 0;		// "OP_JMP";
//		$op_number_of_operands[3] = 0;		// "OP_PUSH_CONST";
		$op_number_of_operands[4] = 2;		// "OP_OR";
		$op_number_of_operands[5] = 2;		// "OP_AND";
		$op_number_of_operands[6] = 2;		// "OP_EQ_INT";
		$op_number_of_operands[7] = 2;		// "OP_NE_INT";
		$op_number_of_operands[8] = 2;		// "OP_GE_INT";
		$op_number_of_operands[9] = 2;		// "OP_GT_INT";
		$op_number_of_operands[10] = 2;		// "OP_LE_INT";
		$op_number_of_operands[11] = 2;		// "OP_LT_INT";
		$op_number_of_operands[12] = 2;		// "OP_STRCONCAT";
		$op_number_of_operands[13] = 2;		// "OP_ADD_INT";
		$op_number_of_operands[14] = 2;		// "OP_SUBTRACT_INT";
		$op_number_of_operands[15] = 2;		// "OP_MULT_INT";
		$op_number_of_operands[16] = 2;		// "OP_DIV_INT";
		$op_number_of_operands[17] = 2;		// "OP_POW_INT";
		$op_number_of_operands[18] = 1;		// "OP_INC_INT";
		$op_number_of_operands[19] = 1;		// "OP_DEC_INT";
		$op_number_of_operands[20] = 1;		// "OP_NEGATE";
		$op_number_of_operands[21] = 1;		// "OP_NOT";
		$op_number_of_operands[22] = 2;		// "OP_PUSH_VAR";
		$op_number_of_operands[23] = 0;		// "OP_PUSH_0";
		$op_number_of_operands[24] = 0;		// "OP_PUSH_0_x_2";
		$op_number_of_operands[25] = 0;		// "OP_PUSH_1";
		$op_number_of_operands[26] = 1;		// "OP_JMP_TRUE";
		$op_number_of_operands[27] = 1;		// "OP_JMP_FALSE_DONT_POP";
		$op_number_of_operands[28] = 1;		// "OP_JMP_TRUE_DONT_POP";
		$op_number_of_operands[29] = 2;		// "OP_PUSH_REL_VARIABLE_ADDR";
		$op_number_of_operands[30] = 1;		// "OP_CONV_BINARY_TO_STRING";
		$op_number_of_operands[31] = 1;		// "OP_CONV_LINK_TO_STRING";
		$op_number_of_operands[32] = 0;		// "OP_POP_VAR";
		$op_number_of_operands[33] = 1;		// "OP_PUSH_ADDR_REL";
		$op_number_of_operands[34] = 1;		// "OP_PUSH_ADDR_ABS";
		$op_number_of_operands[35] = 1;		// "OP_CONV_DOUBLE_TO_DECIMAL";
		$op_number_of_operands[36] = 0;		// "OP_DUPLICATE";
		$op_number_of_operands[37] = 1;		// "OP_POP_DISCARD";
		$op_number_of_operands[38] = 0;		// "OP_CALL_SYSTEM_FUNCTION";
		$op_number_of_operands[39] = 0;		// "OP_CALL_USER_FUNCTION";
		$op_number_of_operands[40] = 0;		// "OP_RETURN";
		$op_number_of_operands[41] = 0;		// "OP_LABEL";
		$op_number_of_operands[42] = 0;		// "OP_START_FUNCTION";
		$op_number_of_operands[43] = 1;		// "OP_CONV_INT_TO_STRING";
		$op_number_of_operands[44] = 1;		// "OP_CONV_DOUBLE_TO_STRING";
		$op_number_of_operands[45] = 1;		// "OP_CONV_DECIMAL_TO_STRING";
		$op_number_of_operands[46] = 1;		// "OP_CONV_BOOL_TO_STRING";
		$op_number_of_operands[47] = 1;		// "OP_CONV_DATE_TO_STRING";
		$op_number_of_operands[48] = 1;		// "OP_CONV_TIME_TO_STRING";
		$op_number_of_operands[49] = 1;		// "OP_CONV_DATETIME_TO_STRING";
		$op_number_of_operands[50] = 2;		// "OP_POP_JMP_GE";
		$op_number_of_operands[51] = 2;		// "OP_POP_JMP_LE";
		$op_number_of_operands[52] = 2;		// "OP_POP_JMP_LT";
		$op_number_of_operands[53] = 2;		// "OP_POP_JMP_GT";
		$op_number_of_operands[54] = 0;		// "OP_ERROR";
		$op_number_of_operands[55] = 2;		// "OP_MOD_INT";
		$op_number_of_operands[56] = 1;		// "OP_CONV_STRING_TO_BINARY";
		$op_number_of_operands[57] = 0;		// "OP_PUSH_REL_ADDR_BASE";
		$op_number_of_operands[58] = 0;		// "OP_NULL_ENTRY";
		$op_number_of_operands[59] = 1;		// "OP_PUSH_NEW_ALLOC";
		$op_number_of_operands[60] = 2;		// "OP_PUSH_DEREFERENCE";
		$op_number_of_operands[61] = 1;		// "OP_CONV_INT_TO_DECIMAL";
		$op_number_of_operands[62] = 1;		// "OP_CONV_DECIMAL_TO_DOUBLE";
		$op_number_of_operands[63] = 1;		// "OP_CONV_INT_TO_DOUBLE";
		$op_number_of_operands[64] = 1;		// "OP_CONV_DECIMAL_TO_INT";
		$op_number_of_operands[65] = 1;		// "OP_CONV_DOUBLE_TO_INT";
		$op_number_of_operands[66] = 0;		// "OP_SET_INDIRECTION_FLAG";
		$op_number_of_operands[67] = 1;		// "OP_PUSH_REL_VARIABLE_ADDR_0";
		$op_number_of_operands[68] = 1;		// "OP_PUSH_VAR_1";
		$op_number_of_operands[69] = 1;		// "OP_PUSH_DEREFERENCE_0";
		$op_number_of_operands[70] = 1;		// "OP_POP_VAR_1";
		$op_number_of_operands[71] = 2;		// "OP_ADD_DECIMAL"
		$op_number_of_operands[72] = 2;		// "OP_SUBTRACT_DECIMAL"
		$op_number_of_operands[73] = 2;		// "OP_MULT_DECIMAL"
		$op_number_of_operands[74] = 2;		// "OP_DIV_DECIMAL"
		$op_number_of_operands[75] = 2;		// "OP_POW_DECIMAL"
		$op_number_of_operands[76] = 1;		// "OP_INC_DECIMAL"
		$op_number_of_operands[77] = 1;		// "OP_DEC_DECIMAL"
		$op_number_of_operands[78] = 1;		// "OP_NEGATE_DECIMAL"
		$op_number_of_operands[79] = 2;		// "OP_ADD_DOUBLE"
		$op_number_of_operands[80] = 2;		// "OP_SUBTRACT_DOUBLE"
		$op_number_of_operands[81] = 2;		// "OP_MULT_DOUBLE"
		$op_number_of_operands[82] = 2;		// "OP_DIV_DOUBLE"
		$op_number_of_operands[83] = 2;		// "OP_POW_DOUBLE"
		$op_number_of_operands[84] = 1;		// "OP_INC_DOUBLE"
		$op_number_of_operands[85] = 1;		// "OP_DEC_DOUBLE"
		$op_number_of_operands[86] = 1;		// "OP_NEGATE_DOUBLE"
		$op_number_of_operands[87] = 1;		// "OP_MOD_DECIMAL"
		$op_number_of_operands[88] = 1;		// "OP_MOD_DOUBLE"
		$op_number_of_operands[89] = 2;		// "OP_EQ_DECIMAL"
		$op_number_of_operands[90] = 2;		// "OP_NE_DECIMAL"
		$op_number_of_operands[91] = 2;		// "OP_GE_DECIMAL"
		$op_number_of_operands[92] = 2;		// "OP_GT_DECIMAL"
		$op_number_of_operands[93] = 2;		// "OP_LE_DECIMAL"
		$op_number_of_operands[94] = 2;		// "OP_LT_DECIMAL"
		$op_number_of_operands[95] = 2;		// "OP_EQ_DOUBLE"
		$op_number_of_operands[96] = 2;		// "OP_NE_DOUBLE"
		$op_number_of_operands[97] = 2;		// "OP_GE_DOUBLE"
		$op_number_of_operands[98] = 2;		// "OP_GT_DOUBLE"
		$op_number_of_operands[99] = 2;		// "OP_LE_DOUBLE"
		$op_number_of_operands[100] = 2;	// "OP_LT_DOUBLE"
		$op_number_of_operands[101] = 2;	// "OP_EQ_DATE_AND_TIME"
		$op_number_of_operands[102] = 2;	// "OP_NE_DATE_AND_TIME"
		$op_number_of_operands[103] = 2;	// "OP_GE_DATE_AND_TIME"
		$op_number_of_operands[104] = 2;	// "OP_GT_DATE_AND_TIME"
		$op_number_of_operands[105] = 2;	// "OP_LE_DATE_AND_TIME"
		$op_number_of_operands[106] = 2;	// "OP_LT_DATE_AND_TIME"
		$op_number_of_operands[107] = 2;	// "OP_EQ_STRING"
		$op_number_of_operands[108] = 2;	// "OP_NE_STRING"
		$op_number_of_operands[109] = 2;	// "OP_GE_STRING"
		$op_number_of_operands[110] = 2;	// "OP_GT_STRING"
		$op_number_of_operands[111] = 2;	// "OP_LE_STRING"
		$op_number_of_operands[112] = 2;	// "OP_LT_STRING"
		$op_number_of_operands[113] = 2;	// "OP_EQ_BOOL"
		$op_number_of_operands[114] = 2;	// "OP_NE_BOOL"
		$op_number_of_operands[115] = 2;	// "OP_EQ_BINARY"
		$op_number_of_operands[116] = 2;	// "OP_NE_BINARY"
		$op_number_of_operands[117] = 2;	// "OP_EQ_LINK"
		$op_number_of_operands[118] = 2;	// "OP_NE_LINK"
		$op_number_of_operands[119] = 0;	// "OP_PUSH_ABS_ADDR_BASE"
		$op_number_of_operands[120] = 0;	// "OP_PUSH_CONST_INT"
		$op_number_of_operands[121] = 0;	// "OP_PUSH_CONST_DECIMAL"
		$op_number_of_operands[122] = 0;	// "OP_PUSH_CONST_DOUBLE"
		$op_number_of_operands[123] = 0;	// "OP_PUSH_CONST_STRING"
		$op_number_of_operands[124] = 0;	// "OP_PUSH_CONST_BOOL"
		$op_number_of_operands[125] = 0;	// "OP_PUSH_CONST_BINARY"
		$op_number_of_operands[126] = 0;	// "OP_PUSH_CONST_DATE"
		$op_number_of_operands[127] = 0;	// "OP_PUSH_CONST_TIME"
		$op_number_of_operands[128] = 0;	// "OP_PUSH_CONST_DATETIME"
		
/*		
		$op_number_of_operands[129] = 1;	// "OP_PUSH_VAR_INT";
		$op_number_of_operands[130] = 1;	// "OP_PUSH_VAR_DECIMAL";
		$op_number_of_operands[131] = 1;	// "OP_PUSH_VAR_DOUBLE";
		$op_number_of_operands[132] = 1;	// "OP_PUSH_VAR_STRING";
		$op_number_of_operands[133] = 1;	// "OP_PUSH_VAR_BOOL";
		$op_number_of_operands[134] = 1;	// "OP_PUSH_VAR_BINARY";
		$op_number_of_operands[135] = 1;	// "OP_PUSH_VAR_DATE";
		$op_number_of_operands[136] = 1;	// "OP_PUSH_VAR_TIME";
		$op_number_of_operands[137] = 1;	// "OP_PUSH_VAR_DATETIME";
*/ 
		$op_number_of_operands[138] = 1;	// "OP_POP_VAR_INT";
		$op_number_of_operands[139] = 1;	// "OP_POP_VAR_DECIMAL";
		$op_number_of_operands[140] = 1;	// "OP_POP_VAR_DOUBLE";
		$op_number_of_operands[141] = 1;	// "OP_POP_VAR_STRING";
		$op_number_of_operands[142] = 1;	// "OP_POP_VAR_BOOL";
		$op_number_of_operands[143] = 1;	// "OP_POP_VAR_BINARY";
		$op_number_of_operands[144] = 1;	// "OP_POP_VAR_DATE";
		$op_number_of_operands[145] = 1;	// "OP_POP_VAR_TIME";
		$op_number_of_operands[146] = 1;	// "OP_POP_VAR_DATETIME";
		$op_number_of_operands[147] = 2;	// "OP_BULK_COPY";
//		$op_number_of_operands[148] = 3;	// "OP_PUSH_VAR_ABS";
//		$op_number_of_operands[149] = 1;	// "OP_POP_VAR_ABS";
//		$op_number_of_operands[150] = 0;	// "OP_SET_INDIRECTION_FLAG_ABS_ADDR";
		$op_number_of_operands[151] = 0;	// "OP_ADD_TO_POINTER";
		$op_number_of_operands[152] = 0;	// "OP_INC_SP";
		$op_number_of_operands[153] = 0;	// "OP_INCLUDE_C";
		$op_number_of_operands[154] = 0;	// "OP_MODULE_NAME";
		$op_number_of_operands[155] = 0;	// "OP_LINK_MODULE";
		$op_number_of_operands[156] = 0;	// "OP_PUSH_REL_ADDRESS";
		$op_number_of_operands[157] = 1;	// "OP_VAR_INC";
		$op_number_of_operands[158] = 1;	// "OP_VAR_DEC";
		$op_number_of_operands[159] = 0;	// "OP_SYS_EXIT";

		return ($op_descriptions);			
	}



	function start_code( $first=false, $db="" )
	{
		init_acv_sessions();
			
        if (session_status() != PHP_SESSION_ACTIVE)
    		session_start();

			/* set config options */

		ini_set( "error_log", pathroot."/error_log.txt" );

		ini_set( "display_errors", "on" );
		ini_set( "display_startup_errors", "on" );

		ini_set( "gc_maxlifetime", 12*60*60 );		/* set session timeout to 12 hours */

		ini_set( "date.timezone", "Australia/Melbourne" );
		
		$cxn = db_login( database_name );

        return ($cxn);		
	}
		
		
	function page_header( $heading, $cxn )
	{
	    main_write_head_section_of_page( "", "", "", $cxn );
	    
//		echo "<html><head><meta http-equiv="Content-Type" content="text/html; charset=utf-8"><meta name='viewport' content='width=device-width, initial-scale=1.0'>";
//
//      echo "<meta name=\"keywords\" content='".$keywords."'>";
        
//Loan,Repayments,Calculator,Calculation,Mortgage,Black,Scholes,Option,Centrelink,Pension
//
//		echo "";


			// use the old version of the Google Analytics libary until Google Translate supports the new library
			
//		include "google_analytics_legacy_version.php";

//		include "google_analytics_tracking.php";


		
//		echo '<link rel="icon" type="image/png" sizes="32x32" href="/favicon-32x32.png">';
//		echo '<link rel="icon" type="image/png" sizes="96x96" href="/favicon-96x96.png">';
//		echo '<link rel="icon" type="image/png" sizes="16x16" href="/favicon-16x16.png">';
//		echo '<link rel="shortcut icon" href="/favicon.ico" type="image/x-icon">';
//		echo '<link rel="icon" href="/favicon.ico" type="image/x-icon">';
//
//
//		write_common_styles();
//
//		
//		$data = define_styles();

		$amp = false;

        if (! low_res_screen( $cxn ))
        {
        	echo "<style> html, body {";
        	echo "margin:0;";
			echo "font-family: verdana;";
			echo "font-size: 11pt;";
			echo "background-color: ".acv_background_color.";"; 			
        	echo "}";
        	echo "</style>";
    
        	echo "<table cellpadding='0' cellspacing='0' width='100%'><tr><td style='padding-left: 12px; line-height: 45px; opacity: 0.9; font-family: Calibri; font-size: 20pt; color: #ffffff; background-color: #008500' align='left'>".$heading."</td></tr></table>";
    
    
//    	    echo "<table width='100%'><tr><td width='90%' align='right'>";
        	
//        	show_green_button( $cxn, "Home", 80, $amp, "/index.php" );

//        	echo "</td><td></td></tr></table>";
        }
        else
        {
    		echo "<style> html, body {";
        	echo "margin:0;";
			echo "background-color: ".acv_background_color.";"; 			
    		echo "}";
    		echo "</style>";
    
    		echo "<table cellspacing='0' width='100%'><tr><td style='padding-left: 12px; padding-top: 3; padding-bottom: 3; font-family: Calibri; font-size: 13pt; color: #ffffff; background-color: #008500' valign='left' align='left'>".$heading."</td></tr></table>";

    		
//    	    echo "<table width='100%'><tr><td width='100%' align='right'>";
        	
//        	show_green_button( $cxn, "Home", 80, $amp, "/index.php" );
        	
//        	echo "</td><td></td></tr></table>";
        }
	}

		
    function main_write_head_section_of_page( $page_title, $description, $keywords, $cxn )
    {
		echo "<html><head><meta name='viewport' content='width=device-width, initial-scale=1.0'>";

        if (val( $_SESSION, "screen_width" ) == "")
            write_screen_parameters_function();


        echo "<meta name='keywords' content='".$keywords."'>";
            
        echo "<meta name='description' content='".$description."'>";

		echo "";


//		include "google_analytics_legacy_version.php";

//		include "google_analytics_tracking.php";


//        echo "<link rel='shortcut icon' href='/ad_favicon.ico' type='image/x-icon'>";
//        echo "<link rel='icon' href='/ad_favicon.ico' type='image/x-icon'>";
//        echo "<link rel='icon' type='image/png' sizes='96x96' href='/ad_favicon-96x96.png'>";

                
        echo '<script type="application/ld+json">';
        echo '{';
        echo '  "@context": "http://schema.org",';
        echo '  "@type": "Organization",';
        echo '  "url": "'.full_site_url.'",';
        echo '  "name": "Au Calculator Central",';
        echo '  "contactPoint": {';
        echo '    "@type": "ContactPoint",';
        echo '    "url": "'.full_site_url.'/contact_us.php",';
        echo '    "email": "'.admin_email_address.'",';
        echo '    "contactType": "Customer service"';
        echo '  }';
        echo '}';            
        echo "</script>";


        echo "<style>";
        
		write_common_styles();
		
		$data = define_styles( $cxn );

        echo "</style>";


		$bg = $data['bg'];


		echo "<title>".$page_title."</title></head>";
		
		return ($bg);
    }
		

		/* generate the heading line for a page */

	function main_page_header( $page_title, $keywords, $description, $cxn )
	{
	    
	    main_write_head_section_of_page( $page_title, $description, $keywords, $cxn );

            // Google Analytics 
            
        echo "<!-- Global site tag (gtag.js) - Google Analytics -->";
        echo "<script async src='https://www.googletagmanager.com/gtag/js?id=UA-97849346-4'></script>";
        echo "<script>";
        echo "  window.dataLayer = window.dataLayer || [];";
        echo "  function gtag(){dataLayer.push(arguments);}";
        echo "  gtag('js', new Date());";
        echo "  gtag('config', 'UA-97849346-4');";
        echo "</script>";


		echo '<link rel="icon" type="image/png" sizes="192x192"  href="/images/android-icon-192x192.png">';
		echo '<link rel="icon" type="image/png" sizes="32x32" href="/favicon-32x32.png">';
		echo '<link rel="icon" type="image/png" sizes="96x96" href="/favicon-96x96.png">';
		echo '<link rel="icon" type="image/png" sizes="16x16" href="/favicon-16x16.png">';


		if (! low_res_screen( $cxn ))
		{
			echo "<style>";

			echo "</style>";
		}
		else
		{
			echo "<style>";
			echo "margin: 0;";
			echo "</style>";
		}


//      $source = val( $_SESSION, "source" );
//
//	    log_hits( $source, $cxn );
//
//
//		define_styles();
//
//		echo "<title>".$page_title."</title></head><body>";

	}

		/* define the CSS styles */

	function define_styles( $cxn )
	{

		$color_scheme = val( $_SESSION, 'color_scheme' );

		$bg = '#ffffff';

		echo "body   		{ color: #000000; font-family: verdana; font-size: ".fs( $cxn, 14 )."pt}";

//		echo "a:visited	{color: #0000bb; text-decoration: underline}";
//		echo "a:link	{color: #0000bb; text-decoration: underline}";

//		echo "a.menubaritem			{color: #000000; font-size:".fs( 14 )."pt; font-family:verdana; text-decoration:none}";
//		echo "a.menubaritem:visited {color: #000000; font-size:".fs( 14 )."pt; font-family:verdana; text-decoration:none}";
//		echo "a.menubaritem:link	{color: #000000; font-size:".fs( 14 )."pt; font-family:verdana; text-decoration:none}";
//		echo "a.menubaritem:hover {color: #000000; background-color: #eeeeee; font-size:".fs( 14 )."pt; font-family:verdana; text-decoration: none}";

//		echo ".hl {color: #0000bb; background-color: #bbbbbb; font-size:".fs( 14 )."pt; font-family:verdana; text-decoration: none}";
//		echo ".uhl {color: #0000bb; font-size:".fs( 14 )."pt; font-family:verdana; text-decoration: none}";

		echo ".gblack         { color: #000000; font-family: verdana; font-size: ".fs( $cxn, 14 )."pt}";
		echo ".gblue          { color: #0000bb; font-family: verdana; font-size: ".fs( $cxn, 14 )."pt}";
		echo ".gred           { color: #bb0000; font-family: verdana; font-size: ".fs( $cxn, 14 )."pt}";
		echo ".gwatermark     { color: #999999; font-family: verdana; font-size: ".fs( $cxn, 14 )."pt}";
		echo ".gpink          { color: #FF69B4; font-family: verdana; font-size: ".fs( $cxn, 14 )."pt}";
		echo ".gmidgreen      { color: #008000; font-family: verdana; font-size: ".fs( $cxn, 14 )."pt}";
		echo ".gwhite         { color: #ffffff; font-family: verdana; font-size: ".fs( $cxn, 14 )."pt}";
		echo ".ggrey          { color: #bbbbbb; font-family: verdana; font-size: ".fs( $cxn, 14 )."pt}";
		echo ".gbrown         { color: #A0522D; font-family: verdana; font-size: ".fs( $cxn, 14 )."pt}";			

		echo ".fprompt        { color: #0000bb; padding-left: 5px; font-family: verdana; font-size: ".fs( $cxn, 14 )."pt}";
		echo ".finput         { color: #000000; padding-left: 2px; border-style: solid; border-width: 1px; border-color: #cccccc; font-family: verdana; font-size: ".fs( $cxn, 14 )."pt}";						
		echo ".fradio         { color: #000000; font-family: verdana; font-size: ".fs( $cxn, 14 )."pt}";

		echo ".fprompt_error  { color: #ff0000; padding-left: 5px; font-family: verdana; font-size: ".fs( $cxn, 14 )."pt}";
		echo ".finput_error   { color: #000000; padding-left: 2px; border-style: solid; border-width: 1px; border-color: #cccccc; background-color: #ff9999; font-family: verdana; font-size: ".fs( $cxn, 14 )."pt}";
		echo ".fradio_error   { color: #ff0000; font-family: verdana; font-size: ".fs( $cxn, 14 )."pt}";

		echo ".dprompt        { color: #0000bb; font-family: verdana; font-size: ".fs( $cxn, 14 )."pt}";
		echo ".dtext          { color: #000000; font-family: verdana; font-size: ".fs( $cxn, 14 )."pt}";

		echo ".paraheading    { color: #0000bb; font-family: verdana; font-size: ".fs( $cxn, 14 )."pt}";

//		echo ".mainmenuheading    { color: #bb0000; font-family: verdana; font-size: ".fs( $cxn, 14 )."pt}";
//		echo ".mainmenuitem			{color: #0000bb; font-size: ".fs( $cxn, 14 )."pt; font-family:verdana; text-decoration:none}";
//		echo ".mainmenuitem:visited	{color: #0000bb; font-size: ".fs( $cxn, 14 )."pt; font-family:verdana; text-decoration:none}";
//		echo ".mainmenuitem:link	{color: #0000bb; font-size: ".fs( $cxn, 14 )."pt; font-family:verdana; text-decoration:none}";

		echo ".pgheading      { color: #0000bb; font-family: verdana; font-size: ".fs( $cxn, 16 )."pt}";
//		echo ".homeheading    { color: #0000bb; font-family: times; font-size: ".fs( $cxn, 26 )."pt}";

		echo ".glink		  { color: #0000bb; font-family: verdana; font-size: ".fs( $cxn, 12 )."pt}";
		echo ".glink:visited  { color: #0000bb; font-family: verdana; font-size: ".fs( $cxn, 12 )."pt}";
		echo ".glink:link     { color: #0000bb; font-family: verdana; font-size: ".fs( $cxn, 12 )."pt}";
		echo ".glink:hover    { color: green; font-family: verdana; font-size: ".fs( $cxn, 12 )."pt}";

//		echo ".pinklink:visited { text-decoration: none; color: #FF69B4; font-family: verdana; font-size: ".fs( 14 )."pt}";
//		echo ".pinklink:link  { text-decoration: none; color: #FF69B4; font-family: verdana; font-size: ".fs( 14 )."pt}";
//		echo ".pinklink:hover { text-decoration: underline; color: #FF69B4; font-family: verdana; font-size: ".fs( 14 )."pt}";

//		echo ".redlink:visited { text-decoration: none; color: #ff0000; font-family: verdana; font-size: ".fs( 14 )."pt}";
//		echo ".redlink:link  { text-decoration: none; color: #ff0000; font-family: verdana; font-size: ".fs( 14 )."pt}";
//		echo ".redlink:hover { text-decoration: underline; color: #ff0000; font-family: verdana; font-size: ".fs( 14 )."pt}";
		
//		echo ".lpinklink:visited { text-decoration: none; color: #ffd7ff; font-family: verdana; font-size: ".fs( 14 )."pt}";
//		echo ".lpinklink:link  { text-decoration: none; color: #ffd7ff; font-family: verdana; font-size: ".fs( 14 )."pt}";
//		echo ".lpinklink:hover { text-decoration: underline; color: #ffd7ff; font-family: verdana; font-size: ".fs( 14 )."pt}";

//		echo ".whitelink:visited { text-decoration: underline; color: #ffffff; font-family: verdana; font-size: ".fs( 14 )."pt}";
//		echo ".whitelink:link  { text-decoration: underline; color: #ffffff; font-family: verdana; font-size: ".fs( 14 )."pt}";
//		echo ".whitelink:hover { text-decoration: underline; color: #ffffff; font-family: verdana; font-size: ".fs( 14 )."pt}";

//		echo ".bluelink:visited { text-decoration: underline; color: #0000bb; font-family: verdana; font-size: ".fs( 14 )."pt}";
//		echo ".bluelink:link  { text-decoration: underline; color: #0000bb; font-family: verdana; font-size: ".fs( 14 )."pt}";
//		echo ".bluelink:hover { text-decoration: underline; color: #0000bb; font-family: verdana; font-size: ".fs( 14 )."pt}";


		echo ".greenbuttonmobile4 {text-align: center; background: #008500; color: #ffffff; font-family: vardana; font-size: 11.5pt; ";
		echo "    border-width:2px; display: inline-block; ";
		echo "    }";


		echo ".greenbuttonmobile4_bottom {text-align: center; background: #008500; color: #ffffff; font-family: verdana; font-size: 11.5pt; ";
		echo "    border-width:2px; display: inline-block; ";
		echo "    }";
		
		$button_color = "#008000";
		$button_hover = "#008000";
		$mobile_button_color = "#008000";
		$mobile_button_hover = "#008000";
		$fs2 = 14;
		$fsm = 14;
		
		echo ".greenbuttondesktop {text-align: center; border: 1px solid ".$button_color."; border-radius: 5px; background: ".$button_color."; color: #ffffff; font-family: arial; font-size: ".$fs2."pt; ";
		echo "    display: inline-block; ";
		echo " }";

		echo ".greenbuttondesktop:hover {text-align: center; cursor: pointer; border: 1px solid ".$button_hover."; border-radius: 5px; background: ".$button_hover."; color: #ffffff; font-family: arial; font-size: ".$fs2."pt; ";
		echo "    display: inline-block; ";
		echo " }";

    	echo ".greenbuttonmobile {text-align: center; line-height: 14pt; border: solid 1px ".$button_color."; border-radius: 4px; background: ".$mobile_button_color."; color: #ffffff; font-family: arial; font-size: ".$fsm."pt; ";
		echo "    display: inline-block;";
		echo " }";

		echo ".greenbuttonmobile:hover {text-align: center; cursor: pointer; line-height: 14pt; border:solid 1px ".$button_hover."; border-radius: 4px; background: ".$mobile_button_hover."; color: #ffffff; font-family: arial; font-size: ".$fsm."pt; ";
		echo "    display: inline-block; ";
		echo " }";
		

			/* mouseover highlight bar */

//		echo "<script>";
//		echo "function hl( idx )	{	document.getElementById(idx).className = \"hl\"; }";
//		echo "function uhl( idx )	{	document.getElementById(idx).className = \"uhl\"; }";
//		echo "</script>";

		$data['bg'] = $bg;

		return ($data);
	}





    function show_cyan_button( $text, $width, $url )
    {
        $font_size = "14pt";
        $this_width = $width;

        echo "<div width=".$this_width."px align=center style='cursor: pointer; font-family: verdana; font-size: ".$font_size."; background: #008500; line-height: 45px; color: #ffffff' onclick=\"window.location.href='".$url."'\" >";
//        echo "<td width='5%'>&nbsp;</td><td width=".$this_width."px align=center style='cursor: pointer; font-family: verdana; font-size: ".$font_size."; background: #008500; line-height: 45px; color: #ffffff' onclick=\"window.location.href='".$url."'\" >";
    
        echo $text;

        echo "</div>";
    }


    function show_cyan_space_line()
    {
        echo "<td width=160px align=center style='font-family: verdana; line-height: 22px;'>&nbsp;</td>";
    }



	function db_login( $database )
	{
		$host = "localhost";
		$user = "aitkencv_mlm1";
		$password = "IndieLogin12%$";

        $cxn = new mysqli( $host, $user, $password, $database );

		if ($cxn->connect_errno)
		{
			echo "<br><span style='font-size: 14pt; font-family: verdana'>".sitename." is currently unavailable.<br><br>Please try again in half an hour.<br><br></span>";
			
			echo "Error text: ".$cxn->connect_error."<br>";

			exit();
		}

		return $cxn;
	}
	
	
	function load_arrays( &$parse_param, &$ic, &$ic_end, &$vars, 
							&$ic_ops,
							&$jump_address,
							&$ic_value,
							&$ic_type,
							&$ic_size,
							&$ic_text,
							&$ic_error_text,
							&$ic_line_number,
							&$ic_input_filename,
							&$ic_input_filenumber,
							&$ic_argument_count,
							&$ic_function_number,
							&$ic_function_name,
							&$local_variables_stackframe_size2,
							&$function_arguments_stackframe_size2,
							&$ic_return_variable_size,
							&$call_addresses )
	{
		for ($ic_ptr=0; $ic_ptr < $ic_end; $ic_ptr++)
		{
			if (isset( $ic[$ic_ptr]['value'] ))
				$jump_address[$ic_ptr] = (int) $ic[$ic_ptr]['value'];
			
			$ic_ops[$ic_ptr] 				= (int) $ic[$ic_ptr]['op'];
			
			$ic_value[$ic_ptr] 				= 		$ic[$ic_ptr]['value'];
			
			if (isset( $ic[$ic_ptr]['type'] ))
			{
				$ic_type[$ic_ptr] 				= 		$ic[$ic_ptr]['type'];
			
				if ($ic[$ic_ptr]['type'] != "")
				{
					if (strpos( $ic_type[$ic_ptr], "variable" ) !== false)
						$size = 1;
					else				
						$size = get_type_total_size( $parse_param, $ic_type[$ic_ptr] );
					
					$ic_size[$ic_ptr] = $size;
				}
			}
							
			$ic_text[$ic_ptr] 				= 		$ic[$ic_ptr]['text'];
			$ic_error_text[$ic_ptr] 		= 		$ic[$ic_ptr]['error_text'];
			$ic_line_number[$ic_ptr] 		= (int) $ic[$ic_ptr]['line_number'];
			$ic_input_filename[$ic_ptr] 	= 		$ic[$ic_ptr]['input_filename'];
			$ic_input_filenumber[$ic_ptr] 	= (int) $ic[$ic_ptr]['input_filenumber'];
			
			if ($ic[$ic_ptr]['op'] == OP_CALL_SYSTEM_FUNCTION)
				$ic_argument_count[$ic_ptr] = (int) $ic[$ic_ptr]['argument_count'];
			
			if ($ic[$ic_ptr]['op'] == OP_START_FUNCTION || 
				$ic[$ic_ptr]['op'] == OP_CALL_USER_FUNCTION ||
				$ic[$ic_ptr]['op'] == OP_CALL_SYSTEM_FUNCTION || 
				$ic[$ic_ptr]['op'] == OP_RETURN)
			{
				$ic_function_number[$ic_ptr] = (int) $ic[$ic_ptr]['function_number'];

				$ic_function_name[$ic_ptr] = $ic[$ic_ptr]['function_name'];
				
				$local_variables_stackframe_size2[$ic_ptr] = (int) $vars['local_variables_stackframe_size'][$ic_function_number[$ic_ptr]];
									
				$function_arguments_stackframe_size2[$ic_ptr] = (int) $vars['function_arguments_stackframe_size'][$ic_function_number[$ic_ptr]];
			}
			
			if ($ic[$ic_ptr]['op'] == OP_RETURN || $ic[$ic_ptr]['op'] == OP_CALL_SYSTEM_FUNCTION)
				$ic_return_variable_size[$ic_ptr] = (int) $ic[$ic_ptr]['return_variable_size'];
			
			if (isset( $ic[$ic_ptr]['call_address'] ))
				$call_addresses[$ic_ptr] = (int) $ic[$ic_ptr]['call_address'];
		}
	}

	


		// Log into the common database. Must happen AFTER the login to the normal local database $cxn as it's set up for this
		// function only to create a second connection
		
	function db_common_login()
	{
		$host="localhost";
		$user="aitkencv_mlm1";
		$password="IndieLogin12%$";

        $cxn_common = new mysqli( $host, $user, $password, "aitkencv_commondata" );
      
		if ($cxn_common->connect_errno)
		{
			echo "The system is currently unavailable.<br><br>Please try again in half an hour.";
			
			echo "Error number: ".$cxn_common->connect_errno."<br>";
			echo "Error text: ".$cxn_common->connect_error."<br>";

			exit();
		}

		return $cxn_common;
	}	
	
    
//    function is_subdomain()
//    {
//    	if (substr( $_SERVER['HTTP_HOST'], 2, 1 ) == "."  || substr( $_SERVER['HTTP_HOST'], 6, 1 ) == "." )
//    	    return (true);
//    	else
//    	    return (false);   
//    }
    
    
    function get_country_from_subdomain( $cxn )
    {
        $country = "";
        
    	if (substr( $_SERVER['HTTP_HOST'], 2, 1 ) == "." )
    	{ 
	        $code_digit2 = substr( $_SERVER['HTTP_HOST'], 0, 2 );
    	
        	$query = "SELECT display_name FROM ".common_data_database_name.".country WHERE internet_domain_name_country_code = '".$code_digit2."'";
        	
        	$result = run_query( $query, $cxn );
        
        	if (query_num_rows($result) > 0)
        	{
        		$data = get_row( $result );	
    
                $country = $data['display_name'];
        	}
            else
            if ($code_digit2 == "gb")
                $country = "United Kingdom";
    	}
        else
    	if (substr( $_SERVER['HTTP_HOST'], 6, 1 ) == "." )
    	{
	        $code_digit2 = substr( $_SERVER['HTTP_HOST'], 4, 2 );

        	$query = "SELECT display_name FROM ".common_data_database_name.".country WHERE internet_domain_name_country_code = '".$code_digit2."'";
        	
        	$result = run_query( $query, $cxn );
        
        	if (query_num_rows($result) > 0)
        	{
        		$data = get_row( $result );	
    
                $country = $data['display_name'];
        	}
            else
            if ($code_digit2 == "gb")
                $country = "United Kingdom";
    	}
    	
    	return ($country);
  	}

    
    function get_the_prefix( $cxn, $country_name )
    {
        $the = "";
        
    	$query = "SELECT prefix FROM ".common_data_database_name.".country WHERE display_name = '".$country_name."'";
    
    	$result = run_query( $query, $cxn );

    	if (query_num_rows($result) > 0)
    	{
    		$data = get_row( $result );	
    
            if ($data['prefix'] != "")
                $the = "the ";
    	}        

        return ($the);
    }
    
    
	function show_green_button_submit_large_mobile( $cxn, $text, $size, $html_form_name="form" )	
	{
		if (! low_res_screen( $cxn ))
			echo "<div onclick=\"document.forms.".$html_form_name.".submit()\" class='greenbuttondesktop' style='line-height: 25px; width:".$size.";' align='center'>".$text."</div> ";			
		else
			echo "<div onclick=\"document.forms.".$html_form_name.".submit()\" class='greenbuttonmobile' style='line-height: 25px; font-size: 12pt; width:".$size.";' align='center'>".$text."</div> ";						
	}
	
	function show_google_translate()
    {
        echo "<td width='15%' valign='top'>";
        echo ' <div id="google_translate_element"></div><script type="text/javascript"> ';
        echo ' function googleTranslateElementInit() { ';
        echo " new google.translate.TranslateElement({pageLanguage: 'en', layout: google.translate.TranslateElement.InlineLayout.SIMPLE, gaTrack: true, gaId: 'UA-97849346-1'}, 'google_translate_element'); ";
        echo ' } ';
        echo ' </script><script type="text/javascript" src="//translate.google.com/translate_a/element.js?cb=googleTranslateElementInit"></script> ';
        echo "</td>";
    }


		// don't put in the common library because different sites have different color schemes
		
	function form_start( $handler )
	{
			//lightskyblue  #cceeff azure
			// lighter color first
			
		echo "<form id='form' name='form' action='".url_encode( $handler )."' method='POST'><table style='border: 1px solid #bbbbbb; background: linear-gradient(#fcfcfc, #e1e1e1)'>\n";
	}


		// suitable for desktop, and mobile when most of the page is available
		
//	function show_ads_large_square()
//	{
//
//		echo " <script async src='//pagead2.googlesyndication.com/pagead/js/adsbygoogle.js'></script>\n ";
//		echo " <!-- New Ads 2 Large Square (other websites) -->\n ";
//		echo " <ins class='adsbygoogle'\n ";
//		echo "     style='display:inline-block;width:336px;height:280px'\n ";
//		echo "     data-ad-client='ca-pub-7728790744816510'\n ";
//		echo "     data-ad-slot='4213119902'></ins>\n ";
//		echo " <script>\n ";
//		echo " (adsbygoogle = window.adsbygoogle || []).push({});\n ";
//		echo " </script>\n ";
//		echo " &nbsp ";		
//	}
	
?>