<?php
			// (c) Copyright Mark McIlroy 2021

	include "/home/aitkencv/public_html/calc/scripts/library.php";

	define( "MAX_STACK_SIZE", 10000000 );
	define( "MAX_INDIRECTION_LEVELS", 10000 );

	define( "MAX_RUN_ITERATIONS", 10000000 );			// to pause incorrect scripts
	
	
	/*
	 * Current programs converted to calc 
	 *
	 * 	Accounts P & L report
	 * 
	 * 	Calc option values
	 *
	 * 	Input screen test program 
	 */
	  
	  
	  /* Version 2
	   * 
	   * A)
	   * 
	   * links
	   *
	   * var link structtype x		// datatype as struct or array
	   * 
	   * x = new()   // type above
	   * 
	   * x = y;		// point to new object
	   *  
	   * type x2
	   * {
	   *  int a;
	   *  link x2 next, previous;
	   * }
	   * 
	   * x3[y].next = x4;
	   * 
	   * x.a = 25;
	   * 
	   * 
	   * B) generate a C program from the Calc code, or the runtime loop in C.
	   * 
	   *  
	   */
	    
//	define( "show_execution_trace", true );
//	define( "show_execution_trace", false );

	include "/home/aitkencv/public_html/calc/scripts/builtin_functions.php";

	include "/home/aitkencv/public_html/calc/scripts/runtime.php";

	ini_set( "memory_limit", "128M" );

	
//---------------------------------------
// NEXT AVAILABLE ERROR NUMBER:   167
//
// Includes 'runtime.php'
//---------------------------------------

class parse_parameters
{
	public $show_parse_trace;
	public $show_scan_trace;
	public $program_text;
	public $fp;
	public $input_pos;
	public $current_filename;
	public $current_line_number;
	public $curr_tok;
	public $curr_token_text;
	public $constants;
	public $num_user_defined_types;
	public $decimal_arithmetic;
	public $user_defined_types;
	public $error_occured;
	public $in_function;
	public $label_num;
	public $include_file_level;
	public $last_error_line;
}


// https://calc.aitkencv.com/test_program.calc

// include "https://calcs.aitkencv.com/stdlib.calc";


	define( "exit_on_first_error", false );
//	define( "exit_on_first_error", true );

//	define( "compress_labels", false );
	define( "compress_labels", true );
	
	define( "TOK_EQ", 1 );
	define( "TOK_NE", 2 );
	define( "TOK_LT", 3 );
	define( "TOK_LE", 4 );
	define( "TOK_GT", 5 );
	define( "TOK_GE", 6 );
	
	define( "TOK_PLUS", 7 );
	define( "TOK_SUBTRACT_MINUS", 8 );
	define( "TOK_MULT", 9 );
	define( "TOK_DIV", 10 );
	
	define( "TOK_NAME", 11 );
	define( "TOK_NUMBER", 12 );

	define( "TOK_LPARENTHESIS", 13 );
	define( "TOK_RPARENTHESIS", 14 );

	define( "TOK_LBRACE", 15 );
	define( "TOK_RBRACE", 16 );

	define( "TOK_COMMA", 17 );
	define( "TOK_ASSIGN", 18 );

	define( "TOK_IF", 19 );
	define( "TOK_WHILE", 20 );
	define( "TOK_FUNCTION", 21 );
	define( "TOK_DECLARE", 22 );
	define( "TOK_VAR", 23 );

	define( "TOK_AND", 24 );
	define( "TOK_OR", 25 );
	define( "TOK_NOT", 26 );

	define( "TOK_SEMICOLON", 27 );
	define( "TOK_ELSE", 28 );
	define( "TOK_POW", 29 );
	define( "TOK_ADDR_STRCONCAT", 30 );
	define( "TOK_STRING_CONSTANT", 31 );
			
	define( "TOK_LBRACKET", 32 );
	define( "TOK_RBRACKET", 33 );

	define( "TOK_INT", 34 );
	define( "TOK_DOUBLE", 35 );
	define( "TOK_STRING", 36 );
	define( "TOK_BOOL", 37 );
	define( "TOK_DECIMAL", 38 );
	define( "TOK_BINARY", 39 );
	define( "TOK_DATE", 40 );
	define( "TOK_TIME", 41 );
	define( "TOK_DATETIME", 42 );
		
	define( "TOK_DATE_CONSTANT", 43 );
	define( "TOK_TIME_CONSTANT", 44 );
	define( "TOK_DATETIME_CONSTANT", 45 );
	define( "TOK_BOOLEAN_CONSTANT", 46 );
	define( "TOK_CONST", 47 );
	define( "TOK_INCLUDE", 48 );
	define( "TOK_ARRAY", 49 );
	define( "TOK_BUILTIN", 50 );
	define( "TOK_FOR", 51 );
	define( "TOK_TO", 52 );
	define( "TOK_STEP", 53 );
	define( "TOK_INC", 54 );
	define( "TOK_DEC", 55 );
	define( "TOK_VOID", 56 );
	define( "TOK_ASSIGN_INC", 57 );
	define( "TOK_ASSIGN_DEC", 58 );
	define( "TOK_ASSIGN_STRCONCAT", 59 );
	define( "TOK_TYPE", 60 );
	define( "TOK_STRUCT", 61 );
	define( "TOK_DOT", 62 );
	define( "TOK_ASSIGN_MULT", 63 );
	define( "TOK_ASSIGN_DIV", 64 );
				
					
	define( "TOK_EOF", 100 );

	$cxn = start_code();

/*
 * 	Syntax:
 * 
 * 				M1 = 10;
 * 
 * 				if (a < b) M2 = 20;
 * 
 * 				while (a < b) M3 = 30;
 * 
 * 				if (a < b) { M1 = 10; M2 = 20; } else {M3 = 30; M4 = 40;}
 * 
 *				boolean: < > <= >= and or not
 * 
 * 				arithmetic:  + - * / ^ 
 */
 
 
 /* st frame
 
    local variables
   	return ptr
   	function arguments
  	global vars 
*/


	function calc_run_program( $program, $input_filename, $show_scan_trace, $show_parse_trace, $show_icode, $show_execution_trace, $run_code ) 
	{		
		$i = 0;
		
		$decimal_arithmetic = true;
	//false
		$parse_param = new parse_parameters;
		
		$parse_param->show_parse_trace = $show_parse_trace;

		$parse_param->show_scan_trace = $show_scan_trace; 
		
		$parse_param->decimal_arithmetic = $decimal_arithmetic;
		
		$parse_param->fp = fopen( "/home/aitkencv/public_html/calc/generated.c", "w" );
		
		$show_execution_trace = $show_execution_trace;
		
		$parse_param->program_text[0] = $program;
		$parse_param->input_pos[0] = 0;
		$parse_param->current_filename[0] = $input_filename;
		$parse_param->current_line_number[0] = 1;
		
		$parse_param->include_file_level = 0;
		
		$parse_param->curr_token = 0;
		$parse_param->curr_token_text = "";
		
		$parse_param->last_error_line = 0;
		
		$ic_pos = 0;
	
		$parse_param->label_num = 0;

		$parse_param->num_user_defined_types = 0;
			
		$parse_param->vars['number_of_global_variables'] = 0;
		$parse_param->vars['number_of_user_functions'] = 0;
	
		$parse_param->error_occured = false;
	
		parse_file( $parse_param, $ic, $ic_pos );
		
		if (! $parse_param->error_occured)	
			assign_vars( $parse_param, $ic, $ic_pos );

		fclose( $parse_param->fp );
	}



	function show_variable_name( $ic, $ic_ptr, $current_function_number, $offset )
	{
		for ($k=0; $k < $parse_param->vars['number_of_local_variables'][$current_function_number]; $k++)
		{
			if ($parse_param->vars['local_variables'][$current_function_number][$k]['offset'] == $offset)
				$name = $parse_param->vars['local_variables'][$current_function_number][$k]['name'];
		}
		
		return ($name);
	}
	

	function parse_file( $parse_param, &$ic, &$ic_pos )
	{
		$current_line_number = 1;
		$current_function_number = 0;
		
		$parse_param->in_function = false;
		
		if ($parse_param->show_parse_trace)
			echo "called parse_file<br>"; 				

		skip_whitespace( $parse_param );

		next_token( $parse_param );
	
        while ($parse_param->curr_tok != TOK_EOF)
		{
			$builtin_function = false;

			if ($parse_param->curr_tok == TOK_BUILTIN)
			{
				$builtin_function = true;

				next_token( $parse_param );
				
				$parse_param->in_function = true;

				parse_function_definition( $parse_param, $ic, $ic_pos, $current_function_number, $builtin_function );

				$parse_param->in_function = false;
			}
			else
			if ($parse_param->curr_tok == TOK_FUNCTION)
			{
				$parse_param->in_function = true;

				parse_function_definition( $parse_param, $ic, $ic_pos, $current_function_number, $builtin_function );
				
				$parse_param->in_function = false;
			}				
			else
			if ($parse_param->curr_tok == TOK_TYPE)
			{
				parse_type_definition( $parse_param, $ic, $ic_pos, false, $current_function_number );

				next_token( $parse_param );
			}
			else
	        if ($parse_param->curr_tok == TOK_INCLUDE)
			{
				parse_include_statement( $parse_param, $ic, $ic_pos );
			}
			else
			if ($parse_param->curr_tok == TOK_CONST)
			{
				parse_const_declaration( $parse_param, $ic, $ic_pos, $num_dimensions, false );
			}
			else
			{
				parse_stat( $parse_param, $ic, $ic_pos, $current_function_number, false );

//				if ($parse_param->curr_tok != TOK_SEMICOLON)
//					syntax_error( 132, $parse_param, "Expected a ';' after a statement" );
				
//				next_token( $parse_param );
			}
		}
	}


function parse_type_definition( $parse_param, &$ic, &$ic_pos, $current_function_number )
{
	if ($parse_param->show_parse_trace)
		echo "called parse_type_definition<br>"; 				
		
	next_token( $parse_param );

	$type_name = $parse_param->curr_token_text;
	 
	fputs( $parse_param->fp, "typedef struct ".$type_name."\n{\n" );
	
	if ($parse_param->curr_tok != TOK_NAME)
		syntax_error( 125, $parse_param, "Expected a name after 'type': ".$parse_param->curr_token_text );

	$parse_param->user_defined_types[$parse_param->num_user_defined_types]['type_name'] = $type_name;
	
	next_token( $parse_param );

	if ($parse_param->curr_tok != TOK_STRUCT)
		syntax_error( 126, $parse_param, "Expected 'struct' after a type name: ".$parse_param->curr_token_text );
	
	next_token( $parse_param );

	if ($parse_param->curr_tok != TOK_LBRACE)
		syntax_error( 127, $parse_param, "Expected '{' after 'struct': ".$parse_param->curr_token_text );

	next_token( $parse_param );
	
		
	$num_items = 0;
	
	while ($parse_param->curr_tok != TOK_EOF && $parse_param->curr_tok != TOK_RBRACE)
	{
		$item_type = parse_data_type( $parse_param, $ic, $ic_pos, $number_of_dimensions, false );
		
		
//					$item_type = $parse_param->curr_token_text;

//					next_token( $parse_param );

		while ($parse_param->curr_tok != TOK_EOF && $parse_param->curr_tok != TOK_SEMICOLON)
		{
			$parse_param->user_defined_types[$parse_param->num_user_defined_types]['item_type'][$num_items] = $item_type;
						
			$parse_param->user_defined_types[$parse_param->num_user_defined_types]['item_name'][$num_items] = $parse_param->curr_token_text;
		
			$num_items++;

			fputs( $parse_param->fp, calc_to_c_type( $item_type )." ".$parse_param->curr_token_text.";\n" );
		
			next_token( $parse_param );

			if ($parse_param->curr_tok != TOK_COMMA && $parse_param->curr_tok != TOK_SEMICOLON)
				syntax_error( 128, $parse_param, "Expected ',' or ';' after a struct item declaration: ".$parse_param->curr_token_text );

			if ($parse_param->curr_tok == TOK_COMMA)
				next_token( $parse_param );
		}
		
		if ($parse_param->curr_tok == TOK_SEMICOLON)
			next_token( $parse_param );
	}

	fputs( $parse_param->fp, "} ".$type_name.";\n\n" );

	$parse_param->user_defined_types[$parse_param->num_user_defined_types]['num_items'] = $num_items;
		
	$parse_param->num_user_defined_types++;
}



function parse_function_definition( $parse_param, &$ic, &$ic_pos, &$current_function_number, &$builtin_function )
{
	if ($parse_param->show_parse_trace)
		echo "called parse_function_definition<br>"; 				
	
	$parse_param->in_function = true;

	$in_void_function = false;
	
	next_token( $parse_param );
	
	$type = parse_data_type( $parse_param, $ic, $ic_pos, $number_of_dimensions, true );

	if ($type == "void")
		$in_void_function = true;
	
	$function_name = $parse_param->curr_token_text;

	$current_function_number = check_or_add_new_function( $parse_param, $function_name, $type, $already_defined );

	for ($j=0; $j < $parse_param->vars['number_of_user_functions']; $j++)
	{
		if ($parse_param->vars['function_name'][$j] == $function_name)
		{
			$parse_param->vars['builtin_function'][$j] = $builtin_function;
		}
	}						

	if (is_reserved_word( $function_name ) )
		syntax_error( 10, $parse_param, "'".$function_name."' cannot be defined as a function name it is a reserved word." );
	
	next_token( $parse_param );
	
	if ($parse_param->curr_tok != TOK_LPARENTHESIS)
		syntax_error( 11, $parse_param, "Expected '(' after a function name." );

	next_token( $parse_param );

    $number_of_arguments = 0;
	
	while ($parse_param->curr_tok != TOK_RPARENTHESIS && $parse_param->curr_tok != TOK_EOF)
	{
		$type = parse_data_type( $parse_param, $ic, $ic_pos, $number_of_dimensions, false );
		
		$argument_names[$number_of_arguments++] = $parse_param->curr_token_text;

		if ($already_defined)
		{
			for ($j=0; $j < $parse_param->vars['number_of_function_arguments'][$current_function_number]; $j++)
			{
				if ($parse_param->vars['function_arguments'][$current_function_number][$j]['name'] == $parse_param->curr_token_text)
				{
					if ($parse_param->vars['function_arguments'][$current_function_number][$j]['type'] != $type)
						semantic_error( 165, $parse_param, "Type mismatch in function definition/declaration: the type of argument '".$parse_param->vars['function_arguments'][$current_function_number][$j]['name']."' in the function declaration does not match the type in the function definition." );
				}
			}
		}			 

		if (! $already_defined)
		{
			for ($j=0; $j < $parse_param->vars['number_of_function_arguments'][$current_function_number]; $j++)
			{
				if ($parse_param->vars['function_arguments'][$current_function_number][ $j ]['name'] == $parse_param->curr_token_text)
					syntax_error( 150, $parse_param, "Cannot declare a function argument with the name ".$parse_param->curr_token_text." as there is already a function argument with this name." );
			}
			
			$parse_param->vars['function_arguments'][$current_function_number][$parse_param->vars['number_of_function_arguments'][$current_function_number]]['name'] = $parse_param->curr_token_text; 
			$parse_param->vars['function_arguments'][$current_function_number][$parse_param->vars['number_of_function_arguments'][$current_function_number]]['type'] = $type; 
			$parse_param->vars['function_arguments'][$current_function_number][$parse_param->vars['number_of_function_arguments'][$current_function_number]]['number_of_indexes'] = $number_of_dimensions; 
			$parse_param->vars['number_of_function_arguments'][$current_function_number]++;
		}
					
		next_token( $parse_param );

		if ($parse_param->curr_tok != TOK_COMMA && $parse_param->curr_tok != TOK_RPARENTHESIS)
			syntax_error( 12, $parse_param, "Expected a ',' or ')' after function arguments." );
		
		if ($parse_param->curr_tok == TOK_COMMA)
			next_token( $parse_param );
	}
	
	if ($parse_param->curr_tok != TOK_RPARENTHESIS)
		syntax_error( 13, $parse_param, "Expected ';' after a var statement." );

	next_token( $parse_param );

	if ($parse_param->curr_tok == TOK_SEMICOLON)
	{
		$parse_param->vars['number_of_declarations'][$current_function_number]++;
		
		if ($parse_param->vars['number_of_declarations'][$current_function_number] > 1)
			semantic_error( 163, $parse_param, "Cannot declare a function with the name '".$function_name."' as there is already a function defined with this name" );
		
		next_token( $parse_param );
	}
	else
	{
		$parse_param->vars['number_of_definitions'][$current_function_number]++;

		if ($parse_param->vars['number_of_definitions'][$current_function_number] > 1)
			semantic_error( 164, $parse_param, "Cannot define a function with the name '".$function_name."' as there is already a function defined with this name" );
		
			// function declaration names may not match the function definion names
			
		for ($j=0; $j < $number_of_arguments; $j++)
			$parse_param->vars['function_arguments'][$current_function_number][$j]['name'] = $argument_names[$j];
		
		
		$label_num2 = $parse_param->label_num;
	
		$parse_param->label_num++;

		for ($j=0; $j < $parse_param->vars['number_of_user_functions']; $j++)
		{
			if ($parse_param->vars['function_name'][$j] == $function_name)
				$parse_param->vars['function_has_been_defined'][$j] = true;
		}

		gen_code( $parse_param, $ic, $ic_pos, OP_JMP, $label_num2 );
		
		gen_code( $parse_param, $ic, $ic_pos, OP_START_FUNCTION, $current_function_number );
		
		if ($parse_param->curr_tok != TOK_LBRACE)
			syntax_error( 14, $parse_param, "Expected '{' after a function name." );

		next_token( $parse_param );
		
		parse_statlist( $parse_param, $ic, $ic_pos, $current_function_number, $in_void_function );
	
		gen_code( $parse_param, $ic, $ic_pos, OP_RETURN, $current_function_number );

		gen_code( $parse_param, $ic, $ic_pos, OP_LABEL, $label_num2 );

		
		if ($parse_param->curr_tok != TOK_RBRACE)
			syntax_error( 15, $parse_param, "Expected '}' after a function statements." );

		next_token( $parse_param );
	}
}

	
	function parse_statlist( $parse_param, &$ic, &$ic_pos, &$current_function_number, $in_void_function )
	{
		if ($parse_param->show_parse_trace)
			echo "called parse_statlist<br>"; 				

		while ($parse_param->curr_tok != TOK_EOF && $parse_param->curr_tok != TOK_RBRACE)
			parse_stat( $parse_param, $ic, $ic_pos, $current_function_number, $in_void_function );

		if ($parse_param->show_parse_trace)
			echo "parse_statlist returned<br>"; 				
	}

	
		// exit function with next token after ';' as current token
		
	function parse_stat( $parse_param, &$ic, &$ic_pos, &$current_function_number, $in_void_function )
	{
		if ($parse_param->show_parse_trace)
			echo "called parse_stat<br>"; 	
		
		$allow_void = false;			

        if ($parse_param->curr_tok == TOK_SEMICOLON)
		{
			next_token( $parse_param );
		}
		else
        if ($parse_param->curr_tok == TOK_IF)
		{
			parse_if_statment( $parse_param, $ic, $ic_pos, $num_dimensions, $allow_void, $current_function_number, $in_void_function );			
		}
		else
        if ($parse_param->curr_tok == TOK_FOR)
		{
			parse_for_statement( $parse_param, $ic, $ic_pos, $num_dimensions, $allow_void, $current_function_number, $in_void_function );			
		}
		else
        if ($parse_param->curr_tok == TOK_WHILE)
		{
			parse_while_statment( $parse_param, $ic, $ic_pos, $num_dimensions, $allow_void, $current_function_number, $in_void_function );			
		}
		else
		if ($parse_param->curr_tok == TOK_NAME)
		{
			$name = $parse_param->curr_token_text;
			
			$function_name = $parse_param->curr_token_text;
				
			$is_function = false;
			
			for ($j=0; $j < $parse_param->vars['number_of_user_functions']; $j++)
			{
				if ($parse_param->vars['function_name'][$j] == $function_name)
				{
					$is_function = true;
					
					$parse_param->vars['has_been_called'][$j] = true;
				}
			}
				
			if ($is_function)
			{
				next_token( $parse_param );

				$type = parse_function_call( $parse_param, $ic, $ic_pos, $current_function_number, $function_name );				

				gen_code( $parse_param, $ic, $ic_pos, OP_POP_DISCARD );
				
				next_token( $parse_param );
			}
			else
			{
				if ($name == "result" && $in_void_function)
					semantic_error( 145, $parse_param, "Cannot assign a value to 'result' in a void function." );
				
				$array_name = $name;
				
				check_var_declaration( $parse_param, $current_function_number, $type, $name, $number_of_indexes );
					
				$left_side_type = $type;
				
				next_token( $parse_param );
			
				$is_aggregate_type = false;
			
				$left_side_dereference = false;
			
				if ($parse_param->curr_tok == TOK_LBRACKET || $parse_param->curr_tok == TOK_DOT)
				{
					$is_aggregate_type = true;
					
					$left_side_dereference = true;
					
					$left_side_type = parse_aggregate_expression( $parse_param, $ic, $ic_pos, $num_dimensions, $allow_void, $type, $current_function_number, $array_name, $number_of_dereferences );
					
					if ($parse_param->decimal_arithmetic)
						gen_code( $parse_param, $ic, $ic_pos, OP_PUSH_CONST, (string) $number_of_dereferences );
					else
						gen_code( $parse_param, $ic, $ic_pos, OP_PUSH_CONST, (int) $number_of_dereferences );
				}
	
//				if (strpos( $left_side_type, " " ) !== false)
//					semantic_error( 166, $parse_param, "Only assignment of simple data types is currently supported." );
								
				if ($parse_param->curr_tok == TOK_ASSIGN_INC ||
					$parse_param->curr_tok == TOK_ASSIGN_DEC ||
					$parse_param->curr_tok == TOK_ASSIGN_MULT ||
					$parse_param->curr_tok == TOK_ASSIGN_DIV )
				{
					if (! is_numeric_type( $left_side_type ))
						semantic_error( 153, $parse_param, "Data type on the left side of a ".$parse_param->curr_token_text." operation must be numeric." );
				}

				if ($parse_param->curr_tok == TOK_ASSIGN_STRCONCAT)
				{
					if ($left_side_type != "string")
						semantic_error( 157, $parse_param, "Data type on the left side of an &= operation must be a string." );
				}

				if ($left_side_dereference && 
					($parse_param->curr_tok == TOK_ASSIGN_INC ||
					$parse_param->curr_tok == TOK_ASSIGN_DEC ||
					$parse_param->curr_tok == TOK_ASSIGN_MULT ||
					$parse_param->curr_tok == TOK_ASSIGN_DIV ||
					$parse_param->curr_tok == TOK_ASSIGN_STRCONCAT))
				{
					semantic_error( 147, $parse_param, $parse_param->curr_token_text." is currently only supported on simple variables." );
				}					
	
				if ($parse_param->curr_tok == TOK_ASSIGN ||
					$parse_param->curr_tok == TOK_ASSIGN_INC ||
					$parse_param->curr_tok == TOK_ASSIGN_DEC ||
					$parse_param->curr_tok == TOK_ASSIGN_MULT ||
					$parse_param->curr_tok == TOK_ASSIGN_DIV ||
					$parse_param->curr_tok == TOK_ASSIGN_STRCONCAT)
				{	
					parse_assignment_right_side( $parse_param, $ic, $ic_pos, $num_dimensions, false, $current_function_number, $name, $left_side_type, $left_side_dereference, $in_void_function );
				}
				else				
				if ($parse_param->curr_tok == TOK_INC)
				{
					check_var_declaration( $parse_param, $current_function_number, $type, $name, $number_of_indexes );
					
					if (! is_numeric_type( $type ))
						semantic_error( 44, $parse_param, "Data type must be numeric." );
					
					if (is_global_variable( $parse_param, $current_function_number, $name ))
						gen_code( $parse_param, $ic, $ic_pos, OP_INC_ABS, $name );
					else
						gen_code( $parse_param, $ic, $ic_pos, OP_INC_REL, $name );
	
					next_token( $parse_param );
				}
				else
				if ($parse_param->curr_tok == TOK_DEC)
				{
					check_var_declaration( $parse_param, $current_function_number, $type, $name, $number_of_indexes );
					
					if (! is_numeric_type( $type ))
						semantic_error( 45, $parse_param, "Data type must be numeric." );
					
					if (is_global_variable( $parse_param, $current_function_number, $name ))
						gen_code( $parse_param, $ic, $ic_pos, OP_DEC_ABS, $name );
					else
						gen_code( $parse_param, $ic, $ic_pos, OP_DEC_REL, $name );
	
					next_token( $parse_param );
				}
				else				
					syntax_error( 46, $parse_param, "Expected '=' or '(' after a name: ".$parse_param->curr_token_text."." );
				
				if ($parse_param->curr_tok != TOK_SEMICOLON)
					syntax_error( 47, $parse_param, "Expected ';' after a statement." );
			
				next_token( $parse_param );
			}
		}
		else	
		if ($parse_param->curr_tok == TOK_VAR)
		{
			parse_variable_declaration( $parse_param, $ic, $ic_pos, $num_dimensions, false, $current_function_number );			
		}
		else		
			syntax_error( 64, $parse_param, "Expected 'if', 'while' or a function or variable name" );

		if ($parse_param->show_parse_trace)
			echo "parse_stat returned<br>"; 				
	}


				
function parse_aggregate_expression( $parse_param, &$ic, &$ic_pos, &$num_dimensions, $allow_void, $expression_type, $current_function_number, $name, &$number_of_dereferences )
{
	if ($parse_param->show_parse_trace)
		echo "called parse_aggregate_expression<br>"; 				
				
	$first_item = true;

	$number_of_dereferences = 0;
		
	while ($parse_param->curr_tok == TOK_LBRACKET || $parse_param->curr_tok == TOK_DOT)
	{
		$prev_is_array = false;
		
		if ($parse_param->curr_tok == TOK_LBRACKET)
		{
			if ($prev_is_array)
				semantic_error( 131, $parse_param, "An array cannot contain another array, only simple data types or user-defined types. To specify an array with multiple dimensions use the syntax [index1, index2, index3 etc]." );
			
			$prev_is_array = true;

			check_var_declaration( $parse_param, $current_function_number, $type, $name, $number_of_indexes );
	
			$index_types = explode( " ", $expression_type );
	
			$number_of_indexes = (count( $index_types ) - 2)/2;		// 'array' <datatype> index1_type index1_count index2_type index2_count
	
			for ($j=0; $j < $number_of_indexes; $j++)
				$index_types[$j] = $index_types[ 2 + ($j*2) ];
			
			$array_name = $name;
											
			$this_number_of_indexes = $number_of_indexes;
			
			next_token( $parse_param );
			
			$type = parse_num_expr( $parse_param, $ic, $ic_pos, $current_function_number );
	
			$index_number = 0;
	
			if (isset( $index_types[2+($index_number*2)] ))
			{
				if ($index_types[2+($index_number*2)] != $type)
					semantic_error( 39, $parse_param, "Expected a type '".$index_types[2+($index_number*2)]."' for index number ".$index_number." but type supplied is '".$type."'." );	
			}
			else
				semantic_error( 123, $parse_param, "Incorrect array index count: '".$array_name."'." );	
			
			while ($parse_param->curr_tok == TOK_COMMA)
			{
				$index_number++;
				
				next_token( $parse_param );
	
				$type = parse_num_expr( $parse_param, $ic, $ic_pos, $current_function_number );
	
				if (isset( $index_types[2+($index_number*2)] ))
				{
					if ($index_types[2+($index_number*2)] != $type)
						semantic_error( 40, $parse_param, "Expected a type '".$index_types[2+($index_number*2)]."' for index number ".$index_number." but type supplied is '".$type."'." );
				}
				
				gen_code( $parse_param, $ic, $ic_pos, OP_STRCONCAT );
			}				
			
			$index_number++;
			
			if ($index_number != $number_of_indexes)
			{
				if ($index_number == 1)
					semantic_error( 41, $parse_param, "Expected ".$this_number_of_indexes." indexes for variable '".$array_name."' but received ".$index_number." index." );
				else
				if ($number_of_indexes == 1)
					semantic_error( 41, $parse_param, "Expected ".$this_number_of_indexes." index for variable '".$array_name."' but received ".$index_number." indexes." );
				else 
					semantic_error( 41, $parse_param, "Expected ".$this_number_of_indexes." indexes for variable '".$array_name."' but received ".$index_number." indexes." );
			}
			
			if ($parse_param->curr_tok != TOK_RBRACKET)
				syntax_error( 42, $parse_param, "Expected ']'." );
	
			next_token( $parse_param );

			$type4 = explode( " ", $expression_type );
			
			if (isset( $type4[1] ))
				$expression_type = $type4[1];
			else
				$expression_type = "";
		}
		else
		if ($parse_param->curr_tok == TOK_DOT)
		{
			next_token( $parse_param );
	
			$item_name = $parse_param->curr_token_text;
			 
			if ($parse_param->curr_tok != TOK_NAME)
				syntax_error( 130, $parse_param, "Expected a name after '.': ".$parse_param->curr_token_text );
	
			if ((! $parse_param->decimal_arithmetic) && is_numeric( $parse_param->curr_token_text ))
				gen_code( $parse_param, $ic, $ic_pos, OP_PUSH_CONST, (double) $parse_param->curr_token_text );
			else
				gen_code( $parse_param, $ic, $ic_pos, OP_PUSH_CONST, (string) $parse_param->curr_token_text );
			
//			gen_code( $parse_param, $ic, $ic_pos, OP_PUSH_CONST, ":".$parse_param->curr_token_text );

//			if (! $first_item)	
//				gen_code( $parse_param, $ic, $ic_pos, OP_STRCONCAT );
			
			next_token( $parse_param );
			
			$found = false;
			
			for ($j=0; $j < $parse_param->num_user_defined_types; $j++)
			{
				if ($parse_param->user_defined_types[$j]['type_name'] == $expression_type)
				{
					for ($k=0; $k < $parse_param->user_defined_types[$j]['num_items']; $k++)
					{
						if ($parse_param->user_defined_types[$j]['item_name'][$k] == $item_name)
						{
							$expression_type = $parse_param->user_defined_types[$j]['item_type'][$k];
							
							$found = true;
						}
					}
				}
			}
			
			if (! $found)
				semantic_error( 136, $parse_param, "Struct item '".$item_name."' for type '".$expression_type."' not found." );
		}

		$number_of_dereferences++;

		$first_item = false;
	}

	if ($parse_param->show_parse_trace)
		echo "parse_aggregate_expression returned<br>"; 				

	return ($expression_type);
}



function parse_assignment_right_side( $parse_param, &$ic, &$ic_pos, &$num_dimensions, $allow_void, $current_function_number, $name, $left_side_type, $left_side_dereference )
{
	if ($parse_param->show_parse_trace)
		echo "called parse_assignment_right_side<br>"; 				

	if ($parse_param->curr_tok == TOK_ASSIGN)
	{
		check_var_declaration( $parse_param, $current_function_number, $type, $name, $number_of_indexes );
		
		$array_type = $type;
		
		next_token( $parse_param );
		
		$right_side_type = parse_num_expr( $parse_param, $ic, $ic_pos, $current_function_number );

		if (! check_types( $parse_param, $ic, $ic_pos, $left_side_type, $right_side_type, true, 0 ))
			semantic_error( 35, $parse_param, "Data types in an assignment expression must match, both be numeric, or be to type string: '".$left_side_type."' and '".$right_side_type."'." );

//		if (! ($right_side_type == $left_side_type || (is_numeric_type( $right_side_type ) && is_numeric_type( $left_side_type ))))
//			semantic_error( 35, $parse_param, "Data types in assignment expression must match or both be numeric: '".$left_side_type."' and '".$right_side_type."'." );

		check_var_declaration( $parse_param, $current_function_number, $type, $name, $number_of_indexes );
	
		if ($left_side_dereference )
		{			
			if (is_global_variable( $parse_param, $current_function_number, $name ))
				gen_code( $parse_param, $ic, $ic_pos, OP_POP_ABS_ARRAY, $name, $array_type );
			else
				gen_code( $parse_param, $ic, $ic_pos, OP_POP_REL_ARRAY, $name, $array_type );
		}
		else
		{	
			if (is_global_variable( $parse_param, $current_function_number, $name ))
				gen_code( $parse_param, $ic, $ic_pos, OP_POP_ABS, $name );
			else
				gen_code( $parse_param, $ic, $ic_pos, OP_POP_REL, $name );
		}
	}
	else
	if ($parse_param->curr_tok == TOK_ASSIGN_INC ||
		$parse_param->curr_tok == TOK_ASSIGN_DEC ||
		$parse_param->curr_tok == TOK_ASSIGN_MULT ||
		$parse_param->curr_tok == TOK_ASSIGN_DIV)
	{
		$operat = $parse_param->curr_tok;
		$operat_text = $parse_param->curr_token_text;
		
		check_var_declaration( $parse_param, $current_function_number, $type, $name, $number_of_indexes );
		
		next_token( $parse_param );

		if (is_global_variable( $parse_param, $current_function_number, $name ))
			gen_code( $parse_param, $ic, $ic_pos, OP_PUSH_ABS, $name );
		else
			gen_code( $parse_param, $ic, $ic_pos, OP_PUSH_REL, $name );
		
		
		$right_side_type = parse_num_expr( $parse_param, $ic, $ic_pos, $current_function_number );

		if (! is_numeric_type( $right_side_type ) )
			semantic_error( 155, $parse_param, "Data type of the expression on the right side of an ".$operat_text." must be numeric." );

		if ($operat == TOK_ASSIGN_INC)
			gen_code( $parse_param, $ic, $ic_pos, OP_ADD, $name );
		else
		if ($operat == TOK_ASSIGN_DEC)
			gen_code( $parse_param, $ic, $ic_pos, OP_SUBTRACT, $name );
		else
		if ($operat == TOK_ASSIGN_MULT)
			gen_code( $parse_param, $ic, $ic_pos, OP_MULT, $name );
		else
		if ($operat == TOK_ASSIGN_DIV)
			gen_code( $parse_param, $ic, $ic_pos, OP_DIV, $name );


		check_var_declaration( $parse_param, $current_function_number, $type, $name, $number_of_indexes );
	
		if ($left_side_dereference )
		{			
			if (is_global_variable( $parse_param, $current_function_number, $name ))
				gen_code( $parse_param, $ic, $ic_pos, OP_POP_ABS_ARRAY, $name );
			else
				gen_code( $parse_param, $ic, $ic_pos, OP_POP_REL_ARRAY, $name );
		}
		else
		{	
			if (is_global_variable( $parse_param, $current_function_number, $name ))
				gen_code( $parse_param, $ic, $ic_pos, OP_POP_ABS, $name );
			else
				gen_code( $parse_param, $ic, $ic_pos, OP_POP_REL, $name );
		}
	}
/*
	else
	if ($parse_param->curr_tok == TOK_ASSIGN_DEC)
	{
		check_var_declaration( $parse_param, $current_function_number, $type, $name, $number_of_indexes );
		
		next_token( $parse_param );
		

		if (is_global_variable( $parse_param, $current_function_number, $name ))
			gen_code( $parse_param, $ic, $ic_pos, OP_PUSH_ABS, $name );
		else
			gen_code( $parse_param, $ic, $ic_pos, OP_PUSH_REL, $name );
		
		
		$right_side_type = parse_num_expr( $parse_param, $ic, $ic_pos, $current_function_number );

		if (! is_numeric_type( $right_side_type ) )
			semantic_error( 156, $parse_param, "Data type of the expression on the right side of an -= must be numeric." );

		gen_code( $parse_param, $ic, $ic_pos, OP_SUBTRACT, $name );

		check_var_declaration( $parse_param, $current_function_number, $type, $name, $number_of_indexes );
	
		if ($left_side_dereference )
		{			
			if (is_global_variable( $parse_param, $current_function_number, $name ))
				gen_code( $parse_param, $ic, $ic_pos, OP_POP_ABS_ARRAY, $name );
			else
				gen_code( $parse_param, $ic, $ic_pos, OP_POP_REL_ARRAY, $name );
		}
		else
		{	
			if (is_global_variable( $parse_param, $current_function_number, $name ))
				gen_code( $parse_param, $ic, $ic_pos, OP_POP_ABS, $name );
			else
				gen_code( $parse_param, $ic, $ic_pos, OP_POP_REL, $name );
		}
	}
*/ 
	else
	if ($parse_param->curr_tok == TOK_ASSIGN_STRCONCAT)
	{
		check_var_declaration( $parse_param, $current_function_number, $type, $name, $number_of_indexes );
		
		next_token( $parse_param );
		

		if (is_global_variable( $parse_param, $current_function_number, $name ))
			gen_code( $parse_param, $ic, $ic_pos, OP_PUSH_ABS, $name );
		else
			gen_code( $parse_param, $ic, $ic_pos, OP_PUSH_REL, $name );
		
		$right_side_type = parse_num_expr( $parse_param, $ic, $ic_pos, $current_function_number );

		if ($left_side_type != "string")
			semantic_error( 38, $parse_param, "Data type on the left side of a &=must be of type 'string'." );

		if (! check_types( $parse_param, $ic, $ic_pos, $left_side_type, $right_side_type, true, 0 ))
			semantic_error( 158, $parse_param, "The data type of the expression on the right side of an &= must be convertable to string: '".$right_side_type."'." );

		gen_code( $parse_param, $ic, $ic_pos, OP_STRCONCAT, $name );

		check_var_declaration( $parse_param, $current_function_number, $type, $name, $number_of_indexes );
	
		if ($left_side_dereference )
		{			
			if (is_global_variable( $parse_param, $current_function_number, $name ))
				gen_code( $parse_param, $ic, $ic_pos, OP_POP_ABS_ARRAY, $name );
			else
				gen_code( $parse_param, $ic, $ic_pos, OP_POP_REL_ARRAY, $name );
		}
		else
		{	
			if (is_global_variable( $parse_param, $current_function_number, $name ))
				gen_code( $parse_param, $ic, $ic_pos, OP_POP_ABS, $name );
			else
				gen_code( $parse_param, $ic, $ic_pos, OP_POP_REL, $name );
		}
	}

	if ($parse_param->show_parse_trace)
		echo " returned<br>"; 				
}

function parse_const_declaration( $parse_param, &$ic, &$ic_pos, &$num_dimensions, $allow_void )
{
	next_token( $parse_param );
	
	$type = $parse_param->curr_token_text;
	
	if (! is_data_type( $parse_param, $parse_param->curr_tok, $parse_param->curr_token_text ))
		syntax_error( 59, $parse_param, "Expected a data type: ".$parse_param->curr_token_text );

	next_token( $parse_param );
	
	if ($parse_param->curr_tok != TOK_NAME)
		syntax_error( 60, $parse_param, "Expected a name after a 'const'" );
	
	if (is_reserved_word( $parse_param->curr_token_text ) )
		syntax_error( 61, $parse_param, "'".$parse_param->curr_token_text."' cannot be defined as a variable name it is a reserved word" );
	
	$const_name = $parse_param->curr_token_text;

	next_token( $parse_param );

	if ($parse_param->curr_tok != TOK_ASSIGN)
		syntax_error( 62, $parse_param, "Expected a '=' after a 'const' name" );
	
	next_token( $parse_param );
				
	if (isset( $parse_param->constants[$const_name]['value'] ))
		syntax_error( 149, $parse_param, "Cannot define a constant with the name '".$const_name."' because there is already a constant defined with that name." );
	else
	{
		$parse_param->constants[$const_name]['value'] = $parse_param->curr_token_text;
		$parse_param->constants[$const_name]['type'] = $type; 
	}
	
	next_token( $parse_param );

	if ($parse_param->curr_tok != TOK_SEMICOLON)
		syntax_error( 63, $parse_param, "Expected a ';' after a 'const'" );

	next_token( $parse_param );
}


			
function parse_variable_declaration( $parse_param, &$ic, &$ic_pos, &$num_dimensions, $allow_void, $current_function_number )
{
	next_token( $parse_param );

	$type = parse_data_type( $parse_param, $ic, $ic_pos,  $number_of_dimensions, false );
	
	while ($parse_param->curr_tok != TOK_SEMICOLON && $parse_param->curr_tok != TOK_EOF)
	{
		if ($parse_param->curr_tok != TOK_NAME)
			syntax_error( 54, $parse_param, "Expected the word 'array' or a name after a 'var'." );
		
		if (is_reserved_word( $parse_param->curr_token_text ) )
			syntax_error( 55, $parse_param, "'".$parse_param->curr_token_text."' cannot be defined as a variable name it is a reserved word." );
		
		if ($parse_param->in_function)
		{
			for ($j=0; $j < $parse_param->vars['number_of_function_arguments'][$current_function_number]; $j++)
			{
				if ($parse_param->vars['function_arguments'][$current_function_number][$j]['name'] == $parse_param->curr_token_text)
					semantic_error( 56, $parse_param, "Cannot declare a local variable with the name '".$parse_param->curr_token_text."' in this function because there is a function parameter with the same name." );
			}

			for ($j=0; $j < $parse_param->vars['number_of_local_variables'][$current_function_number]; $j++)
			{
				if ($parse_param->vars['local_variables'][$current_function_number][$j]['name'] == $parse_param->curr_token_text)
					semantic_error( 134, $parse_param, "Cannot declare a local variable with the name '".$parse_param->curr_token_text."' there is already a local variable with this name." );
			}
		
			$parse_param->vars['local_variables'][$current_function_number][$parse_param->vars['number_of_local_variables'][$current_function_number]]['name'] = $parse_param->curr_token_text;
			$parse_param->vars['local_variables'][$current_function_number][$parse_param->vars['number_of_local_variables'][$current_function_number]]['type'] = $type;
			$parse_param->vars['local_variables'][$current_function_number][$parse_param->vars['number_of_local_variables'][$current_function_number]]['number_of_indexes'] = $number_of_dimensions;
			$parse_param->vars['number_of_local_variables'][$current_function_number]++;
		}
		else
		{
			for ($j=0; $j < $parse_param->vars['number_of_global_variables']; $j++)
			{
				if ($parse_param->vars['global_variables'][$j]['name'] == $parse_param->curr_token_text)
					semantic_error( 135, $parse_param, "Cannot declare a global variable with the name '".$parse_param->curr_token_text."' there is already a global variable with this name." );
			}
						 
			$parse_param->vars['global_variables'][$parse_param->vars['number_of_global_variables']]['name'] = $parse_param->curr_token_text;
			$parse_param->vars['global_variables'][$parse_param->vars['number_of_global_variables']]['type'] = $type;
			$parse_param->vars['global_variables'][$parse_param->vars['number_of_global_variables']]['number_of_indexes'] = $number_of_dimensions; 
			$parse_param->vars['number_of_global_variables']++;
		}

		for ($j=0; $j < $parse_param->vars['number_of_user_functions']; $j++)
		{
			if ($parse_param->vars['function_name'][$j] == $parse_param->curr_token_text)
				semantic_error( 1337, $parse_param, "Cannot declare a variable with the name '".$parse_param->curr_token_text."' there is already a function with this name." );
		}			

		
		next_token( $parse_param );

		if ($parse_param->curr_tok != TOK_COMMA && $parse_param->curr_tok != TOK_SEMICOLON)
			syntax_error( 57, $parse_param, "Expected a ',' or ';' after a 'var' name" );
		
		if ($parse_param->curr_tok == TOK_COMMA)
			next_token( $parse_param );
	}
	
	if ($parse_param->curr_tok != TOK_SEMICOLON)
		syntax_error( 58, $parse_param, "Expected ';' after a var statement" );

	next_token( $parse_param );
}	


function parse_while_statment( $parse_param, &$ic, &$ic_pos, &$num_dimensions, $allow_void, $current_function_number, $in_void_function )
{
	if ($parse_param->show_parse_trace)
		echo "called parse_while_statment<br>"; 				
	
	next_token( $parse_param );
	
	if ($parse_param->curr_tok != TOK_LPARENTHESIS)
		syntax_error( 31, $parse_param, "Expected '(' after 'while'." );

	next_token( $parse_param );
	
	$label_num4 = $parse_param->label_num;
		
	gen_code( $parse_param, $ic, $ic_pos, OP_LABEL, $label_num4 );
		
	$parse_param->label_num++;
	
	$type = parse_bool_expr( $parse_param, $ic, $ic_pos, $current_function_number );

	if ($type != "bool")
		semantic_error( 32, $parse_param, "Expected a boolean expression." );

	$label_num5 = $parse_param->label_num;

	$parse_param->label_num++;

	gen_code( $parse_param, $ic, $ic_pos, OP_JMP_FALSE, $label_num5 );

	if ($parse_param->curr_tok != TOK_RPARENTHESIS)
		syntax_error( 33, $parse_param, "Expected ')' after boolean expression." );

	next_token( $parse_param );

	if ($parse_param->curr_tok != TOK_LBRACE)
	{
		parse_stat( $parse_param, $ic, $ic_pos, $current_function_number, $in_void_function );
	} 					
	else
	{
		next_token( $parse_param );
		
		parse_statlist( $parse_param, $ic, $ic_pos, $current_function_number, $in_void_function );
		
		if ($parse_param->curr_tok != TOK_RBRACE)
			syntax_error( 34, $parse_param, "Expected '}' after a statement list." );
		
		next_token( $parse_param );
	}

	gen_code( $parse_param, $ic, $ic_pos, OP_JMP, $label_num4 );
	
	gen_code( $parse_param, $ic, $ic_pos, OP_LABEL, $label_num5 );
	
	if ($parse_param->show_parse_trace)
		echo "parse_while_statment returned<br>"; 				
}


function parse_for_statement( $parse_param, &$ic, &$ic_pos, &$num_dimensions, $allow_void, $current_function_number, $in_void_function )
{
	if ($parse_param->show_parse_trace)
		echo "called parse_for_statement<br>"; 				

	$step = "1";
	
	next_token( $parse_param );
	
	if ($parse_param->curr_tok != TOK_LPARENTHESIS)
		syntax_error( 23, $parse_param, "Expected '(' after 'while'." );

	next_token( $parse_param );
	
	if ($parse_param->curr_tok != TOK_NAME)
		syntax_error( 24, $parse_param, "Expected a variable name after 'for'." );
		
	$ctrl_variable_name = $parse_param->curr_token_text;
	
	check_var_declaration( $parse_param, $current_function_number, $type, $ctrl_variable_name, $number_of_indexes );
	
	next_token( $parse_param );
	
	if ($parse_param->curr_tok != TOK_ASSIGN)
		syntax_error( 25, $parse_param, "Expected a '=' after the 'for' variable name." );

	next_token( $parse_param );

	$type = parse_num_expr( $parse_param, $ic, $ic_pos, true, $current_function_number );

	if (! is_numeric_type( $type ))
		syntax_error( 26, $parse_param, "Expected a numeric expression for 'from'." );
	
	if (is_global_variable( $parse_param, $current_function_number, $ctrl_variable_name ))
		gen_code( $parse_param, $ic, $ic_pos, OP_POP_ABS, $ctrl_variable_name );
	else
		gen_code( $parse_param, $ic, $ic_pos, OP_POP_REL, $ctrl_variable_name );
	
	
	if ($parse_param->curr_tok != TOK_TO)
		syntax_error( 27, $parse_param, "Expected a 'to' after the 'for' variable name: ".$parse_param->curr_token_text."." );
	
	next_token( $parse_param );

	$type = parse_num_expr( $parse_param, $ic, $ic_pos, $current_function_number );

	if (! is_numeric_type( $type ))
		syntax_error( 28, $parse_param, "Expected a numeric expression for 'to'." );

	$label_num7 = $parse_param->label_num;
		
	gen_code( $parse_param, $ic, $ic_pos, OP_LABEL, $label_num7 );

	if ($parse_param->curr_tok == TOK_STEP)
	{
		next_token( $parse_param );
		
		$step = $parse_param->curr_token_text;
		
		if ($step == "-")
		{
			next_token( $parse_param );
			
			$step = "-".$parse_param->curr_token_text;
		}
		
		next_token( $parse_param );
	}

	$parse_param->label_num++;

	$label_num8 = $parse_param->label_num;

	$parse_param->label_num++;

//	gen_code( $parse_param, $ic, $ic_pos, OP_DUPLICATE, $ctrl_variable_name );

	if (is_global_variable( $parse_param, $current_function_number, $ctrl_variable_name ))
		gen_code( $parse_param, $ic, $ic_pos, OP_PUSH_ABS, $ctrl_variable_name );
	else
		gen_code( $parse_param, $ic, $ic_pos, OP_PUSH_REL, $ctrl_variable_name );

	if ($step > 0)
		gen_code( $parse_param, $ic, $ic_pos, OP_POP_JMP_GE, $label_num8 );
	else
		gen_code( $parse_param, $ic, $ic_pos, OP_POP_JMP_LE, $label_num8 );
/*		
	if ($step > 0)
		gen_code( $parse_param, $ic, $ic_pos, OP_GE );
	else
		gen_code( $parse_param, $ic, $ic_pos, OP_LE );

	gen_code( $parse_param, $ic, $ic_pos, OP_JMP_FALSE, $label_num8 );
*/
	
	if ($parse_param->curr_tok != TOK_RPARENTHESIS)
		syntax_error( 29, $parse_param, "Expected a ')' after the 'for' statement." );

	next_token( $parse_param );

	if ($parse_param->curr_tok != TOK_LBRACE)
	{
		parse_stat( $parse_param, $ic, $ic_pos, $current_function_number, $in_void_function );
	} 					
	else
	{
		next_token( $parse_param );
		
		parse_statlist( $parse_param, $ic, $ic_pos, $current_function_number, $in_void_function );
		
		if ($parse_param->curr_tok != TOK_RBRACE)
			syntax_error( 30, $parse_param, "Expected '}' after a statement list." );
		
		next_token( $parse_param );
	}

	if ($step == "1")
	{
		if (is_global_variable( $parse_param, $current_function_number, $ctrl_variable_name ))
			gen_code( $parse_param, $ic, $ic_pos, OP_INC_ABS, $ctrl_variable_name );
		else
			gen_code( $parse_param, $ic, $ic_pos, OP_INC_REL, $ctrl_variable_name );
	}				
	else
	if ($step == -1)
	{
		if (is_global_variable( $parse_param, $current_function_number, $ctrl_variable_name ))
			gen_code( $parse_param, $ic, $ic_pos, OP_DEC_ABS, $ctrl_variable_name );
		else
			gen_code( $parse_param, $ic, $ic_pos, OP_DEC_REL, $ctrl_variable_name );
	}
	else
	{
		if (is_global_variable( $parse_param, $current_function_number, $ctrl_variable_name ))
			gen_code( $parse_param, $ic, $ic_pos, OP_PUSH_ABS, $ctrl_variable_name );
		else
			gen_code( $parse_param, $ic, $ic_pos, OP_PUSH_REL, $ctrl_variable_name );

		if ($parse_param->decimal_arithmetic)
			gen_code( $parse_param, $ic, $ic_pos, OP_PUSH_CONST, (string) $step );
		else
			gen_code( $parse_param, $ic, $ic_pos, OP_PUSH_CONST, (double) $step );
		
		gen_code( $parse_param, $ic, $ic_pos, OP_ADD );
		
		if (is_global_variable( $parse_param, $current_function_number, $ctrl_variable_name ))
			gen_code( $parse_param, $ic, $ic_pos, OP_POP_ABS, $ctrl_variable_name );
		else
			gen_code( $parse_param, $ic, $ic_pos, OP_POP_REL, $ctrl_variable_name );
		
	}

	gen_code( $parse_param, $ic, $ic_pos, OP_JMP, $label_num7 );
	
	gen_code( $parse_param, $ic, $ic_pos, OP_LABEL, $label_num8 );
	
	gen_code( $parse_param, $ic, $ic_pos, OP_POP_DISCARD );

	if ($parse_param->show_parse_trace)
		echo "parse_for_statement returned<br>"; 				
}


function parse_if_statment( $parse_param, &$ic, &$ic_pos, &$num_dimensions, $allow_void, $current_function_number, $in_void_function )
{
	if ($parse_param->show_parse_trace)
		echo "called parse_if_statment<br>"; 				
	
	next_token( $parse_param );

	if ($parse_param->curr_tok != TOK_LPARENTHESIS)
		syntax_error( 18, $parse_param, "Expected '(' after an if." );

	next_token( $parse_param );
	
	$type = parse_bool_expr( $parse_param, $ic, $ic_pos, $current_function_number );

	if ($type != "bool")
		semantic_error( 19, $parse_param, "Expected a boolean expression." );

	$label_num1 = $parse_param->label_num;
	
	gen_code( $parse_param, $ic, $ic_pos, OP_JMP_FALSE, $label_num1 );

	$parse_param->label_num++;

	if ($parse_param->curr_tok != TOK_RPARENTHESIS)
		syntax_error( 20, $parse_param, "Expected ')' after an if expression." );

	next_token( $parse_param );

							
	if ($parse_param->curr_tok != TOK_LBRACE)
	{
		parse_stat( $parse_param, $ic, $ic_pos, $current_function_number, $in_void_function );
	}					
	else
	{
		next_token( $parse_param );
		
		parse_statlist( $parse_param, $ic, $ic_pos, $current_function_number, $in_void_function );
							
		if ($parse_param->curr_tok != TOK_RBRACE)
			syntax_error( 21, $parse_param, "Expected '}' after a statement list." );
		
		next_token( $parse_param );
	}

	if ($parse_param->curr_tok == TOK_ELSE)
	{
		$label_num2 = $parse_param->label_num;

		gen_code( $parse_param, $ic, $ic_pos, OP_JMP, $label_num2 );
		
		gen_code( $parse_param, $ic, $ic_pos, OP_LABEL, $label_num1 );
		
		$parse_param->label_num++;
					
		next_token( $parse_param );

		if ($parse_param->curr_tok != TOK_LBRACE)
		{
			parse_stat( $parse_param, $ic, $ic_pos, $current_function_number, $in_void_function );
			
//					if ($parse_param->curr_tok != TOK_SEMICOLON)
//						syntax_error( $parse_param, "Expected ';' after a statement" );
								
//					next_token( $parse_param );
		}					
		else
		{
			next_token( $parse_param );
			
			parse_statlist( $parse_param, $ic, $ic_pos, $current_function_number, $in_void_function );

			if ($parse_param->curr_tok != TOK_RBRACE)
				syntax_error( 22, $parse_param, "Expected '}' after a statement list." );

			next_token( $parse_param );
		}
		
		gen_code( $parse_param, $ic, $ic_pos, OP_LABEL, $label_num2 );
	}
	else	
		gen_code( $parse_param, $ic, $ic_pos, OP_LABEL, $label_num1 );

	if ($parse_param->show_parse_trace)
		echo "parse_if_statment returned<br>"; 				
}



function parse_include_statement( $parse_param, &$ic, &$ic_pos )
{
	next_token( $parse_param );

	if ($parse_param->curr_tok != TOK_STRING_CONSTANT)
		syntax_error( 16, $parse_param, "Expected a pathname after 'include'." );

	$pathname = $parse_param->curr_token_text;

	if (sleft( $pathname, 5 ) == "https")
		$s2 = file_get_contents( $pathname );
	else
	{
		$fp = fopen( $pathname, "r" );
		
		$s2 = "";
		
		while (! feof( $fp ))
			$s2 = $s2.fread( $fp, 1000 );
		
		fclose( $fp );
	}
	
	
	$input_filename2 = $pathname;
	$j = 0;
	
	$parse_param->include_file_level++;
	
	$parse_param->program_text[$parse_param->include_file_level] = $s2;
	
	$parse_param->input_pos[$parse_param->include_file_level] = 0;
	
	$parse_param->current_filename[$parse_param->include_file_level] = $pathname;
	
	$parse_param->current_line_number[$parse_param->include_file_level] = 1;
	
	$parse_param->curr_tok = 0;
	
	$parse_param->curr_token_text = "";
	
	parse_file( $parse_param, $ic, $ic_pos );
	
	$parse_param->include_file_level--;
	
	next_token( $parse_param );

	if ($parse_param->curr_tok != TOK_SEMICOLON)
		syntax_error( 17, $parse_param, "Expected a ';' after an 'include'." );

	next_token( $parse_param );
}

	function parse_data_type( $parse_param, &$ic, &$ic_pos, &$num_dimensions, $allow_void )
	{
		$num_dimensions = 0;

		if ($allow_void && $parse_param->curr_tok == TOK_VOID)
		{
			$type = "void";

			next_token( $parse_param );
		}
		else
		{
			if ($parse_param->curr_tok == TOK_ARRAY)
			{
					// types for arrays:		array <type> index1_type index1_count index2_type index2_count
				$type = "array ";
				
				next_token( $parse_param );
	
				$type .= $parse_param->curr_token_text;
	
				if (! is_data_type( $parse_param, $parse_param->curr_tok, $parse_param->curr_token_text ))
					syntax_error( 65, $parse_param, "Expected a data type: ".$parse_param->curr_token_text );
	
				next_token( $parse_param );
				
	//			$array_name = $parse_param->curr_token_text;
				
	//			$num_dimensions = 0;
	
	/*			
				if ($parse_param->curr_tok != TOK_NAME)
					syntax_error( $parse_param, "Expected a name after a 'array'" );
				
				if (is_reserved_word( $parse_param->curr_token_text ) )
					syntax_error( $parse_param, "'".$parse_param->curr_token_text."' cannot be defined as a variable name it is a reserved word" );
	
				next_token( $parse_param );
	*/
				
				if ($parse_param->curr_tok != TOK_LBRACKET)
					syntax_error( 66, $parse_param, "Expected a '['" );
	
				$num_dimensions = 0;
	
				do
				{								
					next_token( $parse_param );
	
					$type .= " ".$parse_param->curr_token_text;
	
					if ($parse_param->curr_tok != TOK_INT)
						syntax_error( 68, $parse_param, "Expected 'int num' after '['" );
					
					{
						next_token( $parse_param );

						$type .= " ".$parse_param->curr_token_text;
	
						if ($parse_param->curr_tok != TOK_NUMBER)
							syntax_error( 67, $parse_param, "Expected a number after '[ int'" );
					}

/*					
					else
					if ($parse_param->curr_tok != TOK_STRING && 
						$parse_param->curr_tok != TOK_DATE &&
						$parse_param->curr_tok != TOK_TIME &&
						$parse_param->curr_tok != TOK_DATETIME)
							syntax_error( 68, $parse_param, "Expected 'int num' or 'string' or 'date' or 'time' or 'datetime'" );
*/
	
					next_token( $parse_param );
					
					$num_dimensions++;
				}
				while ($parse_param->curr_tok == TOK_COMMA);

				if ($parse_param->curr_tok != TOK_RBRACKET)
					syntax_error( 69, $parse_param, "Expected ']'" );

				next_token( $parse_param );
				
	//			if ($parse_param->curr_tok != TOK_SEMICOLON)
	//				syntax_error( $parse_param, "Expected ';' after a var statement" );
			
	//			next_token( $parse_param );
			}
			else
			{
				$type = $parse_param->curr_token_text;
				
				if (! is_data_type( $parse_param, $parse_param->curr_tok, $parse_param->curr_token_text ))
				{
					$found = false;
					
					for ($j=0; $j < $parse_param->num_user_defined_types; $j++)
					{
						if ($parse_param->user_defined_types[$j]['type_name'] == $type)
							$found = true;
					}
								
				
					if (! $found)
						syntax_error( 70, $parse_param, "Expected a data type: ".$parse_param->curr_token_text );
				}
				
				next_token( $parse_param );
			}
		}
		
		return ($type);
	}



	function parse_bool_expr( $parse_param, &$ic, &$ic_pos, $current_function_number )
	{
		if ($parse_param->show_parse_trace)
			echo "called parse_bool_expr<br>"; 				

        if ($parse_param->curr_tok == TOK_LPARENTHESIS)
		{
			next_token( $parse_param );
			
			$type = parse_bool_expr( $parse_param, $ic, $ic_pos, $current_function_number );

			if ($type != "bool")
				semantic_error( 71, $parse_param, "Expected a boolean expression" );
			
        	if ($parse_param->curr_tok != TOK_RPARENTHESIS)
				syntax_error( 72, $parse_param, "Expected ')' after boolean expression" );

			next_token( $parse_param );
		}
		else
		{
			$type = parse_comp_expr( $parse_param, $ic, $ic_pos, $current_function_number );

			if ($type != "bool")
				semantic_error( 73, $parse_param, "Expected a boolean expression" );
		}
			
		$op = $parse_param->curr_tok;
			 		
		while ($op == TOK_AND || $op == TOK_OR)
		{
			next_token( $parse_param );			
				
//		        if ($parse_param->curr_tok == TOK_LPARENTHESIS)
			{
//					next_token( $parse_param );
				
				$type = parse_bool_expr( $parse_param, $ic, $ic_pos, $current_function_number );
									
				if ($type != "bool")
					semantic_error( 74, $parse_param, "Expected a boolean expression" );
									
//	    	    	if ($parse_param->curr_tok != TOK_RPARENTHESIS)
//						syntax_error( $parse_param, "Expected ')' after boolean expression" );
												
//					next_token( $parse_param );
			}

	        if ($op == TOK_OR)
			{
				gen_code( $parse_param, $ic, $ic_pos, OP_OR );
			}
			else
	        if ($op == TOK_AND)
			{
				gen_code( $parse_param, $ic, $ic_pos, OP_AND );
			}
			
			$op = $parse_param->curr_tok;
		}
		
		if ($parse_param->show_parse_trace)
			echo "parse_bool_expr returned<br>";
		
		return ("bool");
	}


	function parse_comp_expr( $parse_param, &$ic, &$ic_pos, $current_function_number )
	{
		if ($parse_param->show_parse_trace)
			echo "called parse_comp_expr<br>"; 				

//		$not = false;
				
        if ($parse_param->curr_tok == TOK_NOT)
		{
//			$not = true;
			next_token( $parse_param );
			
	        if ($parse_param->curr_tok == TOK_LPARENTHESIS)
			{
				next_token( $parse_param );
				
				$type = parse_bool_expr( $parse_param, $ic, $ic_pos, $current_function_number );
				
				if ($type != "bool")
					semantic_error( 75, $parse_param, "Expected a boolean expression" );
								
    	    	if ($parse_param->curr_tok != TOK_RPARENTHESIS)
					syntax_error( 76, $parse_param, "Expected ')' after boolean expression" );
													
				next_token( $parse_param );
			}
			else
				parse_item_expr( $parse_param, $ic, $ic_pos, $current_function_number );
							
			gen_code( $parse_param, $ic, $ic_pos, OP_NOT );
		}			
		else
		{
			$type1 = parse_num_expr( $parse_param, $ic, $ic_pos, $current_function_number );

			if ($parse_param->curr_tok == TOK_EQ || 
				$parse_param->curr_tok == TOK_NE ||
				$parse_param->curr_tok == TOK_GE ||
				$parse_param->curr_tok == TOK_GT ||
				$parse_param->curr_tok == TOK_LE ||
				$parse_param->curr_tok == TOK_LT)
			{
				$operator = $parse_param->curr_tok;
				
				next_token( $parse_param );
		
				$type2 = parse_num_expr( $parse_param, $ic, $ic_pos, $current_function_number );
	
				if (! ($type1 == $type2 || (is_numeric_type( $type1 ) && is_numeric_type( $type2 ))))
					semantic_error( 77, $parse_param, "Data types must match or both be numeric: '".$type1."' and '".$type2."'" );
				
				if ($operator == TOK_EQ)	gen_code( $parse_param, $ic, $ic_pos, OP_EQ );
				if ($operator == TOK_NE)	gen_code( $parse_param, $ic, $ic_pos, OP_NE );
				if ($operator == TOK_GE)	gen_code( $parse_param, $ic, $ic_pos, OP_GE );
				if ($operator == TOK_GT)	gen_code( $parse_param, $ic, $ic_pos, OP_GT );
				if ($operator == TOK_LE)	gen_code( $parse_param, $ic, $ic_pos, OP_LE );
				if ($operator == TOK_LT)	gen_code( $parse_param, $ic, $ic_pos, OP_LT );
			}
		}

		if ($parse_param->show_parse_trace)
			echo "parse_comp_expr returned<br>";
		
		return ("bool"); 				
	}
	
	
	function parse_num_expr( $parse_param, &$ic, &$ic_pos, $current_function_number )
	{
		if ($parse_param->show_parse_trace)
			echo "called parse_num_expr<br>";
		
		$type1 = parse_add_expr( $parse_param, $ic, $ic_pos, $current_function_number );
		
		$type = $type1;
		
		$op = $parse_param->curr_tok;
		
		while ($op == TOK_ADDR_STRCONCAT)
		{
			next_token( $parse_param );
	
			if (! check_types( $parse_param, $ic, $ic_pos, "string", $type1, true, 0 ))
				semantic_error( 159, $parse_param, "The data type of an & operand must be convertable to string: ".$type1 );
		
			$type2 = parse_add_expr( $parse_param, $ic, $ic_pos, $current_function_number );

			if (! check_types( $parse_param, $ic, $ic_pos, "string", $type2, true, 0 ))
				semantic_error( 160, $parse_param, "The data type of an & operand must be convertable to string: ".$type2 );

			$type = "string";
			
			gen_code( $parse_param, $ic, $ic_pos, OP_STRCONCAT );
			
			$op = $parse_param->curr_tok;
		}
	
		if ($parse_param->show_parse_trace)
			echo "parse_num_expr returned<br>";
		
		return ($type); 				
	}

	
	function parse_add_expr( $parse_param, &$ic, &$ic_pos, $current_function_number )
	{
		if ($parse_param->show_parse_trace)
			echo "called parse_add_expr<br>";
		
		$type1 = parse_mult_expr( $parse_param, $ic, $ic_pos, $current_function_number );
		
		$type = $type1;
		
		$op = $parse_param->curr_tok;
		
		while ($op == TOK_PLUS || $op == TOK_SUBTRACT_MINUS)
		{
			next_token( $parse_param );
	
			$type2 = parse_mult_expr( $parse_param, $ic, $ic_pos, $current_function_number );

	        if ($op == TOK_PLUS || $op == TOK_SUBTRACT_MINUS)
			{
				if (! (is_numeric_type( $type1 ) && is_numeric_type( $type2 )))
					semantic_error( 78, $parse_param, "Data types must be numeric: ".$type1." and ".$type2 );
			}
			
	        if ($op == TOK_PLUS)
				gen_code( $parse_param, $ic, $ic_pos, OP_ADD );
			
	        if ($op == TOK_SUBTRACT_MINUS)
				gen_code( $parse_param, $ic, $ic_pos, OP_SUBTRACT );
			
			$op = $parse_param->curr_tok;
		
			if (is_numeric_type( $type1 ) && is_numeric_type( $type2 ))
				$type = promote_numeric_type( $type1, $type2 ); 
		}
	
		if ($parse_param->show_parse_trace)
			echo "parse_add_expr returned<br>";
		
		return ($type); 				
	}


	function parse_mult_expr( $parse_param, &$ic, &$ic_pos, $current_function_number )
	{
		if ($parse_param->show_parse_trace)
			echo "called parse_mult_expr<br>";
		
		$type1 = parse_exp_expr( $parse_param, $ic, $ic_pos, $current_function_number );
		
		$type = $type1;
		
		$op = $parse_param->curr_tok;

		if ($op == TOK_MULT || $op == TOK_DIV)
		{
			next_token( $parse_param );
	
			$type2 = parse_mult_expr( $parse_param, $ic, $ic_pos, $current_function_number );
			
			if (! (is_numeric_type( $type1 ) && is_numeric_type( $type2 )))
				semantic_error( 79, $parse_param, "Data types must be numeric" );
			
	        if ($op == TOK_MULT)
				gen_code( $parse_param, $ic, $ic_pos, OP_MULT );
			
	        if ($op == TOK_DIV)
				gen_code( $parse_param, $ic, $ic_pos, OP_DIV );
			
			$op = $parse_param->curr_tok;
		
			if (is_numeric_type( $type1 ) && is_numeric_type( $type2 ))
				$type = promote_numeric_type( $type1, $type2 ); 
		}

/*		
		while ($op == TOK_MULT || $op == TOK_DIV)
		{
			next_token( $parse_param );
	
			$type2 = parse_exp_expr( $parse_param, $ic, $ic_pos, $current_function_number );
			
			if (! (is_numeric_type( $type1 ) && is_numeric_type( $type2 )))
				semantic_error( 79, $parse_param, "Data types must be numeric" );
			
	        if ($op == TOK_MULT)
				gen_code( $parse_param, $ic, $ic_pos, OP_MULT );
			
	        if ($op == TOK_DIV)
				gen_code( $parse_param, $ic, $ic_pos, OP_DIV );
			
			$op = $parse_param->curr_tok;
		
			if (is_numeric_type( $type1 ) && is_numeric_type( $type2 ))
				$type = promote_numeric_type( $type1, $type2 ); 
		}
*/		
		if ($parse_param->show_parse_trace)
			echo "parse_mult_expr returned<br>";
		
		return ($type); 				
	}


	function parse_exp_expr( $parse_param, &$ic, &$ic_pos, $current_function_number )
	{
		if ($parse_param->show_parse_trace)
			echo "called parse_exp_expr<br>";
		
		$type1 = parse_item_expr( $parse_param, $ic, $ic_pos, $current_function_number );
		
		$type = $type1;
		
		$op = $parse_param->curr_tok;
		
		while ($op == TOK_POW)
		{
			next_token( $parse_param );
	
			$type2 = parse_item_expr( $parse_param, $ic, $ic_pos, $current_function_number );
	
			if (! (is_numeric_type( $type1 ) && is_numeric_type( $type2 )))
				semantic_error( 80, $parse_param, "Data types must be numeric" );
			
	        if ($op == TOK_POW)
				gen_code( $parse_param, $ic, $ic_pos, OP_POW );
			
			$op = $parse_param->curr_tok;
		
			if (is_numeric_type( $type1 ) && is_numeric_type( $type2 ))
				$type = promote_numeric_type( $type1, $type2 ); 
		}
		
		if ($parse_param->show_parse_trace)
			echo "parse_exp_expr returned<br>";
		
		return ($type);
	}


	function parse_item_expr( $parse_param, &$ic, &$ic_pos, $current_function_number )
	{
		if ($parse_param->show_parse_trace)
			echo "called parse_item_expr<br>";
		
		$is_num_constant = false;

		$allow_void = false;
		
		$s2 = "";

		$type = "";
		
		if ($parse_param->curr_tok != TOK_EOF)
		{
			if ($parse_param->curr_tok == TOK_SUBTRACT_MINUS)
			{
				$s2 = '-';
				next_token( $parse_param );
			}
			
						// first item in sequence
							
			if ($parse_param->curr_tok == TOK_LPARENTHESIS)
			{
				next_token( $parse_param );
	
				$type = parse_num_expr( $parse_param, $ic, $ic_pos, $current_function_number );

				next_token( $parse_param );
			}
			else
			if ($parse_param->curr_tok == TOK_INC)
			{
				next_token( $parse_param );

				if ($parse_param->curr_tok != TOK_NAME)
					syntax_error( 81, $parse_param, "Expected a name after a '++'" );
				
				$name = $parse_param->curr_token_text;
				
				check_var_declaration( $parse_param, $current_function_number, $type, $name, $number_of_indexes );

				if (! is_numeric_type( $type ))
					semantic_error( 82, $parse_param, "Data type of an ++ operator must be numeric" );
			
				if (is_global_variable( $parse_param, $current_function_number, $name ))
					gen_code( $parse_param, $ic, $ic_pos, OP_PUSH_ABS, $name );
				else
					gen_code( $parse_param, $ic, $ic_pos, OP_PUSH_REL, $name );

				gen_code( $parse_param, $ic, $ic_pos, OP_INC );

				gen_code( $parse_param, $ic, $ic_pos, OP_DUPLICATE );

				if (is_global_variable( $parse_param, $current_function_number, $name ))
					gen_code( $parse_param, $ic, $ic_pos, OP_POP_ABS, $name );
				else
					gen_code( $parse_param, $ic, $ic_pos, OP_POP_REL, $name );
				
				next_token( $parse_param );
			}
			else
			if ($parse_param->curr_tok == TOK_DEC)
			{
				next_token( $parse_param );

				if ($parse_param->curr_tok != TOK_NAME)
					syntax_error( 83, $parse_param, "Expected a name after a '--'" );
				
				$name = $parse_param->curr_token_text;
				
				check_var_declaration( $parse_param, $current_function_number, $type, $name, $number_of_indexes );
			
				if (! is_numeric_type( $type ))
					semantic_error( 84, $parse_param, "Data type of an -- operator must be numeric" );
			
				if (is_global_variable( $parse_param, $current_function_number, $name ))
					gen_code( $parse_param, $ic, $ic_pos, OP_PUSH_ABS, $name );
				else
					gen_code( $parse_param, $ic, $ic_pos, OP_PUSH_REL, $name );

				gen_code( $parse_param, $ic, $ic_pos, OP_DEC );

				gen_code( $parse_param, $ic, $ic_pos, OP_DUPLICATE );

				if (is_global_variable( $parse_param, $current_function_number, $name ))
					gen_code( $parse_param, $ic, $ic_pos, OP_POP_ABS, $name );
				else
					gen_code( $parse_param, $ic, $ic_pos, OP_POP_REL, $name );
				
				next_token( $parse_param );
			}
			else
			if ($parse_param->curr_tok == TOK_NAME)
			{
				$name = $parse_param->curr_token_text;
				
				$varname = $parse_param->curr_token_text;
				 
				if (isset( $parse_param->constants[$varname]['value'] ))
				{
					$type = $parse_param->constants[$varname]['type'];
					
					if ((! $parse_param->decimal_arithmetic) && is_numeric( $parse_param->constants[$varname]['value'] ))
						gen_code( $parse_param, $ic, $ic_pos, OP_PUSH_CONST, (double) $parse_param->constants[$varname]['value'] );
					else
						gen_code( $parse_param, $ic, $ic_pos, OP_PUSH_CONST, (string) $parse_param->constants[$varname]['value'] );
				
					next_token( $parse_param );			
				}
				else
				{
					$array_name = $name;

					next_token( $parse_param );
					
					if ($parse_param->curr_tok == TOK_LBRACKET || $parse_param->curr_tok == TOK_DOT)
					{
						check_var_declaration( $parse_param, $current_function_number, $type, $array_name, $number_of_indexes );
						
						$array_type = $type;
						
						$type = parse_aggregate_expression( $parse_param, $ic, $ic_pos, $num_dimensions, $allow_void, $type, $current_function_number, $array_name, $number_of_dereferences );

						if ($parse_param->decimal_arithmetic)
							gen_code( $parse_param, $ic, $ic_pos, OP_PUSH_CONST, (string) $number_of_dereferences );
						else
							gen_code( $parse_param, $ic, $ic_pos, OP_PUSH_CONST, (int) $number_of_dereferences );
 
						check_var_declaration( $parse_param, $current_function_number, $type1, $name, $number_of_indexes );
						
						if (is_global_variable( $parse_param, $current_function_number, $name ))
							gen_code( $parse_param, $ic, $ic_pos, OP_PUSH_ABS_ARRAY, $name, $array_type );
						else
							gen_code( $parse_param, $ic, $ic_pos, OP_PUSH_REL_ARRAY, $name, $array_type );
					}
					else
					if ($parse_param->curr_tok == TOK_LPARENTHESIS)
					{
						$type = parse_function_call( $parse_param, $ic, $ic_pos, $current_function_number, $name );						
					}
					else
					{
						check_var_declaration( $parse_param, $current_function_number, $type, $name, $number_of_indexes );
						
						if (is_global_variable( $parse_param, $current_function_number, $name ))
							gen_code( $parse_param, $ic, $ic_pos, OP_PUSH_ABS, $name );
						else
							gen_code( $parse_param, $ic, $ic_pos, OP_PUSH_REL, $name );
						
						if ($parse_param->curr_tok == TOK_INC)
						{
							if (! is_numeric_type( $type ))
								semantic_error( 151, $parse_param, "Data type of a variable that has ++ applied to it must be numeric." );
							
							gen_code( $parse_param, $ic, $ic_pos, OP_DUPLICATE );

							gen_code( $parse_param, $ic, $ic_pos, OP_INC );

							if (is_global_variable( $parse_param, $current_function_number, $name ))
								gen_code( $parse_param, $ic, $ic_pos, OP_POP_ABS, $name );
							else
								gen_code( $parse_param, $ic, $ic_pos, OP_POP_REL, $name );
							
							next_token( $parse_param );
						}
						else
						if ($parse_param->curr_tok == TOK_DEC)
						{
							if (! is_numeric_type( $type ))
								semantic_error( 152, $parse_param, "Data type of a variable that has -- applied to it must be numeric." );
							
							gen_code( $parse_param, $ic, $ic_pos, OP_DUPLICATE );

							gen_code( $parse_param, $ic, $ic_pos, OP_DEC );

							if (is_global_variable( $parse_param, $current_function_number, $name ))
								gen_code( $parse_param, $ic, $ic_pos, OP_POP_ABS, $name );
							else
								gen_code( $parse_param, $ic, $ic_pos, OP_POP_REL, $name );
							
							next_token( $parse_param );
						}
					}
				}

/*
				if (sleft( $type, 5 ) == "array")
				{
					$type3 = explode( " ",  $type );
								
					$type = $type3[1];
				}
*/ 
			}
			else
			if ($parse_param->curr_tok == TOK_NUMBER)
			{
				$is_num_constant = true;
				
				if (strpos( $parse_param->curr_token_text, "." ) == false)
					$type = "int";
				else
				if (strpos( $parse_param->curr_token_text, "E" ) == false)
					$type = "decimal";
				else
					$type = "double";
				
				if ($s2 == "-")
				{
					if ((! $parse_param->decimal_arithmetic) && is_numeric( $parse_param->curr_token_text ))
						gen_code( $parse_param, $ic, $ic_pos, OP_PUSH_CONST, (double) ("-".$parse_param->curr_token_text) );
					else			
						gen_code( $parse_param, $ic, $ic_pos, OP_PUSH_CONST, (string) "-".$parse_param->curr_token_text );
				}
				else
				{
					if ((! $parse_param->decimal_arithmetic) && is_numeric( $parse_param->curr_token_text ))
						gen_code( $parse_param, $ic, $ic_pos, OP_PUSH_CONST, (double) $parse_param->curr_token_text );
					else
						gen_code( $parse_param, $ic, $ic_pos, OP_PUSH_CONST, (string) $parse_param->curr_token_text );
				}
									
				next_token( $parse_param );			
			}
			else
			if ($parse_param->curr_tok == TOK_STRING_CONSTANT ||
				$parse_param->curr_tok == TOK_DATE_CONSTANT ||
				$parse_param->curr_tok == TOK_TIME_CONSTANT ||
				$parse_param->curr_tok == TOK_DATETIME_CONSTANT ||
				$parse_param->curr_tok == TOK_BOOLEAN_CONSTANT)
			{
				$text = $parse_param->curr_token_text;
				
				if ($parse_param->curr_tok == TOK_STRING_CONSTANT) 	$type = "string"; 
				if ($parse_param->curr_tok == TOK_DATE_CONSTANT) 	$type = "date";
				if ($parse_param->curr_tok == TOK_TIME_CONSTANT) 	$type = "time";
				if ($parse_param->curr_tok == TOK_DATETIME_CONSTANT) $type = "datetime";
				if ($parse_param->curr_tok == TOK_BOOLEAN_CONSTANT) 	$type = "bool";

				if ($parse_param->curr_tok == TOK_BOOLEAN_CONSTANT)
				{
					if ($parse_param->curr_token_text == "true")
						$text = "1";
					else
						$text = "0";
				}
					
				gen_code( $parse_param, $ic, $ic_pos, OP_PUSH_CONST, $text );
				
				next_token( $parse_param );			
			}
			else
			{
				syntax_error( 90, $parse_param, "Expected '(', a variable name or a number" );
				
				next_token( $parse_param );			
			}
								
			if ($s2 == '-' && (! $is_num_constant))
				gen_code( $parse_param, $ic, $ic_pos, OP_NEGATE );
		}
				
		if ($parse_param->show_parse_trace)
			echo "parse_item_expr returned<br>";
		
		return ($type); 				
	}

				
	function parse_function_call( $parse_param, &$ic, &$ic_pos, $current_function_number, &$function_name )
	{
		if ($parse_param->show_parse_trace)
			echo "called parse_function_call<br>";
		
		next_token( $parse_param );
		
		$argument_count = 0;

		$text = "";
		
		while ($parse_param->curr_tok != TOK_RPARENTHESIS && $parse_param->curr_tok != TOK_EOF)
		{
			if ($parse_param->curr_tok == TOK_ADDR_STRCONCAT)
			{
				next_token( $parse_param );
			
				$name = $parse_param->curr_token_text;
			
				if ($parse_param->curr_tok != TOK_NAME)
					syntax_error( 91, $parse_param, "Expected a name after &" );

				check_var_declaration( $parse_param, $current_function_number, $type, $name, $number_of_indexes );

				check_function_parameter_type( $parse_param, $ic, $ic_pos, $type, $function_name, $argument_count, false );

				if (is_global_variable( $parse_param, $current_function_number, $name ))
					gen_code( $parse_param, $ic, $ic_pos, OP_PUSH_ADDR_ABS, $name );
				else
					gen_code( $parse_param, $ic, $ic_pos, OP_PUSH_ADDR_REL, $name );
				
				next_token( $parse_param );
				
				if ($parse_param->curr_tok != TOK_COMMA && $parse_param->curr_tok != TOK_RPARENTHESIS)
					syntax_error( 92, $parse_param, "Expected a ',' or ')'" );

				if ($parse_param->curr_tok == TOK_COMMA)
					next_token( $parse_param );
			}
			else 
			{
				$type = parse_num_expr( $parse_param, $ic, $ic_pos, $current_function_number );

				check_function_parameter_type( $parse_param, $ic, $ic_pos, $type, $function_name, $argument_count, true );
				
				if ($parse_param->curr_tok != TOK_COMMA && $parse_param->curr_tok != TOK_RPARENTHESIS)
					syntax_error( 93, $parse_param, "Expected a , or ) after function arguments" );
				
				if ($parse_param->curr_tok == TOK_COMMA)
					next_token( $parse_param );
			}
			
			$argument_count++;
		}

		
		$ic[$ic_pos]['argument_count'] = $argument_count;
		
		if (is_system_function( $parse_param, $function_name ))
		{
			gen_code( $parse_param, $ic, $ic_pos, OP_CALL_SYSTEM_FUNCTION, $function_name );
		}
		else
		{
//			$function_number = check_or_add_new_function( $function_name, $already_defined );
		
			if (! function_has_been_defined( $parse_param, $function_name ))
				semantic_error( 94, $parse_param, "Function ".$function_name." must be declared or defined before being called." );
			
			gen_code( $parse_param, $ic, $ic_pos, OP_CALL_USER_FUNCTION, $function_name );
		}

		$type = check_function_usage( $parse_param, $function_name, $argument_count );
		
		next_token( $parse_param );

		if ($parse_param->show_parse_trace)
			echo "parse_function_call returned<br>";
		
		return ($type);
	}


	function check_function_parameter_type( $parse_param, &$ic, &$ic_pos, &$type, $function_name, $argument_count, $add_conversion )
	{
		$current_function_number = -1;
		
		for ($i=0; $i < $parse_param->vars['number_of_user_functions']; $i++)
		{
			if ($parse_param->vars['function_name'][$i] == $function_name)
			{
				$found = true;
				
				$current_function_number = $i;
			}
		}
		
		if ($current_function_number == -1)
			semantic_error( 95, $parse_param, "Function ".$function_name." not found" );
		else
		{
			if (isset( $parse_param->vars['function_arguments'][$current_function_number][$argument_count]['type'] ))
			{
				$argument_type = $parse_param->vars['function_arguments'][$current_function_number][$argument_count]['type'];

				if (! check_types( $parse_param, $ic, $ic_pos, $argument_type, $type, $add_conversion, 0 ))
					semantic_error( 96, $parse_param, "Type error in function ".$function_name." function call argument number ".($argument_count+1).", expected '".$argument_type."' but variable is of type '".$type."'" );

/*								
				$ok = false;

				if ($argument_type == $type)
					$ok = true;
				else
				if (is_numeric_type( $argument_type ) && is_numeric_type( $type ))
					$ok = true;
				else
				if ($add_conversion && $argument_type == "string" && conversion_to_string_available( $type ))
				{
					$ok = true;
					
					generate_type_conversion( $parse_param, $ic, $ic_pos, $type, "string", "0" );					
				} 
				else
//				if ($parse_param->vars['function_arguments'][$current_function_number][$argument_count]['type'] != $type &&
//					(! (is_numeric_type( $parse_param->vars['function_arguments'][$current_function_number][$argument_count]['type'] ) && is_numeric_type( $type ))))
*/  
			}
			else
				semantic_error( 96, $parse_param, "Type error in function ".$function_name." function call argument number ".($argument_count+1) );
		}
	}
	
	
	function check_types( $parse_param, &$ic, &$ic_pos, $type_required, $type_supplied, $add_conversion, $level )
	{
		$ok = false;

		if ($type_required == $type_supplied)
			$ok = true;
		else
		if (is_numeric_type( $type_required ) && is_numeric_type( $type_supplied ))
			$ok = true;
		else
		if ($add_conversion && $type_required == "string" && conversion_to_string_available( $type_supplied ))
		{
			$ok = true;
			
			generate_type_conversion( $parse_param, $ic, $ic_pos, $type_supplied, "string", $level );					
		} 

		return ($ok);
	}


	function conversion_to_string_available( $type )
	{
		if ($type == "int" ||
			$type == "decimal" ||
			$type == "double" ||
			$type == "bool" ||
			$type == "date" ||
			$type == "time" ||
			$type == "datetime")
				$stat = true;
		else
			$stat = false;
		
		return ($stat);
	}

	
	function generate_type_conversion( $parse_param, &$ic, &$ic_pos, $type_from, $type_to, $level )
	{
		if ($type_to == "string")
		{
			if ($type_from == "int")			$op = OP_CONV_INT_TO_STRING;
			if ($type_from == "double")			$op = OP_CONV_DOUBLE_TO_STRING;
			if ($type_from == "decimal")		$op = OP_CONV_DECIMAL_TO_STRING;
			if ($type_from == "bool")			$op = OP_CONV_BOOL_TO_STRING;
			if ($type_from == "date")			$op = OP_CONV_DATE_TO_STRING;
			if ($type_from == "time")			$op = OP_CONV_TIME_TO_STRING;
			if ($type_from == "datetime")		$op = OP_CONV_DATETIME_TO_STRING;

			gen_code( $parse_param, $ic, $ic_pos, $op, $level );
		}
	}	
	
	function check_var_declaration( &$parse_param, $current_function_number, &$type, $name, &$number_of_indexes )
	{
		$found = false;
		
		$number_of_indexes = 0;

		if ($parse_param->in_function)
		{
			for ($j=0; $j < $parse_param->vars['number_of_function_arguments'][$current_function_number]; $j++)
			{
				if ($parse_param->vars['function_arguments'][$current_function_number][$j]['name'] == $name)
				{
					$found = true;
					$type = $parse_param->vars['function_arguments'][$current_function_number][$j]['type'];
					
					if (sleft( $type, 5 ) == "array")
						$number_of_indexes = $parse_param->vars['function_arguments'][$current_function_number][$j]['number_of_indexes'];
				}
			}
		
			for ($j=0; $j < $parse_param->vars['number_of_local_variables'][$current_function_number]; $j++)
			{
				if ($parse_param->vars['local_variables'][$current_function_number][$j]['name'] == $name)
				{
					$found = true;
					$type = $parse_param->vars['local_variables'][$current_function_number][$j]['type'];
					
					if (sleft( $type, 5 ) == "array")
						$number_of_indexes = $parse_param->vars['local_variables'][$current_function_number][$j]['number_of_indexes'];
				}
			}
		}
		
		if (! $found)
		{
			for ($j=0; $j < $parse_param->vars['number_of_global_variables']; $j++)
			{
				if ($parse_param->vars['global_variables'][$j]['name'] == $name)
				{
					$found = true;
					$type = $parse_param->vars['global_variables'][$j]['type'];
					
					if (sleft( $type, 5 ) == "array")
						$number_of_indexes = $parse_param->vars['global_variables'][$j]['number_of_indexes'];
				}
			}
		}
		
		if (! $found)
		{
			$parse_param->error_occured = true;
			semantic_error( 97, $parse_param, "Variable or function '".$name."' has not been declared" );
		}
	}
	
	
	function is_global_variable( &$parse_param, $current_function_number, $name )
	{
		$found = false;
		
		$loc_version = false;
		
		if ($parse_param->in_function)
		{
			for ($j=0; $j < $parse_param->vars['number_of_function_arguments'][$current_function_number]; $j++)
			{
				if ($parse_param->vars['function_arguments'][$current_function_number][$j]['name'] == $name)
					$loc_version = true;
			}
		
			for ($j=0; $j < $parse_param->vars['number_of_local_variables'][$current_function_number]; $j++)
			{
				if ($parse_param->vars['local_variables'][$current_function_number][$j]['name'] == $name)
					$loc_version = true;
			}
		}

		if (! $loc_version)
		{
			for ($j=0; $j < $parse_param->vars['number_of_global_variables']; $j++)
			{
				if ($parse_param->vars['global_variables'][$j]['name'] == $name)
					$found = true;
			}
		}

		return ($found);
	}


	function check_function_usage( $parse_param, &$function_name, $number_of_arguments )
	{
		$found = false;

		$return_type = "";

		for ($j=0; $j < $parse_param->vars['number_of_user_functions']; $j++)
		{
			if ($parse_param->vars['function_name'][$j] == $function_name)
			{
				$found = true;

				$return_type = $parse_param->vars['function_return_type'][$j];
				
				if (($parse_param->vars['function_has_been_defined'][$j] || $parse_param->vars['builtin_function'][$j]) && 
						$parse_param->vars['number_of_function_arguments'][$j] != $number_of_arguments)

					semantic_error( 98, $parse_param, "Incorrect function usage, ".$function_name.", ".$parse_param->vars['number_of_function_arguments'][$j]." arguments expected but ".$number_of_arguments." supplied" );
			}
		}

		return ($return_type);
	
//		if (! $found)
//			semantic_error( $parse_param, "Function ".$function_name." has not been declared" );
	}
	
	
	function assign_vars( $parse_param, &$ic, &$ic_pos )
	{
		for ($j=0; $j < $parse_param->vars['number_of_user_functions']; $j++)
		{
			if ((! is_system_function( $parse_param, $parse_param->vars['function_name'][$j] )) && 
  				($parse_param->vars['has_been_called'][$j]) &&
  				(! $parse_param->vars['function_has_been_defined'][$j]))
				semantic_error( 99, $parse_param, "Function ".$parse_param->vars['function_name'][$j]." has been called but has not been defined" );			
		}
			
			
		if (! $parse_param->error_occured)
		{
			for ($j=0; $j < $parse_param->vars['number_of_global_variables']; $j++)
				$parse_param->vars['global_variables'][$j]['offset'] = $j;
	
			for ($i=0; $i < $parse_param->vars['number_of_user_functions']; $i++)
			{
				for ($j=0; $j < $ic_pos; $j++)
				{
					if ($ic[$j]['op'] == OP_CALL_USER_FUNCTION && $ic[$j]['value'] == $parse_param->vars['function_name'][$i])
						$ic[$j]['value'] = $i;
				}
			}
		
			for ($j=0; $j < $ic_pos; $j++)
			{
				if ($ic[$j]['op'] == OP_JMP || 
					$ic[$j]['op'] == OP_JMP_FALSE ||
					$ic[$j]['op'] == OP_POP_JMP_GE ||
					$ic[$j]['op'] == OP_POP_JMP_LE)
				{
					$label = $ic[$j]['value'];
					
					$found = false;
					
					for ($k=0; $k < $ic_pos && (!$found); $k++)
					{
						if ($ic[$k]['op'] == OP_LABEL && $ic[$k]['value'] == $label)
						{
							$found = true;
						
							$ic[$j]['value'] = $k;
						}
					}
					
					if (! $found)
						runtime_error( 100, $ic, $ic_pos-1, "Label ".$label." not found" );
				}
			}
	
			if (compress_labels && $ic_pos > 0)
			{
				$new_entry_number = 0;
				$prev_entry_number = 0;
		
				for ($j=0; $j < $ic_pos; $j++)
				{
					if ($ic[$j]['op'] != OP_LABEL)
					{
						$ic_new[$new_entry_number] = $ic[$prev_entry_number];
						
						$new_entry_number_list[$prev_entry_number] = $new_entry_number;
						 
						$prev_entry_number++;
					 	$new_entry_number++;
					}
					else
					{
						$new_entry_number_list[$prev_entry_number] = $new_entry_number;
						
						$prev_entry_number++;
					}
				}
				
				$ic = $ic_new;
				$ic_pos = $new_entry_number;
		
				for ($j=0; $j < $ic_pos; $j++)
				{
					if ($ic[$j]['op'] == OP_JMP || 
						$ic[$j]['op'] == OP_JMP_FALSE ||
						$ic[$j]['op'] == OP_POP_JMP_GE ||
						$ic[$j]['op'] == OP_POP_JMP_LE)
					{
						$ic[$j]['value'] = $new_entry_number_list[$ic[$j]['value']];
					}
				}
			}

			for ($j=0; $j < $ic_pos; $j++)
			{
				if ($ic[$j]['op'] == OP_CALL_USER_FUNCTION)
				{
					$function_number = $ic[$j]['value'];
					
					$found = false;
					
					for ($k=0; $k < $ic_pos && (!$found); $k++)
					{
						if ($ic[$k]['op'] == OP_START_FUNCTION && $ic[$k]['value'] == $function_number)
						{
							$found = true;
						
							$ic[$j]['call_address'] = $k;
						}
					}
					
					if (! $found)
						runtime_error( 146, $ic, $ic_pos-1, "User function ".$ic[$j]['text']." function number ".$ic[$j]['value']." not found" );
				}
			}

			for ($j=0; $j < $ic_pos; $j++)
			{
				if ($ic[$j]['op'] == OP_PUSH_ABS || 
					$ic[$j]['op'] == OP_POP_ABS ||
					$ic[$j]['op'] == OP_INC_ABS ||
					$ic[$j]['op'] == OP_DEC_ABS ||
					$ic[$j]['op'] == OP_PUSH_ADDR_ABS ||
					$ic[$j]['op'] == OP_PUSH_ABS_ARRAY ||
					$ic[$j]['op'] == OP_POP_ABS_ARRAY)
				{
					$found = false;
					
					for ($k=0; $k < $parse_param->vars['number_of_global_variables']; $k++)
					{
						if ($parse_param->vars['global_variables'][$k]['name'] == $ic[$j]['value'])
						{
							$ic[$j]['value'] = $parse_param->vars['global_variables'][$k]['offset'];
							
							$found = true;
						}
					}

					if (! $found)
						runtime_error( 148, $ic, $ic_pos-1, "Variable '".$ic[$j]['value']."' not found" );
				}
			}
					
//			for ($j=0; $j < $parse_param->vars['number_of_user_functions']; $j++)
//			{
//				if ((! is_system_function( $parse_param->vars['function_name'][$j])) && (! $parse_param->vars['function_has_been_defined'][$j]))
//					semantic_error( $parse_param, "", $x2, $x3, $x4, "Function ".$parse_param->vars['function_name'][$j]." has been declared and/or called but has not been defined" );			
//			}	
				
				
	//				syntax_error( $parse_param, &$text )
				
								
			for ($j=0; $j < $parse_param->vars['number_of_user_functions']; $j++)
			{
				$offset = -1;
	
				for ($k=0; $k < $parse_param->vars['number_of_local_variables'][$j]; $k++)
				{
					$parse_param->vars['local_variables'][$j][$k]['offset'] = $offset;
					$offset--;
				}
				
				$offset--; 
				
				for ($k=$parse_param->vars['number_of_function_arguments'][$j]-1; $k >= 0; $k--)
				{
					$parse_param->vars['function_arguments'][$j][$k]['offset'] = $offset;
					$offset--;
				}
			}
			
			$current_function_number = -1;
			
			for ($j=0; $j < $ic_pos; $j++)
			{
				if ($ic[$j]['op'] == OP_START_FUNCTION)
					$current_function_number = $ic[$j]['value']; 
				
				if ($ic[$j]['op'] == OP_PUSH_REL || 
					$ic[$j]['op'] == OP_POP_REL ||
					$ic[$j]['op'] == OP_INC_REL ||
					$ic[$j]['op'] == OP_DEC_REL ||
					$ic[$j]['op'] == OP_PUSH_ADDR_REL ||
					$ic[$j]['op'] == OP_PUSH_REL_ARRAY ||
					$ic[$j]['op'] == OP_POP_REL_ARRAY)
				{
					if (isset( $parse_param->vars['number_of_function_arguments'][$current_function_number] ))
					{
						for ($k=0; $k < $parse_param->vars['number_of_function_arguments'][$current_function_number]; $k++)
						{
							if ($parse_param->vars['function_arguments'][$current_function_number][$k]['name'] == $ic[$j]['value'])
							 	$ic[$j]['value'] = $parse_param->vars['function_arguments'][$current_function_number][$k]['offset'];
						}
					}				
	
					if (isset( $parse_param->vars['number_of_local_variables'][$current_function_number] ))
					{
						for ($k=0; $k < $parse_param->vars['number_of_local_variables'][$current_function_number]; $k++)
						{
							if ($parse_param->vars['local_variables'][$current_function_number][$k]['name'] == $ic[$j]['value'])
							 	$ic[$j]['value'] = $parse_param->vars['local_variables'][$current_function_number][$k]['offset'];
						}
					}
				}
			}
		}
	}
	
		
	function check_or_add_new_function( $parse_param, &$function_name, $return_type, &$already_defined )
	{
		$found = false;
		
		for ($i=0; $i < $parse_param->vars['number_of_user_functions']; $i++)
		{
			if ($parse_param->vars['function_name'][$i] == $function_name)
			{
				$found = true;
				
				$current_function_number = $i;
			}
		}
		
		if (! $found)
		{
			$current_function_number = $parse_param->vars['number_of_user_functions'];

			$parse_param->vars['number_of_user_functions']++;

			$parse_param->vars['function_name'][$current_function_number] = $function_name;
			
			$parse_param->vars['function_return_type'][$current_function_number] = $return_type;
 
			$parse_param->vars['builtin_function'][$current_function_number] = false;

			$parse_param->vars['number_of_function_arguments'][$current_function_number] = 0;
			
			$parse_param->vars['local_variables'][$current_function_number][0]['name'] = 'result';
			$parse_param->vars['local_variables'][$current_function_number][0]['type'] = $return_type;
			 
		 	$parse_param->vars['function_has_been_defined'][$current_function_number] = false;
			 
		 	$parse_param->vars['has_been_called'][$current_function_number] = false;
			
			$parse_param->vars['number_of_declarations'][$current_function_number] = 0;
			
			$parse_param->vars['number_of_definitions'][$current_function_number] = 0;
			 
			$parse_param->vars['number_of_local_variables'][$current_function_number] = 1;
		}
	
		if ($found)
			$already_defined = true;
		else
			$already_defined = false;
		
		return ($current_function_number);
	}
	


	function function_has_been_defined( $parse_param, $function_name )
	{
		$found = false;
		
		for ($i=0; $i < $parse_param->vars['number_of_user_functions']; $i++)
		{
			if ($parse_param->vars['function_name'][$i] == $function_name)
				$found = true;
		}
		
		return ($found);
	}

	
	function gen_code( $parse_param, &$ic, &$ic_pos, $op, $value="", $type="" )
	{
		if ($parse_param->show_parse_trace)
			echo "gen code: ".$op.": ".$value."<br>"; 
		
		$ic[$ic_pos]['op'] = $op;
		
		$ic[$ic_pos]['value'] = $value;

		$ic[$ic_pos]['type'] = $type;

		if ($op == OP_JMP || 
			$op == OP_JMP_FALSE ||
			$op == OP_POP_JMP_GE||
			$op == OP_POP_JMP_LE)
			$ic[$ic_pos]['text'] = "";
		else
			$ic[$ic_pos]['text'] = $value;

		$ic[$ic_pos]['input_filename'] = $parse_param->current_filename[$parse_param->include_file_level];

		$ic[$ic_pos]['line_number'] = $parse_param->current_line_number[$parse_param->include_file_level];
		
		$ic_pos++;
	}


	function semantic_error( $error_number, $parse_param, $text )
	{
		$parse_param->error_occured = true;
		
		if ($parse_param->current_line_number != $parse_param->last_error_line)
		{
			echo "Error number: ".$error_number.": Line ".$parse_param->current_line_number[$parse_param->include_file_level].": ".$parse_param->current_filename[$parse_param->include_file_level].": ".$text;

			echo "<br>";
		
			$parse_param->last_error_line = $parse_param->current_line_number;
		}
		
		if (exit_on_first_error)
			exit();
	}



	function syntax_error( $error_number, $parse_param, $text )
	{
		$parse_param->error_occured = true;
		
		if ($parse_param->current_line_number != $parse_param->last_error_line)
		{
			echo "Error number: ".$error_number.": Line ".$parse_param->current_line_number[$parse_param->include_file_level].": ".$parse_param->current_filename[$parse_param->include_file_level].": ".$text.": ".$parse_param->curr_token_text;

			echo "<br>";
			
			$parse_param->last_error_line = $parse_param->current_line_number;
		}
		
		if (exit_on_first_error)
			exit();
		
		next_token( $parse_param );		
	}


	function input_error( $error_number, $parse_param, $text )
	{
		$parse_param->error_occured = true;
		
		if ($parse_param->current_line_number != $parse_param->last_error_line)
		{
			echo "Error number: ".$error_number.": Line ".$parse_param->current_line_number[$parse_param->include_file_level].": ".$parse_param->current_filename[$parse_param->include_file_level].": ".$text;

			echo "<br>";

			$parse_param->last_error_line = $parse_param->current_line_number;
		}
		
		if (exit_on_first_error)
			exit();
	}


	function is_reserved_word( $text )
	{
		if ($text == "result" ||
			$text == "if" ||
			$text == "while" ||
			$text == "function" ||
			$text == "declare" ||
			$text == "var" ||
			$text == "and" ||
			$text == "or" ||
			$text == "not" ||
			$text == "else" ||
			$text == "int" ||
			$text == "double" ||
			$text == "string" ||
			$text == "bool" ||
			$text == "decimal" ||
			$text == "binary" ||
			$text == "date" ||
			$text == "time" ||
			$text == "datetime" ||
			$text == "true" ||
			$text == "false" ||
			$text == "const" ||
			$text == "include" ||
			$text == "array" ||
			$text == "builtin" ||
			$text == "type" ||
			$text == "struct" ||
			$text == "for" ||
			$text == "to" ||
			$text == "step" ||
			$text == "void")
				$stat = true;
		else
			$stat = false;
		
		return ($stat);
	}


	function is_system_function( $parse_param, $function_name )
	{
		$builtin_function = false;
		
		for ($j=0; $j < $parse_param->vars['number_of_user_functions']; $j++)
		{
			if ($parse_param->vars['function_name'][$j] == $function_name)
				$builtin_function = $parse_param->vars['builtin_function'][$j];
		}						
		
		return ($builtin_function);
	}
	
	
	function is_data_type( $parse_param, $tok, $type )
	{
		$stat = false;
		
		if ($tok == TOK_INT ||
			$tok == TOK_DOUBLE ||
			$tok == TOK_STRING ||
			$tok == TOK_BOOL ||
			$tok == TOK_DECIMAL ||
			$tok == TOK_BINARY ||
			$tok == TOK_DATE ||
			$tok == TOK_TIME ||
			$tok == TOK_DATETIME)
				$stat = true;
		else
		{
			for ($j=0; $j < $parse_param->num_user_defined_types; $j++)
			{
				if ($parse_param->user_defined_types[$j]['type_name'] == $type)
					$stat = true;
			}
		}
		
		return ($stat);
	}


	function calc_to_c_type( $type )
	{
		$ctype = $type;
		
		if ($type == "int") 		$ctype = "int";		else
		if ($type == "double") 		$ctype = "double";	else
		if ($type == "decimal") 	$ctype = "double";	else
		if ($type == "bool") 		$ctype = "int";		else
		if ($type == "string") 		$ctype = "char *";	else
		if ($type == "date") 		$ctype = "char *";	else
		if ($type == "time") 		$ctype = "char *";	else
		if ($type == "datetime") 	$ctype = "char *";
		
		return ($ctype);
	}
	
	
	function next_token( $parse_param )
	{
		$is_hex_string = false;
		
		$s = & $parse_param->program_text[$parse_param->include_file_level];
		
		$i = & $parse_param->input_pos[$parse_param->include_file_level];
		
		$current_line_number = & $parse_param->current_line_number[$parse_param->include_file_level];
				
		if ($i >= strlen( $s ))
		{
			$tok = TOK_EOF;
			$tok_len = 1;
			$parse_param->curr_token_text = "";
		}
		else
		{
			$ch = substr( $s, $i, 1 );

			$text1 = substr( $s, $i, 1 );
	
			$text2 = substr( $s, $i, 2 );
			
			if ($text2 == "++")	{	$tok = TOK_INC;		$tok_len = 2;	}
			else
			if ($text2 == "--")	{	$tok = TOK_DEC;		$tok_len = 2;	}
			else
			if ($text2 == "==")	{	$tok = TOK_EQ;		$tok_len = 2;	}
			else
			if ($text2 == "!=")	{	$tok = TOK_NE;		$tok_len = 2;	}
			else
			if ($text2 == "<=")	{	$tok = TOK_LE;		$tok_len = 2;	}
			else
			if ($text2 == ">=")	{	$tok = TOK_GE;		$tok_len = 2;	}
			else

			if ($text2 == "+=")	{	$tok = TOK_ASSIGN_INC;			$tok_len = 2;	}
			else
			if ($text2 == "-=")	{	$tok = TOK_ASSIGN_DEC;			$tok_len = 2;	}
			else
			if ($text2 == "*=")	{	$tok = TOK_ASSIGN_MULT;			$tok_len = 2;	}
			else
			if ($text2 == "/=")	{	$tok = TOK_ASSIGN_DIV;			$tok_len = 2;	}
			else
			if ($text2 == "&=")	{	$tok = TOK_ASSIGN_STRCONCAT;	$tok_len = 2;	}
			else
				
			if ($text1 == ".")	{	$tok = TOK_DOT;		$tok_len = 1;	}
			else
			if ($text1 == "<")	{	$tok = TOK_LT;		$tok_len = 1;	}
			else
			if ($text1 == ">")	{	$tok = TOK_GT;		$tok_len = 1;	}
	
			else
			if ($text1 == "+")	{	$tok = TOK_PLUS;		$tok_len = 1;	}
			else
			if ($text1 == "*")	{	$tok = TOK_MULT;		$tok_len = 1;	}
			else
			if ($text1 == "/")	{	$tok = TOK_DIV;			$tok_len = 1;	}
			else
			if ($text1 == "^")	{	$tok = TOK_POW;			$tok_len = 1;	}
	
			else
			if ($text1 == "(")	{	$tok = TOK_LPARENTHESIS;	$tok_len = 1;	}
			else
			if ($text1 == ")")	{	$tok = TOK_RPARENTHESIS;	$tok_len = 1;	}
			else
			if ($text1 == "[")	{	$tok = TOK_LBRACKET;	$tok_len = 1;	}
			else
			if ($text1 == "]")	{	$tok = TOK_RBRACKET;	$tok_len = 1;	}
			else
			if ($text1 == "{")	{	$tok = TOK_LBRACE;		$tok_len = 1;	}
			else
			if ($text1 == "}")	{	$tok = TOK_RBRACE;		$tok_len = 1;	}
	
			else
			if ($text1 == ",")	{	$tok = TOK_COMMA;		$tok_len = 1;	}
			else
			if ($text1 == "=")	{	$tok = TOK_ASSIGN;		$tok_len = 1;	}
			else
			if ($text1 == ";")	{	$tok = TOK_SEMICOLON;	$tok_len = 1;	}
			else
			if ($text1 == "&")	{	$tok = TOK_ADDR_STRCONCAT;		$tok_len = 1;	}

			else
			if ($text1 == "\"")
			{
				$tok_len = 1;

				$j = $i;
				
				$j++;

				$ch = substr( $s, $j, 1 );

				while ($j < strlen( $s ) && $ch != "\"")
				{
					if ($ch == "\n")
					{
						$current_line_number++;
							
						if ($parse_param->show_scan_trace)
							echo "Input line: ".$current_line_number."<br>";
					}

					$j++;
					$tok_len++;

					if ($tok_len > 1 && substr( $s, $j-1, 2 ) == '\"')
					{
						$j++;
						$tok_len++;
					}


					$ch = substr( $s, $j, 1 );
				}
				
				$tok = TOK_STRING_CONSTANT;
				
				$tok_len++;
			}		
			else
			if ($text1 == "'")
			{
				$tok_len = 1;

				$j = $i;
				
				$j++;

				$ch = substr( $s, $j, 1 );
									
				while ($j < strlen( $s ) && $ch != "'")
				{
					$j++;
					$tok_len++;

					$ch = substr( $s, $j, 1 );
				}
				
				$tok_len++;
				
				$text = substr( $s, $i+1, $tok_len );
				
				if (sleft( $text, 2 ) == "0x")
				{
					$tok = TOK_NUMBER;
	
					$is_hex_string = true;
				}
				else
				if ($tok_len == 12)
				{
					$tok = TOK_DATE_CONSTANT;

					$text = sleft( $text, 10 );
					
					if (! check_date_valid( $text ))
						input_error( 142, $parse_param, "Invalid date format: ".$text );
				}
				else
				if ($tok_len == 10)
				{
					$tok = TOK_TIME_CONSTANT;
					
					$text = sleft( $text, 8 );
					
					if (! time_is_valid( $text ))
						input_error( 143, $parse_param, "Invalid time format: ".$text );
				}
				else						
				if ($tok_len == 21)
				{
					$tok = TOK_DATETIME_CONSTANT;

					$text = sleft( $text, 19 );
											
					if (! datetime_is_valid( $text ))
						input_error( 144, $parse_param, "Invalid time format: ".$text );
				}
				else
				{
					input_error( 101, $parse_param, "Expected a date 'YYYY-MM-DD', time 'HH:MM:SS' or datetime 'YYYY-MM-DD HH:MM:SS': ".$text1 );
					$parse_param->error_occured = true;
				}
			}		
			else
			if ($text1 == "-")
			{
				$ch = substr( $s, $i+1, 1 );

				$tok = TOK_SUBTRACT_MINUS;
					
				$tok_len = 1;
			}
			else
			if ($text1 >= '0' && $text1 <= '9')
			{			
				$tok = TOK_NUMBER;
				
				$tok_len = 0;
				
				$j = $i;
				
				while ($j < strlen( $s ) && ($ch == '.' || ($ch >= '0' && $ch <= '9')))
				{
					$j++;
					
					$ch = substr( $s, $j, 1 );
				
					$tok_len++;
				}
			}
			else
			if ($text1 == "_" || ($text1 >= 'a' && $text1 <= 'z') || ($text1 >= 'A' && $text1 <= 'Z'))
			{
				$tok = TOK_NAME;
				
				$tok_len = 0;
				
				$j = $i;
				
				while ($j < strlen( $s ) && ($ch == "_" || ($ch >= 'a' && $ch <= 'z') || ($ch >= 'A' && $ch <= 'Z')|| ($ch >= '0' && $ch <= '9')))
				{
					$j++;
					
					$ch = substr( $s, $j, 1 );
				
					$tok_len++;
				}
				
				$text = substr( $s, $i, $tok_len );

				
				if ($text == "if")			$tok = TOK_IF;
				if ($text == "while")		$tok = TOK_WHILE;
				if ($text == "function")	$tok = TOK_FUNCTION;
				if ($text == "declare")		$tok = TOK_DECLARE;
				if ($text == "var")			$tok = TOK_VAR;
				if ($text == "and")			$tok = TOK_AND;
				if ($text == "or")			$tok = TOK_OR;
				if ($text == "not")			$tok = TOK_NOT;
				if ($text == "else")		$tok = TOK_ELSE;

				if ($text == "int")			$tok = TOK_INT;
				if ($text == "double")		$tok = TOK_DOUBLE;
				if ($text == "string")		$tok = TOK_STRING;
				if ($text == "bool")		$tok = TOK_BOOL;
				if ($text == "decimal")		$tok = TOK_DECIMAL;
				if ($text == "binary")		$tok = TOK_BINARY;
				if ($text == "date")		$tok = TOK_DATE;
				if ($text == "time")		$tok = TOK_TIME;
				if ($text == "datetime")	$tok = TOK_DATETIME;
				if ($text == "true")		$tok = TOK_BOOLEAN_CONSTANT;
				if ($text == "false")		$tok = TOK_BOOLEAN_CONSTANT;
				if ($text == "const")		$tok = TOK_CONST;
				if ($text == "include")		$tok = TOK_INCLUDE;
				if ($text == "array")		$tok = TOK_ARRAY;
				if ($text == "for")			$tok = TOK_FOR;
				if ($text == "to")			$tok = TOK_TO;
				if ($text == "step")		$tok = TOK_STEP;
				if ($text == "builtin")		$tok = TOK_BUILTIN;
				if ($text == "void")		$tok = TOK_VOID;
				if ($text == "type")		$tok = TOK_TYPE;
				if ($text == "struct")		$tok = TOK_STRUCT;
			}
			else
			{
				input_error( 102, $parse_param, "Input error: unrecognised character: ".$text1 );

				$parse_param->error_occured = true;
		
				$tok = TOK_NAME;
				
				$tok_len = 1;
			}

			$text = substr( $s, $i+3, $tok_len - 4 );
			
			if ($is_hex_string)
			{
				$text = substr( $s, $i+3, $tok_len - 4 );
			
				$parse_param->curr_token_text = hexdec( $text );

				$i += $tok_len;
			}
			else
			{
				if ($tok == TOK_STRING_CONSTANT ||
					$tok == TOK_DATE_CONSTANT ||
					$tok == TOK_TIME_CONSTANT ||
					$tok == TOK_DATETIME_CONSTANT)
					$parse_param->curr_token_text = substr( $s, $i+1, $tok_len - 2 );
				else
					$parse_param->curr_token_text = substr( $s, $i, $tok_len );
								
				$i += strlen( $parse_param->curr_token_text );
			
			
				if ($tok == TOK_STRING_CONSTANT)
					$parse_param->curr_token_text = process_escape_sequences( $parse_param->curr_token_text );
				
				if ($tok == TOK_STRING_CONSTANT ||
					$tok == TOK_DATE_CONSTANT ||
					$tok == TOK_TIME_CONSTANT ||
					$tok == TOK_DATETIME_CONSTANT)
					$i += 2;
			}
			

//			$parse_param->input_pos[$parse_param->include_file_level] = $i;
			
			skip_whitespace( $parse_param );
			
//			$i = $parse_param->input_pos[$parse_param->include_file_level];
		}

		if ($parse_param->show_scan_trace)
			echo "Scan: ".$tok.": '".$parse_param->curr_token_text."'<br>";
		
		$parse_param->curr_tok = $tok;
		
//		$parse_param->input_pos[$parse_param->include_file_level] = $i;
		
//		$parse_param->current_line_number[$parse_param->include_file_level] = $current_line_number;
	}


	function process_escape_sequences( $s )
	{
		$pos = 0;

		$s2 = "";

		while ($pos < strlen( $s ))
		{
			$ch = smid( $s, $pos, 1 );
			$ch2 = smid( $s, $pos, 2 );
			
			if ($ch2 == '\"')
			{
				$s2 .= '"';
				$pos++;
			}
			else
			if ($ch2 == '\\\\')
			{
				$s2 .= '\\';
				$pos++;
			}
			else
			if ($ch2 == '\n')
			{
				$s2 .= "\n";
				$pos++;
			}
			else
			if ($ch2 == '\r')
			{
				$s2 .= "\r";
				$pos++;
			}
			else
			if ($ch2 == '\t')
			{
				$s2 .= "\t";
				$pos++;
			}
			else
				$s2 .= $ch;
			
			$pos++;
		}
		
		return ($s2);
	}


 	function skip_whitespace( $parse_param )
	{
		$s = & $parse_param->program_text[$parse_param->include_file_level];
		
		$i = & $parse_param->input_pos[$parse_param->include_file_level];

		$current_line_number = & $parse_param->current_line_number[$parse_param->include_file_level];

		$state = 1;
		$nesting_level = 0;

		$ch2 = substr( $s, $i, 2 );

		if ($ch2 == "//")
		{
			$state = 2;
			$i += 2;
		}			
		else				
		if ($ch2 == "/*")
		{
			$state = 3;
			$nesting_level = 1;
			$i += 2;
		}
		
		while ($i < strlen( $s ) && $state != 0)
		{
			$ch = substr( $s, $i, 1 );	
			$ch2 = substr( $s, $i, 2 );
			
			if ($ch == "\n")
			{
				$current_line_number++;
							
				if ($parse_param->show_scan_trace)
					echo "Input line: ".$current_line_number."<br>";
			}			
			
			if ($state == 1)
			{
				if ($ch2 == "<?")
				{
					$i += 2;
				}			
				else				
				if ($ch2 == "//")
				{
					$state = 2;
					$i += 2;
				}			
				else				
				if ($ch2 == "/*")
				{
					$state = 3;
					$nesting_level = 1;
					$i += 2;
				}
				else
				if ($ch == " " || $ch == "\n" || $ch == "\r" || $ch == "\t")
					$i++;
				else					
					$state = 0;
			}
			else
			if ($state == 2)
			{
				if ($ch == "\n")					
					$state = 1;
				
				$i++;			
			}
			else
			if ($state == 3)
			{
				if ($ch2 == "/*")	
				{				
					$nesting_level++;
					$i += 2;			
				}
				else
				if ($ch2 == "*/")
				{					
					$nesting_level--;
					
					if ($nesting_level == 0)
						$state = 1;
					
					$i += 2;
				}
				else
					$i++;
			}
		}

//		$parse_param->input_pos[$parse_param->include_file_level] = $i;

//		$parse_param->current_line_number[$parse_param->include_file_level] = $current_line_number;
	}

    
	function promote_numeric_type( $type1, $type2 )
	{
		if ($type1 == "double" || $type2 == "double")
			$type = "double";
		else
		if ($type1 == "decimal" || $type2 == "decimal")
			$type = "decimal";
		else
			$type = "int";
		
		return ($type);
	}

	function is_numeric_type( $type )
	{
		$stat = false;
		
		if (sleft( $type, 5 ) == "array")
		{
			$s2 = explode( " ", $type );
			
			if ($s2[1] == "double" || $s2[1] == "decimal" || $s2[1] == "int")
				$stat = true;
		}
		else
		if ($type == "double" || $type == "decimal" || $type == "int")
			$stat = true;
		
		return ($stat);
	}

?>