<?php

	define( "DECIMAL_SCALE", 100 );
	

		/* Stackframe
		  
		 					local variables
		 base pointer ->	return address 
		  					function parameters
		  
		 
		 local variable offsets, 1 upwards
		 
		 function parameter offsets, -(size1) downwards
		   
		 */

		 	
			// (c) Copyright Mark McIlroy 2022
	
	
	function run_ic_code( $parse_param, $ic, $ic_end, &$vars, $show_execution_trace, $initialise_variables, $runtime_checks )
	{
		bcscale( 8 );
		
		$op_descriptions = set_op_descriptions( $op_number_of_operands );
		
		$item = 0;

		if ($initialise_variables)
		{
			for ($i=0; $i < $parse_param->vars['global_variables']['init_num_items']; $i++)
				$stack_value[1 + $i] = $parse_param->vars['global_variables']['init'][$i]['value'];
			
			for ($ic_ptr=0; $ic_ptr < $ic_end; $ic_ptr++)
			{
				if ($ic[$ic_ptr]['op'] == OP_START_FUNCTION)
				{
					if (isset( $parse_param->vars['local_variables'][$ic[$ic_ptr]['function_number']]['init']))
						$ic_init[$ic_ptr] = $parse_param->vars['local_variables'][$ic[$ic_ptr]['function_number']]['init'];
				}
			}					
		}
		
		
		$globals_size = 1;						// don't point links to location 0
		
		for ($j=0; $j < $vars['number_of_global_variables']; $j++)
		{
			if (sleft( $vars['global_variables'][$j]['type'], 6 ) == "array ")
				$globals_size++;
			
			$globals_size += $vars['global_variables'][$j]['size'];
		}
		
		for ($j=0; $j < $globals_size; $j++)
			$stack_value_is_pointer[$j] = false;

		
		load_arrays(	$parse_param, $ic, $ic_end, $vars, 
						$ic_ops,
						$jump_address,
						$ic_value,
						$ic_type,
						$ic_size,
						$ic_text,
						$ic_error_text,
						$ic_line_number,
						$ic_input_filename,
						$ic_input_filenumber,
						$ic_argument_count,
						$ic_function_number,
						$ic_function_name,
						$local_variables_stackframe_size2,
						$function_arguments_stackframe_size2,
						$ic_return_variable_size,
						$call_addresses );
		
		
		$sp = (int) $globals_size;

		$next_available_mem = $sp + 1;
		
		$sp += GLOBALS_AND_HEAP_SIZE;
		
		$stackframe_base[0] = $sp;

		$ic_ptr = (int) 0;

		$call_level = (int) 0;

		$count = (int) 0;
	
		$line_number = (int) 0;
		
		$time1 = microtime( true );

		$found = false;

		while ($ic_ptr < $ic_end && (! $found))
		{
			if ($ic_ops[$ic_ptr] == OP_START_FUNCTION)
			{
				if ($ic[$ic_ptr]['function_name'] == 'main')
					$found = true;
				else
					$ic_ptr++;
			}
			else
				$ic_ptr++;
		}
		
		if (! $found)
		{
			echo "Function 'main' not found\n";
			exit();
		}
			
		
		while ($ic_ptr < $ic_end)
//		while ($ic_ptr < $ic_end && $count < MAX_RUN_ITERATIONS)
		{
//			$count++;

			$op = $ic_ops[$ic_ptr];

			if ($runtime_checks)
			{
				$num_operands = $op_number_of_operands[$op];
	
				if ($num_operands >= 1)
				{
					if (! isset( $stack_value[$sp-1] ))
					{
						runtime_error( 187, $ic_ptr, $ic_line_number, $ic_input_filename, "Operand uninitialised: ".$op_descriptions[$op] );
						$stack_value[$sp-1] = 0;
					}
				}
	
				if ($num_operands >= 2)
				{
					if (! isset( $stack_value[$sp-2] ))
					{
						runtime_error( 187, $ic_ptr, $ic_line_number, $ic_input_filename, "Operand uninitialised: ".$op_descriptions[$op] );
						$stack_value[$sp-2] = 0;
					}
				}
	
				if ($num_operands >= 3)
				{
					if (! isset( $stack_value[$sp-3] ))
					{
						runtime_error( 187, $ic_ptr, $ic_line_number, $ic_input_filename, "Operand uninitialised: ".$op_descriptions[$op] );
						$stack_value[$sp-3] = 0;
					}
				}
	
				if ($num_operands >= 4)
				{
					if (! isset( $stack_value[$sp-4] ))
					{
						runtime_error( 187, $ic_ptr, $ic_line_number, $ic_input_filename, "Operand uninitialised: ".$op_descriptions[$op] );
						$stack_value[$sp-4] = 0;
					}
				}
				
				if ($sp > MAX_STACK_SEGMENT)
				{
					runtime_error( 103, $ic_ptr, $ic_line_number, $ic_input_filename, "Stack overflow" );
					exit();
				}
	
				if ($sp < 0)
				{
					runtime_error( 104, $ic_ptr, $ic_line_number, $ic_input_filename, "Stack underflow" );
					exit();
				}
			}

			if ($show_execution_trace)
			{
				if ($line_number != $ic_line_number[$ic_ptr])
				{
					echo "; ".$parse_param->input_text[$ic_input_filenumber[$ic_ptr]][$ic_line_number[$ic_ptr]]."<br>";
					$line_number = $ic_line_number[$ic_ptr];
				}
			
				debug_lineout( $ic_input_filename, $ic_line_number, $ic_ptr, $sp, $op_descriptions[$op].": ".convert_to_html( $ic_value[$ic_ptr] ).": ".convert_to_html( $ic_text[$ic_ptr] ));
			}
			
			switch ($op) 
			{
				
							//--------------------------------------------------------
							// Jumps
							//--------------------------------------------------------
											
				case OP_JMP_FALSE_DONT_POP:
				{
					if ($stack_value[$sp-1] == 0)
					{
						$ic_ptr = (int) $jump_address[$ic_ptr]; 
					}
					else
						$ic_ptr++;
				}
				break;		
				case OP_JMP_TRUE_DONT_POP:
				{
					if ($stack_value[$sp-1] != 0)
					{
						$ic_ptr = (int) $jump_address[$ic_ptr]; 
					}
					else
						$ic_ptr++;
				}
				break;
				case OP_JMP_FALSE:
				{
					$sp--;
					
					if ($stack_value[$sp] == 0)
					{
						$ic_ptr = (int) $jump_address[$ic_ptr]; 
					}
					else
						$ic_ptr++;
				}
				break;		
				case OP_JMP_TRUE:
				{
					$sp--;
					
					if ($stack_value[$sp] != 0)
					{
						$ic_ptr = (int) $jump_address[$ic_ptr]; 
					}
					else
						$ic_ptr++;
				}
				break;
				case OP_POP_JMP_GE:
				{
					if ($show_execution_trace)
						debug_lineout( $ic_input_filename, $ic_line_number, $ic_ptr, $sp, $stack_value[$sp-2]." >= ".$stack_value[$sp-1] );
					
					if ($stack_value[$sp-2] >= $stack_value[$sp-1])
						$stat = 1;
					else
						$stat = 0;
													
					$sp--;
	
					if ($stat == 1)
					{
						$ic_ptr = (int) $jump_address[$ic_ptr]; 
					}
					else
						$ic_ptr++;
				}
				break;
				case OP_POP_JMP_LT:
				{
					if ($show_execution_trace)
						debug_lineout( $ic_input_filename, $ic_line_number, $ic_ptr, $sp, $stack_value[$sp-2]." < ".$stack_value[$sp-1] );
	
					$sp--;
					
					if ($stack_value[$sp-1] < $stack_value[$sp])
						$stat = 1;
					else
						$stat = 0;
						
					if ($stat == 1)
					{
						$ic_ptr = (int) $jump_address[$ic_ptr]; 
					}
					else
						$ic_ptr++;
				}			
				break;
				case OP_POP_JMP_GT:
				{
					if ($show_execution_trace)
						debug_lineout( $ic_input_filename, $ic_line_number, $ic_ptr, $sp, $stack_value[$sp-2]." > ".$stack_value[$sp-1] );
	
					if ($stack_value[$sp-2] > $stack_value[$sp-1])
						$stat = 1;
					else
						$stat = 0;
						
					$sp--;
		
					if ($stat == 1)
					{
						$ic_ptr = (int) $jump_address[$ic_ptr]; 
					}
					else
						$ic_ptr++;
				}			
				break;
				case OP_POP_JMP_LE:
				{
					if ($show_execution_trace)
						debug_lineout( $ic_input_filename, $ic_line_number, $ic_ptr, $sp, $stack_value[$sp-2]." <= ".$stack_value[$sp-1] );
	
					if ($stack_value[$sp-2] <= $stack_value[$sp-1])
						$stat = 1;
					else
						$stat = 0;
						
					$sp--;
		
					if ($stat == 1)
					{
						$ic_ptr = (int) $jump_address[$ic_ptr]; 
					}
					else
						$ic_ptr++;
				}			
				break;
				case OP_JMP:
				{
					$ic_ptr = (int) $jump_address[$ic_ptr]; 
				}
				break;
				
							//--------------------------------------------------------
							// Push and Pop
							//--------------------------------------------------------
						
				case OP_PUSH_0:
				{
					$stack_value[$sp] = 0;
	
					$stack_value_is_pointer[$sp] = false;
					
					$sp++;
					
					$ic_ptr++;
				}
				break;		
				case OP_PUSH_1:
				{
					$stack_value[$sp] = 1;
	
					$stack_value_is_pointer[$sp] = false;
					
					$sp++;
					
					$ic_ptr++;
				}
				break;
				case OP_PUSH_ABS_ADDR_BASE:
				{
					$stack_value[$sp] = $ic_value[$ic_ptr];
	
					$stack_value_is_pointer[$sp] = false;
					
					$sp++;
					
					$ic_ptr++;
				}
				break;
				case OP_PUSH_CONST_DECIMAL:
				{
					$stack_value[$sp] = (double) (round( (double) $ic_value[$ic_ptr] * (double) DECIMAL_SCALE, 0 ));
	
					$stack_value_is_pointer[$sp] = false;
					
					$sp++;
					
					$ic_ptr++;
				}
				break;
				case OP_PUSH_CONST_INT:
				case OP_PUSH_CONST_DOUBLE:
				case OP_PUSH_CONST_STRING:
				case OP_PUSH_CONST_BOOL:
				case OP_PUSH_CONST_BINARY:
				case OP_PUSH_CONST_DATE:
				case OP_PUSH_CONST_TIME:
				case OP_PUSH_CONST_DATETIME:
				{
					$stack_value[$sp] = $ic_value[$ic_ptr];
	
					$stack_value_is_pointer[$sp] = false;
					
					$sp++;
					
					$ic_ptr++;
				}
				break;
				case OP_PUSH_REL_ADDR_BASE:
				{
					if ($call_level == -1)
						runtime_error( 108, $ic_ptr, $ic_line_number, $ic_input_filename, "Internal error: REL address outside a function" );
					
					$sp2 = $stackframe_base[$call_level] + $ic_value[$ic_ptr];		// base of variable
					
					$sp2 = follow_indirect_address( $stack_value, $stack_value_is_pointer, $sp2, $ic_ptr, $ic_line_number, $ic_input_filename );
						
//					if ($stack_value_is_pointer[$sp2])
//						$sp2 = $stack_value[$sp2];
					
					$stack_value[$sp] = $sp2;
					
					$sp++;
					
					$ic_ptr++;
				}
				break;
 
				case OP_PUSH_VAR:									// size					top of stack
				{													// increment flags
					$indirection_levels = 0;						// address
																	
//					$sp--;
	
//					$size = $stack_value[$sp];

	
					$size = $ic_size[$ic_ptr];
	
	
					$sp--;
	
					$push_flags = $stack_value[$sp];
					
					$sp--;
					
					$sp2 = $stack_value[$sp];
	//					$sp2 = $stackframe_base[$call_level-1] + $stack_value[$sp];
					
					
	//				if (isset( $stack_value[$sp] ))
	//					unset( $stack_value[$sp] );
					
	//				if (! isset( $stack_value[$sp2] ))
	//				{
	//					runtime_error( 162, "Trying to access a variable '".$ic_text[$ic_ptr]."' but the variable has not had a value assigned to it." );
	//					$stack_value[$sp] = 0;
	//				}
	//				else
					{
						if ($push_flags == PUSH_FLAGS_PRE_INC || $push_flags == PUSH_FLAGS_PRE_DEC)
						{
							if (! isset( $stack_value[$sp2] ))
								runtime_error( 162, $ic_ptr, $ic_line_number, $ic_input_filename, "Trying to access a variable '".$ic_text[$ic_ptr]."' but the variable has not had a value assigned to it." );
						}
						
						if ($push_flags == PUSH_FLAGS_PRE_INC)
							$stack_value[$sp2]++;
								
						if ($push_flags == PUSH_FLAGS_PRE_DEC)
							$stack_value[$sp2]--;
	
						if ($show_execution_trace)
						{
							if (gettype( $stack_value[$sp2] ) != "object")
								echo "push: ".$stack_value[$sp2]."<br>";
						}
						
						if ($size == 1)
						{
							if (! isset( $stack_value[$sp2] ))
								runtime_error( 162, $ic_ptr, $ic_line_number, $ic_input_filename, "Trying to access a variable '".$ic_text[$ic_ptr]."' but the variable has not had a value assigned to it." );
							
							unset( $stack_value[$sp] );
							
							if (isset( $stack_value[$sp2] ))
				 				$stack_value[$sp] = $stack_value[$sp2];
							
							$stack_value_is_pointer[$sp] = false;
							
							$sp++;
						}
						else
						{						
							$k = $sp2;
		
							for ($i=0; $i < $size; $i++)
							{
								unset( $stack_value[$sp] );
								
								if (isset( $stack_value[$k] ))
					 				$stack_value[$sp] = $stack_value[$k];
								
								$stack_value_is_pointer[$sp] = false;
								
								$sp++;
								$k++;
							}
						}
												
	//					$stack_value[$sp] = $stack_value[$sp2];
	
						if ($push_flags == PUSH_FLAGS_POST_INC || $push_flags == PUSH_FLAGS_POST_DEC)
						{
							if (! isset( $stack_value[$sp2] ))
								runtime_error( 162, $ic_ptr, $ic_line_number, $ic_input_filename, "Trying to access a variable '".$ic_text[$ic_ptr]."' but the variable has not had a value assigned to it." );
						}
						
						if ($push_flags == PUSH_FLAGS_POST_INC)
							$stack_value[$sp2]++;
			
						if ($push_flags == PUSH_FLAGS_POST_DEC)
							$stack_value[$sp2]--;
					}					
					
	//				$stack_value_is_pointer[$sp] = false;
					
									
	//				$sp++;
								
					$ic_ptr++;
				}
				break;
				case OP_PUSH_VAR_1:
				{
					$sp--;
					
					$sp2 = $stack_value[$sp];
	//					$sp2 = $stackframe_base[$call_level-1] + $stack_value[$sp];
					
					
	//				if (isset( $stack_value[$sp] ))
	//					unset( $stack_value[$sp] );
					
	//				if (! isset( $stack_value[$sp2] ))
	//				{
	//					runtime_error( 162, "Trying to access a variable '".$ic_text[$ic_ptr]."' but the variable has not had a value assigned to it." );
	//					$stack_value[$sp] = 0;
	//				}
	//				else

					if ($show_execution_trace)
					{
						if (gettype( $stack_value[$sp2] ) != "object")
							echo "push: ".$stack_value[$sp2]."<br>";
					}
					
					if (! isset( $stack_value[$sp2] ))
						runtime_error( 162, $ic_ptr, $ic_line_number, $ic_input_filename, "Trying to access a variable '".$ic_text[$ic_ptr]."' but the variable has not had a value assigned to it." );
					
					unset( $stack_value[$sp] );
					
					if (isset( $stack_value[$sp2] ))
		 				$stack_value[$sp] = $stack_value[$sp2];
					
					$stack_value_is_pointer[$sp] = false;
					
					$sp++;
								
					$ic_ptr++;
				}
				break;
				case OP_POP_VAR:						
				{										// size		
	//				$sp--;								// values
														// address
	//				$pop_flags = $stack_value[$sp];
	
//					$sp--;
	
//					$size = $stack_value[$sp];
					
					$size = $ic_size[$ic_ptr];
										
										
					$values_start = $sp - $size;  
					
					$sp -= $size + 1;
					
					if (! isset( $stack_value[$sp] ))
					{
						runtime_error( 184, $ic_ptr, $ic_line_number, $ic_input_filename, "POP address not set" );
						exit();
					}
					
					$sp2 = $stack_value[$sp];				// addr
					
					if ($show_execution_trace)
						echo "pop rel 1: ".$sp2.": ".$stack_value[$sp].":<br>";
					
					if ($size == 1)
					{
						if (isset( $stack_value[$sp2] ))
							unset( $stack_value[$sp2] );
							
						if (isset( $stack_value[$values_start] ))
				 			$stack_value[$sp2] = $stack_value[$values_start];
					}
					else
					{
						if (isset( $stack_value[$sp2] ))
							unset( $stack_value[$sp2] );
		
						$j = $sp2;
						$k = $values_start;
						
						for ($i=0; $i < $size; $i++)
						{
							unset( $stack_value[$j] );
							
							if (isset( $stack_value[$k] ))
					 			$stack_value[$j] = $stack_value[$k];
							
							$j++;
							$k++;
						}
					}
					
					$ic_ptr++;
				}
				break;
				case OP_BULK_COPY:						
				{
					$sp--;
					
					$size = $ic_size[$ic_ptr];
					
	
//					$size = $stack_value[$sp];
	
//					$sp--;

//					$push_flags = $stack_value[$sp];
					
//					$sp--;
					
					$sp_from = follow_indirect_address( $stack_value, $stack_value_is_pointer, $stack_value[$sp], $ic_ptr, $ic_line_number, $ic_input_filename );
					
					$sp--;

					$sp_to = follow_indirect_address( $stack_value, $stack_value_is_pointer, $stack_value[$sp], $ic_ptr, $ic_line_number, $ic_input_filename );
	
					$j = $sp_to;
					$k = $sp_from;
						
					for ($i=0; $i < $size; $i++)
					{
						unset( $stack_value[$j] );

						$stack_value_is_pointer[$j] = false;
						
						if (isset( $stack_value[$k] ))
			 				$stack_value[$j] = $stack_value[$k];

						$j++;
						$k++;
					}
					
					$ic_ptr++;
				}
				break;
				case OP_POP_VAR_1:						
				{			
					$values_start = $sp - 1;  
					
					$sp -= 2;
					
					if (! isset( $stack_value[$sp] ))
					{
						runtime_error( 184, $ic_ptr, $ic_line_number, $ic_input_filename, "POP address not set" );
						exit();
					}
					
					$sp2 = $stack_value[$sp];				// addr
					
					if ($show_execution_trace)
						echo "pop rel 1: ".$sp2.": ".$stack_value[$sp].":<br>";
					
					if (isset( $stack_value[$sp2] ))
						unset( $stack_value[$sp2] );
						
					if (isset( $stack_value[$values_start] ))
			 			$stack_value[$sp2] = $stack_value[$values_start];
					
					$ic_ptr++;
				}
				break;
				case OP_POP_DISCARD:
				{
					$sp--;
					
					$sp -= $stack_value[$sp];				// $num_to_dis;
					
					$ic_ptr++;
				}
				break;


							//--------------------------------------------------------
							// VAR_INC, VAR_DEC
							//--------------------------------------------------------
							

				case OP_VAR_INC:
				{
					$sp--;
					
					$sp2 = $stack_value[$sp];
					
					$stack_value[$sp2]++;
								
					$ic_ptr++;
				}
				break;
				
				case OP_VAR_DEC:
				{
					$sp--;
					
					$sp2 = $stack_value[$sp];
					
					$stack_value[$sp2]++;
								
					$ic_ptr++;
				}
				break;
				
							//--------------------------------------------------------
							// Numeric type conversions
							//--------------------------------------------------------
											
				case OP_CONV_INT_TO_DECIMAL:
				{
//					if (isset( $stack_value[$sp-$ic_value[$ic_ptr]] ))
					{
//						if (gettype( $stack_value[$sp-$ic_value[$ic_ptr]] ) == "integer")
							$stack_value[$sp-$ic_value[$ic_ptr]] = (double) ($stack_value[$sp-$ic_value[$ic_ptr]] * DECIMAL_SCALE);
					}
	
					$ic_ptr++;
				}
				break;
				case OP_CONV_DECIMAL_TO_DOUBLE:
				{
					$stack_value[$sp-$ic_value[$ic_ptr]] = (double) round( ($stack_value[$sp-$ic_value[$ic_ptr]] / DECIMAL_SCALE), 2 );
	
					$ic_ptr++;
				}
				break;
				case OP_CONV_INT_TO_DOUBLE:
				{
					$stack_value[$sp-$ic_value[$ic_ptr]] = (double) $stack_value[$sp-$ic_value[$ic_ptr]];
	
					$ic_ptr++;
				}
				break;
				case OP_CONV_DECIMAL_TO_INT:
				{
					$stack_value[$sp-$ic_value[$ic_ptr]] = (int) round( ((double) $stack_value[$sp-$ic_value[$ic_ptr]] / (double) DECIMAL_SCALE), 0 );
	
					$ic_ptr++;
				}
				break;
				case OP_CONV_DOUBLE_TO_INT:
				{
					$stack_value[$sp-$ic_value[$ic_ptr]] = (int) $stack_value[$sp-$ic_value[$ic_ptr]];
	
					$ic_ptr++;
				}
				break;
				case OP_CONV_DOUBLE_TO_DECIMAL:
				{
					$stack_value[$sp-$ic_value[$ic_ptr]] = (double) round( (double) $stack_value[$sp-$ic_value[$ic_ptr]] * (double) DECIMAL_SCALE, 0 );
	
					$ic_ptr++;
				}
				break;		
				
							//--------------------------------------------------------
							// Conversions to string and binary
							//--------------------------------------------------------
											
				case OP_CONV_BOOL_TO_STRING:
				{
					if ($stack_value[$sp-1] == 0)
						$stack_value[$sp-1] = 'false';
					else
						$stack_value[$sp-1] = 'true';
	
					$ic_ptr++;
				}
				break;
				case OP_CONV_LINK_TO_STRING:
				{
					$stack_value[$sp-1] = "&lt;link to ".$stack_value[$sp-1]."&gt;"; 
	
					$ic_ptr++;
				}
				break;
				case OP_CONV_STRING_TO_BINARY:
				{
					$ic_ptr++;
				}
				break;

				case OP_CONV_BINARY_TO_STRING:
				case OP_CONV_DATE_TO_STRING:
				case OP_CONV_TIME_TO_STRING:
				case OP_CONV_DATETIME_TO_STRING:
				{
					
					$ic_ptr++;
				}
				break;
				
				case OP_CONV_INT_TO_STRING: 
				case OP_CONV_DOUBLE_TO_STRING:
				{
					$stack_value[$sp-1] = (string) $stack_value[$sp-1];
					
					$ic_ptr++;
				}
				break;

				case OP_CONV_DECIMAL_TO_STRING:
				{
					$stack_value[$sp-1] = (string) round( ((double) $stack_value[$sp-1] / (double) DECIMAL_SCALE), 2 );
					
					$ic_ptr++;
				}
				break;
				
							//--------------------------------------------------------
							// Boolean operators and, or, not
							//--------------------------------------------------------
				
				case OP_AND:
				{
					if ($show_execution_trace)
						debug_lineout( $ic_input_filename, $ic_line_number, $ic_ptr, $sp, "and: ".$stack_value[$sp-2].": ".$stack_value[$sp-1] );

					$sp--; 
					
					if ($stack_value[$sp-1] != 0 && $stack_value[$sp] != 0)
						$stack_value[$sp-1] = 1;
					else
						$stack_value[$sp-1] = 0;
	
					if ($show_execution_trace)
						debug_lineout( $ic_input_filename, $ic_line_number, $ic_ptr, $sp, ": -> ".$stack_value[$sp-1] );
	
					$ic_ptr++;
				}
				break;
				case OP_OR:
				{
					if ($show_execution_trace)
						debug_lineout( $ic_input_filename, $ic_line_number, $ic_ptr, $sp, "or: ".$stack_value[$sp-2].": ".$stack_value[$sp-1] );

					$sp--;
					
					if ($stack_value[$sp-1] != 0 || $stack_value[$sp] != 0)
						$stack_value[$sp-1] = 1;
					else
						$stack_value[$sp-1] = 0;
	
					if ($show_execution_trace)
						debug_lineout( $ic_input_filename, $ic_line_number, $ic_ptr, $sp, ": -> ".$stack_value[$sp-2] );
							
					$ic_ptr++;
				}
				break;
				case OP_NOT:
				{
					if ($show_execution_trace)
						echo "not: ".$stack_value[$sp-1];
					
					if ($stack_value[$sp-1] == 1)
						$stack_value[$sp-1] = 0;
					else
						$stack_value[$sp-1] = 1;
	
					if ($show_execution_trace)
						echo ": -> ".$stack_value[$sp-1]."<br>";
					
					$ic_ptr++;
				}
				break;
				
							//--------------------------------------------------------
							// Relational operators =, !=, <, >, <=, >=
							//--------------------------------------------------------
				case OP_EQ_INT:
				case OP_EQ_DOUBLE:
				case OP_EQ_BOOL:
				case OP_EQ_LINK:
				{
					if ($show_execution_trace)
						echo $stack_value[$sp-2]." == ".$stack_value[$sp-1]."<br>";

					$sp--; 
					
					if ($stack_value[$sp-1] == $stack_value[$sp])
						$stat = 1;
					else
						$stat = 0;
							
					$stack_value[$sp-1] = $stat;
	
					if ($show_execution_trace)
						echo "eq: ".$stack_value[$sp-1]."<br>";
	
					$ic_ptr++;
				}
				break;
				case OP_EQ_DECIMAL:
				case OP_EQ_DATE_AND_TIME:
				case OP_EQ_STRING:
				case OP_EQ_BINARY:
				{
					if ($show_execution_trace)
						echo $stack_value[$sp-2]." == ".$stack_value[$sp-1]."<br>";
					
					$stat = 0;

					$sp--; 
					
/*					
					if (is_numeric( $stack_value[$sp-1] ) && is_numeric( $stack_value[$sp] ) )
					{
						if (gettype( $stack_value[$sp] ) == 'string')  
						{
							if (bccomp( $stack_value[$sp-1], $stack_value[$sp], 12 ) == 0) 
								$stat = 1;
						}
						else
						if ($stack_value[$sp] == 0)
						{
							if (abs($stack_value[$sp-1] - $stack_value[$sp]) < 0.0000000000001)
								$stat = 1;
						}					
						else
						if (abs( ($stack_value[$sp-1] / $stack_value[$sp]) - 1) < 0.0000000000001)
							$stat = 1;
					}
					else
*/ 
 
					{
						if ($stack_value[$sp-1] == $stack_value[$sp])
							$stat = 1;
					}
							
					$stack_value[$sp-1] = $stat;
	
					if ($show_execution_trace)
						echo "eq: ".$stack_value[$sp-1]."<br>";


					$ic_ptr++;
				}
				break;
				case OP_NE_INT:
				case OP_NE_DOUBLE:
				case OP_NE_BOOL:
				case OP_NE_LINK:
				{
					if ($show_execution_trace)
						echo $stack_value[$sp-2]." != ".$stack_value[$sp-1]."<br>";
					
					$sp--;
					
					if ($stack_value[$sp-1] != $stack_value[$sp])
						$stat = 1;
					else
						$stat = 0;
					
					$stack_value[$sp-1] = $stat;
							
					if ($show_execution_trace)
						echo "ne: ".$stack_value[$sp-1]."<br>";
					
					$ic_ptr++;
				}
				break;
				case OP_NE_DECIMAL:
				case OP_NE_DATE_AND_TIME:
				case OP_NE_STRING:
				case OP_NE_BINARY:
				{
					if ($show_execution_trace)
						echo $stack_value[$sp-2]." != ".$stack_value[$sp-1]."<br>";
					
					$stat = 0;

					$sp--;
					
/*					
					if (is_numeric( $stack_value[$sp-1] ) && is_numeric( $stack_value[$sp] ) )
					{
						if (gettype( $stack_value[$sp] ) == 'string')  
						{
							if (bccomp( $stack_value[$sp-1], $stack_value[$sp], 12 ) != 0) 
								$stat = 1;
						}
						else
						if ($stack_value[$sp] == 0)
						{
							if (abs($stack_value[$sp-1] - $stack_value[$sp]) > 0.0000000000001)
								$stat = 1;
						}					
						else
						if (abs( ($stack_value[$sp-1] / $stack_value[$sp]) - 1) > 0.0000000000001)
							$stat = 1;
							
					}
					else
*/ 
 
					{
						if ($stack_value[$sp-1] != $stack_value[$sp])
							$stat = 1;
					}
					
					$stack_value[$sp-1] = $stat;
							
					if ($show_execution_trace)
						echo "ne: ".$stack_value[$sp-1]."<br>";
					
					$ic_ptr++;
				}
				break;
				case OP_LE_INT:
				case OP_LE_DECIMAL:
				case OP_LE_DOUBLE:
				case OP_LE_DATE_AND_TIME:
				case OP_LE_STRING:
				{
					if ($show_execution_trace)
						echo $stack_value[$sp-2]." <= ".$stack_value[$sp-1]."<br>";
					
					if ($stack_value[$sp-2] <= $stack_value[$sp-1])
						$stack_value[$sp-2] = 1;
					else
						$stack_value[$sp-2] = 0;
											
					$sp--;
	
					$ic_ptr++;
				}
				break;
				case OP_LT_INT:
				case OP_LT_DECIMAL:
				case OP_LT_DOUBLE:
				case OP_LT_DATE_AND_TIME:
				case OP_LT_STRING:
				{
					if ($show_execution_trace)
						echo $stack_value[$sp-2]." < ".$stack_value[$sp-1]."<br>";
	
					if ($stack_value[$sp-2] < $stack_value[$sp-1])
						$stack_value[$sp-2] = 1;
					else
						$stack_value[$sp-2] = 0;
							
					$sp--;
					
					$ic_ptr++;
				}
				break;
				case OP_GE_INT:
				case OP_GE_DECIMAL:
				case OP_GE_DOUBLE:
				case OP_GE_DATE_AND_TIME:
				case OP_GE_STRING:
				{
					if ($show_execution_trace)
						echo $stack_value[$sp-2]." >= ".$stack_value[$sp-1]."<br>";
					
					if ($stack_value[$sp-2] >= $stack_value[$sp-1])
						$stack_value[$sp-2] = 1;
					else
						$stack_value[$sp-2] = 0;
							
					$sp--;
					
					$ic_ptr++;
				}
				break;
				case OP_GT_INT:
				case OP_GT_DECIMAL:
				case OP_GT_DOUBLE:
				case OP_GT_DATE_AND_TIME:
				case OP_GT_STRING:
				{
					if ($show_execution_trace)
						echo $stack_value[$sp-2]." > ".$stack_value[$sp-1]."<br>";
					
					if ($stack_value[$sp-2] > $stack_value[$sp-1])
						$stack_value[$sp-2] = 1;
					else
						$stack_value[$sp-2] = 0;

					$sp--;
					
					$ic_ptr++;
				}
				break;
				
							//--------------------------------------------------------
							// String concatenation
							//--------------------------------------------------------
											
				case OP_STRCONCAT:
				{
					if ($show_execution_trace)
						echo convert_to_html( $stack_value[$sp-2] )." & ".convert_to_html( $stack_value[$sp-1] )." = ".convert_to_html( $stack_value[$sp-2] . $stack_value[$sp-1] )."<br>";

					$sp--;
					
					$stack_value[$sp-1] = $stack_value[$sp-1] . $stack_value[$sp];
					
					$ic_ptr++;
				}
				break;
				
							//--------------------------------------------------------
							// Arithmetic operators +, -, *, /, ^, mod
							//--------------------------------------------------------
				
				case OP_ADD_INT:
				case OP_ADD_DECIMAL:
				case OP_ADD_DOUBLE:
				case OP_ADD_TO_POINTER:
				{
					if ($show_execution_trace)
						echo $stack_value[$sp-2]." + ".$stack_value[$sp-1]." = ".($stack_value[$sp-2] + $stack_value[$sp-1])."<br>";
	
					$sp--;
					
					$stack_value[$sp-1] = $stack_value[$sp-1] + $stack_value[$sp];
					
					$ic_ptr++;
				}
				break;
				case OP_SUBTRACT_INT:
				case OP_SUBTRACT_DECIMAL:
				case OP_SUBTRACT_DOUBLE:
				{
					if ($show_execution_trace)
						echo $stack_value[$sp-2]." - ".$stack_value[$sp-1]." = ".($stack_value[$sp-2] - $stack_value[$sp-1])."<br>";
	
					$sp--; 
					
					$stack_value[$sp-1] = $stack_value[$sp-1] - $stack_value[$sp];
					
					$ic_ptr++;
				}
				break;
				case OP_MULT_INT:
				case OP_MULT_DOUBLE:
				{
					if ($show_execution_trace)
						echo $stack_value[$sp-2]." * ".$stack_value[$sp-1]." = ".($stack_value[$sp-2] * $stack_value[$sp-1])."<br>";
	
					$sp--;
					
					$stack_value[$sp-1] = $stack_value[$sp-1] * $stack_value[$sp];
	
					$ic_ptr++;
				}
				break;
				case OP_MULT_DECIMAL:
				{
					if ($show_execution_trace)
						echo $stack_value[$sp-2]." * ".$stack_value[$sp-1]." = ".($stack_value[$sp-2] * $stack_value[$sp-1])."<br>";
	
					$sp--;
					
					$stack_value[$sp-1] = (double) round( ((double) $stack_value[$sp-1] * (double) $stack_value[$sp]) / (double) DECIMAL_SCALE, 0 );
	
					$ic_ptr++;
				}
				break;
				case OP_DIV_INT:
				case OP_DIV_DOUBLE:
				{
					$sp--;
					
					if ($stack_value[$sp] == 0)
						runtime_error( 105, $ic_ptr, $ic_line_number, $ic_input_filename, "divide by zero" );
					else
					{
						if ($show_execution_trace)
							echo $stack_value[$sp-1]." / ".$stack_value[$sp]." = ".($stack_value[$sp-1] / $stack_value[$sp])."<br>";
							
						$stack_value[$sp-1] = $stack_value[$sp-1] / $stack_value[$sp];
					}
									
					$ic_ptr++;
				}
				break;
				case OP_DIV_DECIMAL:
				{
					$sp--;
					
					if ($stack_value[$sp] == 0)
						runtime_error( 105, $ic_ptr, $ic_line_number, $ic_input_filename, "divide by zero" );
					else
					{
						if ($show_execution_trace)
							echo $stack_value[$sp-1]." / ".$stack_value[$sp]." = ".($stack_value[$sp-1] / $stack_value[$sp])."<br>";
							
						$stack_value[$sp-1] = (double) round( ((double) $stack_value[$sp-1] / (double) $stack_value[$sp]) * (double) DECIMAL_SCALE, 0 );
					}
									
					$ic_ptr++;
				}
				break;
				case OP_MOD_INT:
				case OP_MOD_DOUBLE:
				{
					if ($show_execution_trace)
						echo $stack_value[$sp-2]." mod ".$stack_value[$sp-1]." = ".($stack_value[$sp-2] % $stack_value[$sp-1])."<br>";

					$sp--;
	
					$stack_value[$sp-1] = $stack_value[$sp-1] % $stack_value[$sp];
	
					$ic_ptr++;
				}
				break;
				case OP_MOD_DECIMAL:
				{
					if ($show_execution_trace)
						echo $stack_value[$sp-2]." mod ".$stack_value[$sp-1]." = ".($stack_value[$sp-2] % $stack_value[$sp-1])."<br>";

					$sp--;
	
					$stack_value[$sp-1] = $stack_value[$sp-1] % $stack_value[$sp];
					
					$ic_ptr++;
				}
				break;
				case OP_POW_INT:
				case OP_POW_DOUBLE:
				{
					if ($show_execution_trace)
						echo $stack_value[$sp-2]." ^ ".$stack_value[$sp-1]." = ".(pow( $stack_value[$sp-2], $stack_value[$sp-1]))."<br>";

					$sp--;
					
					$stack_value[$sp-1] = pow( $stack_value[$sp-1], $stack_value[$sp] );
					
					$ic_ptr++;
				}
				break;
				case OP_POW_DECIMAL:
				{
					if ($show_execution_trace)
						echo $stack_value[$sp-2]." ^ ".$stack_value[$sp-1]." = ".(pow( $stack_value[$sp-2], $stack_value[$sp-1]))."<br>";

					$sp--;
					
					$stack_value[$sp-1] = (double) (pow( ((double) $stack_value[$sp-1] / (double) DECIMAL_SCALE), ((double) $stack_value[$sp] / (double) DECIMAL_SCALE)) * DECIMAL_SCALE);
						
					$ic_ptr++;
				}
				break;
				
							//--------------------------------------------------------
							// ++ and --
							//--------------------------------------------------------
											
				case OP_INC_INT:
				case OP_INC_DOUBLE:
				{
					$stack_value[$sp-1]++;
					
					$ic_ptr++;
				}
				break;
				case OP_INC_DECIMAL:
				{
					$stack_value[$sp-1] += DECIMAL_SCALE;
					
					$ic_ptr++;
				}
				break;
				case OP_DEC_INT:
				case OP_DEC_DOUBLE:
				{
					$stack_value[$sp-1]--;
					
					$ic_ptr++;
				}
				break;
				case OP_DEC_DECIMAL:
				{
					$stack_value[$sp-1] -= DECIMAL_SCALE;
					
					$ic_ptr++;
				}
				break;
				
							//--------------------------------------------------------
							//--------------------------------------------------------
											
				case OP_NEGATE_INT:
				case OP_NEGATE_DOUBLE:
				{
					$stack_value[$sp-1] = - $stack_value[$sp-1];
					
					$ic_ptr++;
				}
				break;
				case OP_NEGATE_DECIMAL:
				{
					$stack_value[$sp-1] = - $stack_value[$sp-1];
					
					$ic_ptr++;
				}
				break;
				case OP_PUSH_NEW_ALLOC:
				{
					$size = $stack_value[$sp-1];
					
					for ($i=$next_available_mem; $i < $next_available_mem + $size; $i++)
						$stack_value_is_pointer[$i] = false;
					
					$stack_value[$sp-1] = $next_available_mem;
					
					$stack_value_is_pointer[$sp-1] = false;
					
					$next_available_mem += $size;
					
					$ic_ptr++;
				}
				break;
				case OP_PUSH_REL_VARIABLE_ADDR:
				{				
					$sp--; 
					
					$offset = $stack_value[$sp];		// offset within the variable
					
					$sp--;
	
					$sp2 = $stack_value[$sp];		// stackframe base plus variable offset
					//$sp2 = $stackframe_base[$call_level] + $stack_value[$sp];		// stackframe base plus variable offset
					
					$sp2 = follow_indirect_address( $stack_value, $stack_value_is_pointer, $sp2, $ic_ptr, $ic_line_number, $ic_input_filename );
	
					$stack_value[$sp] = $sp2 + $offset; 
									
					$sp++;
						
					$ic_ptr++;
				}
				break;
				case OP_PUSH_REL_ADDRESS:
				{
					$sp2 = $stackframe_base[$call_level] + $ic_value[$ic_ptr];		// base of variable
					
					$sp2 = follow_indirect_address( $stack_value, $stack_value_is_pointer, $sp2, $ic_ptr, $ic_line_number, $ic_input_filename );
						
//					if ($stack_value_is_pointer[$sp2])
//						$sp2 = $stack_value[$sp2];
					
					$stack_value[$sp] = $sp2;
					
					$sp++;
					
					$ic_ptr++;
				}
				break;
				case OP_PUSH_REL_VARIABLE_ADDR_0:
				{				
					$sp--;
	
					$sp2 = $stackframe_base[$call_level] + $stack_value[$sp];		// stackframe base plus variable offset

					$sp2 = follow_indirect_address( $stack_value, $stack_value_is_pointer, $sp2, $ic_ptr, $ic_line_number, $ic_input_filename );
	
					$stack_value[$sp] = $sp2; 
									
					$sp++;
						
					$ic_ptr++;
				}
				break;
				case OP_PUSH_DEREFERENCE:
				{
					$sp--;
					
					$offset = $stack_value[$sp];
	
					$sp--;
	
					$base = $stack_value[$sp];
					
					if ($stack_value[$base + $offset] == 0)
						runtime_error( 193, $ic_ptr, $ic_line_number, $ic_input_filename, "Attempt to access a link destination on a null link." );
					
					$stack_value[$sp] = $stack_value[$base + $offset]; 
					
					$sp++;
					
					$ic_ptr++;
				}
				break;
				case OP_PUSH_DEREFERENCE_0:
				{
					$sp--;
	
					$base = $stack_value[$sp];
					
					if ($stack_value[$base] == 0)
						runtime_error( 193, $ic_ptr, $ic_line_number, $ic_input_filename, "Attempt to access a link destination on a null link." );
					
					$stack_value[$sp] = $stack_value[$base]; 
					
					$sp++;
					
					$ic_ptr++;
				}
				break;
				case OP_SET_INDIRECTION_FLAG:
				{
					$sp--;
					
					$array_index_length = $stack_value[$sp];
					
					$sp--;
					
					$size = $stack_value[$sp];
	
					$sp--;
					
					$stack_value_is_pointer[$sp] = true;
	
					$sp++;
					
					$stack_value[$sp] = $array_index_length;
					
					$sp += $size - 1;
					
					$ic_ptr++;
				}
				break;
				case OP_DUPLICATE:
				{
					$stack_value[$sp] = $stack_value[$sp-1];
					
					if (isset( $stack_value_is_pointer[$sp-1] ))
						$stack_value_is_pointer[$sp] = $stack_value_is_pointer[$sp-1];
					else
						$stack_value_is_pointer[$sp] = false;
					
					$sp++;
					
					$ic_ptr++;
				}
				break;


							//--------------------------------------------------------
							// Call and return
							//--------------------------------------------------------

				case OP_START_FUNCTION:
				{
					$sp++;		
					
					$sp_end = $sp + $local_variables_stackframe_size2[$ic_ptr];
					
					$i = 0;
					
					while ($sp < $sp_end)
					{
						if (isset( $stack_value[$sp] ))
							unset( $stack_value[$sp] );
	
						if ($initialise_variables)	
							$stack_value[$sp] = $ic_init[$ic_ptr][$i];
	
						$stack_value_is_pointer[$sp] = false;
						
						$i++;
						$sp++;
					}
					
					$ic_ptr++;
				}
				break;
				case OP_CALL_USER_FUNCTION:
				{
					if ($show_execution_trace)
						echo "call ".$vars['function_name'][$ic_function_number[$ic_ptr]]."<br>";

					$call_level++;
	
					$stackframe_base[$call_level] = $sp;
					
					$stack_value[$sp] = $ic_ptr + 1;		// return address
					
					$ic_ptr = (int) $call_addresses[$ic_ptr];
				}
				break;
				case OP_RETURN:
				{
					if ($show_execution_trace)
						echo "return from ".$vars['function_name'][$ic_value[$ic_ptr]]."<br>";
	
					if ($sp != $stackframe_base[$call_level] + $local_variables_stackframe_size2[$ic_ptr] + 1)
						runtime_error( 183, $ic_ptr, $ic_line_number, $ic_input_filename, "Stack not empty on return from function: ".$vars['function_name'][$ic_value[$ic_ptr]] );
	
					$sp -= $local_variables_stackframe_size2[$ic_ptr];
			
					$return_value_starts = $sp;
					
					$sp--;									
	
					$return_address = $stack_value[$sp];
					
					$sp -= $function_arguments_stackframe_size2[$ic_ptr];
	
					if ($ic_return_variable_size[$ic_ptr] > 0)
					{
						if ($ic_return_variable_size[$ic_ptr] == 1)
						{
							unset( $stack_value[$sp] );
							
							if (isset( $stack_value[$return_value_starts] ))
								$stack_value[$sp] = $stack_value[$return_value_starts];
							
							$stack_value_is_pointer[$sp] = false;
							$sp++;
						}
						else
						{	
							for ($i=0; $i < $ic_return_variable_size[$ic_ptr]; $i++)
							{
								unset( $stack_value[$sp] );
								
								if (isset( $stack_value[$return_value_starts+$i] ))
									$stack_value[$sp] = $stack_value[$return_value_starts+$i];
								
								$stack_value_is_pointer[$sp] = false;
								$sp++;
							}
						}
					}
	
					$call_level--;
					
					$ic_ptr = (int) $return_address;
				}
				break;
				case OP_CALL_SYSTEM_FUNCTION:
				{
					if ($show_execution_trace)
						echo $ic_value[$ic_ptr]."<br>";
	
					$number_of_function_arguments = $ic_argument_count[$ic_ptr];
	
					// byref variable arrays = 2 stack positions

					$sp2 = "";
						
					if ($number_of_function_arguments > 0)			$sp2 = follow_indirect_address( $stack_value, $stack_value_is_pointer, $sp - ($number_of_function_arguments), $ic_ptr, $ic_line_number, $ic_input_filename ); 	if (isset( $stack_value[$sp2] )) $arg1 = $stack_value[$sp2]; else $arg1 = "0";  
					if ($number_of_function_arguments > 1)			$sp2 = follow_indirect_address( $stack_value, $stack_value_is_pointer, $sp - ($number_of_function_arguments-1), $ic_ptr, $ic_line_number, $ic_input_filename ); 	if (isset( $stack_value[$sp2] )) $arg2 = $stack_value[$sp2]; else $arg2 = "0";  
					if ($number_of_function_arguments > 2)			$sp2 = follow_indirect_address( $stack_value, $stack_value_is_pointer, $sp - ($number_of_function_arguments-2), $ic_ptr, $ic_line_number, $ic_input_filename ); 	if (isset( $stack_value[$sp2] )) $arg3 = $stack_value[$sp2]; else $arg3 = "0";  
					if ($number_of_function_arguments > 3)			$sp2 = follow_indirect_address( $stack_value, $stack_value_is_pointer, $sp - ($number_of_function_arguments-3), $ic_ptr, $ic_line_number, $ic_input_filename ); 	if (isset( $stack_value[$sp2] )) $arg4 = $stack_value[$sp2]; else $arg4 = "0";  
					if ($number_of_function_arguments > 4)			$sp2 = follow_indirect_address( $stack_value, $stack_value_is_pointer, $sp - ($number_of_function_arguments-4), $ic_ptr, $ic_line_number, $ic_input_filename ); 	if (isset( $stack_value[$sp2] )) $arg5 = $stack_value[$sp2]; else $arg5 = "0";  
					if ($number_of_function_arguments > 5)			$sp2 = follow_indirect_address( $stack_value, $stack_value_is_pointer, $sp - ($number_of_function_arguments-5), $ic_ptr, $ic_line_number, $ic_input_filename ); 	if (isset( $stack_value[$sp2] )) $arg6 = $stack_value[$sp2]; else $arg6 = "0";  
					if ($number_of_function_arguments > 6)			$sp2 = follow_indirect_address( $stack_value, $stack_value_is_pointer, $sp - ($number_of_function_arguments-6), $ic_ptr, $ic_line_number, $ic_input_filename ); 	if (isset( $stack_value[$sp2] )) $arg7 = $stack_value[$sp2]; else $arg7 = "0";  
					if ($number_of_function_arguments > 7)			$sp2 = follow_indirect_address( $stack_value, $stack_value_is_pointer, $sp - ($number_of_function_arguments-7), $ic_ptr, $ic_line_number, $ic_input_filename ); 	if (isset( $stack_value[$sp2] )) $arg8 = $stack_value[$sp2]; else $arg8 = "0";  
					if ($number_of_function_arguments > 8)			$sp2 = follow_indirect_address( $stack_value, $stack_value_is_pointer, $sp - ($number_of_function_arguments-8), $ic_ptr, $ic_line_number, $ic_input_filename ); 	if (isset( $stack_value[$sp2] )) $arg9 = $stack_value[$sp2]; else $arg9 = "0";  
					if ($number_of_function_arguments > 9)			$sp2 = follow_indirect_address( $stack_value, $stack_value_is_pointer, $sp - ($number_of_function_arguments-9), $ic_ptr, $ic_line_number, $ic_input_filename ); 	if (isset( $stack_value[$sp2] )) $arg10 = $stack_value[$sp2]; else $arg10 = "0";  
					if ($number_of_function_arguments > 10)			$sp2 = follow_indirect_address( $stack_value, $stack_value_is_pointer, $sp - ($number_of_function_arguments-10), $ic_ptr, $ic_line_number, $ic_input_filename ); 	if (isset( $stack_value[$sp2] )) $arg11 = $stack_value[$sp2]; else $arg11 = "0";  
						  
	
					if ($show_execution_trace && $ic_value[$ic_ptr] == "output")
						echo convert_to_html( $arg1 );
					else
					{
						$result = call_sys_function( $ic, $ic_ptr, $stack_value, $sp, $stack_value_is_pointer, $ic_value[$ic_ptr],
																$arg1,
																$arg2,
																$arg3,
																$arg4,
																$arg5,
																$arg6,
																$arg7,
																$arg8,
																$arg9,
																$arg10);
	
					}
									
					$sp -= $function_arguments_stackframe_size2[$ic_ptr];
					
					$stack_value[$sp] = $result; 
				
				 	$stack_value_is_pointer[$sp] = false;
		
					$sp += $ic_return_variable_size[$ic_ptr];
									
					$ic_ptr++;
				}
				break;
				case OP_LABEL:
				case OP_MODULE_NAME:
				case OP_LINK_MODULE:
				{
					$ic_ptr++;
				}
				break;
				case OP_SYS_EXIT:
				{
					exit();
				}
				break;
				case OP_ERROR: 
				{
					runtime_error( 1, $ic_ptr, $ic_line_number, $ic_input_filename, $ic_error_text[$ic_ptr] );
				
					exit();
				}
				break;
				default:
				{
					runtime_error( 122, $ic_ptr, $ic_line_number, $ic_input_filename, "Unrecognised opcode: ".$op );
					exit();
				}
			}
		}
		
		echo "<br>";
		echo "<br>";

//		echo gray( "&nbsp;Elapsed: ".number_format( microtime( true ) - $time1, 3 )." seconds, ".($count / (microtime( true ) - $time1))." operations/sec" );
		
		echo "<br>";
		echo "<br>";
 	}


	
			
	function debug_lineout( $ic_input_filename, $ic_line_number, $ic_ptr, $sp, $text )
	{
		$text2 = $ic_input_filename[$ic_ptr];
		
		$pos = strrpos( $text2, "/" );
		
		if ($pos !== false)
			$text2 = sright( $text2, strlen( $text2 ) - $pos - 1 );
		
		echo "Line: ".$ic_line_number[$ic_ptr].": ".$text2.": IP: ".$ic_ptr.": SP: ".$sp.": ".$text."<br>";			
	}


		// round amounts ending in XX.00000000XXX or XX.99999999XXX
/*
    function fixup_rounding_after_div( $str )
    {
        $pos = strpos( $str, "." );

		$str2 = $str;
		
		if ($pos === false)
			$num_decimals = 0;
		else
			$num_decimals = strlen( $str ) - $pos - 1;
		
		if ($num_decimals >= 8)
        {
		 	$str4 = substr( $str, strlen( $str ), 4 );
			
 			if ($str4 == '0000')
            	$str2 = substr( $str, 0, strlen( $str )-3 );
		    else   	
 			if ($str4 == '9999')
            {
            	$str2 = substr( $str, 0, strlen( $str )-3 );
				
                $carry = 1;
				
                $pos = strlen( $str2 )-1;
                
                while ($pos > 0 && $carry == 1)
                {
                    if (substr( $str2, $pos, 1 ) != '.')
                    {
                        if (substr( $str2, $pos, 1 ) == '9')
                            $str2 = substr( $str2, 0, $pos ) . '0' . substr( $str2, $pos+1, strlen( $str2 )-$pos-1 );
                        else
                        {
                            $str2 = substr( $str2, 0, $pos ) . (((int) substr( $str2, $pos, 1 ) + 1)) . substr( $str2, $pos+1, strlen($str2)-$pos-1 );
                            $carry = 0;
                        }
                    }
                    
                    $pos = $pos - 1;
                }

                if ($carry == 1)
                {
                    if (substr( $str2, 0, 1 ) == '9')
                        $str2 = '10' . substr( $str2, 1, strlen( $str2 )-1 );
					else
						$str2 = (string) ((int) substr( $str2, 0, 1 ) + 1);
                }
            }
        }
		
		if (strlen( $str2 ) > 2)
		{
			if (substr( $str, strlen( $str2 )-1, 1 ) == '.')
				$str2 = substr( $str2, 0, strlen( $str2 )-1 );
		}

		$str2 = trim_trailing_zeros( $str2 );

        return ($str2);
    }

*/
	function follow_indirect_address( &$stack_value, &$stack_value_is_pointer, $sp2, $ic_ptr, &$ic_line_number, &$ic_input_filename ) 
	{
		$indirection_levels = 0;
		
		while ($indirection_levels < MAX_INDIRECTION_LEVELS && $stack_value_is_pointer[$sp2])
		{
			$sp2 = $stack_value[$sp2];
			$indirection_levels++;
		}
		
		if ($indirection_levels >= MAX_INDIRECTION_LEVELS)
			runtime_error( 111, $ic_ptr, $ic_line_number, $ic_input_filename, "Exceed the maximum indirection levels" );

		return ($sp2);
	}


	function runtime_error( $error_number, $ic_ptr, $ic_line_number, $ic_input_filename, $text )
	{
		echo "Runtime error: ".$error_number.": Line ".$ic_line_number[$ic_ptr].": ".$ic_input_filename[$ic_ptr].": ".$text."<br>";

		echo "<br>";
	}
	
?>