<?php
			// (c) Copyright Mark McIlroy 2022

			
	function scan_file( &$parse_param, $input_filename, $program )
	{
		$program_text[0] = $program;
		$input_pos[0] = 0;
		
		$pos = strrpos( $input_filename, "/" );
		
		if ($pos !== false)
			$input_filename = sright( $input_filename, strlen( $input_filename ) - $pos - 1 );
		
		$inc_current_filename[0] = $input_filename;
		
		$parse_param->input_filenames[0] = $input_filename;
		  
		$inc_current_filenumber[0] = 0;
		$inc_current_line_number[0] = 1;

		$include_file_level = 0;

		$current_filenumber = 0;
				
		$parse_param->curr_tok = 0;
		$parse_param->curr_token_text = "";
		
		$curr_token_number = 0;
		
		while ($include_file_level >= 0)
		{
			next_token2( $parse_param, $include_file_level, $program_text[$include_file_level], $input_pos[$include_file_level], $inc_current_filename[$include_file_level], $inc_current_line_number[$include_file_level] );

			if ($parse_param->curr_tok == TOK_EOF)
			{
				$include_file_level--;
				
				if ($include_file_level >= 0)
				{
					next_token2( $parse_param, $include_file_level, $program_text[$include_file_level], $input_pos[$include_file_level], $inc_current_line_number[$include_file_level], $inc_current_filename[$include_file_level], $inc_current_line_number[$include_file_level] );
				
					if ($parse_param->curr_tok != TOK_SEMICOLON)
						input_error( 17, $parse_param, $inc_current_filename[$include_file_level], $inc_current_line_number[$include_file_level], "Expected a ';' after an 'include'." );
				}
			}
			else
			{
				if ((! $parse_param->c_output) && $parse_param->curr_tok == TOK_C_INCLUDE)
				{
					next_token2( $parse_param, $include_file_level, $program_text[$include_file_level], $input_pos[$include_file_level], $inc_current_line_number[$include_file_level], $inc_current_filename[$include_file_level], $inc_current_line_number[$include_file_level] );
					next_token2( $parse_param, $include_file_level, $program_text[$include_file_level], $input_pos[$include_file_level], $inc_current_line_number[$include_file_level], $inc_current_filename[$include_file_level], $inc_current_line_number[$include_file_level] );
				}  
				else
				if ($parse_param->c_output && $parse_param->curr_tok == TOK_PHP_INCLUDE)
				{
					next_token2( $parse_param, $include_file_level, $program_text[$include_file_level], $input_pos[$include_file_level], $inc_current_line_number[$include_file_level], $inc_current_filename[$include_file_level], $inc_current_line_number[$include_file_level] );
					next_token2( $parse_param, $include_file_level, $program_text[$include_file_level], $input_pos[$include_file_level], $inc_current_line_number[$include_file_level], $inc_current_filename[$include_file_level], $inc_current_line_number[$include_file_level] );
				}  
				else				
				if ($parse_param->curr_tok == TOK_INCLUDE || 
					($parse_param->c_output && $parse_param->curr_tok == TOK_C_INCLUDE) ||
					((! $parse_param->c_output) && $parse_param->curr_tok == TOK_PHP_INCLUDE))
				{
					next_token2( $parse_param, $include_file_level, $program_text[$include_file_level], $input_pos[$include_file_level], $inc_current_line_number[$include_file_level], $inc_current_filename[$include_file_level], $inc_current_line_number[$include_file_level] );
				
					if ($parse_param->curr_tok != TOK_STRING_CONSTANT)
						input_error( 16, $parse_param, $inc_current_filename[$include_file_level], $inc_current_line_number[$include_file_level], "Expected a pathname after 'include'." );
				
					$pathname = $parse_param->curr_token_text;
				
					if (sleft( $pathname, 5 ) == "https")
						$s2 = file_get_contents( $pathname );
					else
					{
						$fp = fopen( $pathname, "r" );
						
						$s2 = "";
						
						while (! feof( $fp ))
							$s2 = $s2.fread( $fp, 1000 );
						
						fclose( $fp );
					}
			
					
					$include_file_level++;

					$current_filenumber++;
										
					$pos = strrpos( $pathname, "/" );
					
					if ($pos !== false)
						$pathname = sright( $pathname, strlen( $pathname ) - $pos - 1 );
					
					$parse_param->input_filenames[$current_filenumber] = $pathname;  
					
					$program_text[$include_file_level] = $s2;
					
					$input_pos[$include_file_level] = 0;
					
					$inc_current_filename[$include_file_level] = $pathname;
					
					$inc_current_filenumber[$include_file_level] = $current_filenumber;
					
					$inc_current_line_number[$include_file_level] = 1;
				}
				else
				{
					$parse_param->current_filename[$curr_token_number] 		= $inc_current_filename[$include_file_level];
					$parse_param->current_filenumber[$curr_token_number] 	= $inc_current_filenumber[$include_file_level];
					$parse_param->current_line_number[$curr_token_number] 	= $inc_current_line_number[$include_file_level];
										
					$parse_param->all_curr_tok[$curr_token_number] 			= $parse_param->curr_tok;
					$parse_param->all_curr_token_text[$curr_token_number] 	= $parse_param->curr_token_text;
				
					if (! isset( $parse_param->input_text[$parse_param->current_filenumber[$curr_token_number]][$parse_param->current_line_number[$curr_token_number]] ))
						$parse_param->input_text[$parse_param->current_filenumber[$curr_token_number]][$parse_param->current_line_number[$curr_token_number]] = "";

					$text = " ";
					
					if ($parse_param->curr_tok == TOK_STRING_CONSTANT)
						$text .= '"';
					
					$text .= $parse_param->curr_token_text;

					if ($parse_param->curr_tok == TOK_STRING_CONSTANT)
						$text .= '"';
					
					$parse_param->input_text[$parse_param->current_filenumber[$curr_token_number]][$parse_param->current_line_number[$curr_token_number]] .= $text;
				
					$curr_token_number++;
				}
			}
		}

		$parse_param->num_tokens = $curr_token_number;
		
		$parse_param->num_input_files = $current_filenumber + 1; 
		
		$parse_param->all_curr_tok[$curr_token_number] = $parse_param->curr_tok;

		$parse_param->curr_token_number = 0;

		$parse_param->curr_tok = 				$parse_param->all_curr_tok[0];
		$parse_param->curr_token_text = 		$parse_param->all_curr_token_text[0];
	}

	
	function next_token( &$parse_param )
	{
		if ($parse_param->curr_token_number >= $parse_param->num_tokens-1)
			$parse_param->curr_tok = TOK_EOF;
		else
		{
			$parse_param->curr_token_number++;
		
			$parse_param->curr_tok = 		$parse_param->all_curr_tok[$parse_param->curr_token_number];
			$parse_param->curr_token_text = $parse_param->all_curr_token_text[$parse_param->curr_token_number];
			
			if (isset( $parse_param->all_curr_tok[$parse_param->curr_token_number+1] ))
				$parse_param->lookahead_tok = $parse_param->all_curr_tok[$parse_param->curr_token_number+1];
			
			if (isset( $parse_param->all_curr_token_text[$parse_param->curr_token_number+1] ))
				$parse_param->lookahead_token_text = $parse_param->all_curr_token_text[$parse_param->curr_token_number+1];
			
			if (isset( $parse_param->all_curr_tok[$parse_param->curr_token_number+2] ))
				$parse_param->lookahead_tok_2_steps = $parse_param->all_curr_tok[$parse_param->curr_token_number+2];
		}
	}

				
	function next_token2( &$parse_param, $include_file_level, &$s, &$i, &$current_filename, &$current_line_number )
	{
		$already_processed = false;
		
		$tok = "";

		skip_whitespace( $parse_param, $include_file_level, $s, $i, $current_line_number );
				
		$start_text = $i;

		$parse_param->curr_token_text = "";
		
		if ($i >= strlen( $s ))
		{
			$tok = TOK_EOF;
			$tok_len = 1;
			$parse_param->curr_token_text = "";
		}
		else
		{
			$ch = substr( $s, $i, 1 );

			$text1 = substr( $s, $i, 1 );
	
			$text2 = substr( $s, $i, 2 );
			
			if ($text2 == "++")	{	$tok = TOK_INC;		$tok_len = 2;	}
			else
			if ($text2 == "--")	{	$tok = TOK_DEC;		$tok_len = 2;	}
			else
			if ($text2 == "==")	{	$tok = TOK_EQ;		$tok_len = 2;	}
			else
			if ($text2 == "!=")	{	$tok = TOK_NE;		$tok_len = 2;	}
			else
			if ($text2 == "<=")	{	$tok = TOK_LE;		$tok_len = 2;	}
			else
			if ($text2 == ">=")	{	$tok = TOK_GE;		$tok_len = 2;	}
			else

			if ($text2 == "+=")	{	$tok = TOK_ASSIGN_INC;			$tok_len = 2;	}
			else
			if ($text2 == "-=")	{	$tok = TOK_ASSIGN_DEC;			$tok_len = 2;	}
			else
			if ($text2 == "*=")	{	$tok = TOK_ASSIGN_MULT;			$tok_len = 2;	}
			else
			if ($text2 == "/=")	{	$tok = TOK_ASSIGN_DIV;			$tok_len = 2;	}
			else
			if ($text2 == "&=")	{	$tok = TOK_ASSIGN_STRCONCAT;	$tok_len = 2;	}
			else
				
			if ($text1 == ".")	{	$tok = TOK_DOT;		$tok_len = 1;	}
			else
			if ($text1 == "<")	{	$tok = TOK_LT;		$tok_len = 1;	}
			else
			if ($text1 == ">")	{	$tok = TOK_GT;		$tok_len = 1;	}
	
			else
			if ($text1 == "+")	{	$tok = TOK_PLUS;		$tok_len = 1;	}
			else
			if ($text1 == "*")	{	$tok = TOK_MULT;		$tok_len = 1;	}
			else
			if ($text1 == "/")	{	$tok = TOK_DIV;			$tok_len = 1;	}
			else
			if ($text1 == "^")	{	$tok = TOK_POW;			$tok_len = 1;	}
	
			else
			if ($text1 == "(")	{	$tok = TOK_LPARENTHESIS;	$tok_len = 1;	}
			else
			if ($text1 == ")")	{	$tok = TOK_RPARENTHESIS;	$tok_len = 1;	}
			else
			if ($text1 == "[")	{	$tok = TOK_LBRACKET;	$tok_len = 1;	}
			else
			if ($text1 == "]")	{	$tok = TOK_RBRACKET;	$tok_len = 1;	}
			else
			if ($text1 == "{")	{	$tok = TOK_LBRACE;		$tok_len = 1;	}
			else
			if ($text1 == "}")	{	$tok = TOK_RBRACE;		$tok_len = 1;	}
	
			else
			if ($text1 == ",")	{	$tok = TOK_COMMA;		$tok_len = 1;	}
			else
			if ($text1 == "=")	{	$tok = TOK_ASSIGN;		$tok_len = 1;	}
			else
			if ($text1 == ";")	{	$tok = TOK_SEMICOLON;	$tok_len = 1;	}
			else
			if ($text1 == "&")	{	$tok = TOK_ADDR_STRCONCAT;		$tok_len = 1;	}

			else
			if ($text1 == "\"")
			{
				$tok_len = 1;

				$j = $i;
				
				$j++;

				$ch = substr( $s, $j, 1 );

				while ($j < strlen( $s ) && $ch != "\"")
				{
					if ($ch == "\n")
					{
						$current_line_number++;
							
						if ($parse_param->show_scan_trace)
							echo "Input line: ".$current_line_number."<br>";
					}

					$j++;
					$tok_len++;

					if ($tok_len > 1 && substr( $s, $j-1, 2 ) == '\"')
					{
						$j++;
						$tok_len++;
					}


					$ch = substr( $s, $j, 1 );
				}
				
				$tok = TOK_STRING_CONSTANT;
				
				$tok_len++;
			}		
			else
			if ($text2 == "0x")
			{
				$tok_len = 0;

				$j = $i + 2;

				$ch = substr( $s, $j, 1 );
									
				while ($j < strlen( $s ) && $ch >= "0" && $ch <= "9")
				{
					$j++;
					$tok_len++;

					$ch = substr( $s, $j, 1 );
				}
				
				$text = substr( $s, $i+2, $tok_len );
				
				$tok = TOK_NUMBER;
			
				$parse_param->curr_token_text = hexdec( $text );

				$i += $tok_len + 2;
				
				$already_processed = true;
			}
			else
			if ($text2 == "0b")
			{
				$tok_len = 0;

				$j = $i + 2;

				$ch = substr( $s, $j, 1 );
									
				while ($j < strlen( $s ) && $ch >= "0" && $ch <= "1")
				{
					$j++;
					$tok_len++;

					$ch = substr( $s, $j, 1 );
				}
				
				$text = substr( $s, $i+2, $tok_len );
				
				$tok = TOK_NUMBER;
			
				$num = (int) 0;
				$j = (int) 1;
				
				for ($k = strlen( $text )-1; $k >= 0; $k--)
				{
					$ch = substr( $text, $k, 1 );
					
					if ($ch == '1')
						$num += $j;
					else
					if ($ch != '0')
						input_error( 188, $parse_param, $current_filename, $current_line_number, "Invalid character '".$ch."' in binary constant" );
											
					$j = $j << 1; 
				}
				
				$parse_param->curr_token_text = (string) $num;

				$i += $tok_len + 2;
				
				$already_processed = true;
			}
			else
			if ($text1 == "'")
			{
				$tok_len = 1;

				$j = $i;
				
				$j++;

				$ch = substr( $s, $j, 1 );
									
				while ($j < strlen( $s ) && $ch != "'")
				{
					$j++;
					$tok_len++;

					$ch = substr( $s, $j, 1 );
				}
				
				$tok_len++;
				
				$text = substr( $s, $i+1, $tok_len );
				
				if ($tok_len == 12)
				{
					$tok = TOK_DATE_CONSTANT;

					$text = sleft( $text, 10 );
					
					if (! check_date_valid( $text ))
						input_error( 142, $parse_param, $current_filename, $current_line_number, "Invalid date format: ".$text );
				}
				else
				if ($tok_len == 10)
				{
					$tok = TOK_TIME_CONSTANT;
					
					$text = sleft( $text, 8 );
					
					if (! time_is_valid( $text ))
						input_error( 143, $parse_param, $current_filename, $current_line_number, "Invalid time format: ".$text );
				}
				else						
				if ($tok_len == 21)
				{
					$tok = TOK_DATETIME_CONSTANT;

					$text = sleft( $text, 19 );
											
					if (! datetime_is_valid( $text ))
						input_error( 144, $parse_param, $current_filename, $current_line_number, "Invalid time format: ".$text );
				}
				else
				{
					input_error( 101, $parse_param, $current_filename, $current_line_number, "Expected a date 'YYYY-MM-DD', time 'HH:MM:SS' or datetime 'YYYY-MM-DD HH:MM:SS': ".$text1 );
					$parse_param->error_occured = true;
				}
			}		
			else
			if ($text1 == "-")
			{
				$ch = substr( $s, $i+1, 1 );

				$tok = TOK_SUBTRACT_MINUS;
					
				$tok_len = 1;
			}
			else
			if ($text1 >= '0' && $text1 <= '9')
			{			
				$tok = TOK_NUMBER;
				
				$tok_len = 0;
				
				$j = $i;
				
				$text2 = $ch;
				
				while ($j < strlen( $s ) && ($ch == '.' || $ch == 'e' || $ch == 'E' || ($ch >= '0' && $ch <= '9')))
				{
					$j++;
					
					$ch = substr( $s, $j, 1 );
				    
					$text2 .= $ch;
					
					$tok_len++;
				}
				
				if ($j < strlen( $s ))
					$text2  = sleft( $text2, strlen( $text2 ) - 1 );
		
				if (! is_numeric( $text2 ))
					input_error( 194, $parse_param, $current_filename, $current_line_number, "Invalid numeric constant text: ".$text2 );
			}
			else
			if ($text1 == "_" || ($text1 >= 'a' && $text1 <= 'z') || ($text1 >= 'A' && $text1 <= 'Z'))
			{
				$tok = TOK_NAME;
				
				$tok_len = 0;
				
				$j = $i;
				
				while ($j < strlen( $s ) && ($ch == "_" || ($ch >= 'a' && $ch <= 'z') || ($ch >= 'A' && $ch <= 'Z')|| ($ch >= '0' && $ch <= '9')))
				{
					$j++;
					
					$ch = substr( $s, $j, 1 );
				
					$tok_len++;
				}
				
				$text = substr( $s, $i, $tok_len );

				if (sleft( $text, 4 ) == "int_" && is_numeric( sright( $text, strlen( $text ) - 4)))
				{
					$tok = TOK_INT;
					
					$i += strlen( $text );
/*					
					if (substr( $s, $i, 1 ) == "-")
					{
						$i++;
						
						$ch = substr( $s, $i, 1 );
						
						if ($ch >= "0" && $ch <= "9")
						{
							$i++;
						
							$ch = substr( $s, $i, 1 );
							
							if ($ch >= "0" && $ch <= "9")
								$i++;
						} 
					}
*/					

					$parse_param->curr_token_text = "int";
														
					$already_processed = true;
				}
				else
				if (sleft( $text, 7 ) == "double_" && is_numeric( sright( $text, strlen( $text ) - 7)))
				{
					$tok = TOK_DOUBLE;
					
					$i += strlen( $text );
/*					
					if (substr( $s, $i, 1 ) == "-")
					{
						$i++;
						
						$ch = substr( $s, $i, 1 );
						
						if ($ch >= "0" && $ch <= "9")
						{
							$i++;
						
							$ch = substr( $s, $i, 1 );
							
							if ($ch >= "0" && $ch <= "9")
								$i++;
						} 
					}
*/					
					$parse_param->curr_token_text = "double";
														
					$already_processed = true;
				}
				else
				if (sleft( $text, 8 ) == "decimal_" && is_numeric( sright( $text, strlen( $text ) - 8)))
				{
					$tok = TOK_DECIMAL;
					
					$i += strlen( $text );
					
/*					
					if (substr( $s, $i, 1 ) == "-")
					{
						$i++;
						
						$ch = substr( $s, $i, 1 );
						
						if ($ch >= "0" && $ch <= "9")
						{
							$i++;
						
							$ch = substr( $s, $i, 1 );
							
							if ($ch >= "0" && $ch <= "9")
								$i++;
						} 
					}
*/
					
					$parse_param->curr_token_text = "decimal";
														
					$already_processed = true;
				}
				
				if ($text == "if")			$tok = TOK_IF;
				if ($text == "while")		$tok = TOK_WHILE;
				if ($text == "function")	$tok = TOK_FUNCTION;
				if ($text == "declare")		$tok = TOK_DECLARE;
				if ($text == "var")			$tok = TOK_VAR;
				if ($text == "and")			$tok = TOK_AND;
				if ($text == "mod")			$tok = TOK_MOD;
				if ($text == "or")			$tok = TOK_OR;
				if ($text == "not")			$tok = TOK_NOT;
				if ($text == "else")		$tok = TOK_ELSE;
				if ($text == "string")		$tok = TOK_STRING;
				if ($text == "bool")		$tok = TOK_BOOL;
				if ($text == "int")			$tok = TOK_INT;
				if ($text == "decimal")		$tok = TOK_DECIMAL;
				if ($text == "double")		$tok = TOK_DOUBLE;
				if ($text == "binary")		$tok = TOK_BINARY;
				if ($text == "date")		$tok = TOK_DATE;
				if ($text == "time")		$tok = TOK_TIME;
				if ($text == "datetime")	$tok = TOK_DATETIME;
				if ($text == "true")		$tok = TOK_BOOLEAN_CONSTANT;
				if ($text == "false")		$tok = TOK_BOOLEAN_CONSTANT;
				if ($text == "const")		$tok = TOK_CONST;
				if ($text == "include")		$tok = TOK_INCLUDE;
				if ($text == "array")		$tok = TOK_ARRAY;
				if ($text == "for")			$tok = TOK_FOR;
				if ($text == "to")			$tok = TOK_TO;
				if ($text == "step")		$tok = TOK_STEP;
				if ($text == "builtin")		$tok = TOK_BUILTIN;
				if ($text == "void")		$tok = TOK_VOID;
				if ($text == "type")		$tok = TOK_TYPE;
				if ($text == "struct")		$tok = TOK_STRUCT;
				if ($text == "link")		$tok = TOK_LINK;
				if ($text == "new")			$tok = TOK_NEW;
				if ($text == "variable")	$tok = TOK_VARIABLE;
				if ($text == "include_c")	$tok = TOK_INCLUDE_C;
				if ($text == "module_name")	$tok = TOK_MODULE_NAME;
				if ($text == "link_module")	$tok = TOK_LINK_MODULE;
				if ($text == "module_type")	$tok = TOK_MODULE_TYPE;
				if ($text == "output_filename")	$tok = TOK_OUTPUT_FILENAME;
				if ($text == "c_include")	$tok = TOK_C_INCLUDE;
				if ($text == "php_include")	$tok = TOK_PHP_INCLUDE;
				if ($text == "general")		$tok = TOK_GENERAL;
			}
			else
			{
				input_error( 102, $parse_param, $current_filename, $current_line_number, "Input error: unrecognised character: ".$text1 );

				$parse_param->error_occured = true;
		
				$tok = TOK_NAME;
				
				$tok_len = 1;
			}

			if (! $already_processed)
			{
//				$text = substr( $s, $i+3, $tok_len - 4 );

				if ($tok == TOK_STRING_CONSTANT ||
					$tok == TOK_DATE_CONSTANT ||
					$tok == TOK_TIME_CONSTANT ||
					$tok == TOK_DATETIME_CONSTANT)
					$parse_param->curr_token_text = substr( $s, $i+1, $tok_len - 2 );
				else
					$parse_param->curr_token_text = substr( $s, $i, $tok_len );

				$i += strlen( $parse_param->curr_token_text );

				if ($tok == TOK_STRING_CONSTANT)
					$parse_param->curr_token_text = process_escape_sequences( $parse_param->curr_token_text );

				if ($tok == TOK_STRING_CONSTANT ||
					$tok == TOK_DATE_CONSTANT ||
					$tok == TOK_TIME_CONSTANT ||
					$tok == TOK_DATETIME_CONSTANT)
					$i += 2;
			}
		}

		if ($parse_param->show_scan_trace)
			echo "Scan: ".$tok.": '".$parse_param->curr_token_text."'<br>";
		
		$parse_param->curr_tok = $tok;
	}


	function process_escape_sequences( $s )
	{
		$pos = 0;

		$s2 = "";

		while ($pos < strlen( $s ))
		{
			$ch = smid( $s, $pos, 1 );
			$ch2 = smid( $s, $pos, 2 );
			
			if ($ch2 == '\"')
			{
				$s2 .= '"';
				$pos++;
			}
			else
			if ($ch2 == '\\\\')
			{
				$s2 .= '\\';
				$pos++;
			}
			else
			if ($ch2 == '\n')
			{
				$s2 .= "\n";
				$pos++;
			}
			else
			if ($ch2 == '\r')
			{
				$s2 .= "\r";
				$pos++;
			}
			else
			if ($ch2 == '\t')
			{
				$s2 .= "\t";
				$pos++;
			}
			else
				$s2 .= $ch;
			
			$pos++;
		}
		
		return ($s2);
	}


 	function skip_whitespace( $parse_param, $include_file_level, &$s, &$i, &$current_line_number )
	{
		$state = 1;
		$nesting_level = 0;

		$ch2 = substr( $s, $i, 2 );

		if ($ch2 == "//")
		{
			$state = 2;
			$i += 2;
		}			
		else				
		if ($ch2 == "/*")
		{
			$state = 3;
			$nesting_level = 1;
			$i += 2;
		}
		
		while ($i < strlen( $s ) && $state != 0)
		{
			$ch = substr( $s, $i, 1 );	
			$ch2 = substr( $s, $i, 2 );
			
			if ($ch == "\n")
			{
				$current_line_number++;
							
				if ($parse_param->show_scan_trace)
					echo "Input line: ".$current_line_number."<br>";
			}			
			
			if ($state == 1)
			{
				if ($ch2 == "<?")
				{
					$i += 2;
				}			
				else				
				if ($ch2 == "//")
				{
					$state = 2;
					$i += 2;
				}			
				else				
				if ($ch2 == "/*")
				{
					$state = 3;
					$nesting_level = 1;
					$i += 2;
				}
				else
				if ($ch == " " || $ch == "\n" || $ch == "\r" || $ch == "\t")
					$i++;
				else					
					$state = 0;
			}
			else
			if ($state == 2)
			{
				if ($ch == "\n")					
					$state = 1;
				
				$i++;			
			}
			else
			if ($state == 3)
			{
				if ($ch2 == "/*")	
				{				
					$nesting_level++;
					$i += 2;			
				}
				else
				if ($ch2 == "*/")
				{					
					$nesting_level--;
					
					if ($nesting_level == 0)
						$state = 1;
					
					$i += 2;
				}
				else
					$i++;
			}
		}
	}

	function input_error( $error_number, &$parse_param, $current_filename, $current_line_number, $text )
	{
		$parse_param->error_occured = true;
		
		if ($parse_param->last_error_line != $current_line_number)
		{
			echo "Error number: ".$error_number.": Line ".$current_line_number.": ".$current_filename.": ".$text;

			echo "<br>";

			$parse_param->last_error_line = $current_line_number;
		}
		
		if (exit_on_first_error)
			exit();
	}	
	
?>